/***************************************************************************
                          kdesudo.cpp  -  description
                             -------------------
    begin                : Sam Feb 15 15:42:12 CET 2003
    copyright            : (C) 2003 by Robert Gruber <rgruber@users.sourceforge.net>
                           (C) 2007 by Martin Böhm <martin.bohm@kubuntu.org>
                                       Anthony Mercatante <tonio@kubuntu.org>
                                       Canonical Ltd (Jonathan Riddell <jriddell@ubuntu.com>)

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kdesudo.h"

#include <qfile.h>

#include <klocale.h>
#include <kmessagebox.h>
#include <kpushbutton.h>
#include <kpassdlg.h>
#include <kdesu/kcookie.h>
#include <kdebug.h>

#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>

KdeSudo::KdeSudo(QWidget *parent, const char *name, const QString& cmd, const QString& runas, const QString& comment,const QString& icon, const QString& generic, bool withIgnoreButton, bool newDcop)
	: KPasswordDialog(KPasswordDialog::Password, false, (withIgnoreButton ? User1: false), icon, parent, name)
{
	QString defaultComment = i18n("<b>%1</b> needs administrative privileges. Please enter your password for verification.");
	p=NULL;
	bNeedPasswd=false;
	bError=false;
	bNewDcop=newDcop;
	m_pCookie = new KCookie;

	if (comment.isEmpty()) {
		if (! generic.isEmpty())
			setPrompt(defaultComment.arg(generic));
		else
			setPrompt(defaultComment.arg(cmd));
	} else {
		setPrompt(comment);
	}

	if (withIgnoreButton) {
		setButtonText(User1, i18n("&Ignore"));
	}

	QString command = cmd;
	/* vExecCommand */
	p = new KShellProcess;
	p->clearArguments();
	if (runas.isEmpty()) {
		*p << "sudo -S -p passprompt" <<  cmd;
	} else {
		*p << "sudo -S -p passprompt -u " << runas << ' ' <<  cmd;
	}

	// Apologies for the C code, taken from kdelibs/kdesu/kdesu_stub.c
	// KControl and other places need to use the user's existing DCOP server
	// For that we set DCOPSERVER.  Create a file in /tmp and use iceauth to add magic cookies
	// from the existing server and set ICEAUTHORITY to point to the file
	if (!bNewDcop) {
		QCString dcopServer = m_pCookie->dcopServer();
		QCString dcopAuth = m_pCookie->dcopAuth();
		QCString iceAuth = m_pCookie->iceAuth();

		FILE *fout;
		char iceauthority[200];
		char *host, *auth;
		p->setEnvironment("DCOPSERVER", dcopServer);
		host = qstrdup(dcopServer);
		auth = qstrdup(iceAuth);
		int tempfile;
		int oldumask = umask(077);

		strcpy(iceauthority, "/tmp/iceauth.XXXXXXXXXX");
		tempfile = mkstemp(iceauthority);
		umask(oldumask);
		if (tempfile == -1) {
			kdError() << "error in kdesudo mkstemp" << endl;
			exit(1);
		} else {
			// close(tempfile); //FIXME why does this make the connect() call later crash?
		}
		iceauthorityFile = iceauthority;
		//FIXME we should change owner of iceauthority file, but don't have permissions
		p->setEnvironment("ICEAUTHORITY", iceauthority);
		setenv("ICEAUTHORITY", iceauthority, 1);
	
		fout = popen("iceauth >/dev/null 2>&1", "w");
		if (!fout) {
			kdError() << "error in kdesudo running iceauth" << endl;
			exit(1);
		}
		fprintf(fout, "add ICE \"\" %s %s\n", host, auth);
		auth = qstrdup(dcopAuth);
		//auth = xstrsep(params[P_DCOP_AUTH].value);
		fprintf(fout, "add DCOP \"\" %s %s\n", host, auth);
		pclose(fout);
		unsetenv("ICEAUTHORITY");
	}

	connect( p, SIGNAL(receivedStdout(KProcess*, char*, int)), this, SLOT(receivedOut(KProcess*, char*, int)) );
	connect( p, SIGNAL(receivedStderr(KProcess*, char*, int)), this, SLOT(receivedOut(KProcess*, char*, int)) );
	connect( p, SIGNAL(processExited (KProcess *)), this, SLOT(procExited(KProcess*)));

	p->start( KProcess::NotifyOnExit, KProcess::All );
}

KdeSudo::~KdeSudo()
{
}

void KdeSudo::receivedOut(KProcess*proc, char*buffer, int buflen)
{
	char *pcTmp= new char[buflen+1];
	strncpy(pcTmp,buffer,buflen);
	pcTmp[buflen]='\0';
	QString strOut(pcTmp);
	QCString iceauthvalue = getenv("ICEAUTHORITY");
	if (strOut.find("passprompt")!=-1)
	{
		bNeedPasswd=true;
		this->show();
	}
	else if (strOut.find("Sorry, try again")!=-1)
	{
		this->show();
		KMessageBox::error(this, i18n("Wrong password, try again!"));
	}
	else if (strOut.find("command not found")!=-1)
	{
		bError=true;
		KMessageBox::error(this, i18n("Command not found!"));
		kapp->quit();
	}
	else if (strOut.find("is not in the sudoers file")!=-1)
	{
		bError=true;
		KMessageBox::error(this, i18n("Your username is unknown to sudo!"));
		kapp->quit();
	}
	else if (strOut.find("is not allowed to execute")!=-1)
	{
		bError=true;
		KMessageBox::error(this, i18n("Your user is not allowed to run the specified command!"));
		kapp->quit();
	}
	else if (strOut.find("is not allowed to run sudo on")!=-1)
	{
		bError=true;
		KMessageBox::error(this, i18n("Your user is not allowed to run sudo on this host!"));
		kapp->quit();
	}
	else if (strOut.find("may not run sudo on")!=-1)
	{
		bError=true;
		KMessageBox::error(this, i18n("Your user is not allowed to run sudo on this host!"));
		kapp->quit();
	}

	//dump the output to stderr  
	fprintf(stderr,"%s\n",strOut.ascii());
}

void KdeSudo::procExited(KProcess *proc)
{
	//DEBUG  KMessageBox::information(this, "Proc exited!");
	//fprintf(stdout, "Proc ended! bError==%d\n", (bError)?1:0);

	if (!bNewDcop) {
		QFile::remove(iceauthorityFile);
	}

	if (!bError)
		kapp->quit();
}

void KdeSudo::slotOk()
{
	QString strTmp(password());
	strTmp+="\n";
	p->writeStdin(strTmp.ascii(),(int)strTmp.length());
	this->hide();
}

void KdeSudo::slotUser1()
{
	done(AsUser);
}
