#!/bin/sh

usage()
{
	# Title
	echo "Title: MPEG-4 3GPP Mobile (FFMPEG)"

	# Usable?
        test=`ffmpeg -formats 2> /dev/null | egrep "(Encoders:)|(.*E.*aac)" | grep aac | wc -l`
        [ "$test" -gt 0 ] && echo Status: Active || echo Status: Inactive

	# Type
	echo Flags: double-pass file-producer
	
        # Profiles
	which MP4Box > /dev/null
	if [ $? -eq 0 ]; then
		echo "Profile: 2.5G Unhinted"
		echo "Profile: 2.5G Hinted"
		echo "Profile: 3G Unhinted"
		echo "Profile: 3G Hinted"
	fi
}

execute()
{
	# Arguments
	normalisation="$1"
	length="$2"
	profile="$3"
	file="$4"
	pass="$6"
	[ "x$file" = "x" ] && file="kino_export_"`date +%Y-%m-%d_%H.%M.%S`

	# Variable parameters
	hq=""
	[ $pass -eq "2" ] && hq="-deinterlace"

	# Run the command
	if [ "$profile" -ge "0" ] && [ "$profile" -le "1" ]; then 
		ffmpeg -f dv -i pipe: -pass $pass -passlogfile "$file" -f 3gp \
		-vcodec mpeg4 $hq -b 30 \
		-r 5 -s qcif -aspect 4:3 -g 10 \
		-acodec aac -ab 8 -ar 8000 -ac 1 -y "$file".3gp
	else
		ffmpeg -f dv -i pipe: -pass $pass -passlogfile "$file" -f 3gp \
		-vcodec mpeg4 $hq -b 100 \
		-r 12 -s qcif -aspect 4:3 -g 24 \
		-acodec aac -ab 20 -ar 12000 -ac 1 -y "$file".3gp
	fi
	
	if [ $pass -eq "2" ]; then
		rm -f "$file-0.log"
		if [ $profile -eq "1" ] || [ $profile -eq "3" ]; then
			MP4Box -hint -latm -mtu 750 "$file".3gp 1>&2
		fi
	fi
}

[ "$1" = "--usage" ] || [ -z "$1" ] && usage "$@" || execute "$@"
