#!/bin/sh

usage()
{
	# Title
	echo "Title: MPEG-4 AVI Single Pass (FFMPEG)"

	# Usable?
	which ffmpeg > /dev/null
	[ $? -eq 0 ] && echo Status: Active || echo Status: Inactive

	# Type
	echo Flags: single-pass file-producer

	# Profiles
	echo "Profile: High Quality (640x480, VBR)"
	echo "Profile: Medium Quality (320x240, VBR)"
	echo "Profile: Broadband Quality (320x240, 564 Kbps)"
	echo "Profile: Low Quality (160x120, 12fps, 128 Kbps)"
}

execute()
{
	# Arguments
	normalisation="$1"
	length="$2"
	profile="$3"
	file="$4"
	[ "x$file" = "x" ] && file="kino_export_"`date +%Y-%m-%d_%H.%M.%S`
	
	# Determine audio codec (MP3 if avail)
	acodec="mp2"
	mp3=0
	mp3=`ffmpeg -formats 2> /dev/null | egrep "(Encoders:)|(.*E.*mp3)" | grep mp3 | wc -l`
	[ "$mp3" -gt 0 ] && acodec="mp3"

	# Run the command
	case "$profile" in 
		"0" ) 	ffmpeg -f dv -i pipe: -deinterlace -vtag DIVX -s 640x480 \
			-aspect 4:3 -qscale 4 \
			-acodec "$acodec" -ab 192 -y "$file".avi ;;
		"1" ) 	ffmpeg -f dv -i pipe: -deinterlace -vtag DIVX -s 320x240 \
			-aspect 4:3 -qscale 4 -acodec "$acodec" -ab 128 -y "$file".avi ;;
		"2" ) 	ffmpeg -f dv -i pipe: -deinterlace -vtag DIVX -s 320x240 \
			-aspect 4:3 -b 500 -acodec "$acodec" -ab 64 -y "$file".avi ;;
		"3" ) 	ffmpeg -f dv -i pipe: -deinterlace -r 12 -g 36 -vtag DIVX -s 160x120 \
			-aspect 4:3 -b 96 -acodec "$acodec" -ab 32 -y "$file".avi ;;
	esac
}

[ "$1" = "--usage" ] || [ -z "$1" ] && usage "$@" || execute "$@"
