#!/bin/sh
# By Ruda Matousek, October 5th 2004
# matousek(AT)utia.cas.cz

usage()
{
	# Title
	echo "Title: MPEG-4 AVI (MEncoder)"

	# Usable?
	command -v mencoder 1> /dev/null 2>&1
	[ $? -eq 0 ] && echo Status: Active || echo Status: Inactive

	# Type
	echo Flags: single-pass file-producer

	# Profiles
	echo "Profile: 384x288 700bps, mp3 128bps"
	echo "Profile: 640x480 2000bps, mp3 128bps"
	echo "Profile: 640x480 7000bps, mp3 224bps"
}

execute()
{
	# Arguments
	normalisation="$1"
	length="$2"
	profile="$3"
	file="$4"
	[ "x$file" = "x" ] && file="kino_export_"`date +%Y-%m-%d_%H.%M.%S`

	# Run the command
	# Note that the -cache 8192 parameter is required to force mencoder
	# to recognize the DV stream on STDIN.
	case "$profile" in 
		"0" ) 	mencoder - -quiet -cache 8192 -aspect 4:3 -vf harddup,scale=384:288 -ovc lavc -oac lavc -lavcopts vcodec=mpeg4:acodec=mp3:vhq:vbitrate=700:abitrate=128 -o "$file".avi ;;
		"1" ) 	mencoder - -quiet -cache 8192 -aspect 4:3 -vf harddup,pp=ci,scale=640:480 -ovc lavc -oac lavc -lavcopts vcodec=mpeg4:acodec=mp3:vhq:vbitrate=2000:abitrate=128 -o "$file".avi ;;
		"2" )   mencoder - -quiet -cache 8192 -aspect 4:3 -vf harddup,pp=ci,scale=640:480 -ovc lavc -oac lavc -lavcopts vcodec=mpeg4:acodec=mp3:vhq:vbitrate=7000:abitrate=224 -o "$file".avi ;;
	esac
}

[ "$1" = "--usage" ] || [ -z "$1" ] && usage "$@" || execute "$@"
