/*
* Copyright (C) 2000 Arne Schirmacher <arne@schirmacher.de>
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software Foundation,
* Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef _MESSAGE_H
#define _MESSAGE_H

#ifdef __cplusplus
extern "C"
{
#endif

void modal_message ( const char * message );
char *modal_prompt( const char * message );
int modal_confirm( const char * affirm_label, const char *close_label, const char *message, ... );
	
void modal_message_with_parent ( const char * message, GtkWidget *parent );
char *modal_prompt_with_parent( const char * message, GtkWidget *parent );
int modal_confirm_with_parent( const char * affirm_label, const char *close_label, GtkWidget *parent, const char *message, ... );

#ifdef __cplusplus
}
#endif

#endif
