// This is used to sort chunks in a patch always the same way,
// so that it's possible to see the actual changes in git history
// instead of the chunks possibly just being rearranged.

// g++ sortpatch.cpp -o sortpatch -I/usr/include/Qt -lQtCore

#include <qcoreapplication.h>
#include <qmap.h>
#include <qstringlist.h>
#include <qtextstream.h>

int main( int argc, char** argv )
    {
    QCoreApplication app( argc, argv );
    QTextStream in( stdin );
    QTextStream out( stdout );
    QMap< QString, QString > chunks; // key = filename
    QString headers;
    QString minusline;
    while( !in.atEnd())
        {
        QString line = in.readLine();
        if( !line.startsWith( "---" ))
            {
            headers.append( line + "\n" );
            continue;
            }
        minusline = line;
        break;
        }
    while( !in.atEnd())
        {
        QString plusline = in.readLine();
        if( !minusline.startsWith( "---" ) || !plusline.startsWith( "+++" ))
            return 1;
        QString chunk;
        chunk.append( minusline + "\n" );
        chunk.append( plusline + "\n" );
        while( !in.atEnd())
            {
            QString line = in.readLine();
            if( line.startsWith( "---" ))
                {
                minusline = line;
                break;
                }
            chunk.append( line + "\n" );
            }
        QString filename = plusline.split( " " )[ 1 ];
        chunks[ filename ] = chunk;
        }
    out << headers;
    foreach( QString chunk, chunks ) // QMap does the sorting
        out << chunk;
    return 0;
    }
