/***************************************************************************
 *
 * knetworkmanager.cpp - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Timo Hoenig <thoenig@suse.de>, <thoenig@nouse.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_DBUS_H
#define KNETWORKMANAGER_DBUS_H

class KNetworkManager;

#include <dbus/connection.h>
#include <NetworkManager/NetworkManager.h>
#include <NetworkManager/NetworkManagerVPN.h>

class DBusConnection : public QObject
{
	Q_OBJECT

	public:
	  DBusConnection  (void);
	  ~DBusConnection (void);

	  bool push   (KNetworkManager*);
	  void pop    (void);
	  bool status (void);

	  bool bla;

	  KNetworkManager* getContext    (void);
	  DBusConnection*  getConnection (void);

	public slots:
	  void reconnect     (void);

	private:
	  bool                   _initialized;
	  static DBusConnection* _dbus_connection;
	  DBusQt::Connection*    _connection; 
	  
	  bool open               (void);
	  void close              (void);
	  bool registerObjectPath (void);
	  bool addFilter          (void);
	  bool addMatch           (void);

	  
	  void initQt             (void);
	  void deinitQt           (void);

	  static KNetworkManager* _ctx;

	  static void              triggerReconnect                 (void);
	  static DBusHandlerResult networkManagerInfoMessageHandler (DBusConnection*, DBusMessage*, void*);
	  static DBusHandlerResult filterFunction                   (DBusConnection*, DBusMessage*, void*);
};

#endif /* KNETWORKMANAGER_DBUS_H */
