/***************************************************************************
 *
 * knetworkmanager-cdma_device.cpp - A NetworkManager frontend for KDE 
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <Helmut.Schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

// KDE includes
#include <kdebug.h>

// Qt includes
#include <qhostaddress.h>

// QDBus includes
#include <dbus/qdbuserror.h>
#include <dbus/qdbusconnection.h>

// NM includes
#include <NetworkManager.h>

// KNM includes
#include "knetworkmanager.h"
#include "knetworkmanager-cdma_device.h"
#include "dbus/cdmaproxy.h"

class CDMADevicePrivate
{
public:
	CDMADevicePrivate(QString service, QString obj_path)
		: nmCDMA(service, obj_path)
	{}
	~CDMADevicePrivate() {}

	DBus::CDMADeviceProxy nmCDMA;
};

CDMADevice::CDMADevice (const QString & obj_path)
	: CellularDevice(obj_path)
{
	d = new CDMADevicePrivate(NM_DBUS_SERVICE, obj_path);
	d->nmCDMA.setConnection(QDBusConnection::systemBus());
}

CDMADevice::~CDMADevice ()
{
	delete d;
}


#include "knetworkmanager-cdma_device.moc"
