/***************************************************************************
 *
 * knetworkmanager-connection.h - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_CONNECTION_H
#define KNETWORKMANAGER_CONNECTION_H

#include <qmap.h>
#include <qobject.h>

#include "knetworkmanager-connection_setting.h"
#include "dbus/connection.h"
#include "dbus/connectionnode.h"

class AccessPoint;
class QDBusObjectPath;

namespace ConnectionSettings
{

	class WirelessSecurity;
	class Connection;
	class ConnectionSetting;
	class ConnectionPrivate;
	class Info;
	class Wired;
	class Wireless;
	class WirelessSecurity;
	class IPv4;

	typedef QMap<QString, SettingsMap> ConnectionMap;

	// a connection wraps multiple settings
	class Connection : public QObject, DBus::ConnectionNode
	{
		Q_OBJECT
		public:
			Connection();
			virtual ~Connection();

			virtual QString                        getID() const = 0;
			virtual void                           setID(const QString& id) = 0;

			// get a specific setting
			ConnectionSetting*             getSetting(const QString&) const;

			// get all settings of this connection
			QValueList<ConnectionSetting*> getSettings() const;

			// attach a new setting
			virtual void appendSetting(ConnectionSetting* setting);

			// ugly stuff introduced by NM
			void setSpecificObject(const QString&);
			QString getSpecificObject() const;

			// sometimes its usefull to have the object_path
			QDBusObjectPath getObjectPath() const;

			// is the connection valid?
			virtual bool isValid() const;

			// the connections type (only for KNM use)
			virtual QString getType();

			// duplicate
			virtual Connection* duplicate() = 0;

			// update the settings from another connection
			void updateSettings(Connection*);

		public slots:

			// gets called from NM when it needs the secrets
			void slotSecretsNeeded(const QString& setting_name, const QStringList& hints, bool request_new);

			// gets called when the GUI provided new secrets
			void slotSecretsProvided(ConnectionSetting* setting);

			// signal a failure in getting new secrets
			void slotSecretsError();

			// gets called when a settings validity changes
			void slotSettingValidityChanged();

			// gets called when the connection is about to be removed
			void slotAboutToBeRemoved();

			// gets called when the connections settings changed
			void slotUpdated();

		protected:
			// implementations for ConnectionNode
			QDBusObjectBase* createInterface(const QString& interfaceName);
			QString objectPath() const;

		signals:

			// signal when we need new secrets
			void SecretsNeeded(Connection* connection, ConnectionSetting* setting, const QStringList& hints, bool request_new);

			// signal gets emitted when connections validity changes
			void validityChanged();

		private:
			ConnectionPrivate* d;
	};
}
#endif /* KNETWORKMANAGER_CONNECTION_H */
