/***************************************************************************
 *
 * knetworkmanager-connection_setting_cdma_widget.cpp - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2008 Novell, Inc.
 *
 * Author: Will Stephenson <wstephenson@kde.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_CONNECTION_SETTING_CDMA_WIDGET_H
#define KNETWORKMANAGER_CONNECTION_SETTING_CDMA_WIDGET_H


// qt headers
#include <qwidget.h>
#include <qlineedit.h>

// knm headers
#include "knetworkmanager-connection_setting_cdma.h"
#include "knetworkmanager-connection_setting_widget_interface.h"
#include "knetworkmanager-device.h"

//class VPNService;
class ConnectionSettingCdmaWidget;

namespace ConnectionSettings
{

class Connection;

class CDMAWidgetImpl : public WidgetInterface
{
	Q_OBJECT
	public:
		CDMAWidgetImpl(Connection* conn, QWidget* parent = NULL, const char* name = NULL, WFlags fl = 0);
		void Activate();
		void Deactivate();
	public slots:
		void dirty();

	private:
		void Init();
		//VPNConfigWidget* getVPNConfigWidget(VPNService* service);


		CDMA* _cdmasetting;
		ConnectionSettingCdmaWidget* _mainWid;
};

}
#endif /* KNETWORKMANAGER_CONNECTION_SETTING_CDMA_WIDGET_H*/
