/***************************************************************************
 *
 * knetworkmanager-connection_setting_ppp.h - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_CONNECTION_SETTING_PPP_H
#define KNETWORKMANAGER_CONNECTION_SETTING_PPP_H

#include <stdint.h>
#include <qhostaddress.h>
#include <qmap.h>
#include <qvariant.h>
#include <qobject.h>

#include <dbus/qdbusdata.h>

#include "knetworkmanager-connection_setting.h"

namespace ConnectionSettings
{

class Connection;

// serial setting
class PPP : public ConnectionSetting
{
	public:
		PPP(Connection* conn);

		SettingsMap toMap() const;
		SettingsMap toSecretsMap(bool with_settings = true) const;
		void        fromMap(const SettingsMap&);
		bool        fromSecretsMap(const SettingsMap&);

		bool     isValid() const;
		bool     useSetting();

		bool     getNoAuth() const;
		void     setNoAuth(bool);

		bool     getRefuseEAP() const;
		void     setRefuseEAP(bool);

		bool     getRefusePAP() const;
		void     setRefusePAP(bool);

		bool     getRefuseChap() const;
		void     setRefuseChap(bool);

		bool     getRefuseMSChap() const;
		void     setRefuseMSChap(bool);

		bool     getRefuseMSChapV2() const;
		void     setRefuseMSChapV2(bool);

		bool     getNoBSDComp() const;
		void     setNoBSDComp(bool);

		bool     getNoDeflate() const;
		void     setNoDeflate(bool);

		bool     getNoVJComp() const;
		void     setNoVJComp(bool);

		bool     getRequireMPPE() const;
		void     setRequireMPPE(bool);

		bool     getRequireMPPE128() const;
		void     setRequireMPPE128(bool);

		bool     getMPPEStateful() const;
		void     setMPPEStateful(bool);

		bool     getRequireMPPC() const;
		void     setRequireMPPC(bool);

		bool     getCRTSCTS() const;
		void     setCRTSCTS(bool);

		Q_INT32  getBaud() const;
		void     setBaud(Q_INT32);

		Q_INT32  getMRU() const;
		void     setMRU(Q_INT32);

		Q_INT32  getMTU() const;
		void     setMTU(Q_INT32);

		Q_INT32  getLCPEchoFailure() const;
		void     setLCPEchoFailure(Q_INT32);

		Q_INT32  getLCPEchoInterval() const;
		void     setLCPEchoInterval(Q_INT32);

	private:
		bool     _noauth;
		bool     _refuse_eap;
		bool     _refuse_pap;
		bool     _refuse_chap;
		bool     _refuse_mschap;
		bool     _refuse_mschapv2;
		bool     _nobsdcomp;
		bool     _nodeflate;
		bool     _novjcomp;
		bool     _require_mppe;
		bool     _require_mppe_128;
		bool     _mppe_stateful;
		bool     _require_mppc;
		bool     _crtscts;
		Q_UINT32  _baud;
		Q_UINT32  _mru;
		Q_UINT32  _mtu;
		Q_UINT32  _lcp_echo_failure;
		Q_UINT32  _lcp_echo_interval;
};
}
#endif /* KNETWORKMANAGER_CONNECTION_SETTING_PPP_H */
