/***************************************************************************
 *
 * knetworkmanager-pluginmanager.h - A NetworkManager frontend for KDE 
 *
 * Copyright (C) 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_PLUGINMANAGER_H
#define KNETWORKMANAGER_PLUGINMANAGER_H

#include <qobject.h>
#include <qmap.h>
#include <qvaluelist.h>

#include "knetworkmanager-plugin.h"
#include "knetworkmanager.h"

class KPluginInfo;

typedef QMap<KPluginInfo*, Plugin*> PluginMap;

class PluginManager : public QObject
{
	Q_OBJECT
	public:
		PluginManager(QObject*, const char*);
		~PluginManager();

		QStringList getPluginList(const QString&, const QString&, const QString&) const;
		Plugin* getPlugin(const QString&);
		const KPluginInfo* getPluginInfo(const QString&);
		const KPluginInfo* getPluginInfo(const Plugin*);

	  static PluginManager* getInstance (void);

	public slots:
		void loadAllPlugins();

	private:
		QValueList<KPluginInfo*> _plugins;
		PluginMap _loadedPlugins;

		Plugin* loadPlugin(const QString& pluginID);
		KPluginInfo* infoForPluginID(const QString& pluginID) const;

		static PluginManager* _instance;
};

#endif /* KNETWORKMANAGER_PLUGINMANAGER_H */
