/***************************************************************************
 *
 * knetworkmanager-ppp_connection.h - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2008 Novell, Inc.
 *
 * Author: Will Stephenson <wstephenson@kde.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#include "knetworkmanager-ppp_connection.h"

#include <nm-setting-ppp.h>
#include <nm-setting-ip4-config.h>

ConnectionSettings::PPPConnection::PPPConnection(const QString & infoName)
    : GenericConnection(infoName)
{
	appendSetting(new IPv4(this));
	appendSetting(new PPP(this));
}

ConnectionSettings::PPPConnection::~PPPConnection()
{

}

ConnectionSettings::IPv4* ConnectionSettings::PPPConnection::getIPv4Setting() const
{
	return dynamic_cast<ConnectionSettings::IPv4*>(getSetting(NM_SETTING_IP4_CONFIG_SETTING_NAME));
}

ConnectionSettings::PPP* ConnectionSettings::PPPConnection::getPPPSetting() const
{
	return dynamic_cast<PPP*>(getSetting(NM_SETTING_PPP_SETTING_NAME));
}

#include "knetworkmanager-ppp_connection.moc"

// vim: sw=4 sts=4 noet tw=100
