/***************************************************************************
 *   Copyright (C) 2007 by Todor Gyumyushev   *
 *   yodor@developer.bg   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/



#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kuniqueapplication.h>


#include "MainWidget.h"

#include <X11/Xlib.h>


static const char description[] =
    I18N_NOOP("A virtual keyboard for KDE");

static const char version[] = "0.4.5";

static KCmdLineOptions options[] =
{
 { "loginhelper", I18N_NOOP("Stand alone version for use with KDM or XDM"), 0 },
};


void findAloneWindow()
{
	unsigned int numkids, i,mapped,scrn;
	Window r, p, *kids;
	//XWindowAttributes attr;
	Window root;
	Display *dipsy;
	char *win_name;

	dipsy = XOpenDisplay(0);
	scrn = DefaultScreen(dipsy);
	root = RootWindow(dipsy, scrn);
	
	mapped = 0;
	XQueryTree(dipsy, root, &r, &p, &kids, &numkids);
		

	for (i = 0; i < numkids;  ++i)
	{
			XFetchName(dipsy, kids[i], &win_name);
			QString c(win_name);
			
			if (c=="kvkbdalone")
 			{
 				long wid = kids[i];
				XDestroyWindow(dipsy,wid);
				XFlush(dipsy);
				i=numkids;
 			}
			XFree(win_name);
	} 
}

class Kvkbd : public KUniqueApplication
{

public:
	Kvkbd(): KUniqueApplication(true,true,true) {
	
	};
	

	int newInstance(){
		MainWidget *main = (MainWidget *)mainWidget();
		if (!main)
		{
			main = new MainWidget(const_cast<KAboutData *>(aboutData()),false, 0, "kvkbd");
			setMainWidget( main );
		}
		main->show();
		return 0;
	};

	bool process(const QCString &fun, const QByteArray &data,
			QCString &replyType, QByteArray &replyData) {
				
		MainWidget *main = (MainWidget *)mainWidget();
		if (main) {
			if (fun == "show()") {
				main->show();
				return true;
			}
			else if (fun == "hide()") {
				main->hide();
				return true;	
			} 
		}
		
		return KUniqueApplication::process(fun,data,replyType,replyData);
		
	};

	bool x11EventFilter ( XEvent *event ){
		MainWidget *main = (MainWidget *)mainWidget();
		if (main) {
			if (event->type==MappingNotify) {
				XMappingEvent *e = (XMappingEvent *)event;
				if (e->request== MappingKeyboard) {
					main->mappingNotify(e);
				}
			}
		}
		
		return false;
	};


};

class KvkbdApp : public QApplication
{
public:
	KvkbdApp(int argc, char** argv, bool gui):QApplication(argc,argv,gui){
		
	};

	bool x11EventFilter ( XEvent *event ) {	
		if (event->type == DestroyNotify) {
			QApplication::exit();
		}
		else if (event->type == MappingNotify) {
			
				MainWidget *main = (MainWidget *)mainWidget();
				if (main) {
					XMappingEvent *e = (XMappingEvent *) event;
					if (e->request==MappingKeyboard) {
						main->mappingNotify(e);	
					}
				}
			
		}
		return false;
	};
};

int main(int argc, char **argv)
{
	
    KAboutData about("kvkbd", I18N_NOOP("kvkbd"), version, description,
                     KAboutData::License_GPL, "(C) 2007 Todor Gyumyushev", 0, 0, "yodor@developer.bg");
    about.addAuthor( "Todor Gyumyushev", 0, "yodor@developer.bg" );
	
	bool alone=false;
	
	if (argc>0) {
		int curr=0;
		while (curr<argc) {
			if (strcmp(argv[curr],"-loginhelper")==0){
				alone=true;
				break;
			}
			curr++;
		}
		
	}
	argc++;
	if (alone==true){
		KvkbdApp a(argc,argv,true);
		MainWidget *m = new MainWidget( &about, true, 0, "kvkbdalone");
		a.setMainWidget(m);
		m->show();
		return a.exec();
	}
	else
	{
		
		KCmdLineArgs::init(argc, argv, &about);
		KCmdLineArgs::addCmdLineOptions( options );
		Kvkbd::addCmdLineOptions();
		//KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

		findAloneWindow();
		Kvkbd a;
		return a.exec();
	}
  	
}

