
#include <rqfindwindow.h>
#include <rqpackageitem.h>
#include <rqpackagepopup.h>

#include <qpushbutton.h>
#include <qlistview.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qregexp.h>

#include <rpackagelister.h>
#include <rqmainwindow.h>

RQFindWindow::RQFindWindow(RQMainWindow *parent, RPackageLister *lister)
   : WindowFind(parent), _listViewControl(lister, _packageListView),
     _lister(lister), _mainWin(parent),
     _packagePopup(this), _packageTip(_packageListView)
{
   connect(_closeButton, SIGNAL(clicked()), this, SLOT(accept()));

   // Actions that trigger a find.
   connect(_findButton, SIGNAL(clicked()), this, SLOT(find()));
   connect(_findLineEdit, SIGNAL(returnPressed()), this, SLOT(find()));
   connect(_regexCheckBox, SIGNAL(clicked()), this, SLOT(find()));

   // Dynamic results smart checking.
   connect(_summaryCheckBox, SIGNAL(clicked()),
           this, SLOT(resetDynamicResults()));
   connect(_descriptionCheckBox, SIGNAL(clicked()),
           this, SLOT(resetDynamicResults()));
   connect(_dynamicCheckBox, SIGNAL(toggled(bool)),
           this, SLOT(setDynamicResults(bool)));

   resetDynamicResults();

   _listViewControl.setClickable(true);
   _listViewControl.reloadAllPackages();
}

void RQFindWindow::find()
{
   find(_findLineEdit->text());
}

void RQFindWindow::find(const QString &text)
{
   RQPackageItem *pkgItem = (RQPackageItem*)_packageListView->firstChild();
   QRegExp re(text, false, !_regexCheckBox->isChecked());
   if (re.isValid()) {
      bool matched = false;
      RPackage *pkg;
      while (pkgItem) {
         pkg = pkgItem->pkg;
         if ((_nameCheckBox->isChecked()
              && re.search(pkg->name()) != -1) ||
             (_summaryCheckBox->isChecked()
              && re.search(pkg->summary()) != -1) ||
             (_descriptionCheckBox->isChecked()
              && re.search(pkg->description()) != -1))
            matched = true;
         else
            matched = false;
         pkgItem->setVisible(matched);
         pkgItem = (RQPackageItem *)pkgItem->nextSibling();
      }
   }
}

void RQFindWindow::setDynamicResults(bool flag)
{
   _dynamicCheckBox->setChecked(flag);
   _findButton->setEnabled(!flag);

   if (flag)
      connect(_findLineEdit, SIGNAL(textChanged(const QString &)),
              this, SLOT(find(const QString &)));
   else
      disconnect(_findLineEdit, SIGNAL(textChanged(const QString &)),
                 this, SLOT(find(const QString &)));
}

void RQFindWindow::resetDynamicResults()
{
   bool dynamic = true;
   if (_summaryCheckBox->isChecked() || _descriptionCheckBox->isChecked())
      dynamic = false;
   setDynamicResults(dynamic);
}

// vim:ts=3:sw=3:et
