/* rguserdialog.cc
 *
 * Copyright (c) 2000, 2001 Conectiva S/A
 *               2003 Michael Vogt
 *
 * Author: Alfredo K. Kojima <kojima@conectiva.com.br>
 *         Michael Vogt <mvo@debian.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <rquserdialog.h>
#include <kmessagebox.h>
#include <qstring.h>

#include <apt-pkg/error.h>
#include <apt-pkg/fileutl.h>

bool RQUserDialog::message(const char *msg,
                           RUserDialog::DialogType dialog,
                           RUserDialog::ButtonsType buttons, bool defres)
{
   KGuiItem buttonYes;
   KGuiItem buttonNo;
   KMessageBox::DialogType dialogType;
   int options = KMessageBox::Notify;

   switch (dialog) {
      case RUserDialog::DialogInfo:
         dialogType = KMessageBox::Information;
         buttonYes = KStdGuiItem::ok();
         break;
      case RUserDialog::DialogWarning:
         dialogType = KMessageBox::Sorry;
         buttonYes = KStdGuiItem::ok();
         break;
      case RUserDialog::DialogError:
         dialogType = KMessageBox::Error;
         buttonYes = KStdGuiItem::ok();
         break;
      case RUserDialog::DialogQuestion:
         dialogType = KMessageBox::QuestionYesNo;
         buttonYes = KStdGuiItem::yes();
         buttonNo = KStdGuiItem::no();
         break;
   }

   switch (buttons) {
      case RUserDialog::ButtonsDefault:
      case RUserDialog::ButtonsOk:
         break;
      case RUserDialog::ButtonsOkCancel:
         if (defres)
            dialogType = KMessageBox::QuestionYesNo;
         else
            dialogType = KMessageBox::WarningYesNo;
         buttonYes = KStdGuiItem::ok();
         buttonNo = KStdGuiItem::cancel();
         break;
      case RUserDialog::ButtonsYesNo:
         if (defres)
            dialogType = KMessageBox::QuestionYesNo;
         else
            dialogType = KMessageBox::WarningYesNo;
         buttonYes = KStdGuiItem::yes();
         buttonNo = KStdGuiItem::no();
         break;
   }

   int res = KMessageBox::messageBox(_parent, dialogType, msg, "Kynaptic",
                                     buttonYes, buttonNo, options);

   return (res == KMessageBox::Ok ||
           res == KMessageBox::Yes ||
           res == KMessageBox::Continue);
}

// vim:ts=3:sw=3:et
