
namespace Btctl.Test {

	using System;
	using System.Runtime.InteropServices;
	using Btctl;
	using Gtk;

	public class TestApp {

		public static void Main (string[] args)
		{
			Application.Init ();

			Obex obex = new Obex ();

			if (obex.IsInitialised) {
				Console.WriteLine ("Initialised OK.");

				obex.RequestPut += Put_Request;
				obex.Put += Put;
				obex.Error += Error;
				obex.Progress += Progress;
				obex.Complete += Complete;

				Application.Run ();
			} else {
				Console.WriteLine ("Not initialised, exiting.");
			}
		}

		static void Progress (object obj, ProgressArgs args)
		{
			Console.WriteLine ("Progress from {0}", args.Bdaddr);
		}

		static void Complete (object obj, CompleteArgs args)
		{
			Console.WriteLine ("Complete from {0}", args.Bdaddr);
		}

		static void Put_Request (object obj, RequestPutArgs args)
		{
			Console.WriteLine ("Put request from {0}", args.Bdaddr);
		}

		static void Put (object obj, PutArgs args)
		{
			Console.WriteLine ("Put from {0}, filename {1}, len {2}",
					args.Bdaddr, args.Fname, args.Len);
		}

		static void Error (object o, ErrorArgs args)
		{
			Console.WriteLine ("Error from {0}, code {1}",
					args.Bdaddr, args.Code);
		}

	}
}
