/**
 * @file SearchResults.qml
 * @brief Libertine search results list view component
 */
/*
 * Copyright 2015-2016 Canonical Ltd
 *
 * Libertine is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, version 3, as published by the
 * Free Software Foundation.
 *
 * Libertine is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
import QtQuick 2.4
import Ubuntu.Components 1.3
import Ubuntu.Components.Popups 1.3


UbuntuListView {
    id: listView
    anchors {
        topMargin: pageHeader.height
        fill: parent
    }

    function install(packageName) {
        if (!containerConfigList.isAppInstalled(mainView.currentContainer, packageName)) {
            pageStack.pop()
            pageStack.currentPage.installPackage(packageName)
        }
        else {
            PopupUtils.open(Qt.resolvedUrl("PackageExistsDialog.qml"), null, {"package_name": packageName})
        }
    }
    
    delegate: ListItem {
        id: packageItem
        Label {
            text: model.package_desc
            anchors {
                verticalCenter: parent.verticalCenter
                left: parent.left
                leftMargin: units.gu(2)
            }
        }

        onClicked: {
            listView.install(model.package_name)
        }

        trailingActions: ListItemActions {
            actions: [
                Action {
                    iconName: "select"
                    description: i18n.tr("Install Package")
                    onTriggered: {
                        listView.install(model.package_name)
                    }
                }
            ]
        }
    }
}
