/*
 * Gksu -- a library providing access to su functionality
 * Copyright (C) 2004 Gustavo Noronha Silva
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __GKSU_CONTEXT_H__
#define __GKSU_CONTEXT_H__

#include <glib.h>
#include <glib-object.h>

#define GKSU_TYPE_CONTEXT (gksu_context_get_type ())
#define GKSU_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), GKSU_TYPE_CONTEXT, GksuContext))
#define GKSU_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), GKSU_TYPE_CONTEXT, GksuContextClass))
#define GKSU_IS_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), GKSU_TYPE_CONTEXT))
#define GKSU_IS_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GKSU_TYPE_CONTEXT))
#define GKSU_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GKSU_TYPE_CONTEXT, GksuContextClass))

G_BEGIN_DECLS

typedef enum
{
  GKSU_CONTEXT_ERROR_XAUTH,
  GKSU_CONTEXT_ERROR_HELPER,
  GKSU_CONTEXT_ERROR_NOCOMMAND,
  GKSU_CONTEXT_ERROR_NOPASSWORD,
  GKSU_CONTEXT_ERROR_FORK,
  GKSU_CONTEXT_ERROR_EXEC,
  GKSU_CONTEXT_ERROR_PIPE,
  GKSU_CONTEXT_ERROR_PIPEREAD,
  GKSU_CONTEXT_ERROR_WRONGPASS,
  GKSU_CONTEXT_ERROR_CHILDFAILED
} GksuContextError;

#define GKSU_TYPE_CONTEXT_ERROR (gksu_context_error_get_type ())

typedef struct _GksuContext GksuContext;
typedef struct _GksuContextClass GksuContextClass;

/**
 * GksuContext:
 * @parent: #GksuContext is based on #GObject
 * @xauth: the X authorization token
 * @dir: the directory where the .Xauthority file is created in sudo
 * mode
 * @display: storage for the DISPLAY environment variable
 * @user: user gksu will switch to
 * @password: the password that should be passed to su or sudo
 * @command: which command to run with su
 * @login_shell: should run a login shell?
 * @keep_env: should the current environment be kept?
 * @debug: show debug information?
 * @ssh_fwd: are we running inside a ssh X11 forwarding
 * tunnel?
 *
 * Object that holds all configuration information, some
 * important environment variables and some meta-information
 * about mainly x authentication.
 *
 */
struct _GksuContext
{
  GObject parent;

  gchar *xauth;
  gchar *dir;

  gchar *display;

  gchar *user;
  gchar *password;
  gchar *command;

  gboolean login_shell;
  gboolean keep_env;

  gboolean debug;
  gboolean ssh_fwd;
};

struct _GksuContextClass
{
  GObjectClass parent;
};

/* 
   Context handling
*/
GksuContext*
gksu_context_new ();

void
gksu_context_free (GksuContext *context);

/* 
   getters and setters for the configuration
   options
*/
void
gksu_context_set_user (GksuContext *context, gchar *username);

const gchar*
gksu_context_get_user (GksuContext *context);

void
gksu_context_set_command (GksuContext *context, gchar *command);

const gchar*
gksu_context_get_command (GksuContext *context);

void
gksu_context_set_password (GksuContext *context, gchar *password);

const gchar*
gksu_context_get_password (GksuContext *context);

void
gksu_context_set_login_shell (GksuContext *context, gboolean value);

gboolean
gksu_context_get_login_shell (GksuContext *context);

void
gksu_context_set_keep_env (GksuContext *context, gboolean value);

gboolean
gksu_context_get_keep_env (GksuContext *context);

void
gksu_context_set_debug (GksuContext *context, gboolean value);

gboolean
gksu_context_get_debug (GksuContext *context);

void
gksu_context_set_ssh_fwd (GksuContext *context, gboolean value);

gboolean
gksu_context_get_ssh_fwd (GksuContext *context);

GType
gksu_context_get_type (void);

gboolean
gksu_context_try_need_password (GksuContext *context);

gboolean
gksu_context_run (GksuContext *context, GError **error);

gboolean
gksu_context_sudo_try_need_password (GksuContext *context);

gboolean
gksu_context_sudo_run (GksuContext *context, GError **error);

G_END_DECLS

#endif
