/* context.c generated by valac 0.44.7, the Vala compiler
 * generated from context.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright © 2014 Nikhar Agrawal
 * Copyright © 2015 Michael Catanzaro <mcatanzaro@gnome.org>
 *
 * This file is part of libgnome-games-support.
 *
 * libgnome-games-support is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * libgnome-games-support is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with libgnome-games-support.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <errno.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>

typedef enum  {
	GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER,
	GAMES_SCORES_STYLE_POINTS_LESS_IS_BETTER,
	GAMES_SCORES_STYLE_TIME_GREATER_IS_BETTER,
	GAMES_SCORES_STYLE_TIME_LESS_IS_BETTER
} GamesScoresStyle;

#define GAMES_SCORES_TYPE_STYLE (games_scores_style_get_type ())

#define GAMES_SCORES_TYPE_CONTEXT (games_scores_context_get_type ())
#define GAMES_SCORES_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_SCORES_TYPE_CONTEXT, GamesScoresContext))
#define GAMES_SCORES_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_SCORES_TYPE_CONTEXT, GamesScoresContextClass))
#define GAMES_SCORES_IS_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_SCORES_TYPE_CONTEXT))
#define GAMES_SCORES_IS_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_SCORES_TYPE_CONTEXT))
#define GAMES_SCORES_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_SCORES_TYPE_CONTEXT, GamesScoresContextClass))

typedef struct _GamesScoresContext GamesScoresContext;
typedef struct _GamesScoresContextClass GamesScoresContextClass;
typedef struct _GamesScoresContextPrivate GamesScoresContextPrivate;

#define GAMES_SCORES_TYPE_IMPORTER (games_scores_importer_get_type ())
#define GAMES_SCORES_IMPORTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_SCORES_TYPE_IMPORTER, GamesScoresImporter))
#define GAMES_SCORES_IMPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_SCORES_TYPE_IMPORTER, GamesScoresImporterClass))
#define GAMES_SCORES_IS_IMPORTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_SCORES_TYPE_IMPORTER))
#define GAMES_SCORES_IS_IMPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_SCORES_TYPE_IMPORTER))
#define GAMES_SCORES_IMPORTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_SCORES_TYPE_IMPORTER, GamesScoresImporterClass))

typedef struct _GamesScoresImporter GamesScoresImporter;
typedef struct _GamesScoresImporterClass GamesScoresImporterClass;

#define GAMES_SCORES_TYPE_CATEGORY (games_scores_category_get_type ())
#define GAMES_SCORES_CATEGORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_SCORES_TYPE_CATEGORY, GamesScoresCategory))
#define GAMES_SCORES_CATEGORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_SCORES_TYPE_CATEGORY, GamesScoresCategoryClass))
#define GAMES_SCORES_IS_CATEGORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_SCORES_TYPE_CATEGORY))
#define GAMES_SCORES_IS_CATEGORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_SCORES_TYPE_CATEGORY))
#define GAMES_SCORES_CATEGORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_SCORES_TYPE_CATEGORY, GamesScoresCategoryClass))

typedef struct _GamesScoresCategory GamesScoresCategory;
typedef struct _GamesScoresCategoryClass GamesScoresCategoryClass;

#define GAMES_SCORES_TYPE_SCORE (games_scores_score_get_type ())
#define GAMES_SCORES_SCORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_SCORES_TYPE_SCORE, GamesScoresScore))
#define GAMES_SCORES_SCORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_SCORES_TYPE_SCORE, GamesScoresScoreClass))
#define GAMES_SCORES_IS_SCORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_SCORES_TYPE_SCORE))
#define GAMES_SCORES_IS_SCORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_SCORES_TYPE_SCORE))
#define GAMES_SCORES_SCORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_SCORES_TYPE_SCORE, GamesScoresScoreClass))

typedef struct _GamesScoresScore GamesScoresScore;
typedef struct _GamesScoresScoreClass GamesScoresScoreClass;
typedef GamesScoresCategory* (*GamesScoresContextCategoryRequestFunc) (const gchar* category_key, gpointer user_data);
enum  {
	GAMES_SCORES_CONTEXT_0_PROPERTY,
	GAMES_SCORES_CONTEXT_APP_NAME_PROPERTY,
	GAMES_SCORES_CONTEXT_CATEGORY_TYPE_PROPERTY,
	GAMES_SCORES_CONTEXT_GAME_WINDOW_PROPERTY,
	GAMES_SCORES_CONTEXT_STYLE_PROPERTY,
	GAMES_SCORES_CONTEXT_IMPORTER_PROPERTY,
	GAMES_SCORES_CONTEXT_NUM_PROPERTIES
};
static GParamSpec* games_scores_context_properties[GAMES_SCORES_CONTEXT_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GamesScoresContextSaveScoreToFileData GamesScoresContextSaveScoreToFileData;
typedef struct _GamesScoresContextAddScoreInternalData GamesScoresContextAddScoreInternalData;
typedef struct _GamesScoresContextAddScoreData GamesScoresContextAddScoreData;
typedef struct _Block2Data Block2Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_main_context_unref0(var) ((var == NULL) ? NULL : (var = (g_main_context_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
typedef struct _Block3Data Block3Data;

#define GAMES_SCORES_TYPE_DIALOG (games_scores_dialog_get_type ())
#define GAMES_SCORES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_SCORES_TYPE_DIALOG, GamesScoresDialog))
#define GAMES_SCORES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_SCORES_TYPE_DIALOG, GamesScoresDialogClass))
#define GAMES_SCORES_IS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_SCORES_TYPE_DIALOG))
#define GAMES_SCORES_IS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_SCORES_TYPE_DIALOG))
#define GAMES_SCORES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_SCORES_TYPE_DIALOG, GamesScoresDialogClass))

typedef struct _GamesScoresDialog GamesScoresDialog;
typedef struct _GamesScoresDialogClass GamesScoresDialogClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GamesScoresContext {
	GObject parent_instance;
	GamesScoresContextPrivate * priv;
};

struct _GamesScoresContextClass {
	GObjectClass parent_class;
};

struct _GamesScoresContextPrivate {
	gchar* _app_name;
	gchar* _category_type;
	GtkWindow* _game_window;
	GamesScoresStyle _style;
	GamesScoresImporter* _importer;
	GamesScoresCategory* current_category;
	GeeHashMap* scores_per_category;
	gchar* user_score_dir;
	gboolean scores_loaded;
	GamesScoresContextCategoryRequestFunc category_request;
	gpointer category_request_target;
	GDestroyNotify category_request_target_destroy_notify;
};

struct _Block1Data {
	int _ref_count_;
	GamesScoresContext* self;
	GamesScoresContextCategoryRequestFunc category_request;
	gpointer category_request_target;
};

struct _GamesScoresContextSaveScoreToFileData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	GamesScoresContext* self;
	GamesScoresScore* score;
	GamesScoresCategory* category;
	GCancellable* cancellable;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GError* _tmp3_;
	GFile* file;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GFile* _tmp9_;
	GFile* _tmp10_;
	GFileOutputStream* stream;
	GFile* _tmp11_;
	GFileOutputStream* _tmp12_;
	gchar* line;
	glong _tmp13_;
	glong _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gint64 _tmp17_;
	gint64 _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	GFileOutputStream* _tmp26_;
	const gchar* _tmp27_;
	guint8* _tmp28_;
	gint _tmp28__length1;
	guint8* _tmp29_;
	gint _tmp29__length1;
	GError* _inner_error0_;
};

struct _GamesScoresContextAddScoreInternalData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	GamesScoresContext* self;
	GamesScoresScore* score;
	GamesScoresCategory* category;
	gboolean allow_dialog;
	GCancellable* cancellable;
	gboolean result;
	gboolean high_score_added;
	glong _tmp0_;
	glong _tmp1_;
	GeeHashMap* _tmp2_;
	GeeHashMap* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	GeeHashMap* _tmp6_;
	gpointer _tmp7_;
	GeeList* _tmp8_;
	gboolean _tmp9_;
	GamesScoresCategory* _tmp10_;
	gboolean _tmp11_;
	GamesScoresCategory* _tmp12_;
	GError* _inner_error0_;
};

struct _GamesScoresContextAddScoreData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	GamesScoresContext* self;
	glong score;
	GamesScoresCategory* category;
	GCancellable* cancellable;
	gboolean result;
	gboolean _tmp0_;
	GamesScoresScore* _tmp1_;
	GamesScoresScore* _tmp2_;
	GtkWindow* _tmp3_;
	gboolean _tmp4_;
	GError* _inner_error0_;
};

struct _Block2Data {
	int _ref_count_;
	GamesScoresContext* self;
	GMainLoop* main_loop;
	gboolean ret;
	GError* _error_;
};

struct _Block3Data {
	int _ref_count_;
	GamesScoresContext* self;
	GamesScoresContextCategoryRequestFunc category_request;
	gpointer category_request_target;
};

static gint GamesScoresContext_private_offset;
static gpointer games_scores_context_parent_class = NULL;
static GeeHashDataFunc games_scores_context_category_hash;
static gpointer games_scores_context_category_hash_target;
static GDestroyNotify games_scores_context_category_hash_target_destroy_notify;
static GeeHashDataFunc games_scores_context_category_hash = NULL;
static gpointer games_scores_context_category_hash_target = NULL;
static GDestroyNotify games_scores_context_category_hash_target_destroy_notify = NULL;
static GeeEqualDataFunc games_scores_context_category_equal;
static gpointer games_scores_context_category_equal_target;
static GDestroyNotify games_scores_context_category_equal_target_destroy_notify;
static GeeEqualDataFunc games_scores_context_category_equal = NULL;
static gpointer games_scores_context_category_equal_target = NULL;
static GDestroyNotify games_scores_context_category_equal_target_destroy_notify = NULL;

GType games_scores_style_get_type (void) G_GNUC_CONST;
GType games_scores_context_get_type (void) G_GNUC_CONST;
GType games_scores_importer_get_type (void) G_GNUC_CONST;
GType games_scores_category_get_type (void) G_GNUC_CONST;
GType games_scores_score_get_type (void) G_GNUC_CONST;
static guint _games_scores_context_category_hash_lambda4_ (GamesScoresCategory* a);
const gchar* games_scores_category_get_key (GamesScoresCategory* self);
static guint __games_scores_context_category_hash_lambda4__gee_hash_data_func (gconstpointer v,
                                                                        gpointer self);
static gboolean _games_scores_context_category_equal_lambda5_ (GamesScoresCategory* a,
                                                        GamesScoresCategory* b);
static gboolean __games_scores_context_category_equal_lambda5__gee_equal_data_func (gconstpointer a,
                                                                             gconstpointer b,
                                                                             gpointer self);
GamesScoresContext* games_scores_context_new (const gchar* app_name,
                                              const gchar* category_type,
                                              GtkWindow* game_window,
                                              GamesScoresContextCategoryRequestFunc category_request,
                                              gpointer category_request_target,
                                              GamesScoresStyle style);
GamesScoresContext* games_scores_context_construct (GType object_type,
                                                    const gchar* app_name,
                                                    const gchar* category_type,
                                                    GtkWindow* game_window,
                                                    GamesScoresContextCategoryRequestFunc category_request,
                                                    gpointer category_request_target,
                                                    GamesScoresStyle style);
GamesScoresContext* games_scores_context_new_with_importer (const gchar* app_name,
                                                            const gchar* category_type,
                                                            GtkWindow* game_window,
                                                            GamesScoresContextCategoryRequestFunc category_request,
                                                            gpointer category_request_target,
                                                            GamesScoresStyle style,
                                                            GamesScoresImporter* importer);
GamesScoresContext* games_scores_context_construct_with_importer (GType object_type,
                                                                  const gchar* app_name,
                                                                  const gchar* category_type,
                                                                  GtkWindow* game_window,
                                                                  GamesScoresContextCategoryRequestFunc category_request,
                                                                  gpointer category_request_target,
                                                                  GamesScoresStyle style,
                                                                  GamesScoresImporter* importer);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static GamesScoresCategory* __lambda6_ (Block1Data* _data1_,
                                 const gchar* key);
static GamesScoresCategory* ___lambda6__games_scores_context_category_request_func (const gchar* category_key,
                                                                             gpointer self);
static void games_scores_context_load_scores_from_files (GamesScoresContext* self,
                                                  GError** error);
static void games_scores_context_real_constructed (GObject* base);
const gchar* games_scores_context_get_app_name (GamesScoresContext* self);
GamesScoresImporter* games_scores_context_get_importer (GamesScoresContext* self);
void games_scores_importer_run (GamesScoresImporter* self,
                                GamesScoresContext* context,
                                const gchar* new_scores_dir);
GList* games_scores_context_get_categories (GamesScoresContext* self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
void games_scores_context_update_score_name (GamesScoresContext* self,
                                             GamesScoresScore* old_score,
                                             GamesScoresCategory* category,
                                             const gchar* new_name);
gboolean games_scores_score_equals (GamesScoresScore* a,
                                    GamesScoresScore* b);
void games_scores_score_set_user (GamesScoresScore* self,
                                  const gchar* value);
GeeList* games_scores_context_get_high_scores (GamesScoresContext* self,
                                               GamesScoresCategory* category,
                                               gint n);
GamesScoresStyle games_scores_context_get_style (GamesScoresContext* self);
static gint ___lambda7_ (GamesScoresContext* self,
                  GamesScoresScore* a,
                  GamesScoresScore* b);
glong games_scores_score_get_score (GamesScoresScore* self);
static gint ____lambda7__gcompare_data_func (gconstpointer a,
                                      gconstpointer b,
                                      gpointer self);
static gint ___lambda8_ (GamesScoresContext* self,
                  GamesScoresScore* a,
                  GamesScoresScore* b);
static gint ____lambda8__gcompare_data_func (gconstpointer a,
                                      gconstpointer b,
                                      gpointer self);
static gboolean games_scores_context_is_high_score (GamesScoresContext* self,
                                             glong score_value,
                                             GamesScoresCategory* category);
static void games_scores_context_save_score_to_file_data_free (gpointer _data);
static void games_scores_context_save_score_to_file_async_ready_wrapper (GObject *source_object,
                                                                  GAsyncResult *res,
                                                                  void *user_data);
static void games_scores_context_save_score_to_file (GamesScoresContext* self,
                                              GamesScoresScore* score,
                                              GamesScoresCategory* category,
                                              GCancellable* cancellable,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
static void games_scores_context_save_score_to_file_finish (GamesScoresContext* self,
                                                     GAsyncResult* _res_,
                                                     GError** error);
static gboolean games_scores_context_save_score_to_file_co (GamesScoresContextSaveScoreToFileData* _data_);
gint64 games_scores_score_get_time (GamesScoresScore* self);
const gchar* games_scores_score_get_user (GamesScoresScore* self);
static void games_scores_context_save_score_to_file_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_);
static void games_scores_context_add_score_internal_data_free (gpointer _data);
static void games_scores_context_add_score_internal_async_ready_wrapper (GObject *source_object,
                                                                  GAsyncResult *res,
                                                                  void *user_data);
void games_scores_context_add_score_internal (GamesScoresContext* self,
                                              GamesScoresScore* score,
                                              GamesScoresCategory* category,
                                              gboolean allow_dialog,
                                              GCancellable* cancellable,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
gboolean games_scores_context_add_score_internal_finish (GamesScoresContext* self,
                                                         GAsyncResult* _res_,
                                                         GError** error);
static gboolean games_scores_context_add_score_internal_co (GamesScoresContextAddScoreInternalData* _data_);
void games_scores_context_run_dialog_internal (GamesScoresContext* self,
                                               GamesScoresScore* new_high_score);
static void games_scores_context_add_score_internal_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_);
static void games_scores_context_add_score_data_free (gpointer _data);
static void games_scores_context_add_score_async_ready_wrapper (GObject *source_object,
                                                         GAsyncResult *res,
                                                         void *user_data);
void games_scores_context_add_score (GamesScoresContext* self,
                                     glong score,
                                     GamesScoresCategory* category,
                                     GCancellable* cancellable,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
gboolean games_scores_context_add_score_finish (GamesScoresContext* self,
                                                GAsyncResult* _res_,
                                                GError** error);
static gboolean games_scores_context_add_score_co (GamesScoresContextAddScoreData* _data_);
GamesScoresScore* games_scores_score_new (glong score,
                                          gint64 time,
                                          const gchar* user);
GamesScoresScore* games_scores_score_construct (GType object_type,
                                                glong score,
                                                gint64 time,
                                                const gchar* user);
GtkWindow* games_scores_context_get_game_window (GamesScoresContext* self);
static void games_scores_context_add_score_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
gboolean games_scores_context_add_score_sync (GamesScoresContext* self,
                                              GamesScoresScore* score,
                                              GamesScoresCategory* category,
                                              GError** error);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda11_ (Block2Data* _data2_,
                  GObject* object,
                  GAsyncResult* _result_);
static void ___lambda11__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void games_scores_context_load_scores_from_file (GamesScoresContext* self,
                                                 GFileInfo* file_info,
                                                 GError** error);
void games_scores_context_load_scores (GamesScoresContext* self,
                                       GamesScoresContextCategoryRequestFunc category_request,
                                       gpointer category_request_target,
                                       GError** error);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static GamesScoresCategory* __lambda12_ (Block3Data* _data3_,
                                  const gchar* key);
static GamesScoresCategory* ___lambda12__games_scores_context_category_request_func (const gchar* category_key,
                                                                              gpointer self);
GType games_scores_dialog_get_type (void) G_GNUC_CONST;
const gchar* games_scores_context_get_category_type (GamesScoresContext* self);
GamesScoresDialog* games_scores_dialog_new (GamesScoresContext* context,
                                            const gchar* category_type,
                                            GamesScoresStyle style,
                                            GamesScoresScore* new_high_score,
                                            GamesScoresCategory* current_cat,
                                            GtkWindow* window,
                                            const gchar* app_name);
GamesScoresDialog* games_scores_dialog_construct (GType object_type,
                                                  GamesScoresContext* context,
                                                  const gchar* category_type,
                                                  GamesScoresStyle style,
                                                  GamesScoresScore* new_high_score,
                                                  GamesScoresCategory* current_cat,
                                                  GtkWindow* window,
                                                  const gchar* app_name);
void games_scores_context_run_dialog (GamesScoresContext* self);
gboolean games_scores_context_has_scores (GamesScoresContext* self);
static void games_scores_context_set_app_name (GamesScoresContext* self,
                                        const gchar* value);
static void games_scores_context_set_category_type (GamesScoresContext* self,
                                             const gchar* value);
static void games_scores_context_set_game_window (GamesScoresContext* self,
                                           GtkWindow* value);
static void games_scores_context_set_style (GamesScoresContext* self,
                                     GamesScoresStyle value);
static void games_scores_context_set_importer (GamesScoresContext* self,
                                        GamesScoresImporter* value);
static void games_scores_context_finalize (GObject * obj);
static void _vala_games_scores_context_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_games_scores_context_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

GType
games_scores_style_get_type (void)
{
	static volatile gsize games_scores_style_type_id__volatile = 0;
	if (g_once_init_enter (&games_scores_style_type_id__volatile)) {
		static const GEnumValue values[] = {{GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER, "GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER", "points-greater-is-better"}, {GAMES_SCORES_STYLE_POINTS_LESS_IS_BETTER, "GAMES_SCORES_STYLE_POINTS_LESS_IS_BETTER", "points-less-is-better"}, {GAMES_SCORES_STYLE_TIME_GREATER_IS_BETTER, "GAMES_SCORES_STYLE_TIME_GREATER_IS_BETTER", "time-greater-is-better"}, {GAMES_SCORES_STYLE_TIME_LESS_IS_BETTER, "GAMES_SCORES_STYLE_TIME_LESS_IS_BETTER", "time-less-is-better"}, {0, NULL, NULL}};
		GType games_scores_style_type_id;
		games_scores_style_type_id = g_enum_register_static ("GamesScoresStyle", values);
		g_once_init_leave (&games_scores_style_type_id__volatile, games_scores_style_type_id);
	}
	return games_scores_style_type_id__volatile;
}

static inline gpointer
games_scores_context_get_instance_private (GamesScoresContext* self)
{
	return G_STRUCT_MEMBER_P (self, GamesScoresContext_private_offset);
}

static guint
_games_scores_context_category_hash_lambda4_ (GamesScoresCategory* a)
{
	guint result = 0U;
	GHashFunc _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	_tmp0_ = g_str_hash;
	_tmp1_ = games_scores_category_get_key (a);
	_tmp2_ = _tmp1_;
	result = _tmp0_ (_tmp2_);
	return result;
}

static guint
__games_scores_context_category_hash_lambda4__gee_hash_data_func (gconstpointer v,
                                                                  gpointer self)
{
	guint result;
	result = _games_scores_context_category_hash_lambda4_ ((GamesScoresCategory*) v);
	return result;
}

static gboolean
_games_scores_context_category_equal_lambda5_ (GamesScoresCategory* a,
                                               GamesScoresCategory* b)
{
	gboolean result = FALSE;
	GEqualFunc _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	_tmp0_ = g_str_equal;
	_tmp1_ = games_scores_category_get_key (a);
	_tmp2_ = _tmp1_;
	_tmp3_ = games_scores_category_get_key (b);
	_tmp4_ = _tmp3_;
	result = _tmp0_ (_tmp2_, _tmp4_);
	return result;
}

static gboolean
__games_scores_context_category_equal_lambda5__gee_equal_data_func (gconstpointer a,
                                                                    gconstpointer b,
                                                                    gpointer self)
{
	gboolean result;
	result = _games_scores_context_category_equal_lambda5_ ((GamesScoresCategory*) a, (GamesScoresCategory*) b);
	return result;
}

GamesScoresContext*
games_scores_context_construct (GType object_type,
                                const gchar* app_name,
                                const gchar* category_type,
                                GtkWindow* game_window,
                                GamesScoresContextCategoryRequestFunc category_request,
                                gpointer category_request_target,
                                GamesScoresStyle style)
{
	GamesScoresContext * self = NULL;
	g_return_val_if_fail (app_name != NULL, NULL);
	g_return_val_if_fail (category_type != NULL, NULL);
	self = (GamesScoresContext*) games_scores_context_construct_with_importer (object_type, app_name, category_type, game_window, category_request, category_request_target, style, NULL);
	return self;
}

GamesScoresContext*
games_scores_context_new (const gchar* app_name,
                          const gchar* category_type,
                          GtkWindow* game_window,
                          GamesScoresContextCategoryRequestFunc category_request,
                          gpointer category_request_target,
                          GamesScoresStyle style)
{
	return games_scores_context_construct (GAMES_SCORES_TYPE_CONTEXT, app_name, category_type, game_window, category_request, category_request_target, style);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		GamesScoresContext* self;
		self = _data1_->self;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static GamesScoresCategory*
__lambda6_ (Block1Data* _data1_,
            const gchar* key)
{
	GamesScoresContext* self;
	GamesScoresCategory* result = NULL;
	GamesScoresCategory* _tmp0_;
	self = _data1_->self;
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = _data1_->category_request (key, _data1_->category_request_target);
	result = _tmp0_;
	return result;
}

static GamesScoresCategory*
___lambda6__games_scores_context_category_request_func (const gchar* category_key,
                                                        gpointer self)
{
	GamesScoresCategory* result;
	result = __lambda6_ (self, category_key);
	return result;
}

GamesScoresContext*
games_scores_context_construct_with_importer (GType object_type,
                                              const gchar* app_name,
                                              const gchar* category_type,
                                              GtkWindow* game_window,
                                              GamesScoresContextCategoryRequestFunc category_request,
                                              gpointer category_request_target,
                                              GamesScoresStyle style,
                                              GamesScoresImporter* importer)
{
	GamesScoresContext * self = NULL;
	Block1Data* _data1_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (app_name != NULL, NULL);
	g_return_val_if_fail (category_type != NULL, NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->category_request = category_request;
	_data1_->category_request_target = category_request_target;
	self = (GamesScoresContext*) g_object_new (object_type, "app-name", app_name, "category-type", category_type, "game-window", game_window, "style", style, "importer", importer, NULL);
	_data1_->self = g_object_ref (self);
	(self->priv->category_request_target_destroy_notify == NULL) ? NULL : (self->priv->category_request_target_destroy_notify (self->priv->category_request_target), NULL);
	self->priv->category_request = NULL;
	self->priv->category_request_target = NULL;
	self->priv->category_request_target_destroy_notify = NULL;
	self->priv->category_request = ___lambda6__games_scores_context_category_request_func;
	self->priv->category_request_target = block1_data_ref (_data1_);
	self->priv->category_request_target_destroy_notify = block1_data_unref;
	{
		games_scores_context_load_scores_from_files (self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_warning ("context.vala:103: Failed to load scores: %s", _tmp1_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		block1_data_unref (_data1_);
		_data1_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return self;
}

GamesScoresContext*
games_scores_context_new_with_importer (const gchar* app_name,
                                        const gchar* category_type,
                                        GtkWindow* game_window,
                                        GamesScoresContextCategoryRequestFunc category_request,
                                        gpointer category_request_target,
                                        GamesScoresStyle style,
                                        GamesScoresImporter* importer)
{
	return games_scores_context_construct_with_importer (GAMES_SCORES_TYPE_CONTEXT, app_name, category_type, game_window, category_request, category_request_target, style, importer);
}

static void
games_scores_context_real_constructed (GObject* base)
{
	GamesScoresContext * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GamesScoresImporter* _tmp3_;
	self = (GamesScoresContext*) base;
	_tmp0_ = g_get_user_data_dir ();
	_tmp1_ = self->priv->_app_name;
	_tmp2_ = g_build_filename (_tmp0_, _tmp1_, "scores", NULL, NULL);
	_g_free0 (self->priv->user_score_dir);
	self->priv->user_score_dir = _tmp2_;
	_tmp3_ = self->priv->_importer;
	if (_tmp3_ != NULL) {
		GamesScoresImporter* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = self->priv->_importer;
		_tmp5_ = self->priv->user_score_dir;
		games_scores_importer_run (_tmp4_, self, _tmp5_);
	}
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

GList*
games_scores_context_get_categories (GamesScoresContext* self)
{
	GList* result = NULL;
	GList* categories = NULL;
	GeeMapIterator* iterator = NULL;
	GeeHashMap* _tmp0_;
	GeeMapIterator* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	categories = NULL;
	_tmp0_ = self->priv->scores_per_category;
	_tmp1_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp0_);
	iterator = _tmp1_;
	while (TRUE) {
		GeeMapIterator* _tmp2_;
		GeeMapIterator* _tmp3_;
		gpointer _tmp4_;
		_tmp2_ = iterator;
		if (!gee_map_iterator_next (_tmp2_)) {
			break;
		}
		_tmp3_ = iterator;
		_tmp4_ = gee_map_iterator_get_key (_tmp3_);
		categories = g_list_append (categories, (GamesScoresCategory*) _tmp4_);
	}
	result = categories;
	_g_object_unref0 (iterator);
	return result;
}

void
games_scores_context_update_score_name (GamesScoresContext* self,
                                        GamesScoresScore* old_score,
                                        GamesScoresCategory* category,
                                        const gchar* new_name)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (old_score != NULL);
	g_return_if_fail (category != NULL);
	g_return_if_fail (new_name != NULL);
	{
		GeeList* _score_list = NULL;
		GeeHashMap* _tmp0_;
		gpointer _tmp1_;
		gint _score_size = 0;
		GeeList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _score_index = 0;
		_tmp0_ = self->priv->scores_per_category;
		_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, category);
		_score_list = (GeeList*) _tmp1_;
		_tmp2_ = _score_list;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_score_size = _tmp4_;
		_score_index = -1;
		while (TRUE) {
			GamesScoresScore* score = NULL;
			GeeList* _tmp5_;
			gpointer _tmp6_;
			GamesScoresScore* _tmp7_;
			_score_index = _score_index + 1;
			if (!(_score_index < _score_size)) {
				break;
			}
			_tmp5_ = _score_list;
			_tmp6_ = gee_list_get (_tmp5_, _score_index);
			score = (GamesScoresScore*) _tmp6_;
			_tmp7_ = score;
			if (games_scores_score_equals (_tmp7_, old_score)) {
				GamesScoresScore* _tmp8_;
				_tmp8_ = score;
				games_scores_score_set_user (_tmp8_, new_name);
				_g_object_unref0 (score);
				_g_object_unref0 (_score_list);
				return;
			}
			_g_object_unref0 (score);
		}
		_g_object_unref0 (_score_list);
	}
	g_assert_not_reached ();
}

static gint
___lambda7_ (GamesScoresContext* self,
             GamesScoresScore* a,
             GamesScoresScore* b)
{
	gint result = 0;
	glong _tmp0_;
	glong _tmp1_;
	glong _tmp2_;
	glong _tmp3_;
	glong _tmp4_;
	glong _tmp5_;
	glong _tmp6_;
	glong _tmp7_;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = games_scores_score_get_score (b);
	_tmp1_ = _tmp0_;
	_tmp2_ = games_scores_score_get_score (a);
	_tmp3_ = _tmp2_;
	_tmp4_ = games_scores_score_get_score (a);
	_tmp5_ = _tmp4_;
	_tmp6_ = games_scores_score_get_score (b);
	_tmp7_ = _tmp6_;
	result = ((gint) (_tmp1_ > _tmp3_)) - ((gint) (_tmp5_ > _tmp7_));
	return result;
}

static gint
____lambda7__gcompare_data_func (gconstpointer a,
                                 gconstpointer b,
                                 gpointer self)
{
	gint result;
	result = ___lambda7_ ((GamesScoresContext*) self, (GamesScoresScore*) a, (GamesScoresScore*) b);
	return result;
}

static gint
___lambda8_ (GamesScoresContext* self,
             GamesScoresScore* a,
             GamesScoresScore* b)
{
	gint result = 0;
	glong _tmp0_;
	glong _tmp1_;
	glong _tmp2_;
	glong _tmp3_;
	glong _tmp4_;
	glong _tmp5_;
	glong _tmp6_;
	glong _tmp7_;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = games_scores_score_get_score (b);
	_tmp1_ = _tmp0_;
	_tmp2_ = games_scores_score_get_score (a);
	_tmp3_ = _tmp2_;
	_tmp4_ = games_scores_score_get_score (a);
	_tmp5_ = _tmp4_;
	_tmp6_ = games_scores_score_get_score (b);
	_tmp7_ = _tmp6_;
	result = ((gint) (_tmp1_ < _tmp3_)) - ((gint) (_tmp5_ < _tmp7_));
	return result;
}

static gint
____lambda8__gcompare_data_func (gconstpointer a,
                                 gconstpointer b,
                                 gpointer self)
{
	gint result;
	result = ___lambda8_ ((GamesScoresContext*) self, (GamesScoresScore*) a, (GamesScoresScore*) b);
	return result;
}

GeeList*
games_scores_context_get_high_scores (GamesScoresContext* self,
                                      GamesScoresCategory* category,
                                      gint n)
{
	GeeList* result = NULL;
	GeeArrayList* _result_ = NULL;
	GeeArrayList* _tmp0_;
	GeeHashMap* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GamesScoresStyle _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (category != NULL, NULL);
	_tmp0_ = gee_array_list_new (GAMES_SCORES_TYPE_SCORE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_result_ = _tmp0_;
	_tmp1_ = self->priv->scores_per_category;
	if (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, category)) {
		result = (GeeList*) _result_;
		return result;
	}
	_tmp3_ = self->priv->_style;
	if (_tmp3_ == GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER) {
		_tmp2_ = TRUE;
	} else {
		GamesScoresStyle _tmp4_;
		_tmp4_ = self->priv->_style;
		_tmp2_ = _tmp4_ == GAMES_SCORES_STYLE_TIME_GREATER_IS_BETTER;
	}
	if (_tmp2_) {
		GeeHashMap* _tmp5_;
		gpointer _tmp6_;
		GeeList* _tmp7_;
		_tmp5_ = self->priv->scores_per_category;
		_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp5_, category);
		_tmp7_ = (GeeList*) _tmp6_;
		gee_list_sort (_tmp7_, ____lambda7__gcompare_data_func, g_object_ref (self), g_object_unref);
		_g_object_unref0 (_tmp7_);
	} else {
		GeeHashMap* _tmp8_;
		gpointer _tmp9_;
		GeeList* _tmp10_;
		_tmp8_ = self->priv->scores_per_category;
		_tmp9_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp8_, category);
		_tmp10_ = (GeeList*) _tmp9_;
		gee_list_sort (_tmp10_, ____lambda8__gcompare_data_func, g_object_ref (self), g_object_unref);
		_g_object_unref0 (_tmp10_);
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp11_ = FALSE;
			_tmp11_ = TRUE;
			while (TRUE) {
				gboolean _tmp13_ = FALSE;
				GeeArrayList* _tmp19_;
				GeeHashMap* _tmp20_;
				gpointer _tmp21_;
				GeeList* _tmp22_;
				gpointer _tmp23_;
				GamesScoresScore* _tmp24_;
				if (!_tmp11_) {
					gint _tmp12_;
					_tmp12_ = i;
					i = _tmp12_ + 1;
				}
				_tmp11_ = FALSE;
				if (i < n) {
					GeeHashMap* _tmp14_;
					gpointer _tmp15_;
					GeeList* _tmp16_;
					gint _tmp17_;
					gint _tmp18_;
					_tmp14_ = self->priv->scores_per_category;
					_tmp15_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp14_, category);
					_tmp16_ = (GeeList*) _tmp15_;
					_tmp17_ = gee_collection_get_size ((GeeCollection*) _tmp16_);
					_tmp18_ = _tmp17_;
					_tmp13_ = i < _tmp18_;
					_g_object_unref0 (_tmp16_);
				} else {
					_tmp13_ = FALSE;
				}
				if (!_tmp13_) {
					break;
				}
				_tmp19_ = _result_;
				_tmp20_ = self->priv->scores_per_category;
				_tmp21_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp20_, category);
				_tmp22_ = (GeeList*) _tmp21_;
				_tmp23_ = gee_list_get (_tmp22_, i);
				_tmp24_ = (GamesScoresScore*) _tmp23_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, _tmp24_);
				_g_object_unref0 (_tmp24_);
				_g_object_unref0 (_tmp22_);
			}
		}
	}
	result = (GeeList*) _result_;
	return result;
}

static gboolean
games_scores_context_is_high_score (GamesScoresContext* self,
                                    glong score_value,
                                    GamesScoresCategory* category)
{
	gboolean result = FALSE;
	GeeList* best_scores = NULL;
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	glong lowest = 0L;
	GeeList* _tmp5_;
	gpointer _tmp6_;
	GamesScoresScore* _tmp7_;
	glong _tmp8_;
	glong _tmp9_;
	glong _tmp10_;
	gboolean _tmp11_ = FALSE;
	GamesScoresStyle _tmp12_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (category != NULL, FALSE);
	_tmp0_ = games_scores_context_get_high_scores (self, category, 10);
	best_scores = _tmp0_;
	_tmp1_ = best_scores;
	if (_tmp1_ == NULL) {
		result = TRUE;
		_g_object_unref0 (best_scores);
		return result;
	}
	_tmp2_ = best_scores;
	_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ < 10) {
		result = TRUE;
		_g_object_unref0 (best_scores);
		return result;
	}
	_tmp5_ = best_scores;
	_tmp6_ = gee_list_get (_tmp5_, 9);
	_tmp7_ = (GamesScoresScore*) _tmp6_;
	_tmp8_ = games_scores_score_get_score (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = _tmp9_;
	_g_object_unref0 (_tmp7_);
	lowest = _tmp10_;
	_tmp12_ = self->priv->_style;
	if (_tmp12_ == GAMES_SCORES_STYLE_POINTS_LESS_IS_BETTER) {
		_tmp11_ = TRUE;
	} else {
		GamesScoresStyle _tmp13_;
		_tmp13_ = self->priv->_style;
		_tmp11_ = _tmp13_ == GAMES_SCORES_STYLE_TIME_LESS_IS_BETTER;
	}
	if (_tmp11_) {
		result = score_value < lowest;
		_g_object_unref0 (best_scores);
		return result;
	}
	result = score_value > lowest;
	_g_object_unref0 (best_scores);
	return result;
}

static void
games_scores_context_save_score_to_file_data_free (gpointer _data)
{
	GamesScoresContextSaveScoreToFileData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->score);
	_g_object_unref0 (_data_->category);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GamesScoresContextSaveScoreToFileData, _data_);
}

static void
games_scores_context_save_score_to_file_async_ready_wrapper (GObject *source_object,
                                                             GAsyncResult *res,
                                                             void *user_data)
{
	GamesScoresContextSaveScoreToFileData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
games_scores_context_save_score_to_file (GamesScoresContext* self,
                                         GamesScoresScore* score,
                                         GamesScoresCategory* category,
                                         GCancellable* cancellable,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	GamesScoresContextSaveScoreToFileData* _data_;
	GamesScoresContext* _tmp0_;
	GamesScoresScore* _tmp1_;
	GamesScoresCategory* _tmp2_;
	GCancellable* _tmp3_;
	_data_ = g_slice_new0 (GamesScoresContextSaveScoreToFileData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, games_scores_context_save_score_to_file_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, games_scores_context_save_score_to_file_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (score);
	_g_object_unref0 (_data_->score);
	_data_->score = _tmp1_;
	_tmp2_ = _g_object_ref0 (category);
	_g_object_unref0 (_data_->category);
	_data_->category = _tmp2_;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	games_scores_context_save_score_to_file_co (_data_);
}

static void
games_scores_context_save_score_to_file_finish (GamesScoresContext* self,
                                                GAsyncResult* _res_,
                                                GError** error)
{
	GamesScoresContextSaveScoreToFileData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	guint8* _tmp3_;
	gint _tmp3__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _tmp2__length1;
	if (result_length1) {
		*result_length1 = _tmp3__length1;
	}
	result = _tmp3_;
	return result;
}

static void
games_scores_context_save_score_to_file_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_)
{
	GamesScoresContextSaveScoreToFileData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	games_scores_context_save_score_to_file_co (_data_);
}

static gboolean
games_scores_context_save_score_to_file_co (GamesScoresContextSaveScoreToFileData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->user_score_dir;
	if (g_mkdir_with_parents (_data_->_tmp0_, 0766) == -1) {
		_data_->_tmp1_ = _data_->self->priv->user_score_dir;
		_data_->_tmp2_ = g_strerror (errno);
		_data_->_tmp3_ = g_error_new (G_FILE_ERROR, G_FILE_ERROR_FAILED, "Failed to create %s: %s", _data_->_tmp1_, _data_->_tmp2_);
		_data_->_inner_error0_ = _data_->_tmp3_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = _data_->self->priv->user_score_dir;
	_data_->_tmp5_ = games_scores_category_get_key (_data_->category);
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp7_ = g_build_filename (_data_->_tmp4_, _data_->_tmp6_, NULL);
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = g_file_new_for_path (_data_->_tmp8_);
	_data_->_tmp10_ = _data_->_tmp9_;
	_g_free0 (_data_->_tmp8_);
	_data_->file = _data_->_tmp10_;
	_data_->_tmp11_ = _data_->file;
	_data_->_tmp12_ = g_file_append_to (_data_->_tmp11_, G_FILE_CREATE_NONE, NULL, &_data_->_inner_error0_);
	_data_->stream = _data_->_tmp12_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->file);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp13_ = games_scores_score_get_score (_data_->score);
	_data_->_tmp14_ = _data_->_tmp13_;
	_data_->_tmp15_ = g_strdup_printf ("%li", _data_->_tmp14_);
	_data_->_tmp16_ = _data_->_tmp15_;
	_data_->_tmp17_ = games_scores_score_get_time (_data_->score);
	_data_->_tmp18_ = _data_->_tmp17_;
	_data_->_tmp19_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp18_);
	_data_->_tmp20_ = _data_->_tmp19_;
	_data_->_tmp21_ = games_scores_score_get_user (_data_->score);
	_data_->_tmp22_ = _data_->_tmp21_;
	_data_->_tmp23_ = string_to_string (_data_->_tmp22_);
	_data_->_tmp24_ = g_strconcat (_data_->_tmp16_, " ", _data_->_tmp20_, " ", _data_->_tmp23_, "\n", NULL);
	_data_->_tmp25_ = _data_->_tmp24_;
	_g_free0 (_data_->_tmp20_);
	_g_free0 (_data_->_tmp16_);
	_data_->line = _data_->_tmp25_;
	_data_->_tmp26_ = _data_->stream;
	_data_->_tmp27_ = _data_->line;
	_data_->_tmp28_ = string_get_data (_data_->_tmp27_, &_data_->_tmp28__length1);
	_data_->_tmp29_ = _data_->_tmp28_;
	_data_->_tmp29__length1 = _data_->_tmp28__length1;
	_data_->_state_ = 1;
	g_output_stream_write_all_async ((GOutputStream*) _data_->_tmp26_, _data_->_tmp29_, (gsize) _data_->_tmp29__length1, G_PRIORITY_DEFAULT, _data_->cancellable, games_scores_context_save_score_to_file_ready, _data_);
	return FALSE;
	_state_1:
	g_output_stream_write_all_finish ((GOutputStream*) _data_->_tmp26_, _data_->_res_, NULL, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_free0 (_data_->line);
		_g_object_unref0 (_data_->stream);
		_g_object_unref0 (_data_->file);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_free0 (_data_->line);
	_g_object_unref0 (_data_->stream);
	_g_object_unref0 (_data_->file);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!_data_->_task_complete_) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
games_scores_context_add_score_internal_data_free (gpointer _data)
{
	GamesScoresContextAddScoreInternalData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->score);
	_g_object_unref0 (_data_->category);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GamesScoresContextAddScoreInternalData, _data_);
}

static void
games_scores_context_add_score_internal_async_ready_wrapper (GObject *source_object,
                                                             GAsyncResult *res,
                                                             void *user_data)
{
	GamesScoresContextAddScoreInternalData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}

void
games_scores_context_add_score_internal (GamesScoresContext* self,
                                         GamesScoresScore* score,
                                         GamesScoresCategory* category,
                                         gboolean allow_dialog,
                                         GCancellable* cancellable,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	GamesScoresContextAddScoreInternalData* _data_;
	GamesScoresContext* _tmp0_;
	GamesScoresScore* _tmp1_;
	GamesScoresCategory* _tmp2_;
	GCancellable* _tmp3_;
	_data_ = g_slice_new0 (GamesScoresContextAddScoreInternalData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, games_scores_context_add_score_internal_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, games_scores_context_add_score_internal_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (score);
	_g_object_unref0 (_data_->score);
	_data_->score = _tmp1_;
	_tmp2_ = _g_object_ref0 (category);
	_g_object_unref0 (_data_->category);
	_data_->category = _tmp2_;
	_data_->allow_dialog = allow_dialog;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	games_scores_context_add_score_internal_co (_data_);
}

gboolean
games_scores_context_add_score_internal_finish (GamesScoresContext* self,
                                                GAsyncResult* _res_,
                                                GError** error)
{
	gboolean result;
	GamesScoresContextAddScoreInternalData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static void
games_scores_context_add_score_internal_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_)
{
	GamesScoresContextAddScoreInternalData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	games_scores_context_add_score_internal_co (_data_);
}

static gboolean
games_scores_context_add_score_internal_co (GamesScoresContextAddScoreInternalData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = games_scores_score_get_score (_data_->score);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->high_score_added = games_scores_context_is_high_score (_data_->self, _data_->_tmp1_, _data_->category);
	_data_->_tmp2_ = _data_->self->priv->scores_per_category;
	if (!gee_abstract_map_has_key ((GeeAbstractMap*) _data_->_tmp2_, _data_->category)) {
		_data_->_tmp3_ = _data_->self->priv->scores_per_category;
		_data_->_tmp4_ = gee_array_list_new (GAMES_SCORES_TYPE_SCORE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		_data_->_tmp5_ = _data_->_tmp4_;
		gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp3_, _data_->category, (GeeList*) _data_->_tmp5_);
		_g_object_unref0 (_data_->_tmp5_);
	}
	_data_->_tmp6_ = _data_->self->priv->scores_per_category;
	_data_->_tmp7_ = gee_abstract_map_get ((GeeAbstractMap*) _data_->_tmp6_, _data_->category);
	_data_->_tmp8_ = (GeeList*) _data_->_tmp7_;
	_data_->_tmp9_ = gee_collection_add ((GeeCollection*) _data_->_tmp8_, _data_->score);
	_g_object_unref0 (_data_->_tmp8_);
	if (_data_->_tmp9_) {
		_data_->_tmp10_ = _g_object_ref0 (_data_->category);
		_g_object_unref0 (_data_->self->priv->current_category);
		_data_->self->priv->current_category = _data_->_tmp10_;
	}
	if (_data_->high_score_added) {
		_data_->_tmp11_ = _data_->allow_dialog;
	} else {
		_data_->_tmp11_ = FALSE;
	}
	if (_data_->_tmp11_) {
		games_scores_context_run_dialog_internal (_data_->self, _data_->score);
	}
	_data_->_tmp12_ = _data_->self->priv->current_category;
	_data_->_state_ = 1;
	games_scores_context_save_score_to_file (_data_->self, _data_->score, _data_->_tmp12_, _data_->cancellable, games_scores_context_add_score_internal_ready, _data_);
	return FALSE;
	_state_1:
	games_scores_context_save_score_to_file_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->high_score_added;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!_data_->_task_complete_) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
games_scores_context_add_score_data_free (gpointer _data)
{
	GamesScoresContextAddScoreData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->category);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GamesScoresContextAddScoreData, _data_);
}

static void
games_scores_context_add_score_async_ready_wrapper (GObject *source_object,
                                                    GAsyncResult *res,
                                                    void *user_data)
{
	GamesScoresContextAddScoreData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}

void
games_scores_context_add_score (GamesScoresContext* self,
                                glong score,
                                GamesScoresCategory* category,
                                GCancellable* cancellable,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	GamesScoresContextAddScoreData* _data_;
	GamesScoresContext* _tmp0_;
	GamesScoresCategory* _tmp1_;
	GCancellable* _tmp2_;
	_data_ = g_slice_new0 (GamesScoresContextAddScoreData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, games_scores_context_add_score_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, games_scores_context_add_score_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->score = score;
	_tmp1_ = _g_object_ref0 (category);
	_g_object_unref0 (_data_->category);
	_data_->category = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	games_scores_context_add_score_co (_data_);
}

gboolean
games_scores_context_add_score_finish (GamesScoresContext* self,
                                       GAsyncResult* _res_,
                                       GError** error)
{
	gboolean result;
	GamesScoresContextAddScoreData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static void
games_scores_context_add_score_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	GamesScoresContextAddScoreData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	games_scores_context_add_score_co (_data_);
}

static gboolean
games_scores_context_add_score_co (GamesScoresContextAddScoreData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = games_scores_score_new (_data_->score, (gint64) 0, NULL);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = _data_->self->priv->_game_window;
	_data_->_state_ = 1;
	games_scores_context_add_score_internal (_data_->self, _data_->_tmp2_, _data_->category, _data_->_tmp3_ != NULL, _data_->cancellable, games_scores_context_add_score_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp4_ = games_scores_context_add_score_internal_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_g_object_unref0 (_data_->_tmp2_);
	_data_->_tmp0_ = _data_->_tmp4_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->_tmp0_;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!_data_->_task_complete_) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		GamesScoresContext* self;
		self = _data2_->self;
		_g_error_free0 (_data2_->_error_);
		_g_main_loop_unref0 (_data2_->main_loop);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static void
__lambda11_ (Block2Data* _data2_,
             GObject* object,
             GAsyncResult* _result_)
{
	GamesScoresContext* self;
	GMainLoop* _tmp3_;
	GError* _inner_error0_ = NULL;
	self = _data2_->self;
	g_return_if_fail (_result_ != NULL);
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = games_scores_context_add_score_internal_finish (self, _result_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_data2_->ret = _tmp0_;
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		GError* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _g_error_copy0 (_tmp1_);
		_g_error_free0 (_data2_->_error_);
		_data2_->_error_ = _tmp2_;
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp3_ = _data2_->main_loop;
	g_main_loop_quit (_tmp3_);
}

static void
___lambda11__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda11_ (self, source_object, res);
	block2_data_unref (self);
}

gboolean
games_scores_context_add_score_sync (GamesScoresContext* self,
                                     GamesScoresScore* score,
                                     GamesScoresCategory* category,
                                     GError** error)
{
	gboolean result = FALSE;
	Block2Data* _data2_;
	GMainContext* main_context = NULL;
	GMainContext* _tmp0_;
	GMainContext* _tmp1_;
	GMainLoop* _tmp2_;
	GMainContext* _tmp3_;
	GMainLoop* _tmp4_;
	GMainContext* _tmp5_;
	GError* _tmp6_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (score != NULL, FALSE);
	g_return_val_if_fail (category != NULL, FALSE);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = g_main_context_new ();
	main_context = _tmp0_;
	_tmp1_ = main_context;
	_tmp2_ = g_main_loop_new (_tmp1_, FALSE);
	_data2_->main_loop = _tmp2_;
	_data2_->ret = FALSE;
	_data2_->_error_ = NULL;
	_tmp3_ = main_context;
	g_main_context_push_thread_default (_tmp3_);
	games_scores_context_add_score_internal (self, score, category, FALSE, NULL, ___lambda11__gasync_ready_callback, block2_data_ref (_data2_));
	_tmp4_ = _data2_->main_loop;
	g_main_loop_run (_tmp4_);
	_tmp5_ = main_context;
	g_main_context_pop_thread_default (_tmp5_);
	_tmp6_ = _data2_->_error_;
	if (_tmp6_ != NULL) {
		GError* _tmp7_;
		GError* _tmp8_;
		gboolean _tmp9_ = FALSE;
		_tmp7_ = _data2_->_error_;
		_tmp8_ = _g_error_copy0 (_tmp7_);
		_inner_error0_ = _tmp8_;
		g_propagate_error (error, _inner_error0_);
		_g_main_context_unref0 (main_context);
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return _tmp9_;
	}
	result = _data2_->ret;
	_g_main_context_unref0 (main_context);
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return result;
}

static gchar*
g_file_stream_read_line (FILE* self)
{
	gchar* result = NULL;
	gint c = 0;
	GString* ret = NULL;
	GString* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	ret = NULL;
	while (TRUE) {
		GString* _tmp0_;
		GString* _tmp2_;
		c = fgetc (self);
		if (!(c != EOF)) {
			break;
		}
		_tmp0_ = ret;
		if (_tmp0_ == NULL) {
			GString* _tmp1_;
			_tmp1_ = g_string_new ("");
			_g_string_free0 (ret);
			ret = _tmp1_;
		}
		if (c == ((gint) '\n')) {
			break;
		}
		_tmp2_ = ret;
		g_string_append_c ((GString*) _tmp2_, (gchar) c);
	}
	_tmp3_ = ret;
	if (_tmp3_ == NULL) {
		result = NULL;
		_g_string_free0 (ret);
		return result;
	} else {
		GString* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = ret;
		_tmp5_ = ((GString*) _tmp4_)->str;
		_tmp6_ = g_strdup (_tmp5_);
		result = _tmp6_;
		_g_string_free0 (ret);
		return result;
	}
	_g_string_free0 (ret);
}

static glong
long_parse (const gchar* str)
{
	glong result = 0L;
	g_return_val_if_fail (str != NULL, 0L);
	result = strtol (str, NULL, (guint) 0);
	return result;
}

static gint64
int64_parse (const gchar* str)
{
	gint64 result = 0LL;
	g_return_val_if_fail (str != NULL, 0LL);
	result = g_ascii_strtoll (str, NULL, (guint) 0);
	return result;
}

static void
games_scores_context_load_scores_from_file (GamesScoresContext* self,
                                            GFileInfo* file_info,
                                            GError** error)
{
	gchar* category_key = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GamesScoresCategory* category = NULL;
	GamesScoresContextCategoryRequestFunc _tmp2_;
	gpointer _tmp2__target;
	const gchar* _tmp3_;
	GamesScoresCategory* _tmp4_;
	GamesScoresCategory* _tmp5_;
	gchar* filename = NULL;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	GeeArrayList* scores_of_single_category = NULL;
	GeeArrayList* _tmp9_;
	FILE* stream = NULL;
	const gchar* _tmp10_;
	FILE* _tmp11_;
	gchar* line = NULL;
	GeeHashMap* _tmp44_;
	GamesScoresCategory* _tmp45_;
	GeeArrayList* _tmp46_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file_info != NULL);
	_tmp0_ = g_file_info_get_name (file_info);
	_tmp1_ = g_strdup (_tmp0_);
	category_key = _tmp1_;
	_tmp2_ = self->priv->category_request;
	_tmp2__target = self->priv->category_request_target;
	_tmp3_ = category_key;
	_tmp4_ = _tmp2_ (_tmp3_, _tmp2__target);
	category = _tmp4_;
	_tmp5_ = category;
	if (_tmp5_ == NULL) {
		_g_object_unref0 (category);
		_g_free0 (category_key);
		return;
	}
	_tmp6_ = self->priv->user_score_dir;
	_tmp7_ = category_key;
	_tmp8_ = g_build_filename (_tmp6_, _tmp7_, NULL);
	filename = _tmp8_;
	_tmp9_ = gee_array_list_new (GAMES_SCORES_TYPE_SCORE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	scores_of_single_category = _tmp9_;
	_tmp10_ = filename;
	_tmp11_ = g_fopen (_tmp10_, "r");
	stream = _tmp11_;
	while (TRUE) {
		FILE* _tmp12_;
		gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar** tokens = NULL;
		const gchar* _tmp15_;
		gchar** _tmp16_;
		gchar** _tmp17_;
		gint tokens_length1;
		gint _tokens_size_;
		gchar* user = NULL;
		gchar** _tmp18_;
		gint _tmp18__length1;
		glong score_value = 0L;
		gchar** _tmp21_;
		gint _tmp21__length1;
		const gchar* _tmp22_;
		gint64 time = 0LL;
		gchar** _tmp23_;
		gint _tmp23__length1;
		const gchar* _tmp24_;
		gboolean _tmp25_ = FALSE;
		gboolean _tmp26_ = FALSE;
		gchar** _tmp34_;
		gint _tmp34__length1;
		GeeArrayList* _tmp40_;
		const gchar* _tmp41_;
		GamesScoresScore* _tmp42_;
		GamesScoresScore* _tmp43_;
		_tmp12_ = stream;
		_tmp13_ = g_file_stream_read_line (_tmp12_);
		_g_free0 (line);
		line = _tmp13_;
		_tmp14_ = line;
		if (!(_tmp14_ != NULL)) {
			break;
		}
		_tmp15_ = line;
		_tmp17_ = _tmp16_ = g_strsplit (_tmp15_, " ", 3);
		tokens = _tmp17_;
		tokens_length1 = _vala_array_length (_tmp16_);
		_tokens_size_ = tokens_length1;
		user = NULL;
		_tmp18_ = tokens;
		_tmp18__length1 = tokens_length1;
		if (_tmp18__length1 < 2) {
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			_tmp19_ = line;
			_tmp20_ = filename;
			g_warning ("context.vala:276: Failed to read malformed score %s in %s.", _tmp19_, _tmp20_);
			_g_free0 (user);
			tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
			continue;
		}
		_tmp21_ = tokens;
		_tmp21__length1 = tokens_length1;
		_tmp22_ = _tmp21_[0];
		score_value = long_parse (_tmp22_);
		_tmp23_ = tokens;
		_tmp23__length1 = tokens_length1;
		_tmp24_ = _tmp23_[1];
		time = int64_parse (_tmp24_);
		if (score_value == ((glong) 0)) {
			gchar** _tmp27_;
			gint _tmp27__length1;
			const gchar* _tmp28_;
			_tmp27_ = tokens;
			_tmp27__length1 = tokens_length1;
			_tmp28_ = _tmp27_[0];
			_tmp26_ = g_strcmp0 (_tmp28_, "0") != 0;
		} else {
			_tmp26_ = FALSE;
		}
		if (_tmp26_) {
			_tmp25_ = TRUE;
		} else {
			gboolean _tmp29_ = FALSE;
			if (time == ((gint64) 0)) {
				gchar** _tmp30_;
				gint _tmp30__length1;
				const gchar* _tmp31_;
				_tmp30_ = tokens;
				_tmp30__length1 = tokens_length1;
				_tmp31_ = _tmp30_[1];
				_tmp29_ = g_strcmp0 (_tmp31_, "0") != 0;
			} else {
				_tmp29_ = FALSE;
			}
			_tmp25_ = _tmp29_;
		}
		if (_tmp25_) {
			const gchar* _tmp32_;
			const gchar* _tmp33_;
			_tmp32_ = line;
			_tmp33_ = filename;
			g_warning ("context.vala:286: Failed to read malformed score %s in %s.", _tmp32_, _tmp33_);
			_g_free0 (user);
			tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
			continue;
		}
		_tmp34_ = tokens;
		_tmp34__length1 = tokens_length1;
		if (_tmp34__length1 == 3) {
			gchar** _tmp35_;
			gint _tmp35__length1;
			const gchar* _tmp36_;
			gchar* _tmp37_;
			_tmp35_ = tokens;
			_tmp35__length1 = tokens_length1;
			_tmp36_ = _tmp35_[2];
			_tmp37_ = g_strdup (_tmp36_);
			_g_free0 (user);
			user = _tmp37_;
		} else {
			const gchar* _tmp38_;
			const gchar* _tmp39_;
			_tmp38_ = line;
			_tmp39_ = filename;
			g_debug ("context.vala:293: Assuming current username for old score %s in %s.", _tmp38_, _tmp39_);
		}
		_tmp40_ = scores_of_single_category;
		_tmp41_ = user;
		_tmp42_ = games_scores_score_new (score_value, time, _tmp41_);
		_tmp43_ = _tmp42_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp40_, _tmp43_);
		_g_object_unref0 (_tmp43_);
		_g_free0 (user);
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp44_ = self->priv->scores_per_category;
	_tmp45_ = category;
	_tmp46_ = scores_of_single_category;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp44_, _tmp45_, (GeeList*) _tmp46_);
	_g_free0 (line);
	_fclose0 (stream);
	_g_object_unref0 (scores_of_single_category);
	_g_free0 (filename);
	_g_object_unref0 (category);
	_g_free0 (category_key);
}

static void
games_scores_context_load_scores_from_files (GamesScoresContext* self,
                                             GError** error)
{
	gboolean _tmp0_ = FALSE;
	GtkWindow* _tmp1_;
	GFile* directory = NULL;
	const gchar* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	GFileEnumerator* enumerator = NULL;
	GFile* _tmp8_;
	GFileEnumerator* _tmp9_;
	GFileInfo* file_info = NULL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_vala_return_if_fail (!self->priv->scores_loaded, "!scores_loaded");
	self->priv->scores_loaded = TRUE;
	_tmp1_ = self->priv->_game_window;
	if (_tmp1_ != NULL) {
		GtkWindow* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = self->priv->_game_window;
		_tmp3_ = gtk_widget_get_visible ((GtkWidget*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		g_error ("context.vala:308: %s", "The application window associated with the GamesScoresContext " "was set visible before loading scores. The Context performs " "synchronous I/O in the default main context to load scores, so " "so you should do this before showing your main window.");
	}
	_tmp5_ = self->priv->user_score_dir;
	_tmp6_ = g_file_new_for_path (_tmp5_);
	directory = _tmp6_;
	_tmp7_ = directory;
	if (!g_file_query_exists (_tmp7_, NULL)) {
		_g_object_unref0 (directory);
		return;
	}
	_tmp8_ = directory;
	_tmp9_ = g_file_enumerate_children (_tmp8_, G_FILE_ATTRIBUTE_STANDARD_NAME, 0, NULL, &_inner_error0_);
	enumerator = _tmp9_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (directory);
		return;
	}
	while (TRUE) {
		GFileInfo* _tmp10_ = NULL;
		GFileEnumerator* _tmp11_;
		GFileInfo* _tmp12_;
		GFileInfo* _tmp13_;
		GFileInfo* _tmp14_;
		GFileInfo* _tmp15_;
		_tmp11_ = enumerator;
		_tmp12_ = g_file_enumerator_next_file (_tmp11_, NULL, &_inner_error0_);
		_tmp10_ = _tmp12_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (file_info);
			_g_object_unref0 (enumerator);
			_g_object_unref0 (directory);
			return;
		}
		_tmp13_ = _tmp10_;
		_tmp10_ = NULL;
		_g_object_unref0 (file_info);
		file_info = _tmp13_;
		_tmp14_ = file_info;
		if (!(_tmp14_ != NULL)) {
			_g_object_unref0 (_tmp10_);
			break;
		}
		_tmp15_ = file_info;
		games_scores_context_load_scores_from_file (self, _tmp15_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp10_);
			_g_object_unref0 (file_info);
			_g_object_unref0 (enumerator);
			_g_object_unref0 (directory);
			return;
		}
		_g_object_unref0 (_tmp10_);
	}
	_g_object_unref0 (file_info);
	_g_object_unref0 (enumerator);
	_g_object_unref0 (directory);
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		GamesScoresContext* self;
		self = _data3_->self;
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static GamesScoresCategory*
__lambda12_ (Block3Data* _data3_,
             const gchar* key)
{
	GamesScoresContext* self;
	GamesScoresCategory* result = NULL;
	GamesScoresCategory* _tmp0_;
	self = _data3_->self;
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = _data3_->category_request (key, _data3_->category_request_target);
	result = _tmp0_;
	return result;
}

static GamesScoresCategory*
___lambda12__games_scores_context_category_request_func (const gchar* category_key,
                                                         gpointer self)
{
	GamesScoresCategory* result;
	result = __lambda12_ (self, category_key);
	return result;
}

void
games_scores_context_load_scores (GamesScoresContext* self,
                                  GamesScoresContextCategoryRequestFunc category_request,
                                  gpointer category_request_target,
                                  GError** error)
{
	GamesScoresContextCategoryRequestFunc _tmp0_;
	gpointer _tmp0__target;
	Block3Data* _data3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->category_request;
	_tmp0__target = self->priv->category_request_target;
	_vala_return_if_fail (_tmp0_ == NULL, "this.category_request == null");
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_data3_->category_request = category_request;
	_data3_->category_request_target = category_request_target;
	(self->priv->category_request_target_destroy_notify == NULL) ? NULL : (self->priv->category_request_target_destroy_notify (self->priv->category_request_target), NULL);
	self->priv->category_request = NULL;
	self->priv->category_request_target = NULL;
	self->priv->category_request_target_destroy_notify = NULL;
	self->priv->category_request = ___lambda12__games_scores_context_category_request_func;
	self->priv->category_request_target = block3_data_ref (_data3_);
	self->priv->category_request_target_destroy_notify = block3_data_unref;
	games_scores_context_load_scores_from_files (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		block3_data_unref (_data3_);
		_data3_ = NULL;
		return;
	}
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

void
games_scores_context_run_dialog_internal (GamesScoresContext* self,
                                          GamesScoresScore* new_high_score)
{
	GtkWindow* _tmp0_;
	GamesScoresDialog* dialog = NULL;
	const gchar* _tmp1_;
	GamesScoresStyle _tmp2_;
	GamesScoresCategory* _tmp3_;
	GtkWindow* _tmp4_;
	const gchar* _tmp5_;
	GamesScoresDialog* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_game_window;
	_vala_return_if_fail (_tmp0_ != NULL, "game_window != null");
	_tmp1_ = self->priv->_category_type;
	_tmp2_ = self->priv->_style;
	_tmp3_ = self->priv->current_category;
	_tmp4_ = self->priv->_game_window;
	_tmp5_ = self->priv->_app_name;
	_tmp6_ = games_scores_dialog_new (self, _tmp1_, _tmp2_, new_high_score, _tmp3_, _tmp4_, _tmp5_);
	g_object_ref_sink (_tmp6_);
	dialog = _tmp6_;
	gtk_dialog_run ((GtkDialog*) dialog);
	gtk_widget_destroy ((GtkWidget*) dialog);
	_g_object_unref0 (dialog);
}

void
games_scores_context_run_dialog (GamesScoresContext* self)
{
	g_return_if_fail (self != NULL);
	games_scores_context_run_dialog_internal (self, NULL);
}

gboolean
games_scores_context_has_scores (GamesScoresContext* self)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		GeeIterator* _scores_it = NULL;
		GeeHashMap* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp0_ = self->priv->scores_per_category;
		_tmp1_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_scores_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			GeeList* scores = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			GeeList* _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			_tmp6_ = _scores_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _scores_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			scores = (GeeList*) _tmp8_;
			_tmp9_ = scores;
			_tmp10_ = gee_collection_get_size ((GeeCollection*) _tmp9_);
			_tmp11_ = _tmp10_;
			if (_tmp11_ > 0) {
				result = TRUE;
				_g_object_unref0 (scores);
				_g_object_unref0 (_scores_it);
				return result;
			}
			_g_object_unref0 (scores);
		}
		_g_object_unref0 (_scores_it);
	}
	result = FALSE;
	return result;
}

const gchar*
games_scores_context_get_app_name (GamesScoresContext* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_app_name;
	result = _tmp0_;
	return result;
}

static void
games_scores_context_set_app_name (GamesScoresContext* self,
                                   const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, games_scores_context_get_app_name (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_app_name);
		self->priv->_app_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, games_scores_context_properties[GAMES_SCORES_CONTEXT_APP_NAME_PROPERTY]);
	}
}

const gchar*
games_scores_context_get_category_type (GamesScoresContext* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_category_type;
	result = _tmp0_;
	return result;
}

static void
games_scores_context_set_category_type (GamesScoresContext* self,
                                        const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, games_scores_context_get_category_type (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_category_type);
		self->priv->_category_type = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, games_scores_context_properties[GAMES_SCORES_CONTEXT_CATEGORY_TYPE_PROPERTY]);
	}
}

GtkWindow*
games_scores_context_get_game_window (GamesScoresContext* self)
{
	GtkWindow* result;
	GtkWindow* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_game_window;
	result = _tmp0_;
	return result;
}

static void
games_scores_context_set_game_window (GamesScoresContext* self,
                                      GtkWindow* value)
{
	g_return_if_fail (self != NULL);
	if (games_scores_context_get_game_window (self) != value) {
		GtkWindow* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_game_window);
		self->priv->_game_window = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, games_scores_context_properties[GAMES_SCORES_CONTEXT_GAME_WINDOW_PROPERTY]);
	}
}

GamesScoresStyle
games_scores_context_get_style (GamesScoresContext* self)
{
	GamesScoresStyle result;
	GamesScoresStyle _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_style;
	result = _tmp0_;
	return result;
}

static void
games_scores_context_set_style (GamesScoresContext* self,
                                GamesScoresStyle value)
{
	g_return_if_fail (self != NULL);
	if (games_scores_context_get_style (self) != value) {
		self->priv->_style = value;
		g_object_notify_by_pspec ((GObject *) self, games_scores_context_properties[GAMES_SCORES_CONTEXT_STYLE_PROPERTY]);
	}
}

GamesScoresImporter*
games_scores_context_get_importer (GamesScoresContext* self)
{
	GamesScoresImporter* result;
	GamesScoresImporter* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_importer;
	result = _tmp0_;
	return result;
}

static void
games_scores_context_set_importer (GamesScoresContext* self,
                                   GamesScoresImporter* value)
{
	g_return_if_fail (self != NULL);
	if (games_scores_context_get_importer (self) != value) {
		GamesScoresImporter* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_importer);
		self->priv->_importer = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, games_scores_context_properties[GAMES_SCORES_CONTEXT_IMPORTER_PROPERTY]);
	}
}

static void
games_scores_context_base_init (GamesScoresContextClass * klass)
{
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
}

static void
games_scores_context_class_init (GamesScoresContextClass * klass,
                                 gpointer klass_data)
{
	games_scores_context_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesScoresContext_private_offset);
	((GObjectClass *) klass)->constructed = (void (*) (GObject*)) games_scores_context_real_constructed;
	G_OBJECT_CLASS (klass)->get_property = _vala_games_scores_context_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_games_scores_context_set_property;
	G_OBJECT_CLASS (klass)->finalize = games_scores_context_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_SCORES_CONTEXT_APP_NAME_PROPERTY, games_scores_context_properties[GAMES_SCORES_CONTEXT_APP_NAME_PROPERTY] = g_param_spec_string ("app-name", "app-name", "app-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_SCORES_CONTEXT_CATEGORY_TYPE_PROPERTY, games_scores_context_properties[GAMES_SCORES_CONTEXT_CATEGORY_TYPE_PROPERTY] = g_param_spec_string ("category-type", "category-type", "category-type", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_SCORES_CONTEXT_GAME_WINDOW_PROPERTY, games_scores_context_properties[GAMES_SCORES_CONTEXT_GAME_WINDOW_PROPERTY] = g_param_spec_object ("game-window", "game-window", "game-window", gtk_window_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_SCORES_CONTEXT_STYLE_PROPERTY, games_scores_context_properties[GAMES_SCORES_CONTEXT_STYLE_PROPERTY] = g_param_spec_enum ("style", "style", "style", GAMES_SCORES_TYPE_STYLE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_SCORES_CONTEXT_IMPORTER_PROPERTY, games_scores_context_properties[GAMES_SCORES_CONTEXT_IMPORTER_PROPERTY] = g_param_spec_object ("importer", "importer", "importer", GAMES_SCORES_TYPE_IMPORTER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	games_scores_context_category_hash = __games_scores_context_category_hash_lambda4__gee_hash_data_func;
	games_scores_context_category_equal = __games_scores_context_category_equal_lambda5__gee_equal_data_func;
}

static void
games_scores_context_instance_init (GamesScoresContext * self,
                                    gpointer klass)
{
	GeeHashDataFunc _tmp0_;
	gpointer _tmp0__target;
	GDestroyNotify _tmp0__target_destroy_notify;
	GeeEqualDataFunc _tmp1_;
	gpointer _tmp1__target;
	GDestroyNotify _tmp1__target_destroy_notify;
	GeeHashMap* _tmp2_;
	self->priv = games_scores_context_get_instance_private (self);
	self->priv->current_category = NULL;
	_tmp0_ = games_scores_context_category_hash;
	_tmp0__target = games_scores_context_category_hash_target;
	_tmp0__target_destroy_notify = games_scores_context_category_hash_target_destroy_notify;
	games_scores_context_category_hash = NULL;
	games_scores_context_category_hash_target = NULL;
	games_scores_context_category_hash_target_destroy_notify = NULL;
	_tmp1_ = games_scores_context_category_equal;
	_tmp1__target = games_scores_context_category_equal_target;
	_tmp1__target_destroy_notify = games_scores_context_category_equal_target_destroy_notify;
	games_scores_context_category_equal = NULL;
	games_scores_context_category_equal_target = NULL;
	games_scores_context_category_equal_target_destroy_notify = NULL;
	_tmp2_ = gee_hash_map_new (GAMES_SCORES_TYPE_CATEGORY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp0_, _tmp0__target, _tmp0__target_destroy_notify, _tmp1_, _tmp1__target, _tmp1__target_destroy_notify, NULL, NULL, NULL);
	self->priv->scores_per_category = _tmp2_;
	self->priv->scores_loaded = FALSE;
	self->priv->category_request = NULL;
	self->priv->category_request_target = self;
	self->priv->category_request_target_destroy_notify = NULL;
}

static void
games_scores_context_finalize (GObject * obj)
{
	GamesScoresContext * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_SCORES_TYPE_CONTEXT, GamesScoresContext);
	_g_free0 (self->priv->_app_name);
	_g_free0 (self->priv->_category_type);
	_g_object_unref0 (self->priv->_game_window);
	_g_object_unref0 (self->priv->_importer);
	_g_object_unref0 (self->priv->current_category);
	_g_object_unref0 (self->priv->scores_per_category);
	_g_free0 (self->priv->user_score_dir);
	(self->priv->category_request_target_destroy_notify == NULL) ? NULL : (self->priv->category_request_target_destroy_notify (self->priv->category_request_target), NULL);
	self->priv->category_request = NULL;
	self->priv->category_request_target = NULL;
	self->priv->category_request_target_destroy_notify = NULL;
	G_OBJECT_CLASS (games_scores_context_parent_class)->finalize (obj);
}

GType
games_scores_context_get_type (void)
{
	static volatile gsize games_scores_context_type_id__volatile = 0;
	if (g_once_init_enter (&games_scores_context_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GamesScoresContextClass), (GBaseInitFunc) games_scores_context_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_scores_context_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesScoresContext), 0, (GInstanceInitFunc) games_scores_context_instance_init, NULL };
		GType games_scores_context_type_id;
		games_scores_context_type_id = g_type_register_static (G_TYPE_OBJECT, "GamesScoresContext", &g_define_type_info, 0);
		GamesScoresContext_private_offset = g_type_add_instance_private (games_scores_context_type_id, sizeof (GamesScoresContextPrivate));
		g_once_init_leave (&games_scores_context_type_id__volatile, games_scores_context_type_id);
	}
	return games_scores_context_type_id__volatile;
}

static void
_vala_games_scores_context_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	GamesScoresContext * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_SCORES_TYPE_CONTEXT, GamesScoresContext);
	switch (property_id) {
		case GAMES_SCORES_CONTEXT_APP_NAME_PROPERTY:
		g_value_set_string (value, games_scores_context_get_app_name (self));
		break;
		case GAMES_SCORES_CONTEXT_CATEGORY_TYPE_PROPERTY:
		g_value_set_string (value, games_scores_context_get_category_type (self));
		break;
		case GAMES_SCORES_CONTEXT_GAME_WINDOW_PROPERTY:
		g_value_set_object (value, games_scores_context_get_game_window (self));
		break;
		case GAMES_SCORES_CONTEXT_STYLE_PROPERTY:
		g_value_set_enum (value, games_scores_context_get_style (self));
		break;
		case GAMES_SCORES_CONTEXT_IMPORTER_PROPERTY:
		g_value_set_object (value, games_scores_context_get_importer (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_games_scores_context_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	GamesScoresContext * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_SCORES_TYPE_CONTEXT, GamesScoresContext);
	switch (property_id) {
		case GAMES_SCORES_CONTEXT_APP_NAME_PROPERTY:
		games_scores_context_set_app_name (self, g_value_get_string (value));
		break;
		case GAMES_SCORES_CONTEXT_CATEGORY_TYPE_PROPERTY:
		games_scores_context_set_category_type (self, g_value_get_string (value));
		break;
		case GAMES_SCORES_CONTEXT_GAME_WINDOW_PROPERTY:
		games_scores_context_set_game_window (self, g_value_get_object (value));
		break;
		case GAMES_SCORES_CONTEXT_STYLE_PROPERTY:
		games_scores_context_set_style (self, g_value_get_enum (value));
		break;
		case GAMES_SCORES_CONTEXT_IMPORTER_PROPERTY:
		games_scores_context_set_importer (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

