/* GNOME DB components libary
 * Copyright (C) 1999-2002 The GNOME Foundation.
 *
 * AUTHORS:
 * 	Rodrigo Moya <rodrigo@gnome-db.org>
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
 
#if !defined(__gnome_db_window_h__)
#  define __gnome_db_window_h__

#include <bonobo/bonobo-ui-component.h>
#include <bonobo/bonobo-window.h>

G_BEGIN_DECLS

#define GNOME_DB_TYPE_WINDOW            (gnome_db_window_get_type())
#define GNOME_DB_WINDOW(obj)            (G_TYPE_CHECK_INSTANCE_CAST (obj, GNOME_DB_TYPE_WINDOW, GnomeDbWindow))
#define GNOME_DB_WINDOW_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST (klass, GNOME_DB_TYPE_WINDOW, GnomeDbWindowClass))
#define GNOME_DB_IS_WINDOW(obj)         (G_TYPE_CHECK_INSTANCE_TYPE(obj, GNOME_DB_TYPE_WINDOW))
#define GNOME_DB_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_DB_TYPE_WINDOW))

typedef struct _GnomeDbWindow        GnomeDbWindow;
typedef struct _GnomeDbWindowClass   GnomeDbWindowClass;
typedef struct _GnomeDbWindowPrivate GnomeDbWindowPrivate;

struct _GnomeDbWindow {
	BonoboWindow          window;
	GnomeDbWindowPrivate* priv;
};

struct _GnomeDbWindowClass {
	BonoboWindowClass parent_class;
  
	void (* close) (GnomeDbWindow *window);
};

GType              gnome_db_window_get_type         (void);

GtkWidget*         gnome_db_window_new              (const gchar *name,
						     const gchar *app_prefix,
                                                     const gchar *ui_xml_file,
						     BonoboUIVerb *verbs,
                                                     gpointer data);
void               gnome_db_window_close            (GnomeDbWindow *window);
void               gnome_db_window_show             (GnomeDbWindow *window);

GtkWidget*         gnome_db_window_get_contents     (GnomeDbWindow *window);
void               gnome_db_window_set_contents     (GnomeDbWindow *window,
						     GtkWidget *contents);
void               gnome_db_window_set_status       (GnomeDbWindow *window,
						     const gchar *status);

BonoboUIComponent *gnome_db_window_get_ui_component (GnomeDbWindow *window);
Bonobo_UIContainer gnome_db_window_get_ui_container (GnomeDbWindow *window);

G_END_DECLS

#endif
