/*
 * Copyright(C) 2010 Neil Jagdish Patel
 * Copyright(C) 2010 Canonical Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 * Authored by Ken VaDine <ken.vandine@canonical.com>
 */

[DBus (name = "com.Gwibber.Streams")]
private interface StreamsInterface : Object {
        public abstract string Messages (string stream, string account, int time) throws DBus.Error;
}

namespace Gwibber
{
    public class Streams : Object
    {
        private const string streams_name  = "com.Gwibber.Streams";
        private const string streams_path  = "/com/gwibber/Streams";
        private const string streams_iface = "com.Gwibber.Streams";

        private StreamsInterface streams_service;
	private Gwibber.Utils utils;

	/** 
            Streams::is_available:
            @arg0: The current state

            Emitted when com.Gwibber.Streams availability state changes
	*/
	public signal void is_available(bool is_up);

	public Streams ()
	{
	}

        construct
        {
            try
            {
                var dbus_conn = DBus.Bus.get(DBus.BusType.SESSION);

                this.streams_service = (StreamsInterface) dbus_conn.get_object(this.streams_name,
                                                               this.streams_path,
                                                               this.streams_iface);                                                               
		this.utils = new Gwibber.Utils();
		this.utils.setup(this.streams_name);
		this.utils.available.connect(this.streams_available);
            }
            catch (GLib.Error e)
            {
                warning ("Unable to get Gwibber Streams");
            }
        }


        /**
         * com.Gwibber.Streams
         **/
	/*
        public string messages(string stream, string account, int time)
        {
            try
            {
                return this.streams_service.Messages(stream, account, time);
            }
            catch (DBus.Error e)
            {
                warning (e.message);
                return "";
            }
          
        }   
	*/

	public void streams_available(bool is_up)
	{
		this.is_available(is_up);
	}
    }
}
