#!/usr/bin/env python

__revision__ = "$Id: setup.py,v 1.6 2003/01/27 01:46:06 myers Exp $"

from distutils.core import setup, Extension, Command
import distutils.command.build_ext

import sys, os, string

VERSION_MAJOR = 0
VERSION_MINOR = 8
pymusicbrainz_version = str(VERSION_MAJOR) + '.' + str(VERSION_MINOR)

class build_ext(distutils.command.build_ext.build_ext):
    def run(self):
        distutils.command.build_ext.build_ext.run(self)

        build = self.get_finalized_command('build')
        self.build_platlib = build.build_platlib
        
        queries_h = os.path.join('src', 'queries.h')

        output = []
        includes = ''
        for ii in self.include_dirs:
            includes = includes + "-I%s " % ii
        cmd = "gcc -E -dM %s %s" % (includes, queries_h)
        print cmd
        file = os.popen(cmd, "r")
        output = file.readlines()

        queries = {}

        output.sort()

        for ii in output:
            name = ''
            query = ''
            # Remove "#define " from the beginning of each line
            ii = ii[8:-1] 
            if ii[:2] == "MB":
                name = ii[:ii.find(" ")]
                query = ii[ii.find(" ")+1:]
                # Remove all quotes
                query = query.replace("\"", "")
                # Escape out the newlines
                query = query.replace("\\n", "\\\n")
                query = query.replace("\\", "")
                # Get rid of trail/leading spaces
                query = query.strip()
                if query.endswith('\\'):
                    query = query[:-1]
                queries[name] = query

        filename = os.path.join(self.build_platlib, 'musicbrainz', 'queries.py')
        ff = open(filename, "w")
        ff.write("# auto generated\n")

        keys = queries.keys()
        keys.sort()
        for key in keys:
            ff.write("%s = \"\"\"\\\n%s\"\"\"\n\n" % (key, queries[key]))
        ff.close()

        print "Wrote %i queries into '%s'." % (len(queries), filename)

class test(Command):
    """
    
    Based off of http://mail.python.org/pipermail/distutils-sig/2002-January/002714.html
    """
    description  = "test the distribution prior to install"
    
    user_options = [
        ('test-dir=', None,
         "directory that contains the test definitions"),]
                 
    def initialize_options(self):
        self.test_dir = 'tests'    
        
    def finalize_options(self):
        build = self.get_finalized_command('build')
        self.build_purelib = build.build_purelib
        self.build_platlib = build.build_platlib
                                                                                           
    def run(self):
        import unittest
        self.run_command('build')
        self.run_command('build_ext')

        old_path = sys.path[:]
        sys.path.insert(0, self.build_purelib)
        sys.path.insert(0, self.build_platlib)
        sys.path.insert(0, os.path.join(os.getcwd(), self.test_dir))
        
        runner = unittest.TextTestRunner()
        for ff in os.listdir(self.test_dir):
            if ff[-3:] != ".py":
                continue
            print "Running tests found in '%s'..." % ff
            TEST = __import__(ff[:-3], globals(), locals(), [''])
            runner.run(TEST.suite())
        
        sys.path = old_path[:]
                
            
musicbrainzmodule = Extension(name='_musicbrainz',
                         sources=['src/musicbrainzmodule.c',
                                  'src/pymb.c',
                                  'src/pytrm.c',],
                         define_macros = [('VERSION', '"%s"' % pymusicbrainz_version)],
                         libraries=["musicbrainz","stdc++"])

setup ( 
    name            = "pymusicbrainz",
    version         = pymusicbrainz_version,
    description     = "A wrapper for the MusicBrainz libraries",
    license         = "LGPL",
    author          = "Myers W. Carpenter",
    author_email    = "myers@maski.org",
    packages = ['musicbrainz'],
    ext_package = 'musicbrainz',
    ext_modules     = [musicbrainzmodule],
    cmdclass        = {'build_ext': build_ext,
                       'test': test},
)

