/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2009-2012 Canonical Ltd.
 *
 * Authors: Rodrigo Moya <rodrigo.moya@canonical.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of version 3 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef __U1_MUSIC_STORE_H__
#define __U1_MUSIC_STORE_H__

#include <gtk/gtk.h>


G_BEGIN_DECLS

#define U1_TYPE_MUSIC_STORE                (u1_music_store_get_type ())
#define U1_MUSIC_STORE(obj)                (G_TYPE_CHECK_INSTANCE_CAST ((obj), U1_TYPE_MUSIC_STORE, U1MusicStore))
#define U1_IS_MUSIC_STORE(obj)             (G_TYPE_CHECK_INSTANCE_TYPE ((obj), U1_TYPE_MUSIC_STORE))
#define U1_MUSIC_STORE_CLASS(klass)        (G_TYPE_CHECK_CLASS_CAST ((klass), U1_TYPE_MUSIC_STORE, U1MusicStoreClass))
#define U1_IS_MUSIC_STORE_CLASS(klass)     (G_TYPE_CHECK_CLASS_TYPE ((klass), U1_TYPE_MUSIC_STORE))
#define U1_MUSIC_STORE_GET_CLASS(obj)      (G_TYPE_INSTANCE_GET_CLASS ((obj), U1_TYPE_MUSIC_STORE, U1MusicStoreClass))

typedef struct _U1MusicStore        U1MusicStore;
typedef struct _U1MusicStoreClass   U1MusicStoreClass;
typedef struct _U1MusicStorePrivate U1MusicStorePrivate;

struct _U1MusicStore {
	GtkVBox parent;
	U1MusicStorePrivate *priv;
};

struct _U1MusicStoreClass {
	GtkVBoxClass parent_class;

	/* Signals */
	void (* preview_mp3) (U1MusicStore *music_store, const gchar *url, const gchar *title);
	void (* play_library) (U1MusicStore *music_store, const gchar *path);
	void (* url_loaded) (U1MusicStore *music_store, const gchar *url);
	void (* download_finished) (U1MusicStore *music_store, const gchar *path);
};

GType        u1_music_store_get_type (void);

GtkWidget   *u1_music_store_new (void);
const gchar *u1_music_store_get_library_location (U1MusicStore *music_store);
void         u1_music_store_load_store_link (U1MusicStore *music_store, const gchar *url);

G_END_DECLS

#endif
