/*
 * unity-webapps-desktop-infos.h
 * Copyright (C) Canonical LTD 2013
 * 
 * Author: Alexandre Abreu <alexandre.abreu@canonical.com>
 * 
unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */

#include <glib.h>

#include "unity-webapps-desktop-infos.h"
#include "unity-webapps-string-utils.h"

gchar*
unity_webapps_desktop_infos_build_desktop_basename(const gchar* name,
                                                   const gchar* domain)
{
#define ADD_CANONICALIZED_STRING_TO_BASENAME(s) \
  { \
    const gchar *canonicalized_identifier; \
    canonicalized_identifier =                                      \
      unity_webapps_string_utils_canonicalize_string ((s), FALSE);  \
    basename = g_string_append(basename, canonicalized_identifier); \
    g_free((gpointer) canonicalized_identifier); \
  }

  GString *basename;

  g_return_val_if_fail(NULL != name, NULL);
  g_return_val_if_fail(NULL != domain, NULL);

  basename = g_string_new("");
  ADD_CANONICALIZED_STRING_TO_BASENAME(name);
  ADD_CANONICALIZED_STRING_TO_BASENAME(domain);

  return g_string_free (basename, FALSE);
}

