/* unity-scope-factory.c generated by valac 0.12.1, the Vala compiler
 * generated from unity-scope-factory.vala, do not modify */

/*
 * Copyright (C) 2011 Canonical, Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <dee.h>
#include "unity.h"
#include <config.h>


#define UNITY_TYPE_SCOPE_FACTORY (unity_scope_factory_get_type ())
#define UNITY_SCOPE_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_SCOPE_FACTORY, UnityScopeFactory))
#define UNITY_SCOPE_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_SCOPE_FACTORY, UnityScopeFactoryClass))
#define UNITY_IS_SCOPE_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_SCOPE_FACTORY))
#define UNITY_IS_SCOPE_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_SCOPE_FACTORY))
#define UNITY_SCOPE_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_SCOPE_FACTORY, UnityScopeFactoryClass))

typedef struct _UnityScopeFactory UnityScopeFactory;
typedef struct _UnityScopeFactoryClass UnityScopeFactoryClass;
typedef struct _UnityScopeFactoryPrivate UnityScopeFactoryPrivate;

#define UNITY_TYPE_SCOPE_PROXY (unity_scope_proxy_get_type ())
#define UNITY_SCOPE_PROXY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_SCOPE_PROXY, UnityScopeProxy))
#define UNITY_IS_SCOPE_PROXY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_SCOPE_PROXY))
#define UNITY_SCOPE_PROXY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), UNITY_TYPE_SCOPE_PROXY, UnityScopeProxyIface))

typedef struct _UnityScopeProxy UnityScopeProxy;
typedef struct _UnityScopeProxyIface UnityScopeProxyIface;

#define UNITY_TYPE_ACTIVATION_REPLY_RAW (unity_activation_reply_raw_get_type ())
typedef struct _UnityActivationReplyRaw UnityActivationReplyRaw;

#define UNITY_TYPE_PREVIEW_REPLY_RAW (unity_preview_reply_raw_get_type ())
typedef struct _UnityPreviewReplyRaw UnityPreviewReplyRaw;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _UnityScopeFactoryListLensDirectoryData UnityScopeFactoryListLensDirectoryData;

#define UNITY_TYPE_SCOPE_PROXY_REMOTE (unity_scope_proxy_remote_get_type ())
#define UNITY_SCOPE_PROXY_REMOTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_SCOPE_PROXY_REMOTE, UnityScopeProxyRemote))
#define UNITY_SCOPE_PROXY_REMOTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_SCOPE_PROXY_REMOTE, UnityScopeProxyRemoteClass))
#define UNITY_IS_SCOPE_PROXY_REMOTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_SCOPE_PROXY_REMOTE))
#define UNITY_IS_SCOPE_PROXY_REMOTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_SCOPE_PROXY_REMOTE))
#define UNITY_SCOPE_PROXY_REMOTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_SCOPE_PROXY_REMOTE, UnityScopeProxyRemoteClass))

typedef struct _UnityScopeProxyRemote UnityScopeProxyRemote;
typedef struct _UnityScopeProxyRemoteClass UnityScopeProxyRemoteClass;
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))

#define UNITY_TYPE_SCOPE_PROXY_LOCAL (unity_scope_proxy_local_get_type ())
#define UNITY_SCOPE_PROXY_LOCAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_SCOPE_PROXY_LOCAL, UnityScopeProxyLocal))
#define UNITY_SCOPE_PROXY_LOCAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_SCOPE_PROXY_LOCAL, UnityScopeProxyLocalClass))
#define UNITY_IS_SCOPE_PROXY_LOCAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_SCOPE_PROXY_LOCAL))
#define UNITY_IS_SCOPE_PROXY_LOCAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_SCOPE_PROXY_LOCAL))
#define UNITY_SCOPE_PROXY_LOCAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_SCOPE_PROXY_LOCAL, UnityScopeProxyLocalClass))

typedef struct _UnityScopeProxyLocal UnityScopeProxyLocal;
typedef struct _UnityScopeProxyLocalClass UnityScopeProxyLocalClass;

struct _UnityActivationReplyRaw {
	gchar* uri;
	guint handled;
	GHashTable* hints;
};

struct _UnityPreviewReplyRaw {
	gchar* uri;
	gchar* renderer_name;
	GHashTable* properties;
};

struct _UnityScopeProxyIface {
	GTypeInterface parent_iface;
	void (*activate) (UnityScopeProxy* self, const gchar* uri, guint action_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*activate_finish) (UnityScopeProxy* self, GAsyncResult* _res_, UnityActivationReplyRaw* result);
	void (*search) (UnityScopeProxy* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*search_finish) (UnityScopeProxy* self, GAsyncResult* _res_);
	void (*global_search) (UnityScopeProxy* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*global_search_finish) (UnityScopeProxy* self, GAsyncResult* _res_);
	void (*preview) (UnityScopeProxy* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*preview_finish) (UnityScopeProxy* self, GAsyncResult* _res_, UnityPreviewReplyRaw* result);
	void (*set_active) (UnityScopeProxy* self, gboolean active, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*set_active_finish) (UnityScopeProxy* self, GAsyncResult* _res_);
	void (*set_active_sources) (UnityScopeProxy* self, gchar** sources, int sources_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*set_active_sources_finish) (UnityScopeProxy* self, GAsyncResult* _res_);
	gchar** (*get_sources) (UnityScopeProxy* self, int* result_length1);
	void (*set_sources) (UnityScopeProxy* self, gchar** value, int value_length1);
	gboolean (*get_search_in_global) (UnityScopeProxy* self);
	void (*set_search_in_global) (UnityScopeProxy* self, gboolean value);
	DeeSharedModel* (*get_results_model) (UnityScopeProxy* self);
	void (*set_results_model) (UnityScopeProxy* self, DeeSharedModel* value);
	DeeSharedModel* (*get_global_results_model) (UnityScopeProxy* self);
	void (*set_global_results_model) (UnityScopeProxy* self, DeeSharedModel* value);
	DeeSharedModel* (*get_filters_model) (UnityScopeProxy* self);
	void (*set_filters_model) (UnityScopeProxy* self, DeeSharedModel* value);
};

struct _UnityScopeFactory {
	GObject parent_instance;
	UnityScopeFactoryPrivate * priv;
	GeeArrayList* scopes;
};

struct _UnityScopeFactoryClass {
	GObjectClass parent_class;
};

struct _UnityScopeFactoryPrivate {
	gchar* _lens_id;
	gchar* _lenses_directory;
};

struct _UnityScopeFactoryListLensDirectoryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityScopeFactory* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GFile* _tmp3_;
	GFile* dir;
	GFileEnumerator* _tmp4_;
	GFileEnumerator* e;
	GList* _tmp5_;
	GList* files;
	GList* info_collection;
	GList* info_it;
	GFileInfo* _tmp6_;
	GFileInfo* info;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* name;
	gboolean _tmp9_;
	GError * _error_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GError * _inner_error_;
};


static gpointer unity_scope_factory_parent_class = NULL;

GType unity_scope_factory_get_type (void) G_GNUC_CONST;
GType unity_activation_reply_raw_get_type (void) G_GNUC_CONST;
UnityActivationReplyRaw* unity_activation_reply_raw_dup (const UnityActivationReplyRaw* self);
void unity_activation_reply_raw_free (UnityActivationReplyRaw* self);
void unity_activation_reply_raw_copy (const UnityActivationReplyRaw* self, UnityActivationReplyRaw* dest);
void unity_activation_reply_raw_destroy (UnityActivationReplyRaw* self);
GType unity_preview_reply_raw_get_type (void) G_GNUC_CONST;
UnityPreviewReplyRaw* unity_preview_reply_raw_dup (const UnityPreviewReplyRaw* self);
void unity_preview_reply_raw_free (UnityPreviewReplyRaw* self);
void unity_preview_reply_raw_copy (const UnityPreviewReplyRaw* self, UnityPreviewReplyRaw* dest);
void unity_preview_reply_raw_destroy (UnityPreviewReplyRaw* self);
GType unity_scope_proxy_get_type (void) G_GNUC_CONST;
#define UNITY_SCOPE_FACTORY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_TYPE_SCOPE_FACTORY, UnityScopeFactoryPrivate))
enum  {
	UNITY_SCOPE_FACTORY_DUMMY_PROPERTY,
	UNITY_SCOPE_FACTORY_LENS_ID,
	UNITY_SCOPE_FACTORY_LENSES_DIRECTORY
};
UnityScopeFactory* unity_scope_factory_new (const gchar* lens_id_, const gchar* lenses_directory_);
UnityScopeFactory* unity_scope_factory_construct (GType object_type, const gchar* lens_id_, const gchar* lenses_directory_);
static void unity_scope_factory_list_lens_directory_data_free (gpointer _data);
static void unity_scope_factory_list_lens_directory (UnityScopeFactory* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void unity_scope_factory_list_lens_directory_finish (UnityScopeFactory* self, GAsyncResult* _res_);
static gboolean unity_scope_factory_list_lens_directory_co (UnityScopeFactoryListLensDirectoryData* data);
const gchar* unity_scope_factory_get_lenses_directory (UnityScopeFactory* self);
static void unity_scope_factory_list_lens_directory_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void unity_scope_factory_load_scope_file (UnityScopeFactory* self, const gchar* name);
UnityScopeProxyRemote* unity_scope_proxy_remote_new (const gchar* dbus_name_, const gchar* dbus_path_);
UnityScopeProxyRemote* unity_scope_proxy_remote_construct (GType object_type, const gchar* dbus_name_, const gchar* dbus_path_);
GType unity_scope_proxy_remote_get_type (void) G_GNUC_CONST;
void unity_scope_factory_add_local_scope (UnityScopeFactory* self, UnityScope* scope);
UnityScopeProxyLocal* unity_scope_proxy_local_new (UnityScope* scope);
UnityScopeProxyLocal* unity_scope_proxy_local_construct (GType object_type, UnityScope* scope);
GType unity_scope_proxy_local_get_type (void) G_GNUC_CONST;
const gchar* unity_scope_factory_get_lens_id (UnityScopeFactory* self);
static void unity_scope_factory_set_lens_id (UnityScopeFactory* self, const gchar* value);
static void unity_scope_factory_set_lenses_directory (UnityScopeFactory* self, const gchar* value);
static GObject * unity_scope_factory_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void unity_scope_factory_finalize (GObject* obj);
static void _vala_unity_scope_factory_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_unity_scope_factory_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


UnityScopeFactory* unity_scope_factory_construct (GType object_type, const gchar* lens_id_, const gchar* lenses_directory_) {
	UnityScopeFactory * self = NULL;
	g_return_val_if_fail (lens_id_ != NULL, NULL);
	g_return_val_if_fail (lenses_directory_ != NULL, NULL);
	self = (UnityScopeFactory*) g_object_new (object_type, "lens-id", lens_id_, "lenses-directory", lenses_directory_, NULL);
	return self;
}


UnityScopeFactory* unity_scope_factory_new (const gchar* lens_id_, const gchar* lenses_directory_) {
	return unity_scope_factory_construct (UNITY_TYPE_SCOPE_FACTORY, lens_id_, lenses_directory_);
}


static void unity_scope_factory_list_lens_directory_data_free (gpointer _data) {
	UnityScopeFactoryListLensDirectoryData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (UnityScopeFactoryListLensDirectoryData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void unity_scope_factory_list_lens_directory (UnityScopeFactory* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityScopeFactoryListLensDirectoryData* _data_;
	_data_ = g_slice_new0 (UnityScopeFactoryListLensDirectoryData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_scope_factory_list_lens_directory);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_scope_factory_list_lens_directory_data_free);
	_data_->self = _g_object_ref0 (self);
	unity_scope_factory_list_lens_directory_co (_data_);
}


static void unity_scope_factory_list_lens_directory_finish (UnityScopeFactory* self, GAsyncResult* _res_) {
	UnityScopeFactoryListLensDirectoryData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static void unity_scope_factory_list_lens_directory_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityScopeFactoryListLensDirectoryData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	unity_scope_factory_list_lens_directory_co (data);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static gboolean unity_scope_factory_list_lens_directory_co (UnityScopeFactoryListLensDirectoryData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = string_to_string (data->self->priv->_lenses_directory);
	data->_tmp1_ = NULL;
	data->_tmp1_ = g_strconcat ("Searching for Scopes in ", data->_tmp0_, NULL);
	data->_tmp2_ = data->_tmp1_;
	g_debug ("unity-scope-factory.vala:57: %s", data->_tmp2_);
	_g_free0 (data->_tmp2_);
	data->_tmp3_ = NULL;
	data->_tmp3_ = g_file_new_for_path (data->self->priv->_lenses_directory);
	data->dir = data->_tmp3_;
	data->_state_ = 1;
	g_file_enumerate_children_async (data->dir, G_FILE_ATTRIBUTE_STANDARD_NAME, 0, G_PRIORITY_DEFAULT, NULL, unity_scope_factory_list_lens_directory_ready, data);
	return FALSE;
	_state_1:
	data->_tmp4_ = NULL;
	data->_tmp4_ = g_file_enumerate_children_finish (data->dir, data->_res_, &data->_inner_error_);
	data->e = data->_tmp4_;
	if (data->_inner_error_ != NULL) {
		goto __catch21_g_error;
	}
	while (TRUE) {
		data->_state_ = 2;
		g_file_enumerator_next_files_async (data->e, 10, G_PRIORITY_DEFAULT, NULL, unity_scope_factory_list_lens_directory_ready, data);
		return FALSE;
		_state_2:
		data->_tmp5_ = NULL;
		data->_tmp5_ = g_file_enumerator_next_files_finish (data->e, data->_res_, &data->_inner_error_);
		data->files = data->_tmp5_;
		if (data->_inner_error_ != NULL) {
			_g_object_unref0 (data->e);
			goto __catch21_g_error;
		}
		if (data->files == NULL) {
			__g_list_free__g_object_unref0_0 (data->files);
			break;
		}
		{
			data->info_collection = data->files;
			for (data->info_it = data->info_collection; data->info_it != NULL; data->info_it = data->info_it->next) {
				data->_tmp6_ = _g_object_ref0 ((GFileInfo*) data->info_it->data);
				data->info = data->_tmp6_;
				{
					data->_tmp7_ = NULL;
					data->_tmp7_ = g_file_info_get_name (data->info);
					data->_tmp8_ = g_strdup (data->_tmp7_);
					data->name = data->_tmp8_;
					data->_tmp9_ = g_str_has_suffix (data->name, ".scope");
					if (data->_tmp9_) {
						unity_scope_factory_load_scope_file (data->self, data->name);
					}
					_g_free0 (data->name);
					_g_object_unref0 (data->info);
				}
			}
		}
		__g_list_free__g_object_unref0_0 (data->files);
	}
	_g_object_unref0 (data->e);
	goto __finally21;
	__catch21_g_error:
	{
		data->_error_ = data->_inner_error_;
		data->_inner_error_ = NULL;
		data->_tmp10_ = NULL;
		data->_tmp10_ = string_to_string (data->_error_->message);
		data->_tmp11_ = NULL;
		data->_tmp11_ = g_strconcat ("Unable to search for scopes: ", data->_tmp10_, NULL);
		data->_tmp12_ = data->_tmp11_;
		g_debug ("unity-scope-factory.vala:78: %s", data->_tmp12_);
		_g_free0 (data->_tmp12_);
		_g_error_free0 (data->_error_);
	}
	__finally21:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (data->dir);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void unity_scope_factory_load_scope_file (UnityScopeFactory* self, const gchar* name) {
	static const char GROUP[] = "Scope";
	static const char DBUS_NAME[] = "DBusName";
	static const char DBUS_PATH[] = "DBusPath";
	gchar* _tmp0_ = NULL;
	gchar* path;
	GKeyFile* _tmp1_ = NULL;
	GKeyFile* key_file;
	gboolean _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = g_build_filename (self->priv->_lenses_directory, name, NULL);
	path = _tmp0_;
	_tmp1_ = g_key_file_new ();
	key_file = _tmp1_;
	g_key_file_load_from_file (key_file, path, G_KEY_FILE_NONE, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch22_g_error;
	}
	_tmp2_ = g_key_file_has_group (key_file, "Scope");
	if (_tmp2_) {
		gchar* _tmp3_ = NULL;
		gchar* dbus_name;
		gchar* _tmp4_ = NULL;
		gchar* dbus_path;
		UnityScopeProxyRemote* _tmp5_ = NULL;
		UnityScopeProxyRemote* scope;
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
		_tmp3_ = g_key_file_get_string (key_file, GROUP, DBUS_NAME, &_inner_error_);
		dbus_name = _tmp3_;
		if (_inner_error_ != NULL) {
			goto __catch22_g_error;
		}
		_tmp4_ = g_key_file_get_string (key_file, GROUP, DBUS_PATH, &_inner_error_);
		dbus_path = _tmp4_;
		if (_inner_error_ != NULL) {
			_g_free0 (dbus_name);
			goto __catch22_g_error;
		}
		_tmp5_ = unity_scope_proxy_remote_new (dbus_name, dbus_path);
		scope = _tmp5_;
		gee_abstract_collection_add ((GeeAbstractCollection*) self->scopes, (UnityScopeProxy*) scope);
		g_signal_emit_by_name (self, "scope-added", (UnityScopeProxy*) scope);
		_tmp6_ = string_to_string (path);
		_tmp7_ = string_to_string (dbus_name);
		_tmp8_ = string_to_string (dbus_path);
		_tmp9_ = g_strconcat ("Successfully loaded ", _tmp6_, ": ", _tmp7_, " | ", _tmp8_, NULL);
		_tmp10_ = _tmp9_;
		g_debug ("unity-scope-factory.vala:102: %s", _tmp10_);
		_g_free0 (_tmp10_);
		_g_object_unref0 (scope);
		_g_free0 (dbus_path);
		_g_free0 (dbus_name);
	} else {
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		_tmp11_ = string_to_string (path);
		_tmp12_ = g_strconcat ("Unable to load ", _tmp11_, ": Does not contain 'Scope' group", NULL);
		_tmp13_ = _tmp12_;
		g_warning ("unity-scope-factory.vala:106: %s", _tmp13_);
		_g_free0 (_tmp13_);
	}
	goto __finally22;
	__catch22_g_error:
	{
		GError * e;
		const gchar* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp14_ = string_to_string (path);
		_tmp15_ = string_to_string (e->message);
		_tmp16_ = g_strconcat ("Unable to load ", _tmp14_, ": ", _tmp15_, NULL);
		_tmp17_ = _tmp16_;
		g_warning ("unity-scope-factory.vala:109: %s", _tmp17_);
		_g_free0 (_tmp17_);
		_g_error_free0 (e);
	}
	__finally22:
	if (_inner_error_ != NULL) {
		_g_key_file_free0 (key_file);
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_key_file_free0 (key_file);
	_g_free0 (path);
}


void unity_scope_factory_add_local_scope (UnityScopeFactory* self, UnityScope* scope) {
	UnityScopeProxyLocal* _tmp0_ = NULL;
	UnityScopeProxyLocal* proxy;
	g_return_if_fail (self != NULL);
	g_return_if_fail (scope != NULL);
	_tmp0_ = unity_scope_proxy_local_new (scope);
	proxy = _tmp0_;
	gee_abstract_collection_add ((GeeAbstractCollection*) self->scopes, (UnityScopeProxy*) proxy);
	g_signal_emit_by_name (self, "scope-added", (UnityScopeProxy*) proxy);
	_g_object_unref0 (proxy);
}


const gchar* unity_scope_factory_get_lens_id (UnityScopeFactory* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_lens_id;
	return result;
}


static void unity_scope_factory_set_lens_id (UnityScopeFactory* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_lens_id);
	self->priv->_lens_id = _tmp0_;
	g_object_notify ((GObject *) self, "lens-id");
}


const gchar* unity_scope_factory_get_lenses_directory (UnityScopeFactory* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_lenses_directory;
	return result;
}


static void unity_scope_factory_set_lenses_directory (UnityScopeFactory* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_lenses_directory);
	self->priv->_lenses_directory = _tmp0_;
	g_object_notify ((GObject *) self, "lenses-directory");
}


static GObject * unity_scope_factory_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityScopeFactory * self;
	GeeArrayList* _tmp2_ = NULL;
	parent_class = G_OBJECT_CLASS (unity_scope_factory_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_SCOPE_FACTORY (obj);
	if (g_strcmp0 (self->priv->_lenses_directory, "") == 0) {
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		_tmp0_ = g_strdup_printf ("%s/unity/lenses/%s", DATADIR, self->priv->_lens_id);
		_tmp1_ = _tmp0_;
		unity_scope_factory_set_lenses_directory (self, _tmp1_);
		_g_free0 (_tmp1_);
	}
	_tmp2_ = gee_array_list_new (UNITY_TYPE_SCOPE_PROXY, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	_g_object_unref0 (self->scopes);
	self->scopes = _tmp2_;
	unity_scope_factory_list_lens_directory (self, NULL, NULL);
	return obj;
}


static void unity_scope_factory_class_init (UnityScopeFactoryClass * klass) {
	unity_scope_factory_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityScopeFactoryPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_unity_scope_factory_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_unity_scope_factory_set_property;
	G_OBJECT_CLASS (klass)->constructor = unity_scope_factory_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_scope_factory_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_SCOPE_FACTORY_LENS_ID, g_param_spec_string ("lens-id", "lens-id", "lens-id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_SCOPE_FACTORY_LENSES_DIRECTORY, g_param_spec_string ("lenses-directory", "lenses-directory", "lenses-directory", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_signal_new ("scope_added", UNITY_TYPE_SCOPE_FACTORY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, UNITY_TYPE_SCOPE_PROXY);
}


static void unity_scope_factory_instance_init (UnityScopeFactory * self) {
	self->priv = UNITY_SCOPE_FACTORY_GET_PRIVATE (self);
}


static void unity_scope_factory_finalize (GObject* obj) {
	UnityScopeFactory * self;
	self = UNITY_SCOPE_FACTORY (obj);
	_g_free0 (self->priv->_lens_id);
	_g_free0 (self->priv->_lenses_directory);
	_g_object_unref0 (self->scopes);
	G_OBJECT_CLASS (unity_scope_factory_parent_class)->finalize (obj);
}


GType unity_scope_factory_get_type (void) {
	static volatile gsize unity_scope_factory_type_id__volatile = 0;
	if (g_once_init_enter (&unity_scope_factory_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityScopeFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_scope_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityScopeFactory), 0, (GInstanceInitFunc) unity_scope_factory_instance_init, NULL };
		GType unity_scope_factory_type_id;
		unity_scope_factory_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityScopeFactory", &g_define_type_info, 0);
		g_once_init_leave (&unity_scope_factory_type_id__volatile, unity_scope_factory_type_id);
	}
	return unity_scope_factory_type_id__volatile;
}


static void _vala_unity_scope_factory_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityScopeFactory * self;
	self = UNITY_SCOPE_FACTORY (object);
	switch (property_id) {
		case UNITY_SCOPE_FACTORY_LENS_ID:
		g_value_set_string (value, unity_scope_factory_get_lens_id (self));
		break;
		case UNITY_SCOPE_FACTORY_LENSES_DIRECTORY:
		g_value_set_string (value, unity_scope_factory_get_lenses_directory (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_unity_scope_factory_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityScopeFactory * self;
	self = UNITY_SCOPE_FACTORY (object);
	switch (property_id) {
		case UNITY_SCOPE_FACTORY_LENS_ID:
		unity_scope_factory_set_lens_id (self, g_value_get_string (value));
		break;
		case UNITY_SCOPE_FACTORY_LENSES_DIRECTORY:
		unity_scope_factory_set_lenses_directory (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



