/* unity-scope.c generated by valac 0.12.1, the Vala compiler
 * generated from unity-scope.vala, do not modify */

/*
 * Copyright (C) 2011 Canonical, Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include "unity.h"
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <dee.h>


#define UNITY_TYPE_SCOPE_IMPL (unity_scope_impl_get_type ())
#define UNITY_SCOPE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_SCOPE_IMPL, UnityScopeImpl))
#define UNITY_SCOPE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_SCOPE_IMPL, UnityScopeImplClass))
#define UNITY_IS_SCOPE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_SCOPE_IMPL))
#define UNITY_IS_SCOPE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_SCOPE_IMPL))
#define UNITY_SCOPE_IMPL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_SCOPE_IMPL, UnityScopeImplClass))

typedef struct _UnityScopeImpl UnityScopeImpl;
typedef struct _UnityScopeImplClass UnityScopeImplClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define UNITY_TYPE_SCOPE_SERVICE (unity_scope_service_get_type ())
#define UNITY_SCOPE_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_SCOPE_SERVICE, UnityScopeService))
#define UNITY_IS_SCOPE_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_SCOPE_SERVICE))
#define UNITY_SCOPE_SERVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), UNITY_TYPE_SCOPE_SERVICE, UnityScopeServiceIface))

typedef struct _UnityScopeService UnityScopeService;
typedef struct _UnityScopeServiceIface UnityScopeServiceIface;

#define UNITY_TYPE_SCOPE_SERVICE_PROXY (unity_scope_service_proxy_get_type ())

#define UNITY_TYPE_ACTIVATION_REPLY_RAW (unity_activation_reply_raw_get_type ())
typedef struct _UnityActivationReplyRaw UnityActivationReplyRaw;

#define UNITY_TYPE_PREVIEW_REPLY_RAW (unity_preview_reply_raw_get_type ())
typedef struct _UnityPreviewReplyRaw UnityPreviewReplyRaw;
typedef struct _UnityScopeImplPrivate UnityScopeImplPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _UnityScopeActivateData UnityScopeActivateData;
typedef struct _UnityScopeSearchData UnityScopeSearchData;
typedef struct _UnityScopeGlobalSearchData UnityScopeGlobalSearchData;
typedef struct _UnityScopePreviewData UnityScopePreviewData;

struct _UnityScopePrivate {
	gboolean _active;
	gboolean _exported;
	gboolean _search_in_global;
	gchar* _dbus_path;
	gchar** _sources;
	gint _sources_length1;
	gint __sources_size_;
	UnityLensSearch* _active_search;
	UnityLensSearch* _active_global_search;
	gchar** _active_sources;
	gint _active_sources_length1;
	gint __active_sources_size_;
	UnityScopeImpl* _pimpl;
	gboolean is_local;
};

struct _UnityActivationReplyRaw {
	gchar* uri;
	guint handled;
	GHashTable* hints;
};

struct _UnityPreviewReplyRaw {
	gchar* uri;
	gchar* renderer_name;
	GHashTable* properties;
};

struct _UnityScopeServiceIface {
	GTypeInterface parent_iface;
	void (*info_request) (UnityScopeService* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*info_request_finish) (UnityScopeService* self, GAsyncResult* _res_, GError** error);
	void (*activate) (UnityScopeService* self, const gchar* uri, guint action_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*activate_finish) (UnityScopeService* self, GAsyncResult* _res_, UnityActivationReplyRaw* result, GError** error);
	void (*search) (UnityScopeService* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*search_finish) (UnityScopeService* self, GAsyncResult* _res_, GError** error);
	void (*global_search) (UnityScopeService* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*global_search_finish) (UnityScopeService* self, GAsyncResult* _res_, GError** error);
	void (*preview) (UnityScopeService* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*preview_finish) (UnityScopeService* self, GAsyncResult* _res_, UnityPreviewReplyRaw* result, GError** error);
	void (*set_active) (UnityScopeService* self, gboolean active, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*set_active_finish) (UnityScopeService* self, GAsyncResult* _res_, GError** error);
	void (*set_active_sources) (UnityScopeService* self, gchar** sources, int sources_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*set_active_sources_finish) (UnityScopeService* self, GAsyncResult* _res_, GError** error);
};

struct _UnityScopeImpl {
	GObject parent_instance;
	UnityScopeImplPrivate * priv;
	DeeSharedModel* _results_model;
	DeeSharedModel* _global_results_model;
	DeeSharedModel* _filters_model;
};

struct _UnityScopeImplClass {
	GObjectClass parent_class;
};

struct _UnityScopeActivateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityScope* self;
	gchar* uri;
	guint action_type;
	UnityActivationReplyRaw result;
	UnityActivationReplyRaw _tmp0_;
	UnityActivationReplyRaw _tmp1_;
	UnityActivationReplyRaw reply;
	GError * e;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	UnityActivationReplyRaw res;
	gchar* _tmp5_;
	GHashTable* _tmp6_;
	GError * _inner_error_;
};

struct _UnityScopeSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityScope* self;
	gchar* search_string;
	GHashTable* hints;
	GError * e;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GError * _inner_error_;
};

struct _UnityScopeGlobalSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityScope* self;
	gchar* search_string;
	GHashTable* hints;
	GError * e;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GError * _inner_error_;
};

struct _UnityScopePreviewData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityScope* self;
	gchar* uri;
	UnityPreviewReplyRaw result;
	UnityPreviewReplyRaw _tmp0_;
	UnityPreviewReplyRaw _tmp1_;
	UnityPreviewReplyRaw reply;
	GError * e;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	UnityPreviewReplyRaw _tmp5_;
	UnityPreviewReplyRaw _tmp6_;
	GError * _inner_error_;
};


static gpointer unity_scope_parent_class = NULL;

GType unity_scope_impl_get_type (void) G_GNUC_CONST;
#define UNITY_SCOPE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_TYPE_SCOPE, UnityScopePrivate))
enum  {
	UNITY_SCOPE_DUMMY_PROPERTY,
	UNITY_SCOPE_ACTIVE,
	UNITY_SCOPE_EXPORTED,
	UNITY_SCOPE_SEARCH_IN_GLOBAL,
	UNITY_SCOPE_DBUS_PATH,
	UNITY_SCOPE_SOURCES,
	UNITY_SCOPE_FILTERS,
	UNITY_SCOPE_RESULTS_MODEL,
	UNITY_SCOPE_GLOBAL_RESULTS_MODEL,
	UNITY_SCOPE_ACTIVE_SEARCH,
	UNITY_SCOPE_ACTIVE_GLOBAL_SEARCH,
	UNITY_SCOPE_ACTIVE_SOURCES
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
void unity_scope_impl_export (UnityScopeImpl* self, GError** error);
static void unity_scope_set_exported (UnityScope* self, gboolean value);
void unity_scope_set_active_internal (UnityScope* self, gboolean is_active);
void unity_scope_set_active_sources_internal (UnityScope* self, gchar** active_sources_, int active_sources__length1);
static void unity_scope_set_active_sources (UnityScope* self, gchar** value, int value_length1);
void unity_scope_set_local (UnityScope* self, gboolean is_local_);
DeeSharedModel* unity_scope_get_filter_model (UnityScope* self);
GType unity_scope_service_proxy_get_type (void) G_GNUC_CONST;
guint unity_scope_service_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType unity_activation_reply_raw_get_type (void) G_GNUC_CONST;
UnityActivationReplyRaw* unity_activation_reply_raw_dup (const UnityActivationReplyRaw* self);
void unity_activation_reply_raw_free (UnityActivationReplyRaw* self);
void unity_activation_reply_raw_copy (const UnityActivationReplyRaw* self, UnityActivationReplyRaw* dest);
void unity_activation_reply_raw_destroy (UnityActivationReplyRaw* self);
GType unity_preview_reply_raw_get_type (void) G_GNUC_CONST;
UnityPreviewReplyRaw* unity_preview_reply_raw_dup (const UnityPreviewReplyRaw* self);
void unity_preview_reply_raw_free (UnityPreviewReplyRaw* self);
void unity_preview_reply_raw_copy (const UnityPreviewReplyRaw* self, UnityPreviewReplyRaw* dest);
void unity_preview_reply_raw_destroy (UnityPreviewReplyRaw* self);
GType unity_scope_service_get_type (void) G_GNUC_CONST;
static void unity_scope_activate_data_free (gpointer _data);
void unity_scope_activate (UnityScope* self, const gchar* uri, guint action_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_scope_activate_finish (UnityScope* self, GAsyncResult* _res_, UnityActivationReplyRaw* result);
static gboolean unity_scope_activate_co (UnityScopeActivateData* data);
void unity_scope_service_activate (UnityScopeService* self, const gchar* uri, guint action_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_scope_service_activate_finish (UnityScopeService* self, GAsyncResult* _res_, UnityActivationReplyRaw* result, GError** error);
static void unity_scope_activate_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _g_free0_ (gpointer var);
static void _g_variant_unref0_ (gpointer var);
static void unity_scope_search_data_free (gpointer _data);
void unity_scope_search (UnityScope* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_scope_search_finish (UnityScope* self, GAsyncResult* _res_);
static gboolean unity_scope_search_co (UnityScopeSearchData* data);
void unity_scope_service_search (UnityScopeService* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_scope_service_search_finish (UnityScopeService* self, GAsyncResult* _res_, GError** error);
static void unity_scope_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void unity_scope_global_search_data_free (gpointer _data);
void unity_scope_global_search (UnityScope* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_scope_global_search_finish (UnityScope* self, GAsyncResult* _res_);
static gboolean unity_scope_global_search_co (UnityScopeGlobalSearchData* data);
void unity_scope_service_global_search (UnityScopeService* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_scope_service_global_search_finish (UnityScopeService* self, GAsyncResult* _res_, GError** error);
static void unity_scope_global_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void unity_scope_preview_data_free (gpointer _data);
void unity_scope_preview (UnityScope* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_scope_preview_finish (UnityScope* self, GAsyncResult* _res_, UnityPreviewReplyRaw* result);
static gboolean unity_scope_preview_co (UnityScopePreviewData* data);
void unity_scope_service_preview (UnityScopeService* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_scope_service_preview_finish (UnityScopeService* self, GAsyncResult* _res_, UnityPreviewReplyRaw* result, GError** error);
static void unity_scope_preview_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gchar** _vala_array_dup3 (gchar** self, int length);
static gchar** _vala_array_dup4 (gchar** self, int length);
static void g_cclosure_user_marshal_OBJECT__STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__STRING_BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static GObject * unity_scope_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
UnityScopeImpl* unity_scope_impl_new (UnityScope* owner);
UnityScopeImpl* unity_scope_impl_construct (GType object_type, UnityScope* owner);
static void _lambda3_ (const gchar* s, GHashTable* h, UnityScope* self);
static void __lambda3__unity_scope_service_search_finished (UnityScopeService* _sender, const gchar* search_string, GHashTable* hints, gpointer self);
static void _lambda4_ (const gchar* s, GHashTable* h, UnityScope* self);
static void __lambda4__unity_scope_service_global_search_finished (UnityScopeService* _sender, const gchar* search_string, GHashTable* hints, gpointer self);
static void unity_scope_finalize (GObject* obj);
static void _vala_unity_scope_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_unity_scope_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


UnityScope* unity_scope_construct (GType object_type, const gchar* dbus_path_) {
	UnityScope * self = NULL;
	g_return_val_if_fail (dbus_path_ != NULL, NULL);
	self = (UnityScope*) g_object_new (object_type, "dbus-path", dbus_path_, NULL);
	return self;
}


UnityScope* unity_scope_new (const gchar* dbus_path_) {
	return unity_scope_construct (UNITY_TYPE_SCOPE, dbus_path_);
}


void unity_scope_export (UnityScope* self, GError** error) {
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (!self->priv->_exported) {
		_tmp0_ = !self->priv->is_local;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		unity_scope_impl_export (self->priv->_pimpl, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		unity_scope_set_exported (self, TRUE);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


UnityFilter* unity_scope_get_filter (UnityScope* self, const gchar* id) {
	UnityFilter* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	{
		GList* filter_collection;
		GList* filter_it;
		filter_collection = self->_filters;
		for (filter_it = filter_collection; filter_it != NULL; filter_it = filter_it->next) {
			UnityFilter* _tmp0_;
			UnityFilter* filter;
			_tmp0_ = _g_object_ref0 ((UnityFilter*) filter_it->data);
			filter = _tmp0_;
			{
				const gchar* _tmp1_ = NULL;
				_tmp1_ = unity_filter_get_id (filter);
				if (g_strcmp0 (_tmp1_, id) == 0) {
					result = filter;
					return result;
				}
				_g_object_unref0 (filter);
			}
		}
	}
	result = NULL;
	return result;
}


void unity_scope_set_active_internal (UnityScope* self, gboolean is_active) {
	g_return_if_fail (self != NULL);
	unity_scope_set_active (self, is_active);
}


void unity_scope_set_active_sources_internal (UnityScope* self, gchar** active_sources_, int active_sources__length1) {
	gchar** _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = active_sources_;
	unity_scope_set_active_sources (self, _tmp0_, active_sources__length1);
}


void unity_scope_set_local (UnityScope* self, gboolean is_local_) {
	g_return_if_fail (self != NULL);
	self->priv->is_local = is_local_;
}


DeeSharedModel* unity_scope_get_filter_model (UnityScope* self) {
	DeeSharedModel* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_pimpl->_filters_model;
	return result;
}


static void unity_scope_activate_data_free (gpointer _data) {
	UnityScopeActivateData* data;
	data = _data;
	_g_free0 (data->uri);
	unity_activation_reply_raw_destroy (&data->result);
	_g_object_unref0 (data->self);
	g_slice_free (UnityScopeActivateData, data);
}


void unity_scope_activate (UnityScope* self, const gchar* uri, guint action_type, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityScopeActivateData* _data_;
	_data_ = g_slice_new0 (UnityScopeActivateData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_scope_activate);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_scope_activate_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->uri = g_strdup (uri);
	_data_->action_type = action_type;
	unity_scope_activate_co (_data_);
}


void unity_scope_activate_finish (UnityScope* self, GAsyncResult* _res_, UnityActivationReplyRaw* result) {
	UnityScopeActivateData* _data_;
	UnityActivationReplyRaw _tmp0_ = {0};
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	unity_activation_reply_raw_copy (&_data_->result, &_tmp0_);
	*result = _tmp0_;
}


static void unity_scope_activate_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityScopeActivateData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	unity_scope_activate_co (data);
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_variant_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}


static gboolean unity_scope_activate_co (UnityScopeActivateData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	memset (&data->_tmp0_, 0, sizeof (UnityActivationReplyRaw));
	data->_state_ = 1;
	unity_scope_service_activate ((UnityScopeService*) data->self->priv->_pimpl, data->uri, data->action_type, unity_scope_activate_ready, data);
	return FALSE;
	_state_1:
	unity_scope_service_activate_finish ((UnityScopeService*) data->self->priv->_pimpl, data->_res_, &data->_tmp0_, &data->_inner_error_);
	memset (&data->_tmp1_, 0, sizeof (UnityActivationReplyRaw));
	data->_tmp1_ = data->_tmp0_;
	data->reply = data->_tmp1_;
	if (data->_inner_error_ != NULL) {
		goto __catch17_g_error;
	}
	data->result = data->reply;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	unity_activation_reply_raw_destroy (&data->reply);
	goto __finally17;
	__catch17_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		data->_tmp2_ = NULL;
		data->_tmp2_ = string_to_string (data->e->message);
		data->_tmp3_ = NULL;
		data->_tmp3_ = g_strconcat ("Unable to activate scope: ", data->_tmp2_, NULL);
		data->_tmp4_ = data->_tmp3_;
		g_warning ("unity-scope.vala:128: %s", data->_tmp4_);
		_g_free0 (data->_tmp4_);
		_g_error_free0 (data->e);
	}
	__finally17:
	if (data->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	memset (&data->res, 0, sizeof (UnityActivationReplyRaw));
	data->_tmp5_ = g_strdup (data->uri);
	_g_free0 (data->res.uri);
	data->res.uri = data->_tmp5_;
	data->res.handled = (guint) UNITY_HANDLED_TYPE_NOT_HANDLED;
	data->_tmp6_ = NULL;
	data->_tmp6_ = g_hash_table_new_full (NULL, NULL, _g_free0_, _g_variant_unref0_);
	_g_hash_table_unref0 (data->res.hints);
	data->res.hints = data->_tmp6_;
	data->result = data->res;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	unity_activation_reply_raw_destroy (&data->res);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void unity_scope_search_data_free (gpointer _data) {
	UnityScopeSearchData* data;
	data = _data;
	_g_free0 (data->search_string);
	_g_hash_table_unref0 (data->hints);
	_g_object_unref0 (data->self);
	g_slice_free (UnityScopeSearchData, data);
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


void unity_scope_search (UnityScope* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityScopeSearchData* _data_;
	_data_ = g_slice_new0 (UnityScopeSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_scope_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_scope_search_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->search_string = g_strdup (search_string);
	_data_->hints = _g_hash_table_ref0 (hints);
	unity_scope_search_co (_data_);
}


void unity_scope_search_finish (UnityScope* self, GAsyncResult* _res_) {
	UnityScopeSearchData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void unity_scope_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityScopeSearchData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	unity_scope_search_co (data);
}


static gboolean unity_scope_search_co (UnityScopeSearchData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_state_ = 1;
	unity_scope_service_search ((UnityScopeService*) data->self->priv->_pimpl, data->search_string, data->hints, unity_scope_search_ready, data);
	return FALSE;
	_state_1:
	unity_scope_service_search_finish ((UnityScopeService*) data->self->priv->_pimpl, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		goto __catch18_g_error;
	}
	goto __finally18;
	__catch18_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		data->_tmp0_ = NULL;
		data->_tmp0_ = string_to_string (data->e->message);
		data->_tmp1_ = NULL;
		data->_tmp1_ = g_strconcat ("Unable to search scope: ", data->_tmp0_, NULL);
		data->_tmp2_ = data->_tmp1_;
		g_warning ("unity-scope.vala:143: %s", data->_tmp2_);
		_g_free0 (data->_tmp2_);
		_g_error_free0 (data->e);
	}
	__finally18:
	if (data->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void unity_scope_global_search_data_free (gpointer _data) {
	UnityScopeGlobalSearchData* data;
	data = _data;
	_g_free0 (data->search_string);
	_g_hash_table_unref0 (data->hints);
	_g_object_unref0 (data->self);
	g_slice_free (UnityScopeGlobalSearchData, data);
}


void unity_scope_global_search (UnityScope* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityScopeGlobalSearchData* _data_;
	_data_ = g_slice_new0 (UnityScopeGlobalSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_scope_global_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_scope_global_search_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->search_string = g_strdup (search_string);
	_data_->hints = _g_hash_table_ref0 (hints);
	unity_scope_global_search_co (_data_);
}


void unity_scope_global_search_finish (UnityScope* self, GAsyncResult* _res_) {
	UnityScopeGlobalSearchData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void unity_scope_global_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityScopeGlobalSearchData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	unity_scope_global_search_co (data);
}


static gboolean unity_scope_global_search_co (UnityScopeGlobalSearchData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_state_ = 1;
	unity_scope_service_global_search ((UnityScopeService*) data->self->priv->_pimpl, data->search_string, data->hints, unity_scope_global_search_ready, data);
	return FALSE;
	_state_1:
	unity_scope_service_global_search_finish ((UnityScopeService*) data->self->priv->_pimpl, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		goto __catch19_g_error;
	}
	goto __finally19;
	__catch19_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		data->_tmp0_ = NULL;
		data->_tmp0_ = string_to_string (data->e->message);
		data->_tmp1_ = NULL;
		data->_tmp1_ = g_strconcat ("Unable to global search scope: ", data->_tmp0_, NULL);
		data->_tmp2_ = data->_tmp1_;
		g_warning ("unity-scope.vala:153: %s", data->_tmp2_);
		_g_free0 (data->_tmp2_);
		_g_error_free0 (data->e);
	}
	__finally19:
	if (data->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void unity_scope_preview_data_free (gpointer _data) {
	UnityScopePreviewData* data;
	data = _data;
	_g_free0 (data->uri);
	unity_preview_reply_raw_destroy (&data->result);
	_g_object_unref0 (data->self);
	g_slice_free (UnityScopePreviewData, data);
}


void unity_scope_preview (UnityScope* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityScopePreviewData* _data_;
	_data_ = g_slice_new0 (UnityScopePreviewData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_scope_preview);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_scope_preview_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->uri = g_strdup (uri);
	unity_scope_preview_co (_data_);
}


void unity_scope_preview_finish (UnityScope* self, GAsyncResult* _res_, UnityPreviewReplyRaw* result) {
	UnityScopePreviewData* _data_;
	UnityPreviewReplyRaw _tmp0_ = {0};
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	unity_preview_reply_raw_copy (&_data_->result, &_tmp0_);
	*result = _tmp0_;
}


static void unity_scope_preview_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityScopePreviewData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	unity_scope_preview_co (data);
}


static gboolean unity_scope_preview_co (UnityScopePreviewData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	memset (&data->_tmp0_, 0, sizeof (UnityPreviewReplyRaw));
	data->_state_ = 1;
	unity_scope_service_preview ((UnityScopeService*) data->self->priv->_pimpl, data->uri, unity_scope_preview_ready, data);
	return FALSE;
	_state_1:
	unity_scope_service_preview_finish ((UnityScopeService*) data->self->priv->_pimpl, data->_res_, &data->_tmp0_, &data->_inner_error_);
	memset (&data->_tmp1_, 0, sizeof (UnityPreviewReplyRaw));
	data->_tmp1_ = data->_tmp0_;
	data->reply = data->_tmp1_;
	if (data->_inner_error_ != NULL) {
		goto __catch20_g_error;
	}
	data->result = data->reply;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	unity_preview_reply_raw_destroy (&data->reply);
	goto __finally20;
	__catch20_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		data->_tmp2_ = NULL;
		data->_tmp2_ = string_to_string (data->e->message);
		data->_tmp3_ = NULL;
		data->_tmp3_ = g_strconcat ("Unable to preview scope: ", data->_tmp2_, NULL);
		data->_tmp4_ = data->_tmp3_;
		g_warning ("unity-scope.vala:163: %s", data->_tmp4_);
		_g_free0 (data->_tmp4_);
		_g_error_free0 (data->e);
	}
	__finally20:
	if (data->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	memset (&data->_tmp5_, 0, sizeof (UnityPreviewReplyRaw));
	memset (&data->_tmp5_, 0, sizeof (UnityPreviewReplyRaw));
	memset (&data->_tmp6_, 0, sizeof (UnityPreviewReplyRaw));
	data->_tmp6_ = data->_tmp5_;
	data->result = data->_tmp6_;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


gboolean unity_scope_get_active (UnityScope* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_active;
	return result;
}


void unity_scope_set_active (UnityScope* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_active = value;
	g_object_notify ((GObject *) self, "active");
}


gboolean unity_scope_get_exported (UnityScope* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_exported;
	return result;
}


static void unity_scope_set_exported (UnityScope* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_exported = value;
	g_object_notify ((GObject *) self, "exported");
}


gboolean unity_scope_get_search_in_global (UnityScope* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_search_in_global;
	return result;
}


void unity_scope_set_search_in_global (UnityScope* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_search_in_global = value;
	g_object_notify ((GObject *) self, "search-in-global");
}


const gchar* unity_scope_get_dbus_path (UnityScope* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_dbus_path;
	return result;
}


static void unity_scope_set_dbus_path (UnityScope* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_dbus_path);
	self->priv->_dbus_path = _tmp0_;
	g_object_notify ((GObject *) self, "dbus-path");
}


gchar** unity_scope_get_sources (UnityScope* self, int* result_length1) {
	gchar** result;
	gchar** _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_sources;
	if (result_length1) {
		*result_length1 = self->priv->_sources_length1;
	}
	result = _tmp0_;
	return result;
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


void unity_scope_set_sources (UnityScope* self, gchar** value, int value_length1) {
	gchar** _tmp0_;
	gchar** _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (_tmp1_ = value, (_tmp1_ == NULL) ? ((gpointer) _tmp1_) : _vala_array_dup3 (_tmp1_, value_length1));
	self->priv->_sources = (_vala_array_free (self->priv->_sources, self->priv->_sources_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_sources = _tmp0_;
	self->priv->_sources_length1 = value_length1;
	self->priv->__sources_size_ = value_length1;
	g_object_notify ((GObject *) self, "sources");
}


GList* unity_scope_get_filters (UnityScope* self) {
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->_filters;
	return result;
}


DeeSharedModel* unity_scope_get_results_model (UnityScope* self) {
	DeeSharedModel* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_pimpl->_results_model;
	return result;
}


DeeSharedModel* unity_scope_get_global_results_model (UnityScope* self) {
	DeeSharedModel* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_pimpl->_global_results_model;
	return result;
}


UnityLensSearch* unity_scope_get_active_search (UnityScope* self) {
	UnityLensSearch* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_active_search;
	return result;
}


void unity_scope_set_active_search (UnityScope* self, UnityLensSearch* value) {
	UnityLensSearch* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_active_search);
	self->priv->_active_search = _tmp0_;
	g_object_notify ((GObject *) self, "active-search");
}


UnityLensSearch* unity_scope_get_active_global_search (UnityScope* self) {
	UnityLensSearch* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_active_global_search;
	return result;
}


void unity_scope_set_active_global_search (UnityScope* self, UnityLensSearch* value) {
	UnityLensSearch* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_active_global_search);
	self->priv->_active_global_search = _tmp0_;
	g_object_notify ((GObject *) self, "active-global-search");
}


gchar** unity_scope_get_active_sources (UnityScope* self, int* result_length1) {
	gchar** result;
	gchar** _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_active_sources;
	if (result_length1) {
		*result_length1 = self->priv->_active_sources_length1;
	}
	result = _tmp0_;
	return result;
}


static gchar** _vala_array_dup4 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static void unity_scope_set_active_sources (UnityScope* self, gchar** value, int value_length1) {
	gchar** _tmp0_;
	gchar** _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (_tmp1_ = value, (_tmp1_ == NULL) ? ((gpointer) _tmp1_) : _vala_array_dup4 (_tmp1_, value_length1));
	self->priv->_active_sources = (_vala_array_free (self->priv->_active_sources, self->priv->_active_sources_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_active_sources = _tmp0_;
	self->priv->_active_sources_length1 = value_length1;
	self->priv->__active_sources_size_ = value_length1;
	g_object_notify ((GObject *) self, "active-sources");
}


static void g_cclosure_user_marshal_OBJECT__STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gpointer (*GMarshalFunc_OBJECT__STRING) (gpointer data1, const char* arg_1, gpointer data2);
	register GMarshalFunc_OBJECT__STRING callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	gpointer v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_OBJECT__STRING) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, g_value_get_string (param_values + 1), data2);
	g_value_take_object (return_value, v_return);
}


static void g_cclosure_user_marshal_VOID__STRING_BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_BOXED) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_BOXED callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_BOXED) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_boxed (param_values + 2), data2);
}


static void _lambda3_ (const gchar* s, GHashTable* h, UnityScope* self) {
	g_return_if_fail (s != NULL);
	g_return_if_fail (h != NULL);
	g_signal_emit_by_name (self, "search-finished", s, h);
}


static void __lambda3__unity_scope_service_search_finished (UnityScopeService* _sender, const gchar* search_string, GHashTable* hints, gpointer self) {
	_lambda3_ (search_string, hints, self);
}


static void _lambda4_ (const gchar* s, GHashTable* h, UnityScope* self) {
	g_return_if_fail (s != NULL);
	g_return_if_fail (h != NULL);
	g_signal_emit_by_name (self, "global-search-finished", s, h);
}


static void __lambda4__unity_scope_service_global_search_finished (UnityScopeService* _sender, const gchar* search_string, GHashTable* hints, gpointer self) {
	_lambda4_ (search_string, hints, self);
}


static GObject * unity_scope_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityScope * self;
	UnityScopeImpl* _tmp0_ = NULL;
	parent_class = G_OBJECT_CLASS (unity_scope_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_SCOPE (obj);
	_tmp0_ = unity_scope_impl_new (self);
	_g_object_unref0 (self->priv->_pimpl);
	self->priv->_pimpl = _tmp0_;
	g_signal_connect_object ((UnityScopeService*) self->priv->_pimpl, "search-finished", (GCallback) __lambda3__unity_scope_service_search_finished, self, 0);
	g_signal_connect_object ((UnityScopeService*) self->priv->_pimpl, "global-search-finished", (GCallback) __lambda4__unity_scope_service_global_search_finished, self, 0);
	return obj;
}


static void unity_scope_class_init (UnityScopeClass * klass) {
	unity_scope_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityScopePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_unity_scope_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_unity_scope_set_property;
	G_OBJECT_CLASS (klass)->constructor = unity_scope_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_scope_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_SCOPE_ACTIVE, g_param_spec_boolean ("active", "active", "active", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_SCOPE_EXPORTED, g_param_spec_boolean ("exported", "exported", "exported", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_SCOPE_SEARCH_IN_GLOBAL, g_param_spec_boolean ("search-in-global", "search-in-global", "search-in-global", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_SCOPE_DBUS_PATH, g_param_spec_string ("dbus-path", "dbus-path", "dbus-path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_SCOPE_SOURCES, g_param_spec_boxed ("sources", "sources", "sources", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_SCOPE_FILTERS, g_param_spec_pointer ("filters", "filters", "filters", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_SCOPE_RESULTS_MODEL, g_param_spec_object ("results-model", "results-model", "results-model", DEE_TYPE_SHARED_MODEL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_SCOPE_GLOBAL_RESULTS_MODEL, g_param_spec_object ("global-results-model", "global-results-model", "global-results-model", DEE_TYPE_SHARED_MODEL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_SCOPE_ACTIVE_SEARCH, g_param_spec_object ("active-search", "active-search", "active-search", UNITY_TYPE_LENS_SEARCH, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_SCOPE_ACTIVE_GLOBAL_SEARCH, g_param_spec_object ("active-global-search", "active-global-search", "active-global-search", UNITY_TYPE_LENS_SEARCH, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_SCOPE_ACTIVE_SOURCES, g_param_spec_boxed ("active-sources", "active-sources", "active-sources", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("activate_uri", UNITY_TYPE_SCOPE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_OBJECT__STRING, UNITY_TYPE_ACTIVATION_RESPONSE, 1, G_TYPE_STRING);
	g_signal_new ("preview_uri", UNITY_TYPE_SCOPE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_OBJECT__STRING, UNITY_TYPE_PREVIEW, 1, G_TYPE_STRING);
	g_signal_new ("filters_changed", UNITY_TYPE_SCOPE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("search_finished", UNITY_TYPE_SCOPE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOXED, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_HASH_TABLE);
	g_signal_new ("global_search_finished", UNITY_TYPE_SCOPE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOXED, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_HASH_TABLE);
}


static void unity_scope_instance_init (UnityScope * self) {
	self->priv = UNITY_SCOPE_GET_PRIVATE (self);
	self->priv->_active = FALSE;
	self->priv->_exported = FALSE;
	self->priv->_search_in_global = TRUE;
	self->priv->is_local = FALSE;
	self->_filters = NULL;
}


static void unity_scope_finalize (GObject* obj) {
	UnityScope * self;
	self = UNITY_SCOPE (obj);
	_g_free0 (self->priv->_dbus_path);
	self->priv->_sources = (_vala_array_free (self->priv->_sources, self->priv->_sources_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (self->priv->_active_search);
	_g_object_unref0 (self->priv->_active_global_search);
	self->priv->_active_sources = (_vala_array_free (self->priv->_active_sources, self->priv->_active_sources_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (self->priv->_pimpl);
	__g_list_free__g_object_unref0_0 (self->_filters);
	G_OBJECT_CLASS (unity_scope_parent_class)->finalize (obj);
}


GType unity_scope_get_type (void) {
	static volatile gsize unity_scope_type_id__volatile = 0;
	if (g_once_init_enter (&unity_scope_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityScopeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_scope_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityScope), 0, (GInstanceInitFunc) unity_scope_instance_init, NULL };
		GType unity_scope_type_id;
		unity_scope_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityScope", &g_define_type_info, 0);
		g_once_init_leave (&unity_scope_type_id__volatile, unity_scope_type_id);
	}
	return unity_scope_type_id__volatile;
}


static void _vala_unity_scope_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityScope * self;
	int length;
	self = UNITY_SCOPE (object);
	switch (property_id) {
		case UNITY_SCOPE_ACTIVE:
		g_value_set_boolean (value, unity_scope_get_active (self));
		break;
		case UNITY_SCOPE_EXPORTED:
		g_value_set_boolean (value, unity_scope_get_exported (self));
		break;
		case UNITY_SCOPE_SEARCH_IN_GLOBAL:
		g_value_set_boolean (value, unity_scope_get_search_in_global (self));
		break;
		case UNITY_SCOPE_DBUS_PATH:
		g_value_set_string (value, unity_scope_get_dbus_path (self));
		break;
		case UNITY_SCOPE_SOURCES:
		g_value_set_boxed (value, unity_scope_get_sources (self, &length));
		break;
		case UNITY_SCOPE_FILTERS:
		g_value_set_pointer (value, unity_scope_get_filters (self));
		break;
		case UNITY_SCOPE_RESULTS_MODEL:
		g_value_set_object (value, unity_scope_get_results_model (self));
		break;
		case UNITY_SCOPE_GLOBAL_RESULTS_MODEL:
		g_value_set_object (value, unity_scope_get_global_results_model (self));
		break;
		case UNITY_SCOPE_ACTIVE_SEARCH:
		g_value_set_object (value, unity_scope_get_active_search (self));
		break;
		case UNITY_SCOPE_ACTIVE_GLOBAL_SEARCH:
		g_value_set_object (value, unity_scope_get_active_global_search (self));
		break;
		case UNITY_SCOPE_ACTIVE_SOURCES:
		g_value_set_boxed (value, unity_scope_get_active_sources (self, &length));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_unity_scope_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityScope * self;
	gpointer boxed;
	self = UNITY_SCOPE (object);
	switch (property_id) {
		case UNITY_SCOPE_ACTIVE:
		unity_scope_set_active (self, g_value_get_boolean (value));
		break;
		case UNITY_SCOPE_EXPORTED:
		unity_scope_set_exported (self, g_value_get_boolean (value));
		break;
		case UNITY_SCOPE_SEARCH_IN_GLOBAL:
		unity_scope_set_search_in_global (self, g_value_get_boolean (value));
		break;
		case UNITY_SCOPE_DBUS_PATH:
		unity_scope_set_dbus_path (self, g_value_get_string (value));
		break;
		case UNITY_SCOPE_SOURCES:
		boxed = g_value_get_boxed (value);
		unity_scope_set_sources (self, boxed, g_strv_length (boxed));
		break;
		case UNITY_SCOPE_ACTIVE_SEARCH:
		unity_scope_set_active_search (self, g_value_get_object (value));
		break;
		case UNITY_SCOPE_ACTIVE_GLOBAL_SEARCH:
		unity_scope_set_active_global_search (self, g_value_get_object (value));
		break;
		case UNITY_SCOPE_ACTIVE_SOURCES:
		boxed = g_value_get_boxed (value);
		unity_scope_set_active_sources (self, boxed, g_strv_length (boxed));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



