/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SAXTest
implements ContentHandler,
ErrorHandler {
    public static void main(String[] stringArray) {
        System.out.println("************************************************************************");
        System.out.println("* Testing SAX2");
        System.out.println("************************************************************************");
        System.out.print("\n");
        String string = System.getProperty("org.xml.sax.driver", "org.apache.xerces.parsers.SAXParser");
        System.out.println("SAX driver class: " + string + "\n  (you can specify a different one using the " + "org.xml.sax.driver property)");
        System.out.print("\n");
        System.out.println("Now, we'll try to create an instance of the driver, using XMLReaderFactory");
        XMLReader xMLReader = null;
        try {
            xMLReader = XMLReaderFactory.createXMLReader(string);
        }
        catch (SAXException sAXException) {
            System.out.println("Failed to create XMLReader: " + sAXException.getMessage() + "\nMake sure that the class actually " + "exists and is present on your CLASSPATH" + "\nor specify a different class using the " + "org.xml.sax.driver property");
            System.exit(1);
        }
        System.out.println("XMLReader created successfully\n");
        System.out.println("Checking defaults for some well-known features:");
        SAXTest.checkFeature(xMLReader, "http://xml.org/sax/features/namespaces");
        SAXTest.checkFeature(xMLReader, "http://xml.org/sax/features/namespace-prefixes");
        SAXTest.checkFeature(xMLReader, "http://xml.org/sax/features/string-interning");
        SAXTest.checkFeature(xMLReader, "http://xml.org/sax/features/validation");
        SAXTest.checkFeature(xMLReader, "http://xml.org/sax/features/external-general-entities");
        SAXTest.checkFeature(xMLReader, "http://xml.org/sax/features/external-parameter-entities");
        System.out.print("\n");
        System.out.println("Creating and assigning handlers\n");
        SAXTest sAXTest = new SAXTest();
        xMLReader.setContentHandler(sAXTest);
        xMLReader.setErrorHandler(sAXTest);
        if (stringArray.length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                String string2 = SAXTest.makeAbsoluteURL(stringArray[n]);
                System.out.println("Trying file " + string2);
                try {
                    xMLReader.parse(string2);
                }
                catch (SAXException sAXException) {
                    System.out.println(string2 + " failed with XML error: " + sAXException.getMessage());
                }
                catch (IOException iOException) {
                    System.out.println(string2 + " failed with I/O error: " + iOException.getMessage());
                }
                System.out.print("\n");
                ++n;
            }
        } else {
            System.out.println("No documents supplied on command line; parsing skipped.");
        }
        System.out.println("SAX2 test finished.");
    }

    private static void checkFeature(XMLReader xMLReader, String string) {
        try {
            System.out.println("  " + string + " = " + xMLReader.getFeature(string));
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            System.out.println("XMLReader does not recognize feature " + string);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            System.out.println("XMLReader recognizes feature " + string + " but does not support checking its value");
        }
    }

    private static String makeAbsoluteURL(String string) {
        String string2;
        String string3 = System.getProperty("user.dir");
        String string4 = string3.replace((string2 = System.getProperty("file.separator")).charAt(0), '/') + '/';
        if (string4.charAt(0) != '/') {
            string4 = "/" + string4;
        }
        try {
            URL uRL = new URL("file", null, string4);
            return new URL(uRL, string).toString();
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println(string + ": " + malformedURLException.getMessage());
            return string;
        }
    }

    private static String makeNSName(String string, String string2, String string3) {
        if (string.equals("")) {
            string = "[none]";
        }
        if (string2.equals("")) {
            string2 = "[none]";
        }
        if (string3.equals("")) {
            string3 = "[none]";
        }
        return string + '/' + string2 + '/' + string3;
    }

    private static String escapeData(char[] cArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n;
        while (n3 < n + n2) {
            switch (cArray[n3]) {
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    break;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                default: {
                    stringBuffer.append(cArray[n3]);
                }
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    public void setDocumentLocator(Locator locator) {
        System.out.println("  EVENT: setDocumentLocator");
    }

    public void startDocument() throws SAXException {
        System.out.println("  EVENT: startDocument");
    }

    public void endDocument() throws SAXException {
        System.out.println("  EVENT: endDocument");
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        System.out.println("  EVENT: startPrefixMapping " + string + " = " + string2);
    }

    public void endPrefixMapping(String string) throws SAXException {
        System.out.println("  EVENT: endPrefixMapping " + string);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        System.out.println("  EVENT: startElement " + SAXTest.makeNSName(string, string2, string3));
        int n = attributes.getLength();
        int n2 = 0;
        while (n2 < n) {
            char[] cArray = attributes.getValue(n2).toCharArray();
            System.out.println("    Attribute " + SAXTest.makeNSName(attributes.getURI(n2), attributes.getLocalName(n2), attributes.getQName(n2)) + '=' + SAXTest.escapeData(cArray, 0, cArray.length));
            ++n2;
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        System.out.println("  EVENT: endElement " + SAXTest.makeNSName(string, string2, string3));
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        System.out.println("  EVENT: characters " + SAXTest.escapeData(cArray, n, n2));
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        System.out.println("  EVENT: ignorableWhitespace " + SAXTest.escapeData(cArray, n, n2));
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        System.out.println("  EVENT: processingInstruction " + string + ' ' + string2);
    }

    public void skippedEntity(String string) throws SAXException {
        System.out.println("  EVENT: skippedEntity " + string);
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        System.out.println("  EVENT: warning " + sAXParseException.getMessage() + ' ' + sAXParseException.getSystemId() + ' ' + sAXParseException.getLineNumber() + ' ' + sAXParseException.getColumnNumber());
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        System.out.println("  EVENT: error " + sAXParseException.getMessage() + ' ' + sAXParseException.getSystemId() + ' ' + sAXParseException.getLineNumber() + ' ' + sAXParseException.getColumnNumber());
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        System.out.println("  EVENT: fatal error " + sAXParseException.getMessage() + ' ' + sAXParseException.getSystemId() + ' ' + sAXParseException.getLineNumber() + ' ' + sAXParseException.getColumnNumber());
    }
}

