/* Copyright 2014 Canonical Ltd.  This software is licensed under the
 * GNU Affero General Public License version 3 (see the file LICENSE).
 *
 * License key viewable utilities.
 *
 * @module Y.maas.license_key
 */

YUI.add('maas.license_key', function(Y) {

Y.log('loading maas.license_key');
var module = Y.namespace('maas.license_key');

// Only used to mockup io in tests.
module._io = new Y.IO();

var LicenseKeyWidget;

/**
 * A widget class used hide or show the license key field for a node's
 * selected operating system.
 *
 */
LicenseKeyWidget = function() {
    LicenseKeyWidget.superclass.constructor.apply(this, arguments);
};

LicenseKeyWidget.NAME = 'license-key-widget';

Y.extend(LicenseKeyWidget, Y.Widget, {

   /**
    * Initialize the widget.
    * - cfg.srcNode is the node which will be updated when the selected
    *   value of the 'release node' will change.
    * - cfg.releaseNode is the node containing a 'select' element.  When
    *   the selected element will change, the srcNode HTML will be
    *   updated.
    *
    * @method initializer
    */
    initializer: function(cfg) {
    },

   /**
    * Bind the widget to events (to name 'event_name') generated by the given
    * 'releaseNode'.
    *
    * @method bindTo
    */
    bindTo: function(releaseNode, event_name) {
        var self = this;
        Y.one(releaseNode).on(event_name, function(e) {
            var releaseValue = e.currentTarget.get('value');
            self.update(releaseValue);
        });
        var releaseValue = Y.one(releaseNode).get('value');
        self.update(releaseValue);
    },

   /**
    * React to a new value of the release node: update the HTML of
    * 'srcNode'.
    *
    * @method update
    */
    update: function(newReleaseValue) {
        var srcNode = this.get('srcNode');
        // Values that do not contain an astrick do not
        // require the license_key field.
        if(newReleaseValue.indexOf('*') === -1) {
            srcNode.addClass('hidden');
        }
        else {
            srcNode.removeClass('hidden');
        }
    }
});

module.LicenseKeyWidget = LicenseKeyWidget;

}, '0.1', {'requires': ['widget', 'io']}
);
