/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.ArrowTip;
import CH.ifa.draw.figures.PolyLineFigure;
import CH.ifa.draw.figures.PolyLineHandle;
import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.standard.AbstractHandle;
import CH.ifa.draw.standard.ChangeConnectionEndHandle;
import CH.ifa.draw.standard.ChangeConnectionStartHandle;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Point;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Vector;

public class LineConnection
extends PolyLineFigure
implements ConnectionFigure {
    protected Connector fStart = null;
    protected Connector fEnd = null;
    private static final long serialVersionUID = 6883731614578414801L;
    private int lineConnectionSerializedDataVersion = 1;

    public LineConnection() {
        super(4);
        this.setStartDecoration(new ArrowTip());
        this.setEndDecoration(new ArrowTip());
    }

    public boolean canConnect() {
        return false;
    }

    protected void basicMoveBy(int n, int n2) {
        for (int i = 1; i < this.fPoints.size() - 1; ++i) {
            ((Point)this.fPoints.elementAt(i)).translate(n, n2);
        }
        this.updateConnection();
    }

    public void connectStart(Connector connector) {
        this.fStart = connector;
        this.startFigure().addFigureChangeListener(this);
    }

    public void connectEnd(Connector connector) {
        this.fEnd = connector;
        this.endFigure().addFigureChangeListener(this);
        this.handleConnect(this.startFigure(), this.endFigure());
    }

    public void disconnectStart() {
        this.startFigure().removeFigureChangeListener(this);
        this.fStart = null;
    }

    public void disconnectEnd() {
        this.handleDisconnect(this.startFigure(), this.endFigure());
        this.endFigure().removeFigureChangeListener(this);
        this.fEnd = null;
    }

    public boolean connectsSame(ConnectionFigure connectionFigure) {
        return connectionFigure.start() == this.start() && connectionFigure.end() == this.end();
    }

    protected void handleDisconnect(Figure figure, Figure figure2) {
    }

    protected void handleConnect(Figure figure, Figure figure2) {
    }

    public Figure startFigure() {
        if (this.start() != null) {
            return this.start().owner();
        }
        return null;
    }

    public Figure endFigure() {
        if (this.end() != null) {
            return this.end().owner();
        }
        return null;
    }

    public Connector start() {
        return this.fStart;
    }

    public Connector end() {
        return this.fEnd;
    }

    public boolean canConnect(Figure figure, Figure figure2) {
        return true;
    }

    public void startPoint(int n, int n2) {
        this.willChange();
        if (this.fPoints.size() == 0) {
            this.fPoints.addElement(new Point(n, n2));
        } else {
            this.fPoints.setElementAt(new Point(n, n2), 0);
        }
        this.changed();
    }

    public void endPoint(int n, int n2) {
        this.willChange();
        if (this.fPoints.size() < 2) {
            this.fPoints.addElement(new Point(n, n2));
        } else {
            this.fPoints.setElementAt(new Point(n, n2), this.fPoints.size() - 1);
        }
        this.changed();
    }

    public Point startPoint() {
        Point point = (Point)this.fPoints.firstElement();
        return new Point(point.x, point.y);
    }

    public Point endPoint() {
        Point point = (Point)this.fPoints.lastElement();
        return new Point(point.x, point.y);
    }

    public Vector handles() {
        Vector<AbstractHandle> vector = new Vector<AbstractHandle>(this.fPoints.size());
        vector.addElement(new ChangeConnectionStartHandle(this));
        for (int i = 1; i < this.fPoints.size() - 1; ++i) {
            vector.addElement(new PolyLineHandle(this, PolyLineFigure.locator(i), i));
        }
        vector.addElement(new ChangeConnectionEndHandle(this));
        return vector;
    }

    public void setPointAt(Point point, int n) {
        super.setPointAt(point, n);
        this.layoutConnection();
    }

    public void insertPointAt(Point point, int n) {
        super.insertPointAt(point, n);
        this.layoutConnection();
    }

    public void removePointAt(int n) {
        super.removePointAt(n);
        this.layoutConnection();
    }

    public void updateConnection() {
        Point point;
        if (this.fStart != null) {
            point = this.fStart.findStart(this);
            this.startPoint(point.x, point.y);
        }
        if (this.fEnd != null) {
            point = this.fEnd.findEnd(this);
            this.endPoint(point.x, point.y);
        }
    }

    public void layoutConnection() {
        this.updateConnection();
    }

    public void figureChanged(FigureChangeEvent figureChangeEvent) {
        this.updateConnection();
    }

    public void figureRemoved(FigureChangeEvent figureChangeEvent) {
        if (this.listener() != null) {
            this.listener().figureRequestRemove(new FigureChangeEvent(this));
        }
    }

    public void figureRequestRemove(FigureChangeEvent figureChangeEvent) {
    }

    public void figureInvalidated(FigureChangeEvent figureChangeEvent) {
    }

    public void figureRequestUpdate(FigureChangeEvent figureChangeEvent) {
    }

    public void release() {
        super.release();
        this.handleDisconnect(this.startFigure(), this.endFigure());
        if (this.fStart != null) {
            this.startFigure().removeFigureChangeListener(this);
        }
        if (this.fEnd != null) {
            this.endFigure().removeFigureChangeListener(this);
        }
    }

    public void write(StorableOutput storableOutput) {
        super.write(storableOutput);
        storableOutput.writeStorable(this.fStart);
        storableOutput.writeStorable(this.fEnd);
    }

    public void read(StorableInput storableInput) throws IOException {
        Connector connector;
        super.read(storableInput);
        Connector connector2 = (Connector)storableInput.readStorable();
        if (connector2 != null) {
            this.connectStart(connector2);
        }
        if ((connector = (Connector)storableInput.readStorable()) != null) {
            this.connectEnd(connector);
        }
        if (connector2 != null && connector != null) {
            this.updateConnection();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        if (this.fStart != null) {
            this.connectStart(this.fStart);
        }
        if (this.fEnd != null) {
            this.connectEnd(this.fEnd);
        }
    }
}

