/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.text.JTextComponent;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.util.ResourceBundleUtil;

public class AttributeToggler<T>
extends AbstractAction {
    private DrawingEditor editor;
    private AttributeKey<T> key;
    private T value1;
    private T value2;
    private Action compatibleTextAction;

    public AttributeToggler(DrawingEditor drawingEditor, AttributeKey<T> attributeKey, T t, T t2) {
        this(drawingEditor, attributeKey, t, t2, null);
    }

    public AttributeToggler(DrawingEditor drawingEditor, AttributeKey<T> attributeKey, T t, T t2, Action action) {
        this.editor = drawingEditor;
        this.key = attributeKey;
        this.value1 = t;
        this.value2 = t2;
        this.compatibleTextAction = action;
    }

    public DrawingView getView() {
        return this.editor.getActiveView();
    }

    public DrawingEditor getEditor() {
        return this.editor;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        Object object2;
        Object object3;
        if (this.compatibleTextAction != null && (object3 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner()) != null && object3 instanceof JTextComponent) {
            this.compatibleTextAction.actionPerformed(actionEvent);
            return;
        }
        object3 = this.getView().getSelectedFigures().iterator();
        T t = this.value1;
        if (object3.hasNext()) {
            object2 = (Figure)object3.next();
            object = object2.get(this.key);
            if (this.value1 == null && object == null || this.value1 != null && object != null && object.equals(this.value1)) {
                t = this.value2;
            }
        }
        object2 = t;
        object = new ArrayList<Figure>(this.getView().getSelectedFigures());
        final ArrayList<Object> arrayList = new ArrayList<Object>(((ArrayList)object).size());
        Object object4 = ((ArrayList)object).iterator();
        while (object4.hasNext()) {
            Figure figure = (Figure)object4.next();
            arrayList.add(figure.getAttributesRestoreData());
            figure.willChange();
            figure.set(this.key, object2);
            figure.changed();
        }
        object4 = new AbstractUndoableEdit((ArrayList)object, object2){
            final /* synthetic */ ArrayList val$selectedFigures;
            final /* synthetic */ Object val$newValue;
            {
                this.val$selectedFigures = arrayList2;
                this.val$newValue = object;
            }

            @Override
            public String getPresentationName() {
                String string = (String)AttributeToggler.this.getValue("undoPresentationName");
                if (string == null) {
                    string = (String)AttributeToggler.this.getValue("Name");
                }
                if (string == null) {
                    ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
                    string = resourceBundleUtil.getString("attribute.text");
                }
                return string;
            }

            @Override
            public void undo() {
                super.undo();
                Iterator iterator = arrayList.iterator();
                for (Figure figure : this.val$selectedFigures) {
                    figure.willChange();
                    figure.restoreAttributesTo(iterator.next());
                    figure.changed();
                }
            }

            @Override
            public void redo() {
                super.redo();
                for (Figure figure : this.val$selectedFigures) {
                    arrayList.add(figure.getAttributesRestoreData());
                    figure.willChange();
                    figure.set(AttributeToggler.this.key, this.val$newValue);
                    figure.changed();
                }
            }
        };
        this.getView().getDrawing().fireUndoableEditHappened((UndoableEdit)object4);
    }
}

