# -*- mode: Perl -*-

# Copyright (c) 2007-2008 Fabien Tassin <fta@sofaraway.org>
# Description: MozClient::Subversion
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2, or (at
# your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

############################################################################

package MozClient::Subversion;

use vars qw(@ISA);
use strict;
use MozClient::VCS;

@ISA = ("MozClient::VCS");

sub get_client {
  my $self = shift;

  $self->LOG("MozClient::Subversion::get_client()");
  # nothing to do
}

sub convert_revdate {
  my $self = shift;
  my $arg = shift;

  $self->LOG("MozClient::Subversion::convert_revdate($arg)");
  $arg =~ s,.*r(\d+),$1,;
  $arg;
}

sub set_revdate {
  my $self = shift;

  $self->LOG("MozClient::Subversion::set_revdate()");

  # We can set a revision for svn
  $self->{'mozclient_date'} =
    '-r ' . $self->convert_revdate($self->{'have_date'});
}

sub set_tag {
  my $self = shift;
  my $tag  = shift;

  $self->LOG("MozClient::Subversion::set_tag()");

  # For svn, a tag is just a snapshot
  $self->{'MOZCLIENT_PROJECT'} =~ s,/[^/]*$,/tags/$tag,;
  $self->{'co_tag'} = $tag;
}

sub checkout {
  my $self = shift;

  $self->LOG("MozClient::Subversion::checkout:()");

  $self->chdir($self->work_dir);
  my $modules = [];
  $self->{'MOZCLIENT_VCS_LOC'} .= "/" unless $self->{'MOZCLIENT_VCS_LOC'} =~ m,/$,;
  if (defined $self->{'MOZCLIENT_PROJECT'}) {
    push @$modules,
      $self->{'MOZCLIENT_VCS_LOC'} . $self->{'MOZCLIENT_PROJECT'} . "/";
  }
  else {
    for my $module (@{$self->{'MOZCLIENT_MODULES'}}) {
      push @$modules, (sprintf " %s%s/%s", $self->{'MOZCLIENT_VCS_LOC'},
	$self->{'MOZCLIENT_PROJECT'}, $module);
    }
  }
  my $out = length $self->{'co_tag'} > 0 ? $self->{'co_tag'} : "trunk";
  my $cmd = sprintf "svn checkout %s %s $out", $self->{'mozclient_date'},
    join " ", @$modules;
  $self->run_system($cmd);
  # We drop the 1st directory if there's a mozilla dir inside
  if (-d "$out/" . $self->{'MOZCLIENT_MOZDIRNAME'}) {
    $self->run_shell("mv $out/* $out/.svn .");
    $self->run_system("rm -rf $out");
  }
  else {
    # we name it mozilla as it is what is expected later on
    $self->run_system("mv $out  " . $self->{'MOZCLIENT_MOZDIRNAME'});
  }
  $self->chdir("..");
}

sub tar_exclude {
  my $self = shift;

  $self->LOG("MozClient::Subversion::tar_exclude()");
  [ '--exclude .svn' ];
}

1;
