/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import com.sun.java.accessibility.Accessible;
import com.sun.java.accessibility.AccessibleAction;
import com.sun.java.accessibility.AccessibleComponent;
import com.sun.java.accessibility.AccessibleContext;
import com.sun.java.accessibility.AccessibleRole;
import com.sun.java.accessibility.AccessibleSelection;
import com.sun.java.accessibility.AccessibleState;
import com.sun.java.accessibility.AccessibleStateSet;
import com.sun.java.accessibility.AccessibleText;
import com.sun.java.accessibility.AccessibleValue;
import com.sun.java.swing.AbstractListModel;
import com.sun.java.swing.ComboBoxEditor;
import com.sun.java.swing.ComboBoxModel;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.ListCellRenderer;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.event.AncestorEvent;
import com.sun.java.swing.event.AncestorListener;
import com.sun.java.swing.event.ListDataEvent;
import com.sun.java.swing.event.ListDataListener;
import com.sun.java.swing.plaf.ComboBoxUI;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Locale;
import java.util.Vector;

public class JComboBox
extends JComponent
implements ItemSelectable,
ListDataListener,
ActionListener,
Accessible {
    protected ComboBoxModel dataModel;
    protected ListCellRenderer renderer;
    protected ComboBoxEditor editor;
    protected int maximumRowCount = 8;
    protected boolean isEditable = false;
    protected Object selectedItemReminder;
    protected KeySelectionManager keySelectionManager;
    protected String actionCommand = "comboBoxChanged";
    protected boolean lightWeightPopupEnabled = true;
    static /* synthetic */ Class class$java$awt$event$ItemListener;
    static /* synthetic */ Class class$java$awt$event$ActionListener;

    public JComboBox(ComboBoxModel comboBoxModel) {
        this.setModel(comboBoxModel);
        this.installAncestorListener();
        this.updateUI();
    }

    public JComboBox(Object[] objectArray) {
        this.setModel(new DefaultComboBoxModel(objectArray));
        this.installAncestorListener();
        this.updateUI();
    }

    public JComboBox(Vector vector) {
        this.setModel(new DefaultComboBoxModel(vector));
        this.installAncestorListener();
        this.updateUI();
    }

    public JComboBox() {
        this.setModel(new DefaultComboBoxModel());
        this.installAncestorListener();
        this.updateUI();
    }

    protected void installAncestorListener() {
        this.addAncestorListener(new 1());
    }

    public void setUI(ComboBoxUI comboBoxUI) {
        super.setUI(comboBoxUI);
    }

    public void updateUI() {
        this.setUI((ComboBoxUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "ComboBoxUI";
    }

    public ComboBoxUI getUI() {
        return (ComboBoxUI)this.ui;
    }

    public void setModel(ComboBoxModel comboBoxModel) {
        ComboBoxModel comboBoxModel2 = this.dataModel;
        if (this.dataModel != null) {
            this.dataModel.removeListDataListener(this);
        }
        this.dataModel = comboBoxModel;
        this.firePropertyChange("model", comboBoxModel2, this.dataModel);
        this.dataModel.addListDataListener(this);
        this.invalidate();
    }

    public ComboBoxModel getModel() {
        return this.dataModel;
    }

    public void setLightWeightPopupEnabled(boolean bl) {
        this.lightWeightPopupEnabled = bl;
    }

    public boolean isLightWeightPopupEnabled() {
        return this.lightWeightPopupEnabled;
    }

    public void setEditable(boolean bl) {
        boolean bl2 = bl != this.isEditable;
        this.isEditable = bl;
        if (bl2) {
            this.firePropertyChange("editable", !this.isEditable, this.isEditable);
        }
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void setMaximumRowCount(int n) {
        int n2 = this.maximumRowCount;
        this.maximumRowCount = n;
        this.firePropertyChange("maximumRowCount", n2, this.maximumRowCount);
    }

    public int getMaximumRowCount() {
        return this.maximumRowCount;
    }

    public void setRenderer(ListCellRenderer listCellRenderer) {
        ListCellRenderer listCellRenderer2 = this.renderer;
        this.renderer = listCellRenderer;
        this.firePropertyChange("renderer", listCellRenderer2, this.renderer);
        this.invalidate();
    }

    public ListCellRenderer getRenderer() {
        return this.renderer;
    }

    public void setEditor(ComboBoxEditor comboBoxEditor) {
        ComboBoxEditor comboBoxEditor2 = this.editor;
        if (this.editor != null) {
            this.editor.removeActionListener(this);
        }
        this.editor = comboBoxEditor;
        if (this.editor != null) {
            this.editor.addActionListener(this);
        }
        this.firePropertyChange("editor", comboBoxEditor2, this.editor);
    }

    public ComboBoxEditor getEditor() {
        return this.editor;
    }

    public void setSelectedItem(Object object) {
        this.dataModel.setSelectedItem(object);
    }

    public Object getSelectedItem() {
        return this.dataModel.getSelectedItem();
    }

    public void setSelectedIndex(int n) {
        int n2 = this.dataModel.getSize();
        if (n < 0 || n >= n2) {
            throw new IllegalArgumentException("setSelectedIndex: " + n + " out of bounds");
        }
        this.setSelectedItem(this.dataModel.getElementAt(n));
    }

    public int getSelectedIndex() {
        Object object = this.dataModel.getSelectedItem();
        int n = 0;
        int n2 = this.dataModel.getSize();
        while (n < n2) {
            Object object2 = this.dataModel.getElementAt(n);
            if (object2.equals(object)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void addItem(Object object) {
        this.checkDefaultComboBoxModel();
        ((DefaultComboBoxModel)this.dataModel).addObject(object);
    }

    public void insertItemAt(Object object, int n) {
        this.checkDefaultComboBoxModel();
        ((DefaultComboBoxModel)this.dataModel).insertObjectAt(object, n);
    }

    public void removeItem(Object object) {
        this.checkDefaultComboBoxModel();
        int n = ((DefaultComboBoxModel)this.dataModel).getIndexOf(object);
        ((DefaultComboBoxModel)this.dataModel).removeObject(object);
        if (!this.isEditable() && this.dataModel.getSize() > 0 && n < this.dataModel.getSize()) {
            this.setSelectedIndex(n);
        }
    }

    public void removeItemAt(int n) {
        this.checkDefaultComboBoxModel();
        ((DefaultComboBoxModel)this.dataModel).removeObjectAt(n);
    }

    public void removeAllItems() {
        this.checkDefaultComboBoxModel();
        ((DefaultComboBoxModel)this.dataModel).removeAllObjects();
        if (!this.isEditable()) {
            this.setSelectedItem(null);
        }
    }

    void checkDefaultComboBoxModel() {
        if (!(this.dataModel instanceof DefaultComboBoxModel)) {
            throw new InternalError("Cannot use this method with a custom data model.");
        }
    }

    public void showPopup() {
        this.getUI().showPopup();
    }

    public void hidePopup() {
        this.getUI().hidePopup();
    }

    public void addItemListener(ItemListener itemListener) {
        this.listenerList.add(class$java$awt$event$ItemListener != null ? class$java$awt$event$ItemListener : (class$java$awt$event$ItemListener = JComponent.class$("java.awt.event.ItemListener")), itemListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.listenerList.remove(class$java$awt$event$ItemListener != null ? class$java$awt$event$ItemListener : (class$java$awt$event$ItemListener = JComponent.class$("java.awt.event.ItemListener")), itemListener);
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(class$java$awt$event$ActionListener != null ? class$java$awt$event$ActionListener : (class$java$awt$event$ActionListener = JComponent.class$("java.awt.event.ActionListener")), actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(class$java$awt$event$ActionListener != null ? class$java$awt$event$ActionListener : (class$java$awt$event$ActionListener = JComponent.class$("java.awt.event.ActionListener")), actionListener);
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    protected void fireItemStateChanged(ItemEvent itemEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$java$awt$event$ItemListener != null ? class$java$awt$event$ItemListener : JComponent.class$("java.awt.event.ItemListener"))) {
                ((ItemListener)objectArray[n + 1]).itemStateChanged(itemEvent);
            }
            n -= 2;
        }
    }

    protected void fireActionEvent() {
        ActionEvent actionEvent = null;
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$java$awt$event$ActionListener != null ? class$java$awt$event$ActionListener : JComponent.class$("java.awt.event.ActionListener"))) {
                if (actionEvent == null) {
                    actionEvent = new ActionEvent(this, 1001, this.getActionCommand());
                }
                ((ActionListener)objectArray[n + 1]).actionPerformed(actionEvent);
            }
            n -= 2;
        }
    }

    protected void selectedItemChanged() {
        if (this.selectedItemReminder != null) {
            this.fireItemStateChanged(new ItemEvent(this, 701, this.selectedItemReminder, 2));
        }
        this.selectedItemReminder = this.getModel().getSelectedItem();
        if (this.selectedItemReminder != null) {
            this.fireItemStateChanged(new ItemEvent(this, 701, this.selectedItemReminder, 1));
        }
        this.fireActionEvent();
    }

    public Object[] getSelectedObjects() {
        Object object = this.getSelectedItem();
        if (object == null) {
            return new Object[0];
        }
        Object[] objectArray = new Object[]{object};
        return objectArray;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = this.getEditor().getItem();
        this.getModel().setSelectedItem(object);
        this.getUI().hidePopup();
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        ComboBoxModel comboBoxModel = this.getModel();
        Object object = comboBoxModel.getSelectedItem();
        if (!this.isEditable() && comboBoxModel instanceof DefaultComboBoxModel && object == null && this.getModel().getSize() > 0) {
            this.setSelectedIndex(0);
        } else if (this.selectedItemReminder == null) {
            if (object != null) {
                this.selectedItemChanged();
            }
        } else if (!this.selectedItemReminder.equals(object)) {
            this.selectedItemChanged();
        }
        if (!this.isEditable() && object != null) {
            boolean bl = true;
            Object object2 = comboBoxModel.getSelectedItem();
            int n = 0;
            int n2 = comboBoxModel.getSize();
            while (n < n2) {
                Object object3 = comboBoxModel.getElementAt(n);
                if (object3.equals(object2)) {
                    bl = false;
                    break;
                }
                ++n;
            }
            if (bl) {
                if (comboBoxModel.getSize() > 0) {
                    this.setSelectedIndex(0);
                    return;
                }
                this.setSelectedItem(null);
            }
        }
    }

    public boolean selectWithKeyChar(char c) {
        int n;
        if (this.keySelectionManager == null) {
            this.keySelectionManager = this.createDefaultKeySelectionManager();
        }
        if ((n = this.keySelectionManager.selectionForKey(c, this.getModel())) != -1) {
            this.setSelectedIndex(n);
            return true;
        }
        return false;
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        this.contentsChanged(listDataEvent);
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.contentsChanged(listDataEvent);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.firePropertyChange("enabled", !this.isEnabled(), this.isEnabled());
    }

    public void configureEditor(ComboBoxEditor comboBoxEditor, Object object) {
        comboBoxEditor.setItem(object);
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 9) {
            this.hidePopup();
        }
        super.processKeyEvent(keyEvent);
    }

    public boolean isFocusTraversable() {
        return this.getUI().isFocusTraversable();
    }

    public void setKeySelectionManager(KeySelectionManager keySelectionManager) {
        this.keySelectionManager = keySelectionManager;
    }

    public KeySelectionManager getKeySelectionManager() {
        return this.keySelectionManager;
    }

    public int getItemCount() {
        return this.dataModel.getSize();
    }

    public Object getItemAt(int n) {
        return this.dataModel.getElementAt(n);
    }

    protected KeySelectionManager createDefaultKeySelectionManager() {
        return new DefaultKeySelectionManager();
    }

    public boolean isOpaque() {
        return true;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJComboBox();
        }
        return this.accessibleContext;
    }

    private final class 1
    implements AncestorListener {
        public void ancestorAdded(AncestorEvent ancestorEvent) {
            JComboBox.this.hidePopup();
        }

        public void ancestorRemoved(AncestorEvent ancestorEvent) {
            JComboBox.this.hidePopup();
        }

        public void ancestorMoved(AncestorEvent ancestorEvent) {
            JComboBox.this.hidePopup();
        }

        /* synthetic */ 1() {
        }
    }

    class DefaultComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    Serializable {
        Vector objects = new Vector();
        Object selectedObject;

        public DefaultComboBoxModel() {
            JComboBox.this = JComboBox.this;
        }

        public DefaultComboBoxModel(Object[] objectArray) {
            JComboBox.this = JComboBox.this;
            int n = 0;
            int n2 = objectArray.length;
            while (n < n2) {
                this.objects.addElement(objectArray[n]);
                ++n;
            }
        }

        public DefaultComboBoxModel(Vector vector) {
            JComboBox.this = JComboBox.this;
            int n = 0;
            int n2 = vector.size();
            while (n < n2) {
                this.objects.addElement(vector.elementAt(n));
                ++n;
            }
        }

        public void setSelectedItem(Object object) {
            this.selectedObject = object;
            this.fireContentsChanged(this, -1, -1);
        }

        public Object getSelectedItem() {
            return this.selectedObject;
        }

        public int getSize() {
            return this.objects.size();
        }

        public Object getElementAt(int n) {
            if (n >= 0 && n < this.objects.size()) {
                return this.objects.elementAt(n);
            }
            return null;
        }

        public int getIndexOf(Object object) {
            return this.objects.indexOf(object);
        }

        void addObject(Object object) {
            this.objects.addElement(object);
            this.fireIntervalAdded(this, this.objects.size() - 1, this.objects.size() - 1);
        }

        void insertObjectAt(Object object, int n) {
            this.objects.insertElementAt(object, n);
            this.fireIntervalAdded(this, n, n);
        }

        void removeObjectAt(int n) {
            this.objects.removeElementAt(n);
            this.fireIntervalRemoved(this, n, n);
        }

        void removeObject(Object object) {
            int n = this.objects.indexOf(object);
            if (n != -1) {
                this.removeObjectAt(n);
            }
        }

        void removeAllObjects() {
            int n = 0;
            int n2 = this.objects.size() - 1;
            this.objects.removeAllElements();
            this.fireIntervalRemoved(this, n, n2);
        }
    }

    public interface KeySelectionManager {
        public int selectionForKey(char var1, ComboBoxModel var2);
    }

    class DefaultKeySelectionManager
    implements KeySelectionManager,
    Serializable {
        public int selectionForKey(char c, ComboBoxModel comboBoxModel) {
            String string;
            int n;
            int n2;
            int n3 = -1;
            Object object = comboBoxModel.getSelectedItem();
            if (object != null) {
                object = object.toString();
                n2 = 0;
                n = comboBoxModel.getSize();
                while (n2 < n) {
                    if (object.equals(comboBoxModel.getElementAt(n2).toString())) {
                        n3 = n2;
                        break;
                    }
                    ++n2;
                }
            }
            String string2 = String.valueOf(c).toLowerCase();
            c = string2.charAt(0);
            n2 = ++n3;
            n = comboBoxModel.getSize();
            while (n2 < n) {
                string = comboBoxModel.getElementAt(n2).toString().toLowerCase();
                if (string.length() > 0 && string.charAt(0) == c) {
                    return n2;
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < n3) {
                string = comboBoxModel.getElementAt(n2).toString().toLowerCase();
                if (string.length() > 0 && string.charAt(0) == c) {
                    return n2;
                }
                ++n2;
            }
            return -1;
        }

        DefaultKeySelectionManager() {
            JComboBox.this = JComboBox.this;
        }
    }

    protected class AccessibleJComboBox
    extends JComponent.AccessibleJComponent {
        public int getAccessibleChildrenCount() {
            if (JComboBox.this.isEditable() && JComboBox.this.getEditor().getEditorComponent() instanceof Accessible) {
                return 2;
            }
            return 1;
        }

        public Accessible getAccessibleChild(int n) {
            Object object;
            JComboBox.this.getUI().getPreferredSize(JComboBox.this);
            Accessible accessible = null;
            if (n == 0) {
                accessible = new AccessibleJComboBoxList(JComboBox.this);
            } else if (n == 1 && JComboBox.this.isEditable() && (object = JComboBox.this.getEditor().getEditorComponent()) instanceof Accessible) {
                accessible = (Accessible)object;
            }
            if (accessible != null && (object = accessible.getAccessibleContext()) != null) {
                ((AccessibleContext)object).setAccessibleParent(JComboBox.this);
            }
            return accessible;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (JComboBox.this.isEditable()) {
                accessibleStateSet.add(AccessibleState.EDITABLE);
            }
            return accessibleStateSet;
        }

        public Accessible getAccessibleAt(Point point) {
            Accessible accessible = this.getAccessibleChild(1);
            if (accessible != null) {
                return accessible;
            }
            return this.getAccessibleChild(0);
        }

        AccessibleJComboBox() {
            super(JComboBox.this);
            JComboBox.this = JComboBox.this;
        }

        protected class AccessibleJComboBoxList
        extends AccessibleContext
        implements Accessible,
        AccessibleComponent {
            private JComboBox parent;
            private AccessibleContext listAC;
            private AccessibleComponent listACmp;

            public AccessibleJComboBoxList(JComboBox jComboBox) {
                AccessibleJComboBox.this = AccessibleJComboBox.this;
                this.parent = jComboBox;
                this.setAccessibleParent(jComboBox);
                this.listAC = jComboBox.getUI().getList().getAccessibleContext();
                this.listACmp = this.listAC.getAccessibleComponent();
            }

            public AccessibleContext getAccessibleContext() {
                return this;
            }

            public String getAccessibleName() {
                return this.listAC.getAccessibleName();
            }

            public void setAccessibleName(String string) {
                this.listAC.setAccessibleName(string);
            }

            public String getAccessibleDescription() {
                return this.listAC.getAccessibleDescription();
            }

            public void setAccessibleDescription(String string) {
                this.listAC.setAccessibleDescription(string);
            }

            public AccessibleRole getAccessibleRole() {
                return this.listAC.getAccessibleRole();
            }

            public AccessibleStateSet getAccessibleStateSet() {
                return this.listAC.getAccessibleStateSet();
            }

            public int getAccessibleIndexInParent() {
                return 0;
            }

            public int getAccessibleChildrenCount() {
                return this.listAC.getAccessibleChildrenCount();
            }

            public Accessible getAccessibleChild(int n) {
                Accessible accessible = this.listAC.getAccessibleChild(n);
                AccessibleContext accessibleContext = accessible.getAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.setAccessibleParent(this);
                }
                return accessible;
            }

            public Locale getLocale() {
                return this.listAC.getLocale();
            }

            public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                this.listAC.addPropertyChangeListener(propertyChangeListener);
            }

            public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                this.listAC.removePropertyChangeListener(propertyChangeListener);
            }

            public AccessibleAction getAccessibleAction() {
                return this.listAC.getAccessibleAction();
            }

            public AccessibleComponent getAccessibleComponent() {
                return this;
            }

            public AccessibleSelection getAccessibleSelection() {
                return this.listAC.getAccessibleSelection();
            }

            public AccessibleText getAccessibleText() {
                return this.listAC.getAccessibleText();
            }

            public AccessibleValue getAccessibleValue() {
                return this.listAC.getAccessibleValue();
            }

            public Color getBackground() {
                return this.listACmp.getBackground();
            }

            public void setBackground(Color color) {
                this.listACmp.setBackground(color);
            }

            public Color getForeground() {
                return this.listACmp.getForeground();
            }

            public void setForeground(Color color) {
                this.listACmp.setForeground(color);
            }

            public Cursor getCursor() {
                return this.listACmp.getCursor();
            }

            public void setCursor(Cursor cursor) {
                this.listACmp.setCursor(cursor);
            }

            public Font getFont() {
                return this.listACmp.getFont();
            }

            public void setFont(Font font) {
                this.listACmp.setFont(font);
            }

            public FontMetrics getFontMetrics(Font font) {
                return this.listACmp.getFontMetrics(font);
            }

            public boolean isEnabled() {
                return this.listACmp.isEnabled();
            }

            public void setEnabled(boolean bl) {
                this.listACmp.setEnabled(bl);
            }

            public boolean isVisible() {
                return this.listACmp.isVisible();
            }

            public void setVisible(boolean bl) {
                this.listACmp.setVisible(bl);
            }

            public boolean isShowing() {
                return this.listACmp.isShowing();
            }

            public boolean contains(Point point) {
                return this.parent.contains(point);
            }

            public Point getLocationOnScreen() {
                return this.parent.getLocationOnScreen();
            }

            public Point getLocation() {
                return new Point(0, 0);
            }

            public void setLocation(Point point) {
            }

            public Rectangle getBounds() {
                Rectangle rectangle = this.parent.getBounds();
                rectangle.x = 0;
                rectangle.y = 0;
                return rectangle;
            }

            public void setBounds(Rectangle rectangle) {
            }

            public Dimension getSize() {
                return this.parent.getSize();
            }

            public void setSize(Dimension dimension) {
            }

            public Accessible getAccessibleAt(Point point) {
                return this.listACmp.getAccessibleAt(point);
            }

            public boolean isFocusTraversable() {
                return this.listACmp.isFocusTraversable();
            }

            public void requestFocus() {
                this.parent.requestFocus();
            }

            public void addFocusListener(FocusListener focusListener) {
                this.listACmp.addFocusListener(focusListener);
            }

            public void removeFocusListener(FocusListener focusListener) {
                this.listACmp.removeFocusListener(focusListener);
            }
        }
    }
}

