import gtk
import gobject

from Onboard.IconPalette import IconPalette

### Logging ###
import logging
_logger = logging.getLogger("KbdWindow")
###############

### Config Singleton ###
from Onboard.Config import Config
config = Config()
########################

class KbdWindow(gtk.Window):
    """Very messy class holds the keyboard widget.  The mess is the docked window support which is disable because of numerous metacity bugs."""
    def __init__(self):
        gtk.Window.__init__(self)
        _logger.debug("Entered in __init__")
        self.keyboard = None
        self.connect("destroy", gtk.main_quit)
        self.connect("configure-event", self.cb_configure_event)
        self.set_accept_focus(False)
        self.grab_remove()
        self.set_keep_above(True)
        self.hidden = True

        config.geometry_notify_add(self.resize)
        self.set_default_size(config.keyboard_width, config.keyboard_height)
        config.position_notify_add(self.move)
        self.move(config.x_position, config.y_position)

        self.connect("window-state-event", self.cb_state_change)

        self.icp = IconPalette()
        self.icp.connect("activated", self.do_show)
        config.icp_in_use_change_notify_add(self._on_icp_in_use_toggled)
        _logger.debug("Leaving __init__")

    def move(self, new_x_position, new_y_position):
        # Don't move window if already in the right place.
        x_position, y_position = self.get_position()
        if x_position != new_x_position or y_position != new_y_position:
            gtk.Window.move(self, new_x_position, new_y_position)

    def do_show(self, widget=None):
        _logger.debug("Entered in do_show")
        self.icp.do_hide()
        self.move(config.x_position, config.y_position) # to be sure that the window manager places it correctly
        self.show_all()
        self.hidden = False
        _logger.debug("Leaving do_show")

    def do_hide(self):
        _logger.debug("Entered in do_hide")
        self.hide_all()
        self.hidden = True
        if config.icp_in_use: self.icp.do_show()
        _logger.debug("Leaving do_hide")

    def set_keyboard(self, keyboard):
        _logger.debug("Entered in set_keyboard")
        if self.keyboard:
            self.remove(self.keyboard)
        self.keyboard = keyboard
        self.add(self.keyboard)
        self.keyboard.show()
        self.queue_draw()

    def do_set_layout(self, client, cxion_id, entry, user_data):
        _logger.debug("Entered in do_set_layout")
        return

    def cb_configure_event(self, event, user_data):
        """
        Callback that is called when onboard receives a configure-event
        because of a change of its position or size.
        The callback stores the new values to the correspondent gconf
        keys.
        """
        _logger.debug("Entered in cb_configure_event")
        x_pos, y_pos = self.get_position()
        width, height = self.get_size()

        # store new value only if it is different to avoid infinite loop
        config.x_position = x_pos
        config.y_position = y_pos
        config.keyboard_width = width
        config.keyboard_height = height


    def do_set_gravity(self, edgeGravity):
        _logger.debug("Entered in do_set_gravity")
        self.edgeGravity = edgeGravity
        width, height = self.get_size()

        '''
        This will place the window on the edge corresponding to the edge gravity
        '''

        geom = self.get_screen().get_monitor_geometry(0)
        eg = self.edgeGravity

        x = 0
        y = 0
        if eg == gtk.gdk.GRAVITY_SOUTH:
            y = geom.height - height
            y += 29 #to account for panel.


        self.move(x, y)

        gobject.idle_add(self.do_set_strut)

    def do_set_strut(self):
        _logger.debug("Entered in do_set_strut")
        propvals = [0,0,0,0,0,0,0,0,0,0,0,0]
        """propvals = [0,#left
                0, #right
                0, #top
                300,#bottom
                0,#left_start_y
                0,#left_end_y
                0,#right_start_y
                0,#right_end_y
                0,#top_start_x
                0,#top_end_x
                0,#bottom_start_x
                3000]#bottom_end_x"""

        screen = self.get_screen()
        biggestHeight = 0
        for n in range(screen.get_n_monitors()):
            tempHeight = screen.get_monitor_geometry(n).height
            if biggestHeight < tempHeight:
                biggestHeight = tempHeight

        geom = self.get_screen().get_monitor_geometry(0)
        eg = self.edgeGravity
        x, y = self.window.get_origin()

        width,height = self.get_size()

        if eg == gtk.gdk.GRAVITY_NORTH:
            propvals[2] = height + y
            propvals[9] = width
        elif eg == gtk.gdk.GRAVITY_SOUTH and y != 0:
            #propvals[2] = y
            #propvals[9] = geom.width - 1
            propvals[3] = biggestHeight - y
            propvals[11] = width - 1

        # tell window manager to not overlap buttons with maximized window
            self.window.property_change("_NET_WM_STRUT_PARTIAL",
                                        "CARDINAL",
                                        32,
                                        gtk.gdk.PROP_MODE_REPLACE,
                                        propvals)
        self.queue_resize_no_redraw()


    def cb_state_change(self, widget, event):
        """
        This is the callback that gets executed when the user hides the
        onscreen keyboard by using the minimize button in the decoration
        of the window.
        """
        _logger.debug("Entered in cb_state_change")
        if event.changed_mask & gtk.gdk.WINDOW_STATE_ICONIFIED:
            if event.new_window_state & gtk.gdk.WINDOW_STATE_ICONIFIED:
                self.do_hide()
                self.deiconify()

    def _on_icp_in_use_toggled(self, icp_in_use):
        """
        This is the callback that gets executed when the user toggles 
        the gconf key named in_use of the icon_palette.
        """
        _logger.debug("Entered in _on_icp_in_use_toggled")
        if not self.hidden:
            _logger.debug("Entered in not self.hidden")
            return
        elif icp_in_use:
            _logger.debug("calling do_show")
            self.icp.do_show()
        else:
            _logger.debug("calling do_hide")
            self.icp.do_hide()
