/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _OPENCTL_MODULE_P_H_
#define _OPENCTL_MODULE_P_H_

#include <map>
#include <list>
#include <GTLCore/ScopedName.h>

namespace llvm {
  class Constant;
  class Module;
}

namespace GTLCore {
  class Function;
  class TypeManager;
  /**
   * @internal
   * This class is not part of the public API of GTLCore.
   * @ingroup GTLCore
   */
  class ModuleData {
    public:
      ModuleData( llvm::Module* llvmModule);
      ~ModuleData();
      bool appendFunction(const ScopedName& name, Function* function);
      Function* function(const String& _currentNameSpace, const String& _name);
      Function* function(const ScopedName& name);
      std::list<Function*> functions();
      std::map< ScopedName, llvm::Constant* > constants() { return m_constants; }
      void addConstant( const ScopedName& _scopedName, llvm::Constant* _constant )
      {
        m_constants[_scopedName] = _constant;
      }
      llvm::Module* llvmModule() { return m_llvmModule; }
      const llvm::Module* llvmModule() const { return m_llvmModule; }
      TypeManager* typeManager() { return m_typeManager; }
      const TypeManager* typeManager() const { return m_typeManager; }
    private:
      llvm::Module* m_llvmModule;
      std::map<ScopedName, Function*> m_functions;
      TypeManager* m_typeManager;
      std::map< ScopedName, llvm::Constant* > m_constants;
  };
}

#endif
