/*
 * Copyright (c) 1997, 2010, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * (C) Copyright Taligent, Inc. 1996, 1997 - All Rights Reserved
 * (C) Copyright IBM Corp. 1996 - 1998 - All Rights Reserved
 *
 * The original version of this source code and documentation
 * is copyrighted and owned by Taligent, Inc., a wholly-owned
 * subsidiary of IBM. These materials are provided under terms
 * of a License Agreement between Taligent and Sun. This technology
 * is protected by multiple US and International patents.
 *
 * This notice and attribution to Taligent may not be removed.
 * Taligent is a registered trademark of Taligent, Inc.
 *
 */

package sun.util.resources;

public final class TimeZoneNames_sv extends TimeZoneNamesBundle {

    protected final Object[][] getContents() {
        String ACT[] = new String[] {"Acre, normaltid", "ACT",
                                     "Acre, sommartid", "ACST"};
        String ADELAIDE[] = new String[] {"Central Standard Time (S\u00f6dra Australien)", "CST",
                                          "Central Summer Time (S\u00f6dra Australien)", "CST"};
        String AGT[] = new String[] {"Argentina, normaltid", "ART",
                                     "Argentina, sommartid", "ARST"};
        String AKST[] = new String[] {"Alaska, normaltid", "AKST",
                                      "Alaska, sommartid", "AKDT"};
        String AMT[] = new String[] {"Amazonas, normaltid", "AMT",
                                     "Amazonas, sommartid", "AMST"};
        String ARAST[] = new String[] {"Arabisk normaltid", "AST",
                                       "Arabisk sommartid", "ADT"};
        String ARMT[] = new String[] {"Armenien, normaltid", "AMT",
                                      "Armenien, sommartid", "AMST"};
        String AST[] = new String[] {"Atlantisk normaltid", "AST",
                                     "Atlantisk sommartid", "ADT"};
        String BDT[] = new String[] {"Bangladesh, normaltid", "BDT",
                                     "Bangladesh, sommartid", "BDST"};
        String BRISBANE[] = new String[] {"Eastern Standard Time (Queensland)", "EST",
                                          "Eastern Summer Time (Queensland)", "EST"};
        String BROKEN_HILL[] = new String[] {"Central Standard Time (S\u00f6dra Australien/Nya Sydwales)", "CST",
                                             "Central Summer Time (S\u00f6dra Australien/Nya Sydwales)", "CST"};
        String BRT[] = new String[] {"Brasilien, normaltid", "BRT",
                                     "Brasilien, sommartid", "BRST"};
        String BTT[] = new String[] {"Bhutan, normaltid", "BTT",
                                     "Bhutan, sommartid", "BTST"};
        String CAT[] = new String[] {"Centralafrikansk tid", "CAT",
                                     "Centralafrikansk sommartid", "CAST"};
        String CET[] = new String[] {"Centraleuropeisk tid", "CET",
                                     "Centraleuropeisk sommartid", "CEST"};
        String CHAST[] = new String[] {"Chatham, normaltid", "CHAST",
                                       "Chatham, sommartid", "CHADT"};
        String CIT[] = new String[] {"Centralindonesisk tid", "CIT",
                                     "Centralindonesisk sommartid", "CIST"};
        String CLT[] = new String[] {"Chile, normaltid", "CLT",
                                     "Chile, sommartid", "CLST"};
        String CST[] = new String[] {"Central normaltid", "CST",
                                     "Central sommartid", "CDT"};
        String CTT[] = new String[] {"Kina, normaltid", "CST",
                                     "Kina, sommartid", "CDT"};
        String CUBA[] = new String[] {"Cuba Standard Time", "CST",
                                      "Cuba Daylight Time", "CDT"};
        String DARWIN[] = new String[] {"Central Standard Time (Nordterritoriet)", "CST",
                                        "Central Summer Time (Nordterritoriet)", "CST"};
        String DUBLIN[] = new String[] {"Greenwichtid", "GMT",
                                        "Irland, sommartid", "IST"};
        String EAT[] = new String[] {"\u00d6stafrikansk tid", "EAT",
                                     "\u00d6stafrikansk sommartid", "EAST"};
        String EASTER[] = new String[] {"P\u00e5sk\u00f6n, normaltid", "EAST",
                                        "P\u00e5sk\u00f6n, sommartid", "EASST"};
        String EET[] = new String[] {"\u00d6steuropeisk tid", "EET",
                                     "\u00d6steuropeisk sommartid", "EEST"};
        String EGT[] = new String[] {"\u00d6stgr\u00f6nl\u00e4ndsk tid", "EGT",
                                     "\u00d6stgr\u00f6nl\u00e4ndsk sommartid", "EGST"};
        String EST[] = new String[] {"Eastern, normaltid", "EST",
                                     "Eastern, sommartid", "EDT"};
        String EST_NSW[] = new String[] {"Eastern Standard Time (Nya Sydwales)", "EST",
                                         "Eastern Summer Time (Nya Sydwales)", "EST"};
        String GHMT[] = new String[] {"Ghana, normaltid", "GMT",
                                      "Ghana, sommartid", "GHST"};
        String GAMBIER[] =  new String[] {"Gambier, normaltid", "GAMT",
                                          "Gambier, sommartid", "GAMST"};
        String GMT[] = new String[] {"Greenwichtid", "GMT",
                                     "Greenwichtid", "GMT"};
        String GMTBST[] = new String[] {"Greenwichtid", "GMT",
                                        "Brittisk sommartid", "BST"};
        String GST[] = new String[] {"Gulf-normaltid", "GST",
                                     "Gulf-sommartid", "GDT"};
        String HAST[] = new String[] {"Hawaii-Aleuterna, normaltid", "HAST",
                                      "Hawaii-Aleuterna, sommartid", "HADT"};
        String HKT[] =  new String[] {"Hong Kong, normaltid", "HKT",
                                      "Hong Kong, sommartid", "HKST"};
        String HST[] = new String[] {"Hawaii, normaltid", "HST",
                                     "Hawaii, sommartid", "HDT"};
        String ICT[] = new String[] {"Indokinesisk tid", "ICT",
                                     "Indokinesisk sommartid", "ICST"};
        String IRT[] = new String[] {"Iran, normaltid", "IRST",
                                     "Iran, sommartid", "IRDT"};
        String ISRAEL[] = new String[] {"Israel, normaltid", "IST",
                                        "Israel, sommartid", "IDT"};
        String IST[] = new String[] {"Indien, normaltid", "IST",
                                     "Indien, sommartid", "IDT"};
        String JST[] = new String[] {"Japan, normaltid", "JST",
                                     "Japan, sommartid", "JDT"};
        String KST[] = new String[] {"Korea, normaltid", "KST",
                                     "Korea, sommartid", "KDT"};
        String LORD_HOWE[] = new String[] {"Lord Howe, normaltid", "LHST",
                                           "Lord Howe, sommartid", "LHST"};
        String MHT[] = new String[] {"Marshall\u00f6arna, normaltid", "MHT",
                                     "Marshall\u00f6arna, sommartid", "MHST"};
        String MSK[] = new String[] {"Moskva, normaltid", "MSK",
                                     "Moskva, sommartid", "MSD"};
        String MST[] = new String[] {"Mountain, normaltid", "MST",
                                     "Mountain, sommartid", "MDT"};
        String MYT[] = new String[] {"Malaysia, normaltid", "MYT",
                                     "Malaysia, sommartid", "MYST"};
        String NORONHA[] = new String[] {"Fernando de Noronha, normaltid", "FNT",
                                         "Fernando de Noronha, sommartid", "FNST"};
        String NOVT[] = new String[] {"Novosibirsk, normaltid", "NOVT",
                                      "Novosibirsk, sommartid", "NOVST"};
        String NPT[] = new String[] {"Nepal, normaltid", "NPT",
                                     "Nepal, sommartid", "NPST"};
        String NST[] = new String[] {"Newfoundland, normaltid", "NST",
                                     "Newfoundland, sommartid", "NDT"};
        String NZST[] = new String[] {"Nya Zeeland, normaltid", "NZST",
                                      "Nya Zeeland, sommartid", "NZDT"};
        String PITCAIRN[] = new String[] {"Pitcairn, normaltid", "PST",
                                          "Pitcairn, sommartid", "PDT"};
        String PKT[] = new String[] {"Pakistan, normaltid", "PKT",
                                     "Pakistan, sommartid", "PKST"};
        String PST[] = new String[] {"Stilla havet, normaltid", "PST",
                                     "Stilla havet, sommartid", "PDT"};
        String RST[] = new String[] {"Eastern, normaltid", "EST",
                                     "Central sommartid", "CDT"};
        String SAST[] = new String[] {"Sydafrika, normaltid", "SAST",
                                      "Sydafrika, sommartid", "SAST"};
        String SBT[] = new String[] {"Salomon\u00f6arna, normaltid", "SBT",
                                     "Salomon\u00f6arna, sommartid", "SBST"};
        String SGT[] = new String[] {"Singapore, normaltid", "SGT",
                                     "Singapore, sommartid", "SGST"};
        String SLST[] = new String[] {"Greenwich Mean Time", "GMT",
                                      "Sierra Leone, sommartid", "SLST"};
        String TASMANIA[] = new String[] {"Eastern Standard Time (Tasmanien)", "EST",
                                          "Eastern Summer Time (Tasmanien)", "EST"};
        String TMT[] = new String[] {"Turkmenistan, normaltid", "TMT",
                                     "Turkmenistan, sommartid", "TMST"};
        String TRUT[] = new String[] {"Truk, normaltid", "TRUT",
                                      "Truk, sommartid", "TRUST"};
        String ULAT[]= new String[] {"Ulaanbaatar, normaltid", "ULAT",
                                     "Ulaanbaatar, sommartid", "ULAST"};
        String WART[] = new String[] {"Argentina, normaltid", "WART",
                                      "Argentina, sommartid", "WARST"};
        String WAT[] = new String[] {"V\u00e4stafrikansk tid", "WAT",
                                     "V\u00e4stafrikansk sommartid", "WAST"};
        String WET[] = new String[] {"V\u00e4steuropeisk tid", "WET",
                                     "V\u00e4steuropeisk sommartid", "WEST"};
        String WIT[] = new String[] {"V\u00e4stindonesisk tid", "WIT",
                                     "V\u00e4stindonesisk sommartid", "WIST"};
        String WST_AUS[] = new String[] {"Western Standard Time (Australien)", "WST",
                                         "Western Summer Time (Australien)", "WST"};
        String SAMOA[] = new String[] {"Samoa, normaltid", "SST",
                                       "Samoa, sommartid", "SDT"};
        String WST_SAMOA[] = new String[] {"V\u00e4stsamoansk tid", "WST",
                                           "V\u00e4stsamoansk sommartid", "WSST"};
        String ChST[] = new String[] {"Chamorro, normaltid", "ChST",
                                      "Chamorro, sommartid", "ChDT"};
        String VICTORIA[] = new String[] {"Eastern Standard Time (Victoria)", "EST",
                                          "Eastern Summer Time (Victoria)", "EST"};
        String UTC[] = new String[] {"Koordinerad universell tid", "UTC",
                                     "Koordinerad universell tid", "UTC"};
        String UZT[] = new String[] {"Uzbekistan, normaltid", "UZT",
                                     "Uzbekistan, sommartid", "UZST"};

        return new Object[][] {
            {"America/Los_Angeles", PST},
            {"PST", PST},
            {"America/Denver", MST},
            {"MST", MST},
            {"America/Phoenix", MST},
            {"PNT", MST},
            {"America/Chicago", CST},
            {"CST", CST},
            {"America/New_York", EST},
            {"EST", EST},
            {"America/Indianapolis", EST},
            {"IET", EST},
            {"Pacific/Honolulu", HST},
            {"HST", HST},
            {"America/Anchorage", AKST},
            {"AST", AKST},
            {"America/Halifax", AST},
            {"America/St_Johns", NST},
            {"CNT", NST},
            {"Europe/Paris", CET},
            {"ECT", CET},
            {"GMT", GMT},
            {"Africa/Casablanca", WET},
            {"Asia/Jerusalem", ISRAEL},
            {"Asia/Tokyo", JST},
            {"JST", JST},
            {"Europe/Bucharest", EET},
            {"Asia/Shanghai", CTT},
            {"CTT", CTT},
            /* Don't change the order of the above zones
             * to keep compatibility with the previous version.
             */

            {"ACT", DARWIN},
            {"AET", EST_NSW},
            {"AGT", AGT},
            {"ART", EET},
            {"Africa/Abidjan", GMT},
            {"Africa/Accra", GHMT},
            {"Africa/Addis_Ababa", EAT},
            {"Africa/Algiers", CET},
            {"Africa/Asmara", EAT},
            {"Africa/Asmera", EAT},
            {"Africa/Bamako", GMT},
            {"Africa/Bangui", WAT},
            {"Africa/Banjul", GMT},
            {"Africa/Bissau", GMT},
            {"Africa/Blantyre", CAT},
            {"Africa/Brazzaville", WAT},
            {"Africa/Bujumbura", CAT},
            {"Africa/Cairo", EET},
            {"Africa/Ceuta", CET},
            {"Africa/Conakry", GMT},
            {"Africa/Dakar", GMT},
            {"Africa/Dar_es_Salaam", EAT},
            {"Africa/Djibouti", EAT},
            {"Africa/Douala", WAT},
            {"Africa/El_Aaiun", WET},
            {"Africa/Freetown", SLST},
            {"Africa/Gaborone", CAT},
            {"Africa/Harare", CAT},
            {"Africa/Johannesburg", SAST},
            {"Africa/Kampala", EAT},
            {"Africa/Khartoum", EAT},
            {"Africa/Kigali", CAT},
            {"Africa/Kinshasa", WAT},
            {"Africa/Lagos", WAT},
            {"Africa/Libreville", WAT},
            {"Africa/Lome", GMT},
            {"Africa/Luanda", WAT},
            {"Africa/Lubumbashi", CAT},
            {"Africa/Lusaka", CAT},
            {"Africa/Malabo", WAT},
            {"Africa/Maputo", CAT},
            {"Africa/Maseru", SAST},
            {"Africa/Mbabane", SAST},
            {"Africa/Mogadishu", EAT},
            {"Africa/Monrovia", GMT},
            {"Africa/Nairobi", EAT},
            {"Africa/Ndjamena", WAT},
            {"Africa/Niamey", WAT},
            {"Africa/Nouakchott", GMT},
            {"Africa/Ouagadougou", GMT},
            {"Africa/Porto-Novo", WAT},
            {"Africa/Sao_Tome", GMT},
            {"Africa/Timbuktu", GMT},
            {"Africa/Tripoli", EET},
            {"Africa/Tunis", CET},
            {"Africa/Windhoek", WAT},
            {"America/Adak", HAST},
            {"America/Anguilla", AST},
            {"America/Antigua", AST},
            {"America/Araguaina", BRT},
            {"America/Argentina/Buenos_Aires", AGT},
            {"America/Argentina/Catamarca", AGT},
            {"America/Argentina/ComodRivadavia", AGT},
            {"America/Argentina/Cordoba", AGT},
            {"America/Argentina/Jujuy", AGT},
            {"America/Argentina/La_Rioja", AGT},
            {"America/Argentina/Mendoza", AGT},
            {"America/Argentina/Rio_Gallegos", AGT},
            {"America/Argentina/Salta", AGT},
            {"America/Argentina/San_Juan", AGT},
            {"America/Argentina/San_Luis", WART},
            {"America/Argentina/Tucuman", AGT},
            {"America/Argentina/Ushuaia", AGT},
            {"America/Aruba", AST},
            {"America/Asuncion", new String[] {"Paraguay, normaltid", "PYT",
                                               "Paraguay, sommartid", "PYST"}},
            {"America/Atikokan", EST},
            {"America/Atka", HAST},
            {"America/Bahia", BRT},
            {"America/Barbados", AST},
            {"America/Belem", BRT},
            {"America/Belize", CST},
            {"America/Blanc-Sablon", AST},
            {"America/Boa_Vista", AMT},
            {"America/Bogota", new String[] {"Colombia, normaltid", "COT",
                                             "Colombia, sommartid", "COST"}},
            {"America/Boise", MST},
            {"America/Buenos_Aires", AGT},
            {"America/Cambridge_Bay", MST},
            {"America/Campo_Grande", AMT},
            {"America/Cancun", CST},
            {"America/Caracas", new String[] {"Venezuela, normaltid", "VET",
                                              "Venezuela, sommartid", "VEST"}},
            {"America/Catamarca", AGT},
            {"America/Cayenne", new String[] {"Franska Guyana, normaltid", "GFT",
                                              "Franska Guyana, sommartid", "GFST"}},
            {"America/Cayman", EST},
            {"America/Chihuahua", MST},
            {"America/Coral_Harbour", EST},
            {"America/Cordoba", AGT},
            {"America/Costa_Rica", CST},
            {"America/Cuiaba", AMT},
            {"America/Curacao", AST},
            {"America/Danmarkshavn", GMT},
            {"America/Dawson", PST},
            {"America/Dawson_Creek", MST},
            {"America/Detroit", EST},
            {"America/Dominica", AST},
            {"America/Edmonton", MST},
            {"America/Eirunepe", AMT},
            {"America/El_Salvador", CST},
            {"America/Ensenada", PST},
            {"America/Fort_Wayne", EST},
            {"America/Fortaleza", BRT},
            {"America/Glace_Bay", AST},
            {"America/Godthab", new String[] {"V\u00e4stra Gr\u00f6nland, normaltid", "WGT",
                                              "V\u00e4stra Gr\u00f6nland, sommartid", "WGST"}},
            {"America/Goose_Bay", AST},
            {"America/Grand_Turk", EST},
            {"America/Grenada", AST},
            {"America/Guadeloupe", AST},
            {"America/Guatemala", CST},
            {"America/Guayaquil", new String[] {"Ecuador, normaltid", "ECT",
                                                "Ecuador, sommartid", "ECST"}},
            {"America/Guyana", new String[] {"Guyana, normaltid", "GYT",
                                             "Guyana, sommartid", "GYST"}},
            {"America/Havana", CUBA},
            {"America/Hermosillo", MST},
            {"America/Indiana/Indianapolis", EST},
            {"America/Indiana/Knox", CST},
            {"America/Indiana/Marengo", EST},
           {"America/Indiana/Petersburg", EST},
           {"America/Indiana/Tell_City", CST},
            {"America/Indiana/Vevay", EST},
           {"America/Indiana/Vincennes", EST},
            {"America/Indiana/Winamac", EST},
            {"America/Inuvik", MST},
            {"America/Iqaluit", EST},
            {"America/Jamaica", EST},
            {"America/Jujuy", AGT},
            {"America/Juneau", AKST},
            {"America/Kentucky/Louisville", EST},
            {"America/Kentucky/Monticello", EST},
            {"America/Knox_IN", CST},
            {"America/La_Paz", new String[] {"Bolivia, normaltid", "BOT",
                                             "Bolivia, sommartid", "BOST"}},
            {"America/Lima", new String[] {"Peru, normaltid", "PET",
                                           "Peru, sommartid", "PEST"}},
            {"America/Louisville", EST},
            {"America/Maceio", BRT},
            {"America/Managua", CST},
            {"America/Manaus", AMT},
           {"America/Marigot", AST},
            {"America/Martinique", AST},
            {"America/Matamoros", CST},
            {"America/Mazatlan", MST},
            {"America/Mendoza", AGT},
            {"America/Menominee", CST},
            {"America/Merida", CST},
            {"America/Mexico_City", CST},
            {"America/Miquelon", new String[] {"Saint-Pierre-et-Miquelon, normaltid", "PMST",
                                               "Saint-Pierre-et-Miquelon, sommartid", "PMDT"}},
            {"America/Moncton", AST},
            {"America/Montevideo", new String[] {"Uruguay, normaltid", "UYT",
                                                 "Uruguay, sommartid", "UYST"}},
            {"America/Monterrey", CST},
            {"America/Montreal", EST},
            {"America/Montserrat", AST},
            {"America/Nassau", EST},
            {"America/Nipigon", EST},
            {"America/Nome", AKST},
            {"America/Noronha", NORONHA},
            {"America/North_Dakota/Center", CST},
            {"America/North_Dakota/New_Salem", CST},
            {"America/Ojinaga", MST},
            {"America/Panama", EST},
            {"America/Pangnirtung", EST},
            {"America/Paramaribo", new String[] {"Surinam, normaltid", "SRT",
                                                 "Surinam, sommartid", "SRST"}},
            {"America/Port-au-Prince", EST},
            {"America/Port_of_Spain", AST},
            {"America/Porto_Acre", AMT},
            {"America/Porto_Velho", AMT},
            {"America/Puerto_Rico", AST},
            {"America/Rainy_River", CST},
            {"America/Rankin_Inlet", CST},
            {"America/Recife", BRT},
            {"America/Regina", CST},
            {"America/Resolute", RST},
            {"America/Rio_Branco", AMT},
            {"America/Rosario", AGT},
            {"America/Santa_Isabel", PST},
            {"America/Santarem", BRT},
            {"America/Santiago", CLT},
            {"America/Santo_Domingo", AST},
            {"America/Sao_Paulo", BRT},
            {"America/Scoresbysund", EGT},
            {"America/Shiprock", MST},
           {"America/St_Barthelemy", AST},
            {"America/St_Kitts", AST},
            {"America/St_Lucia", AST},
            {"America/St_Thomas", AST},
            {"America/St_Vincent", AST},
            {"America/Swift_Current", CST},
            {"America/Tegucigalpa", CST},
            {"America/Thule", AST},
            {"America/Thunder_Bay", EST},
            {"America/Tijuana", PST},
            {"America/Toronto", EST},
            {"America/Tortola", AST},
            {"America/Vancouver", PST},
            {"America/Virgin", AST},
            {"America/Whitehorse", PST},
            {"America/Winnipeg", CST},
            {"America/Yakutat", AKST},
            {"America/Yellowknife", MST},
            {"Antarctica/Davis", new String[] {"Davis, normaltid", "DAVT",
                                               "Davis, sommartid", "DAVST"}},
            {"Antarctica/DumontDUrville", new String[] {"Dumont-d'Urville, normaltid", "DDUT",
                                                        "Dumont-d'Urville, sommartid", "DDUST"}},
            {"Antarctica/Mawson", new String[] {"Mawson, normaltid", "MAWT",
                                                "Mawson, sommartid", "MAWST"}},
            {"Antarctica/McMurdo", NZST},
            {"Antarctica/Palmer", CLT},
            {"Antarctica/Rothera", new String[] {"Rothera, normaltid", "ROTT",
                                                 "Rothera, sommartid", "ROTST"}},
            {"Antarctica/South_Pole", NZST},
            {"Antarctica/Syowa", new String[] {"Syowa, normaltid", "SYOT",
                                               "Syowa, sommartid", "SYOST"}},
            {"Antarctica/Vostok", new String[] {"Vostok, normaltid", "VOST",
                                                "Vostok, sommartid", "VOSST"}},
            {"Arctic/Longyearbyen", CET},
            {"Asia/Aden", ARAST},
            {"Asia/Almaty", new String[] {"Alma-Ata, normaltid", "ALMT",
                                          "Alma-Ata, sommartid", "ALMST"}},
            {"Asia/Amman", EET},
            {"Asia/Anadyr", new String[] {"Anadyr, normaltid", "ANAT",
                                          "Anadyr, sommartid", "ANAST"}},
            {"Asia/Aqtau", new String[] {"Aqtau, normaltid", "AQTT",
                                         "Aqtau, sommartid", "AQTST"}},
            {"Asia/Aqtobe", new String[] {"Aqtobe, normaltid", "AQTT",
                                          "Aqtobe, sommartid", "AQTST"}},
            {"Asia/Ashgabat", TMT},
            {"Asia/Ashkhabad", TMT},
            {"Asia/Baghdad", ARAST},
            {"Asia/Bahrain", ARAST},
            {"Asia/Baku", new String[] {"Azerbajdzjan, normaltid", "AZT",
                                        "Azerbajdzjan, sommartid", "AZST"}},
            {"Asia/Bangkok", ICT},
            {"Asia/Beirut", EET},
            {"Asia/Bishkek", new String[] {"Kirgizstan, normaltid", "KGT",
                                           "Kirgizstan, sommartid", "KGST"}},
            {"Asia/Brunei", new String[] {"Brunei, normaltid", "BNT",
                                          "Brunei, sommartid", "BNST"}},
            {"Asia/Calcutta", IST},
            {"Asia/Choibalsan", new String[] {"Choibalsan, normaltid", "CHOT",
                                              "Choibalsan, sommartid", "CHOST"}},
            {"Asia/Chongqing", CTT},
            {"Asia/Chungking", CTT},
            {"Asia/Colombo", IST},
            {"Asia/Dacca", BDT},
            {"Asia/Dhaka", BDT},
            {"Asia/Dili", new String[] {"Timor-Leste, normaltid", "TLT",
                                        "Timor-Leste, sommartid", "TLST"}},
            {"Asia/Damascus", EET},
            {"Asia/Dubai", GST},
            {"Asia/Dushanbe", new String[] {"Tadzjikistan, normaltid", "TJT",
                                            "Tadzjikistan, sommartid", "TJST"}},
            {"Asia/Gaza", EET},
            {"Asia/Harbin", CTT},
            {"Asia/Ho_Chi_Minh", ICT},
            {"Asia/Hong_Kong", HKT},
            {"Asia/Hovd", new String[] {"Hovd, normaltid", "HOVT",
                                        "Hovd, sommartid", "HOVST"}},
            {"Asia/Irkutsk", new String[] {"Irkutsk, normaltid", "IRKT",
                                           "Irkutsk, sommartid", "IRKST"}},
            {"Asia/Istanbul", EET},
            {"Asia/Jakarta", WIT},
            {"Asia/Jayapura", new String[] {"\u00d6stindonesisk tid", "EIT",
                                            "\u00d6stindonesisk sommartid", "EIST"}},
            {"Asia/Kabul", new String[] {"Afghanistan, normaltid", "AFT",
                                         "Afghanistan, sommartid", "AFST"}},
            {"Asia/Kamchatka", new String[] {"Petropavlovsk-Kamtjatka, normaltid", "PETT",
                                             "Petropavlovsk-Kamtjatka, sommartid", "PETST"}},
            {"Asia/Karachi", PKT},
            {"Asia/Kashgar", CTT},
            {"Asia/Kathmandu", NPT},
            {"Asia/Katmandu", NPT},
            {"Asia/Kolkata", IST},
            {"Asia/Krasnoyarsk", new String[] {"Krasnojarsk, normaltid", "KRAT",
                                               "Krasnojarsk, sommartid", "KRAST"}},
            {"Asia/Kuala_Lumpur", MYT},
            {"Asia/Kuching", MYT},
            {"Asia/Kuwait", ARAST},
            {"Asia/Macao", CTT},
            {"Asia/Macau", CTT},
            {"Asia/Magadan", new String[] {"Magadan, normaltid", "MAGT",
                                           "Magadan, sommartid", "MAGST"}},
            {"Asia/Makassar", CIT},
            {"Asia/Manila", new String[] {"Filippinerna, normaltid", "PHT",
                                          "Filippinerna, sommartid", "PHST"}},
            {"Asia/Muscat", GST},
            {"Asia/Nicosia", EET},
            {"Asia/Novokuznetsk", NOVT},
            {"Asia/Novosibirsk", NOVT},
            {"Asia/Oral", new String[] {"Oral, normaltid", "ORAT",
                                        "Oral, sommartid", "ORAST"}},
            {"Asia/Omsk", new String[] {"Omsk, normaltid", "OMST",
                                        "Omsk, sommartid", "OMSST"}},
            {"Asia/Phnom_Penh", ICT},
            {"Asia/Pontianak", WIT},
            {"Asia/Pyongyang", KST},
            {"Asia/Qatar", ARAST},
            {"Asia/Qyzylorda", new String[] {"Qyzylorda, normaltid", "QYZT",
                                             "Qyzylorda, sommartid", "QYZST"}},
            {"Asia/Rangoon", new String[] {"Myanmar, normaltid", "MMT",
                                           "Myanmar, sommartid", "MMST"}},
            {"Asia/Riyadh", ARAST},
            {"Asia/Saigon", ICT},
            {"Asia/Sakhalin", new String[] {"Sakhalin, normaltid", "SAKT",
                                            "Sakhalin, sommartid", "SAKST"}},
            {"Asia/Samarkand", UZT},
            {"Asia/Seoul", KST},
            {"Asia/Singapore", SGT},
            {"Asia/Taipei", CTT},
            {"Asia/Tel_Aviv", ISRAEL},
            {"Asia/Tashkent", UZT},
            {"Asia/Tbilisi", new String[] {"Georgien, normaltid", "GET",
                                           "Georgien, sommartid", "GEST"}},
            {"Asia/Tehran", IRT},
            {"Asia/Thimbu", BTT},
            {"Asia/Thimphu", BTT},
            {"Asia/Ujung_Pandang", CIT},
            {"Asia/Ulaanbaatar", ULAT},
            {"Asia/Ulan_Bator", ULAT},
            {"Asia/Urumqi", CTT},
            {"Asia/Vientiane", ICT},
            {"Asia/Vladivostok", new String[] {"Vladivostok, normaltid", "VLAT",
                                               "Vladivostok, sommartid", "VLAST"}},
            {"Asia/Yakutsk", new String[] {"Jakutsk, normaltid", "YAKT",
                                           "Jakutsk, sommartid", "YAKST"}},
            {"Asia/Yekaterinburg", new String[] {"Jekaterinburg, normaltid", "YEKT",
                                                 "Jekaterinburg, sommartid", "YEKST"}},
            {"Asia/Yerevan", ARMT},
            {"Atlantic/Azores", new String[] {"Azorerna, normaltid", "AZOT",
                                              "Azorerna, sommartid", "AZOST"}},
            {"Atlantic/Bermuda", AST},
            {"Atlantic/Canary", WET},
            {"Atlantic/Cape_Verde", new String[] {"Kap Verde, normaltid", "CVT",
                                                  "Kap Verde, sommartid", "CVST"}},
            {"Atlantic/Faeroe", WET},
            {"Atlantic/Faroe", WET},
            {"Atlantic/Jan_Mayen", CET},
            {"Atlantic/Madeira", WET},
            {"Atlantic/Reykjavik", GMT},
            {"Atlantic/South_Georgia", new String[] {"Sydgeorgien, normaltid", "GST",
                                                     "Sydgeorgien, sommartid", "GDT"}},
            {"Atlantic/St_Helena", GMT},
            {"Atlantic/Stanley", new String[] {"Falklands\u00f6arna, normaltid", "FKT",
                                               "Falklands\u00f6arna, sommartid", "FKST"}},
            {"Australia/ACT", EST_NSW},
            {"Australia/Adelaide", ADELAIDE},
            {"Australia/Brisbane", BRISBANE},
            {"Australia/Broken_Hill", BROKEN_HILL},
            {"Australia/Canberra", EST_NSW},
            {"Australia/Currie", EST_NSW},
            {"Australia/Darwin", DARWIN},
            {"Australia/Eucla", new String[] {"Central Western Standard Time (Australia)", "CWST",
                                              "Central Western Summer Time (Australia)", "CWST"}},
            {"Australia/Hobart", TASMANIA},
            {"Australia/LHI", LORD_HOWE},
            {"Australia/Lindeman", BRISBANE},
            {"Australia/Lord_Howe", LORD_HOWE},
            {"Australia/Melbourne", VICTORIA},
            {"Australia/North", DARWIN},
            {"Australia/NSW", EST_NSW},
            {"Australia/Perth", WST_AUS},
            {"Australia/Queensland", BRISBANE},
            {"Australia/South", ADELAIDE},
            {"Australia/Sydney", EST_NSW},
            {"Australia/Tasmania", TASMANIA},
            {"Australia/Victoria", VICTORIA},
            {"Australia/West", WST_AUS},
            {"Australia/Yancowinna", BROKEN_HILL},
            {"BET", BRT},
            {"BST", BDT},
            {"Brazil/Acre", AMT},
            {"Brazil/DeNoronha", NORONHA},
            {"Brazil/East", BRT},
            {"Brazil/West", AMT},
            {"Canada/Atlantic", AST},
            {"Canada/Central", CST},
            {"Canada/East-Saskatchewan", CST},
            {"Canada/Eastern", EST},
            {"Canada/Mountain", MST},
            {"Canada/Newfoundland", NST},
            {"Canada/Pacific", PST},
            {"Canada/Yukon", PST},
            {"Canada/Saskatchewan", CST},
            {"CAT", CAT},
            {"CET", CET},
            {"Chile/Continental", CLT},
            {"Chile/EasterIsland", EASTER},
            {"CST6CDT", CST},
            {"Cuba", CUBA},
            {"EAT", EAT},
            {"EET", EET},
            {"Egypt", EET},
            {"Eire", DUBLIN},
            {"EST5EDT", EST},
            {"Etc/Greenwich", GMT},
            {"Etc/UCT", UTC},
            {"Etc/Universal", UTC},
            {"Etc/UTC", UTC},
            {"Etc/Zulu", UTC},
            {"Europe/Amsterdam", CET},
            {"Europe/Andorra", CET},
            {"Europe/Athens", EET},
            {"Europe/Belfast", GMTBST},
            {"Europe/Belgrade", CET},
            {"Europe/Berlin", CET},
            {"Europe/Bratislava", CET},
            {"Europe/Brussels", CET},
            {"Europe/Budapest", CET},
            {"Europe/Chisinau", EET},
            {"Europe/Copenhagen", CET},
            {"Europe/Dublin", DUBLIN},
            {"Europe/Gibraltar", CET},
            {"Europe/Guernsey", GMTBST},
            {"Europe/Helsinki", EET},
            {"Europe/Isle_of_Man", GMTBST},
            {"Europe/Istanbul", EET},
            {"Europe/Jersey", GMTBST},
            {"Europe/Kaliningrad", EET},
            {"Europe/Kiev", EET},
            {"Europe/Lisbon", WET},
            {"Europe/Ljubljana", CET},
            {"Europe/London", GMTBST},
            {"Europe/Luxembourg", CET},
            {"Europe/Madrid", CET},
            {"Europe/Malta", CET},
            {"Europe/Mariehamn", EET},
            {"Europe/Minsk", EET},
            {"Europe/Monaco", CET},
            {"Europe/Moscow", MSK},
            {"Europe/Nicosia", EET},
            {"Europe/Oslo", CET},
            {"Europe/Podgorica", CET},
            {"Europe/Prague", CET},
            {"Europe/Riga", EET},
            {"Europe/Rome", CET},
            {"Europe/Samara", new String[] {"Samara, normaltid", "SAMT",
                                            "Samara, sommartid", "SAMST"}},
            {"Europe/San_Marino", CET},
            {"Europe/Sarajevo", CET},
            {"Europe/Simferopol", EET},
            {"Europe/Skopje", CET},
            {"Europe/Sofia", EET},
            {"Europe/Stockholm", CET},
            {"Europe/Tallinn", EET},
            {"Europe/Tirane", CET},
            {"Europe/Tiraspol", EET},
            {"Europe/Uzhgorod", EET},
            {"Europe/Vaduz", CET},
            {"Europe/Vatican", CET},
            {"Europe/Vienna", CET},
            {"Europe/Vilnius", EET},
            {"Europe/Volgograd", new String[] {"Volgograd-tid", "VOLT",
                                               "Volgograd, sommartid", "VOLST"}},
            {"Europe/Warsaw", CET},
            {"Europe/Zagreb", CET},
            {"Europe/Zaporozhye", EET},
            {"Europe/Zurich", CET},
            {"GB", GMTBST},
            {"GB-Eire", GMTBST},
            {"Greenwich", GMT},
            {"Hongkong", HKT},
            {"Iceland", GMT},
            {"Iran", IRT},
            {"IST", IST},
            {"Indian/Antananarivo", EAT},
            {"Indian/Chagos", new String[] {"Indiska oceanen, normaltid", "IOT",
                                            "Indiska oceanen, sommartid", "IOST"}},
            {"Indian/Christmas", new String[] {"Jul\u00f6n, normaltid", "CXT",
                                               "Jul\u00f6n, sommartid", "CXST"}},
            {"Indian/Cocos", new String[] {"Cocos-Keeling\u00f6arna, normaltid", "CCT",
                                           "Cocos-Keeling\u00f6arna, sommartid", "CCST"}},
            {"Indian/Comoro", EAT},
            {"Indian/Kerguelen", new String[] {"Franska s\u00f6dra och antarktiska omr\u00e5dena, normaltid", "TFT",
                                               "Franska s\u00f6dra och antarktiska omr\u00e5dena, sommartid", "TFST"}},
            {"Indian/Mahe", new String[] {"Seychellerna, normaltid", "SCT",
                                          "Seychellerna, sommartid", "SCST"}},
            {"Indian/Maldives", new String[] {"Maldiverna, normaltid", "MVT",
                                              "Maldiverna, sommartid", "MVST"}},
            {"Indian/Mauritius", new String[] {"Mauritius, normaltid", "MUT",
                                               "Mauritius, sommartid", "MUST"}},
            {"Indian/Mayotte", EAT},
            {"Indian/Reunion", new String[] {"Reunion, normaltid", "RET",
                                             "Reunion, sommartid", "REST"}},
            {"Israel", ISRAEL},
            {"Jamaica", EST},
            {"Japan", JST},
            {"Kwajalein", MHT},
            {"Libya", EET},
            {"MET", new String[] {"Mellaneuropeisk tid", "MET",
                                  "Mellaneuropeisk sommartid", "MEST"}},
            {"Mexico/BajaNorte", PST},
            {"Mexico/BajaSur", MST},
            {"Mexico/General", CST},
            {"MIT", WST_SAMOA},
            {"MST7MDT", MST},
            {"Navajo", MST},
            {"NET", ARMT},
            {"NST", NZST},
            {"NZ", NZST},
            {"NZ-CHAT", CHAST},
            {"PLT", PKT},
            {"Portugal", WET},
            {"PRT", AST},
            {"Pacific/Apia", WST_SAMOA},
            {"Pacific/Auckland", NZST},
            {"Pacific/Chatham", CHAST},
            {"Pacific/Easter", EASTER},
            {"Pacific/Efate", new String[] {"Vanuatu, normaltid", "VUT",
                                            "Vanuatu, sommartid", "VUST"}},
            {"Pacific/Enderbury", new String[] {"Phoenix-\u00f6arna, normaltid", "PHOT",
                                                "Phoenix-\u00f6arna, sommartid", "PHOST"}},
            {"Pacific/Fakaofo", new String[] {"Tokelau, normaltid", "TKT",
                                              "Tokelau, sommartid", "TKST"}},
            {"Pacific/Fiji", new String[] {"Fiji, normaltid", "FJT",
                                           "Fiji, sommartid", "FJST"}},
            {"Pacific/Funafuti", new String[] {"Tuvalu, normaltid", "TVT",
                                               "Tuvalu, sommartid", "TVST"}},
            {"Pacific/Galapagos", new String[] {"Galapagos, normaltid", "GALT",
                                                "Galapagos, sommartid", "GALST"}},
            {"Pacific/Gambier", GAMBIER},
            {"Pacific/Guadalcanal", SBT},
            {"Pacific/Guam", ChST},
            {"Pacific/Johnston", HST},
            {"Pacific/Kiritimati", new String[] {"Line-\u00f6arna, normaltid", "LINT",
                                                 "Line-\u00f6arna, sommartid", "LINST"}},
            {"Pacific/Kosrae", new String[] {"Kosrae, normaltid", "KOST",
                                             "Kosrae, sommartid", "KOSST"}},
            {"Pacific/Kwajalein", MHT},
            {"Pacific/Majuro", MHT},
            {"Pacific/Marquesas", new String[] {"Marquesas, normaltid", "MART",
                                                "Marquesas, sommartid", "MARST"}},
            {"Pacific/Midway", SAMOA},
            {"Pacific/Nauru", new String[] {"Nauru, normaltid", "NRT",
                                            "Nauru, sommartid", "NRST"}},
            {"Pacific/Niue", new String[] {"Niue, normaltid", "NUT",
                                           "Niue, sommartid", "NUST"}},
            {"Pacific/Norfolk", new String[] {"Norfolk, normaltid", "NFT",
                                              "Norfolk, sommartid", "NFST"}},
            {"Pacific/Noumea", new String[] {"Nya Caledonien, normaltid", "NCT",
                                             "Nya Caledonien, sommartid", "NCST"}},
            {"Pacific/Pago_Pago", SAMOA},
            {"Pacific/Palau", new String[] {"Palau, normaltid", "PWT",
                                            "Palau, sommartid", "PWST"}},
            {"Pacific/Pitcairn", PITCAIRN},
            {"Pacific/Ponape", new String[] {"Ponape, normaltid", "PONT",
                                             "Ponape, sommartid", "PONST"}},
            {"Pacific/Port_Moresby", new String[] {"Papua Nya Guinea, normaltid", "PGT",
                                                   "Papua Nya Guinea, sommartid", "PGST"}},
            {"Pacific/Rarotonga", new String[] {"Cook\u00f6arna, normaltid", "CKT",
                                                "Cook\u00f6arna, sommartid", "CKHST"}},
            {"Pacific/Saipan", ChST},
            {"Pacific/Samoa", SAMOA},
            {"Pacific/Tahiti", new String[] {"Tahiti, normaltid", "TAHT",
                                             "Tahiti, sommartid", "TAHST"}},
            {"Pacific/Tarawa", new String[] {"Gilbert\u00f6arna, normaltid", "GILT",
                                             "Gilbert\u00f6arna, sommartid", "GILST"}},
            {"Pacific/Tongatapu", new String[] {"Tonga, normaltid", "TOT",
                                                "Tonga, sommartid", "TOST"}},
            {"Pacific/Truk", TRUT},
            {"Pacific/Wake", new String[] {"Wake, normaltid", "WAKT",
                                           "Wake, sommartid", "WAKST"}},
            {"Pacific/Wallis", new String[] {"Wallis & Futuna, normaltid", "WFT",
                                             "Wallis & Futuna, sommartid", "WFST"}},
            {"Pacific/Yap", TRUT},
            {"Poland", CET},
            {"PRC", CTT},
            {"PST8PDT", PST},
            {"ROK", KST},
            {"Singapore", SGT},
            {"SST", SBT},
            {"SystemV/AST4", AST},
            {"SystemV/AST4ADT", AST},
            {"SystemV/CST6", CST},
            {"SystemV/CST6CDT", CST},
            {"SystemV/EST5", EST},
            {"SystemV/EST5EDT", EST},
            {"SystemV/HST10", HST},
            {"SystemV/MST7", MST},
            {"SystemV/MST7MDT", MST},
            {"SystemV/PST8", PST},
            {"SystemV/PST8PDT", PST},
            {"SystemV/YST9", AKST},
            {"SystemV/YST9YDT", AKST},
            {"Turkey", EET},
            {"UCT", UTC},
            {"Universal", UTC},
            {"US/Alaska", AKST},
            {"US/Aleutian", HAST},
            {"US/Arizona", MST},
            {"US/Central", CST},
            {"US/Eastern", EST},
            {"US/Hawaii", HST},
            {"US/Indiana-Starke", CST},
            {"US/East-Indiana", EST},
            {"US/Michigan", EST},
            {"US/Mountain", MST},
            {"US/Pacific", PST},
            {"US/Pacific-New", PST},
            {"US/Samoa", SAMOA},
            {"UTC", UTC},
            {"VST", ICT},
            {"W-SU", MSK},
            {"WET", WET},
            {"Zulu", UTC},
        };
    }
}
