/*************************************************************************
 *
 *  $RCSfile: filesource.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:16:51 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <plugin/filesource.hxx>

#include <tools/fastfsys.hxx>


SMART_UNO_IMPLEMENTATION( FileSource, UsrObject )

FileSource::FileSource( const char* FileName )
{
// !wird wieder rausgenommen!
	ItemIDPath aPath( FileName );
	fp = fopen( aPath.GetHostNotationPath().GetStr()/*FileName*/, "rb" );
}

FileSource::~FileSource()
{
	if( fp )
		fclose( fp );
}

// automatisch auskommentiert - [getIdlClass(es) or queryInterface] - Bitte XTypeProvider benutzen!
//sal_Bool FileSource::queryInterface( ::com::sun::star::uno::Uik aUik, ::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface > & rOut )

{
	if( aUik == ::getCppuType((const Reference< ::com::sun::star::sdbc::XDataSource >*)0) )
		rOut = (::com::sun::star::sdbc::XDataSource*)this;
	else
// automatisch auskommentiert - [getIdlClass(es) or queryInterface] - Bitte XTypeProvider benutzen!
//		return UsrObject::queryInterface( aUik, rOut );

	
	return sal_True;
}

void FileSource::addSourceControllerListener( const ::com::sun::star::uno::Reference< XStreamConnectionListener > & Listener )
{
	if( m_xListener.is() )
		fprintf( stderr, "Warning: addSourceControllerListener called when already having a listener\n" );
	m_xListener = Listener;
}

void FileSource::removeSourceControllerListener( const ::com::sun::star::uno::Reference< XStreamConnectionListener > & Listener )
{
	m_xListener = ::com::sun::star::uno::Reference< XStreamConnectionListener > ();
}

void FileSource::setDataSink( const ::com::sun::star::uno::Reference< XDataSink > & Listener )
{
	m_xSink = Listener;
	startWriting();
}

void FileSource::startWriting()
{
	if( ! fp )
		return;

	sal_uInt32 nSize = 65536;
	sal_Int8  *pbuf = new sal_Int8 [nSize];

	int nBytes;
	while( nBytes = fread( pbuf, 1, nSize, fp ) )
	{
		m_xSink->write( ::com::sun::star::uno::Sequence<sal_Int8>( pbuf, nBytes ) );
	}
	if( m_xListener.is() )
            m_xListener->connectionClosed( StreamConnectionEvent() );

	delete [] pbuf;
}

void FileSource::open()
{
}

void FileSource::close()
{
	m_xSink = ::com::sun::star::uno::Reference< XDataSink > ();
}

