/*************************************************************************
 *
 *  $RCSfile: daemon.c,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: jl $ $Date: 2001/03/14 09:48:11 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <osl/diagnose.h>
#include <osl/daemon.h>
#include <osl/thread.h>
#include <osl/conditn.h>

#ifndef _OSL_TIME_H_
#include <osl/time.h>
#endif

#include "../all/daemclie.h"

/*****************************************************************************/
/* osl_accessDaemonManager */
/*****************************************************************************/
sal_Bool osl_accessDaemonManager()
{
	return(osl_default_accessDaemonManager());
}	

/*****************************************************************************/
/* osl_queryDaemonCount */
/*****************************************************************************/

oslDaemonManagerError SAL_CALL osl_queryDaemonCount(sal_uInt32* pCount)
{
	return(osl_default_queryDaemonCount(pCount));
}	

/*****************************************************************************/
/* osl_queryDaemonIdentifier */
/*****************************************************************************/

oslDaemonManagerError SAL_CALL osl_queryDaemonIdentifier(sal_uInt32 index, sal_Char* buffer, sal_uInt32 sizeOfBuffer)
{
	return(osl_default_queryDaemonIdentifier(index, buffer, sizeOfBuffer));
}	

/*****************************************************************************/
/* osl_isDaemonInstalled */
/*****************************************************************************/
oslDaemonManagerError SAL_CALL osl_isDaemonInstalled(const sal_Char* Identifier, sal_Bool* pRet)
{
	return(osl_default_isDaemonInstalled(Identifier, pRet));
}

/*****************************************************************************/
/* osl_queryDaemonStatus */
/*****************************************************************************/

oslDaemonManagerError SAL_CALL osl_queryDaemonStatus(const sal_Char* pszIdentifier, oslDaemonStatus* pStatus)
{
	return(osl_default_queryDaemonStatus(pszIdentifier, pStatus));
}	

/*****************************************************************************/
/* osl_queryDaemonInfo */
/*****************************************************************************/

oslDaemonManagerError SAL_CALL osl_queryDaemonInfo(const sal_Char* pszIdentifier, oslDaemonInfo* pInfo)
{
	return(osl_default_queryDaemonInfo(pszIdentifier, pInfo));
}	


/*****************************************************************************/
/* osl_startDaemon */
/*****************************************************************************/

oslDaemonManagerError SAL_CALL osl_startDaemon(const sal_Char* pszIdentifier)
{
	return(osl_default_startDaemon(pszIdentifier));
}	

/*****************************************************************************/
/* osl_stopDaemon */
/*****************************************************************************/

oslDaemonManagerError SAL_CALL osl_stopDaemon(const sal_Char* pszIdentifier)
{
	return(osl_default_stopDaemon(pszIdentifier));
}	

/*****************************************************************************/
/* osl_pauseDaemon */
/*****************************************************************************/

oslDaemonManagerError SAL_CALL osl_pauseDaemon(const sal_Char* pszIdentifier)
{
	return(osl_default_pauseDaemon(pszIdentifier));
}	

/*****************************************************************************/
/* osl_pauseDaemon */
/*****************************************************************************/

oslDaemonManagerError SAL_CALL osl_continueDaemon(const sal_Char* pszIdentifier)
{
	return(osl_default_continueDaemon(pszIdentifier));
}	

/*****************************************************************************/
/* osl_installDaemon */
/*****************************************************************************/

oslDaemonManagerError SAL_CALL osl_installDaemon(const oslDaemonInfo* pInfo)
{
	return(osl_default_installDaemon(pInfo));
}	

/*****************************************************************************/
/* osl_uninstallDaemon */
/*****************************************************************************/

oslDaemonManagerError SAL_CALL osl_uninstallDaemon(const sal_Char* Identifier)
{
	return(osl_default_uninstallDaemon(Identifier));
}	

/*****************************************************************************/
/* osl_createDaemon */
/*****************************************************************************/

oslDaemonManagerError SAL_CALL osl_createDaemon(const sal_Char* pszIdentifier,
						   		  	   oslDaemonControl pControl, 
						  		  	   void* pControlData,
									   oslDaemonPropertyAccess* pPropertyAccess,
						  		  	   void* pAccessData,
						  		  	   oslDaemonHandle* pHandle)
{
	return(osl_default_createDaemon(pszIdentifier,
						   		  	pControl, 
						  		  	pControlData,
									pPropertyAccess,
						  		  	pAccessData,
						  		  	pHandle));
}	

/*****************************************************************************/
/* osl_executeDaemon */
/*****************************************************************************/

oslDaemonManagerError SAL_CALL osl_executeDaemon(oslDaemonHandle handle)
{
	return(osl_default_executeDaemon(handle));
}	

/*****************************************************************************/
/* osl_executeDaemons */
/*****************************************************************************/

oslDaemonManagerError SAL_CALL osl_executeDaemons(oslDaemonHandle* pHandle, sal_uInt32 numOfDaemons)
{
	return(osl_default_executeDaemons(pHandle, numOfDaemons));
}	


/*****************************************************************************/
/* osl_setDaemonStatus */
/*****************************************************************************/

oslDaemonManagerError SAL_CALL osl_setDaemonStatus(oslDaemonHandle handle, oslDaemonStatus Status)
{
	return(osl_default_setDaemonStatus(handle, Status));
}	

/*****************************************************************************/
/* osl_endDaemon */
/*****************************************************************************/

oslDaemonManagerError SAL_CALL osl_endDaemon(oslDaemonHandle handle)
{
	return(osl_default_endDaemon(handle));
}	

/*****************************************************************************/
/* osl_getDaemonPropertyCount */
/*****************************************************************************/

oslDaemonManagerError SAL_CALL osl_getDaemonPropertyCount(const sal_Char* pszIdentifier, sal_uInt32* pCount)
{
	return(osl_default_getDaemonPropertyCount(pszIdentifier, pCount));
}	

/*****************************************************************************/
/* osl_getDaemonProperties */
/*****************************************************************************/

oslDaemonManagerError SAL_CALL osl_getDaemonProperties(const sal_Char* pszIdentifier, 
											  oslDaemonProperty** ppProps, 
											  sal_uInt32* pCount)
{
	return(osl_default_getDaemonProperties(pszIdentifier, 
										   ppProps, 
										   pCount));
}	

/*****************************************************************************/
/* osl_setDaemonProperties */
/*****************************************************************************/

oslDaemonManagerError SAL_CALL osl_setDaemonProperties(const sal_Char* pszIdentifier, 
											  oslDaemonProperty* pProps, 
											  sal_uInt32 count, 
											  sal_uInt32* pErrorCode, 
											  sal_Char* errorBuffer, 
											  sal_uInt32 sizeOfBuffer)
{
	return(osl_default_setDaemonProperties(pszIdentifier, 
										   pProps, 
										   count, 
										   pErrorCode, 
										   errorBuffer, 
										   sizeOfBuffer));
}	


/*****************************************************************************/
/* osl_getDaemonProfileSections */
/*****************************************************************************/

oslDaemonManagerError SAL_CALL osl_getDaemonProfileSections(const sal_Char* pszIdentifier, 
												   sal_Char* buffer, 
												   sal_uInt32 bufferSize,
												   sal_uInt32* pRequiredSize)
{
	return(osl_default_getDaemonProfileSections(pszIdentifier, 
												buffer, 
												bufferSize,
												pRequiredSize));
}	

/*****************************************************************************/
/* osl_getDaemonProfileEntries */
/*****************************************************************************/

oslDaemonManagerError SAL_CALL osl_getDaemonProfileEntries(const sal_Char* pszIdentifier, 
												  const sal_Char* section, 
												  sal_Char* buffer, 
												  sal_uInt32 bufferSize,
												  sal_uInt32* pRequiredSize)
{
	return(osl_default_getDaemonProfileEntries(pszIdentifier, 
											   section, 
											   buffer, 
											   bufferSize,
											   pRequiredSize));
}	

/*****************************************************************************/
/* osl_readDaemonProfileString */
/*****************************************************************************/

oslDaemonManagerError SAL_CALL osl_readDaemonProfileString(const sal_Char* pszIdentifier, 
												  const sal_Char* section, 
												  const sal_Char* entry, 
												  sal_Char* buffer, 
												  sal_uInt32 bufferSize, 
												  const sal_Char* defaultValue)
{
	return(osl_default_readDaemonProfileString(pszIdentifier, 
											   section, 
											   entry, 
											   buffer, 
											   bufferSize, 
											   defaultValue));
}	

/*****************************************************************************/
/* osl_readDaemonProfileBool */
/*****************************************************************************/

oslDaemonManagerError SAL_CALL osl_readDaemonProfileBool(const sal_Char* pszIdentifier, 
												const sal_Char* section, 
												const sal_Char* entry, 
												sal_Bool* pValue, 
												sal_Bool defaultValue)
{
	return(osl_default_readDaemonProfileBool(pszIdentifier, 
											 section, 
											 entry, 
											 pValue, 
											 defaultValue));
}	

/*****************************************************************************/
/* osl_readDaemonProfileIdent */
/*****************************************************************************/

oslDaemonManagerError SAL_CALL osl_readDaemonProfileIdent(const sal_Char* pszIdentifier, 
												 const sal_Char* section, 
												 const sal_Char* entry, 
												 sal_uInt32* pValue, 
												 sal_uInt32 firstId, 
												 const sal_Char* strings[], 
												 sal_uInt32 defaultValue)
{
	return(osl_default_readDaemonProfileIdent(pszIdentifier, 
											  section, 
											  entry, 
											  pValue, 
											  firstId, 
											  strings, 
											  defaultValue));
}	

/*****************************************************************************/
/* osl_writeDaemonProfileString */
/*****************************************************************************/

oslDaemonManagerError SAL_CALL osl_writeDaemonProfileString(const sal_Char* pszIdentifier, 
												   const sal_Char* section, 
												   const sal_Char* entry, 
												   const sal_Char* value)
{
	return(osl_default_writeDaemonProfileString(pszIdentifier, 
												section, 
												entry, 
												value));
}	

/*****************************************************************************/
/* osl_writeDaemonProfileBool */
/*****************************************************************************/

oslDaemonManagerError SAL_CALL osl_writeDaemonProfileBool(const sal_Char* pszIdentifier, 
												 const sal_Char* section, 
												 const sal_Char* entry, 
												 sal_Bool value)
{
	return(osl_default_writeDaemonProfileBool(pszIdentifier, 
											  section, 
											  entry, 
											  value));
}	

/*****************************************************************************/
/* osl_writeDaemonProfileIdent */
/*****************************************************************************/

oslDaemonManagerError SAL_CALL osl_writeDaemonProfileIdent(const sal_Char* pszIdentifier, 
												  const sal_Char* section, 
												  const sal_Char* entry, 
												  sal_uInt32 value, 
												  sal_uInt32 firstId, 
												  const sal_Char* strings[])
{
	return(osl_default_writeDaemonProfileIdent(pszIdentifier, 
											   section, 
											   entry, 
											   value, 
											   firstId, 
											   strings));
}	

/*****************************************************************************/
/* osl_removeDaemonProfileEntry */
/*****************************************************************************/

oslDaemonManagerError SAL_CALL osl_removeDaemonProfileEntry(const sal_Char* pszIdentifier, 
												   const sal_Char* section, 
												   const sal_Char* entry)
{
	return(osl_default_removeDaemonProfileEntry(pszIdentifier, 
												section, 
												entry));
}	

oslDaemonManagerError SAL_CALL osl_queryDaemonChanges(TimeValue* pSince, sal_Bool* pBChanged)
{
	return(osl_default_queryDaemonChanges(pSince, pBChanged));
}	

