/*************************************************************************
 *
 *  $RCSfile: SchRangeChecker.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: af $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

/**	$Revision  
	@descr A RangeChecker has the task to test if the y value range of a given 
		data set complies with a given chart type.
	
	@author
		Andre Fischer (af)
*/

#include	<SchRangeChecker.hxx>

#include	<chaxis.hxx>
#include	<chtmodel.hxx>


SchRangeChecker::SchRangeChecker		(ChartModel * pChartModel)
	:	mpChartModel (pChartModel)	
{
	//	We have to determine minimum and maximum values of the data set here, 
	//	because the values returned by the y-axis are not sufficient.
	
	long	nColCount = pChartModel->GetColCount(),
			nRowCount = pChartModel->GetRowCount(),
			nCol,
			nRow;
	double	fVal;
				
	if ((nColCount <= 0) || (nRowCount <= 0))
	{
		//	Use default values if we have no data.
		mfMin = mfMax = 0;
	}
	else
	{
		mfMin = mfMax = pChartModel->GetData (0,0);
		//	Just iterate over all data points.
		for (nCol=0; nCol<nColCount; nCol++)
			for (nRow=0; nRow<nRowCount; nRow++)
			{
				fVal = pChartModel->GetData (nCol,nRow);
				if (fVal < mfMin)
					mfMin = fVal;
				if (fVal > mfMax)
					mfMax = fVal;
			}
	}
}


	
SchRangeChecker::~SchRangeChecker	(void)	
{
}



BOOL	SchRangeChecker::TestAbsoluteValues	(SvxChartStyle eChartStyle)
{
	return (	(mfMin < 0.0)
			&&	(mfMax > 0.0) 
			&&	( ! mpChartModel->IsSignedChart(&eChartStyle))	);
}



BOOL	SchRangeChecker::TestNegativeValues	(SvxChartStyle eChartStyle)
{
	return (	(mfMin < 0.0)
			&&	( ! mpChartModel->IsNegativeChart(&eChartStyle))	);
}



BOOL	SchRangeChecker::TestLogarithmicValues	(void)
{
	return (	(mfMin <= 0.0)
			&&	((const SfxBoolItem&)mpChartModel->GetAttr(CHOBJID_DIAGRAM_Y_AXIS).Get(
						SCHATTR_AXIS_LOGARITHM)).GetValue());
}
