/*************************************************************************
 *
 *  $RCSfile: outlnvsh.hxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/24 17:05:37 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SD_OUTLNVSH_HXX
#define _SD_OUTLNVSH_HXX

#ifndef _SD_DOCSHELL_HXX
#include "docshell.hxx"
#endif
#ifndef _SD_VIEWSHEL_HXX
#include "viewshel.hxx"
#endif
#ifndef _SD_OUTLVIEW_HXX
#include "outlview.hxx"
#endif

class SdPage;
class TransferableDataHelper;
class TransferableClipboardListener;
class SdUnoOutlineView;

/*************************************************************************
|*
|* Viewshell fuer Outline-Modus
|*
\************************************************************************/

class SdOutlineViewShell : public SdViewShell
{
	SdOutlineView*	pOlView;
	SdPage*			pLastPage; // Zur performanten Aufbereitung der Preview
	TransferableClipboardListener* pClipEvtLstnr;
	BOOL			bPastePossible;

	void	Construct(SdDrawDocShell* pDocSh);
	DECL_LINK( ClipboardChanged, TransferableDataHelper* );

	SdUnoOutlineView*	pController;

 protected:
	virtual SvxRuler* CreateHRuler(SdWindow* pWin, BOOL bIsFirst);
	virtual void UpdateHRuler();

	virtual void InnerResizePixel(const Point &rPos, const Size &rSize);
	virtual void OuterResizePixel(const Point &rPos, const Size &rSize);
	virtual Size GetOptimalSizePixel() const;

	// Methoden, die fuer die Preview gebraucht werden
	virtual void  UpdatePreview( SdPage* pPage, BOOL bInit = FALSE );
	BOOL		  UpdateTitleObject( SdPage* pPage, Paragraph* pPara );
	BOOL		  UpdateLayoutObject( SdPage* pPage, Paragraph* pPara );

 public:
	TYPEINFO();

	SFX_DECL_VIEWFACTORY(SdOutlineViewShell);
	SFX_DECL_INTERFACE(SD_IF_SDOUTLINEVIEWSHELL);

	 SdOutlineViewShell(SfxViewFrame *pFrame, const SdOutlineViewShell& rShell);
	 SdOutlineViewShell(SfxViewFrame* pFrame, SfxViewShell* pOldShell);
	~SdOutlineViewShell();

	virtual void Paint(const Rectangle& rRect, SdWindow* pWin);

    /** Set the position and size of the area which contains the GUI
        elements like rulers, sliders, and buttons as well as the document
        view.  Both size and position are expected to be in pixel
        coordinates.  The positions and sizes of the mentioned GUI elements
        are updated as well.

        <p> This method is implemented by first setting copying the given
        values to internal variables and then calling the
        <type>ArrangeGUIElements</type> method which performs the actual
        work of sizeing and arranging the UI elements accordingly.</p>
        @param rPos
            The position of the enclosing window relative to the document
            window.  This is only interesting if a Draw/Impress document
            view is embedded as OLE object into another document view.  For
            normal documents this position is (0,0).
        @param rSize
            The new size in pixel.
    */
	virtual void AdjustPosSizePixel(const Point &rPos, const Size &rSize);

    /** Arrange and resize the GUI elements like rulers, sliders, and
        buttons as well as the actual document view according to the size of
        the enclosing window and current sizes of buttons, rulers, and
        sliders.
    */
    virtual void ArrangeGUIElements (void);

	virtual USHORT PrepareClose( BOOL bUI = TRUE, BOOL bForBrowsing = FALSE );

	virtual long VirtHScrollHdl(ScrollBar* pHScroll);
	virtual long VirtVScrollHdl(ScrollBar* pVHScroll);

	virtual void AddWindow(SdWindow* pWin) { pOlView->AddWin(pWin); }
	virtual void RemoveWindow(SdWindow* pWin) { pOlView->DelWin(pWin); }

	virtual void Activate( BOOL IsMDIActivate );
	virtual void Deactivate( BOOL IsMDIActivate );

	virtual SdPage*	GetActualPage();
	String			GetPageRangeString();

	void ExecCtrl(SfxRequest &rReq);
	void GetCtrlState(SfxItemSet &rSet);
	void GetMenuState(SfxItemSet &rSet);
	void GetAttrState(SfxItemSet &rSet);
    void GetState (SfxItemSet& rSet);

	void ExecStatusBar(SfxRequest& rReq);
	void GetStatusBarState(SfxItemSet& rSet);

	void FuTemporary(SfxRequest &rReq);
	void FuPermanent(SfxRequest &rReq);
	void FuSupport(SfxRequest &rReq);

	virtual void SetZoom(long nZoom);
	virtual void SetZoomRect(const Rectangle& rZoomRect);
	virtual String	GetSelectionText( BOOL bCompleteWords = FALSE );
	virtual BOOL    HasSelection( BOOL bText = TRUE ) const;

	void Execute(SfxRequest& rReq);

	virtual void ReadFrameViewData(FrameView* pView);
	virtual void WriteFrameViewData();

	virtual void Command( const CommandEvent& rCEvt, SdWindow* pWin );
	virtual BOOL KeyInput(const KeyEvent& rKEvt, SdWindow* pWin);
	virtual void MouseButtonUp(const MouseEvent& rMEvt, SdWindow* pWin);

	ULONG   Read(SvStream& rInput, USHORT eFormat);

    virtual void WriteUserDataSequence ( ::com::sun::star::uno::Sequence < ::com::sun::star::beans::PropertyValue >&, sal_Bool bBrowse = sal_False );
    virtual void ReadUserDataSequence ( const ::com::sun::star::uno::Sequence < ::com::sun::star::beans::PropertyValue >&, sal_Bool bBrowse = sal_False );

	/** this method is called when the visible area of the view from this viewshell is changed */
	virtual void VisAreaChanged(const Rectangle& rRect);

    /** Create an accessible object representing the specified window.
	    @param pWindow
	        The returned object makes the document displayed in this window
	        accessible.
        @return
	        Returns an <type>AccessibleDrawDocumentView</type> object.
   */
    virtual ::com::sun::star::uno::Reference<
        ::com::sun::star::accessibility::XAccessible>
        CreateAccessibleDocumentView (SdWindow* pWindow);

};



#endif		// _SD_OUTLNVSH_HXX

