/*************************************************************************
 *
 *  $RCSfile: tabarea.hxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: af $ $Date: 2002/11/22 14:49:35 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SVX_TAB_AREA_HXX
#define _SVX_TAB_AREA_HXX

// include ---------------------------------------------------------------

#ifndef _VALUESET_HXX //autogen
#include <svtools/valueset.hxx>
#endif
#ifndef _IMAGEBTN_HXX //autogen
#include <vcl/imagebtn.hxx>
#endif
#ifndef _FIXED_HXX //autogen
#include <vcl/fixed.hxx>
#endif
#include "xoutx.hxx"
#include "dlgctrl.hxx"

#ifndef _SVX_XSETITEM_HXX //autogen
#include <xsetit.hxx>
#endif

#ifndef SVX_XFILLIT0_HXX //autogen
#include <xfillit0.hxx>
#endif

#ifndef _SVX_FILLITEM_HXX //autogen
#include <xfillit.hxx>
#endif

// enum ------------------------------------------------------------------

enum ColorModel
{
	CM_RGB,
	CM_CMYK // kann um weitere Modelle, z.B. HSV erweitert werden
};

enum PageType
{
	PT_AREA,
	PT_GRADIENT,
	PT_HATCH,
	PT_BITMAP,
	PT_COLOR,
	PT_SHADOW,
	PT_TRANSPARENCE
};

// define ----------------------------------------------------------------

typedef USHORT ChangeType; // auch in tab_line.hxx (mitpflegen !!!)

#define CT_NONE                 ( (ChangeType) 0x0000 )
#define CT_MODIFIED             ( (ChangeType) 0x0001 )
#define CT_CHANGED              ( (ChangeType) 0x0002 )
#define CT_SAVED                ( (ChangeType) 0x0004 )

class SdrModel;
class SdrView;

/*************************************************************************
|*
|* Fl"achen-Tab-Dialog
|*
\************************************************************************/

class SvxAreaTabDialog : public SfxTabDialog
{
private:
	SdrModel*           pDrawModel;
	const SdrView*		pView;

	XColorTable*        pColorTab;
	XColorTable*        pNewColorTab;
	XGradientList*      pGradientList;
	XGradientList*      pNewGradientList;
	XHatchList*         pHatchingList;
	XHatchList*         pNewHatchingList;
	XBitmapList*        pBitmapList;
	XBitmapList*        pNewBitmapList;

	const SfxItemSet&   rOutAttrs;

	ChangeType          nColorTableState;
	ChangeType          nBitmapListState;
	ChangeType          nGradientListState;
	ChangeType          nHatchingListState;

	USHORT              nPageType;
	USHORT              nDlgType;
	USHORT              nPos;
	BOOL                bAreaTP;
	BOOL                bDeleteColorTable;

	virtual void        PageCreated( USHORT nId, SfxTabPage &rPage );

protected:
	virtual short       Ok();
#ifdef _SVX_TABAREA_CXX
	DECL_LINK( CancelHdl, void * );
	void                SavePalettes();
#endif

public:
	SvxAreaTabDialog( Window* pParent,
					  const SfxItemSet* pAttr, SdrModel* pModel,
					  const SdrView* pSdrView = NULL );
	~SvxAreaTabDialog();

	void            	 SetNewColorTable( XColorTable* pColTab )
							{ pNewColorTab = pColTab; }
	XColorTable*    	 GetNewColorTable() const { return pNewColorTab; }
	const XColorTable*	 GetColorTable() const { return pColorTab; }

	void            	 SetNewGradientList( XGradientList* pGrdLst)
							{ pNewGradientList = pGrdLst; }
	XGradientList*  	 GetNewGradientList() const
							{ return pNewGradientList; }
	const XGradientList* GetGradientList() const { return pGradientList; }

	void				 SetNewHatchingList( XHatchList* pHtchLst)
							{ pNewHatchingList = pHtchLst; }
	XHatchList*     	 GetNewHatchingList() const
							{ return pNewHatchingList; }
	const XHatchList*	 GetHatchingList() const { return pHatchingList; }

	void				 SetNewBitmapList( XBitmapList* pBmpLst)
							{ pNewBitmapList = pBmpLst; }
	XBitmapList*		 GetNewBitmapList() const { return pNewBitmapList; }
	const XBitmapList*	 GetBitmapList() const { return pBitmapList; }

	void				 DontDeleteColorTable() { bDeleteColorTable = FALSE; }
};

/*************************************************************************
|*
|* Transparence-Tab-Page
|*
\************************************************************************/

class SvxTransparenceTabPage : public SvxTabPage
{
	const SfxItemSet&   rOutAttrs;
	RECT_POINT          eRP;

	UINT16*             pPageType;
	UINT16*             pDlgType;

	// main selection
    FixedLine           aFlProp;
    RadioButton         aRbtTransOff;
    RadioButton         aRbtTransLinear;
	RadioButton         aRbtTransGradient;

	// linear transparency
	MetricField         aMtrTransparent;

	// gradient transparency
	FixedText           aFtTrgrType;
	ListBox             aLbTrgrGradientType;
	FixedText           aFtTrgrCenterX;
	MetricField         aMtrTrgrCenterX;
	FixedText           aFtTrgrCenterY;
	MetricField         aMtrTrgrCenterY;
	FixedText           aFtTrgrAngle;
	MetricField         aMtrTrgrAngle;
	FixedText           aFtTrgrBorder;
	MetricField         aMtrTrgrBorder;
	FixedText           aFtTrgrStartValue;
	MetricField         aMtrTrgrStartValue;
	FixedText           aFtTrgrEndValue;
	MetricField         aMtrTrgrEndValue;

	// preview
	SvxXRectPreview     aCtlBitmapPreview;
	SvxXRectPreview     aCtlXRectPreview;
	XOutputDevice       XOutBmp;
	XOutputDevice       XOut;
	BOOL				bBitmap;

	XOutdevItemPool*    pXPool;
	XFillAttrSetItem    aXFillAttr;
	SfxItemSet&         rXFSet;

#ifdef _SVX_TPAREA_CXX
	DECL_LINK(ClickTransOffHdl_Impl, void * );
	DECL_LINK(ClickTransLinearHdl_Impl, void * );
	DECL_LINK(ClickTransGradientHdl_Impl, void * );
	DECL_LINK(ModifyTransparentHdl_Impl, void*);
	DECL_LINK(ChangeTrgrTypeHdl_Impl, void*);
	DECL_LINK(ModifiedTrgrHdl_Impl, void*);
#endif

	void ActivateLinear(BOOL bActivate);
	void ActivateGradient(BOOL bActivate);
	void SetControlState_Impl(XGradientStyle eXGS);

	BOOL InitPreview ( const SfxItemSet& rSet );
	void InvalidatePreview (BOOL bEnable = TRUE );

public:
	SvxTransparenceTabPage(Window* pParent, const SfxItemSet& rInAttrs);
	void Construct();

	static SfxTabPage* Create(Window*, const SfxItemSet&);
	static UINT16* GetRanges();

	virtual BOOL FillItemSet(SfxItemSet&);
	virtual void Reset(const SfxItemSet&);
	virtual void ActivatePage(const SfxItemSet& rSet);
	virtual int  DeactivatePage(SfxItemSet* pSet);
	virtual void PointChanged(Window* pWindow, RECT_POINT eRP);

	void SetPageType(UINT16 *pInType) { pPageType = pInType; }
	void SetDlgType(UINT16* pInType) { pDlgType = pInType; }
};

/*************************************************************************
|*
|* Fl"achen-Tab-Page
|*
\************************************************************************/

class SvxAreaTabPage : public SvxTabPage
{
private:
    FixedLine           aFlProp;
    RadioButton         aRbtNoFill;
    RadioButton         aRbtColor;
    RadioButton         aRbtGradient;
    RadioButton         aRbtHatch;
    RadioButton         aRbtBitmap;

//      ListBox             aDlgType;
	ColorLB             aLbColor;
	GradientLB          aLbGradient;
	HatchingLB          aLbHatching;
	BitmapLB            aLbBitmap;
	SvxXRectPreview     aCtlBitmapPreview;

	TriStateBox         aTsbStepCount;
    FixedLine           aFlStepCount;
	NumericField        aNumFldStepCount;

	CheckBox			aCbxHatchBckgrd;
	ColorLB             aLbHatchBckgrdColor;

    FixedLine           aFlSize;
	TriStateBox			aTsbOriginal;
	TriStateBox			aTsbScale;
	FixedText			aFtXSize;
	MetricField			aMtrFldXSize;
	FixedText			aFtYSize;
	MetricField			aMtrFldYSize;
    FixedLine           aFlPosition;
	SvxRectCtl			aCtlPosition;
	FixedText			aFtXOffset;
	MetricField			aMtrFldXOffset;
	FixedText			aFtYOffset;
	MetricField			aMtrFldYOffset;
	TriStateBox         aTsbTile;
	TriStateBox         aTsbStretch;
    FixedLine           aFlOffset;
	RadioButton			aRbtRow;
	RadioButton			aRbtColumn;
	MetricField			aMtrFldOffset;

	SvxXRectPreview     aCtlXRectPreview;

	const SfxItemSet&   rOutAttrs;
	RECT_POINT          eRP;

	XColorTable*        pColorTab;
	XGradientList*      pGradientList;
	XHatchList*         pHatchingList;
	XBitmapList*        pBitmapList;

	ChangeType*         pnColorTableState;
	ChangeType*         pnBitmapListState;
	ChangeType*         pnGradientListState;
	ChangeType*         pnHatchingListState;

	USHORT*             pPageType;
	USHORT*             pDlgType;
	USHORT*             pPos;
	BOOL*               pbAreaTP;

	XOutdevItemPool*    pXPool;
	XOutputDevice       XOut;
	XOutputDevice       XOutBmp;
	XFillAttrSetItem    aXFillAttr;
	SfxItemSet&         rXFSet;

	SfxMapUnit			ePoolUnit;
	FieldUnit			eFUnit;

#ifdef _SVX_TPAREA_CXX
	DECL_LINK( SelectDialogType_Impl, void * );
	DECL_LINK( ClickInvisibleHdl_Impl, void * );
	DECL_LINK( ClickColorHdl_Impl, void * );
	DECL_LINK( ModifyColorHdl_Impl, void * );
	DECL_LINK( ModifyHatchBckgrdColorHdl_Impl, void * );
	DECL_LINK( ClickGradientHdl_Impl, void * );
	DECL_LINK( ModifyGradientHdl_Impl, void * );
	DECL_LINK( ClickHatchingHdl_Impl, void * );
	DECL_LINK( ModifyHatchingHdl_Impl, void * );
	DECL_LINK( ToggleHatchBckgrdColorHdl_Impl, void * );
	DECL_LINK( ClickBitmapHdl_Impl, void * );
	DECL_LINK( ModifyBitmapHdl_Impl, void * );
//	DECL_LINK( ModifyTransparentHdl_Impl, void * );
	DECL_LINK( ModifyStepCountHdl_Impl, void * );
	DECL_LINK( ModifyTileHdl_Impl, void * );
	DECL_LINK( ClickScaleHdl_Impl, void * );
#endif

public:
	SvxAreaTabPage( Window* pParent, const SfxItemSet& rInAttrs  );

	void    Construct();

	static  SfxTabPage* Create( Window*, const SfxItemSet& );
	static  USHORT*	    GetRanges();

	virtual BOOL FillItemSet( SfxItemSet& );
	virtual void Reset( const SfxItemSet & );
	virtual void ActivatePage( const SfxItemSet& rSet );
	virtual int  DeactivatePage( SfxItemSet* pSet );
	virtual void PointChanged( Window* pWindow, RECT_POINT eRP );

	void    SetColorTable( XColorTable* pColTab ) { pColorTab = pColTab; }
	void    SetGradientList( XGradientList* pGrdLst)
				{ pGradientList = pGrdLst; }
	void    SetHatchingList( XHatchList* pHtchLst)
				{ pHatchingList = pHtchLst; }
	void    SetBitmapList( XBitmapList* pBmpLst) { pBitmapList = pBmpLst; }

	void    SetPageType( USHORT* pInType ) { pPageType = pInType; }
	void    SetDlgType( USHORT* pInType ) { pDlgType = pInType; }
	void    SetPos( USHORT* pInPos ) { pPos = pInPos; }
	void    SetAreaTP( BOOL* pIn ) { pbAreaTP = pIn; }

	void    SetColorChgd( ChangeType* pIn ) { pnColorTableState = pIn; }
	void    SetGrdChgd( ChangeType* pIn ) { pnGradientListState = pIn; }
	void    SetHtchChgd( ChangeType* pIn ) { pnHatchingListState = pIn; }
	void    SetBmpChgd( ChangeType* pIn ) { pnBitmapListState = pIn; }
};

/*************************************************************************
|*
|* Schatten-Tab-Page
|*
\************************************************************************/

class SvxShadowTabPage : public SvxTabPage
{
private:
    FixedLine           aFlProp;
    TriStateBox         aTsbShowShadow;
	FixedText           aFtPosition;
	SvxRectCtl          aCtlPosition;
	FixedText           aFtDistance;
	MetricField         aMtrDistance;
	FixedText           aFtShadowColor;
	ColorLB             aLbShadowColor;
	FixedText           aFtTransparent;
	MetricField         aMtrTransparent;
	SvxXShadowPreview	aCtlXRectPreview;

	const SfxItemSet&   rOutAttrs;
	RECT_POINT          eRP;

	XColorTable*        pColorTab;
	ChangeType*         pnColorTableState;
	USHORT*             pPageType;
	USHORT*             pDlgType;
	USHORT*             pPos;
	BOOL*               pbAreaTP;

	BOOL				bDisable;

	XOutdevItemPool*    pXPool;
	XOutputDevice       XOut;
	XFillAttrSetItem    aXFillAttr;
	SfxItemSet&         rXFSet;
	SfxMapUnit			ePoolUnit;

#ifdef _SVX_TPSHADOW_CXX
	DECL_LINK( ClickShadowHdl_Impl, void * );
	DECL_LINK( ModifyShadowHdl_Impl, void * );
#endif

public:
	SvxShadowTabPage( Window* pParent, const SfxItemSet& rInAttrs  );

	void    Construct();
	static  SfxTabPage* Create( Window*, const SfxItemSet& );
	static  USHORT*	    GetRanges();

	virtual BOOL FillItemSet( SfxItemSet& );
	virtual void Reset( const SfxItemSet & );
	virtual void ActivatePage( const SfxItemSet& rSet );
	virtual int  DeactivatePage( SfxItemSet* pSet );
	virtual void PointChanged( Window* pWindow, RECT_POINT eRP );

	void    SetColorTable( XColorTable* pColTab ) { pColorTab = pColTab; }
	void    SetPageType( USHORT* pInType ) { pPageType = pInType; }
	void    SetDlgType( USHORT* pInType ) { pDlgType = pInType; }
	void    SetAreaTP( BOOL* pIn ) { pbAreaTP = pIn; }
	void    SetColorChgd( ChangeType* pIn ) { pnColorTableState = pIn; }

	void	DisablePage( BOOL bIn ) { bDisable = bIn; }
};

/*************************************************************************
|*
|* Farbverlauf-Tab-Page
|*
\************************************************************************/

class SvxGradientTabPage : public SfxTabPage
{
private:
    FixedLine           aFlProp;
	FixedText           aFtType;
	ListBox             aLbGradientType;
	FixedText           aFtCenterX;
	MetricField         aMtrCenterX;
	FixedText           aFtCenterY;
	MetricField         aMtrCenterY;
	FixedText           aFtAngle;
	MetricField         aMtrAngle;
	FixedText           aFtBorder;
	MetricField         aMtrBorder;
	FixedText           aFtColorFrom;
	ColorLB             aLbColorFrom;
	MetricField         aMtrColorFrom;
	FixedText           aFtColorTo;
	ColorLB             aLbColorTo;
	MetricField         aMtrColorTo;
	GradientLB          aLbGradients;
	SvxXRectPreview     aCtlPreview;
	PushButton          aBtnAdd;
	PushButton          aBtnModify;
	PushButton          aBtnDelete;
	ImageButton         aBtnLoad;
	ImageButton         aBtnSave;

	const SfxItemSet&   rOutAttrs;

	XColorTable*        pColorTab;
	XGradientList*      pGradientList;

	ChangeType*         pnGradientListState;
	ChangeType*         pnColorTableState;
	USHORT*             pPageType;
	USHORT*             pDlgType;
	USHORT*             pPos;
	BOOL*               pbAreaTP;

	XOutdevItemPool*    pXPool;
	XOutputDevice       XOut;
	XFillStyleItem      aXFStyleItem;
	XFillGradientItem   aXGradientItem;
	XFillAttrSetItem    aXFillAttr;
	SfxItemSet&         rXFSet;

#ifdef _SVX_TPGRADNT_CXX
	DECL_LINK( ClickAddHdl_Impl, void * );
	DECL_LINK( ClickModifyHdl_Impl, void * );
	DECL_LINK( ClickDeleteHdl_Impl, void * );
	DECL_LINK( ChangeGradientHdl_Impl, void * );
	DECL_LINK( ModifiedHdl_Impl, void * );
	DECL_LINK( ClickLoadHdl_Impl, void * );
	DECL_LINK( ClickSaveHdl_Impl, void * );

	long CheckChanges_Impl();
	void SetControlState_Impl( XGradientStyle eXGS );
#endif

public:
	SvxGradientTabPage( Window* pParent, const SfxItemSet& rInAttrs  );

	void    Construct();

	static  SfxTabPage* Create( Window*, const SfxItemSet& );
	virtual BOOL FillItemSet( SfxItemSet& );
	virtual void Reset( const SfxItemSet & );

	virtual void ActivatePage( const SfxItemSet& rSet );
	virtual int  DeactivatePage( SfxItemSet* pSet );

	void    SetColorTable( XColorTable* pColTab ) { pColorTab = pColTab; }
	void    SetGradientList( XGradientList* pGrdLst)
				{ pGradientList = pGrdLst; }

	void    SetPageType( USHORT* pInType ) { pPageType = pInType; }
	void    SetDlgType( USHORT* pInType ) { pDlgType = pInType; }
	void    SetPos( USHORT* pInPos ) { pPos = pInPos; }
	void    SetAreaTP( BOOL* pIn ) { pbAreaTP = pIn; }

	void    SetGrdChgd( ChangeType* pIn ) { pnGradientListState = pIn; }
	void    SetColorChgd( ChangeType* pIn ) { pnColorTableState = pIn; }
};

/*************************************************************************
|*
|* Schraffuren-Tab-Page
|*
\************************************************************************/

class SvxHatchTabPage : public SvxTabPage
{
private:
	FixedText           aFtDistance;
	MetricField         aMtrDistance;
	FixedText           aFtAngle;
	MetricField         aMtrAngle;
	SvxRectCtl          aCtlAngle;
    FixedLine           aFlProp;
	FixedText           aFtLineType;
	ListBox             aLbLineType;
	FixedText           aFtLineColor;
	ColorLB             aLbLineColor;
	HatchingLB          aLbHatchings;
	SvxXRectPreview     aCtlPreview;
	PushButton          aBtnAdd;
	PushButton          aBtnModify;
	PushButton          aBtnDelete;
	ImageButton         aBtnLoad;
	ImageButton         aBtnSave;

	const SfxItemSet&   rOutAttrs;
	RECT_POINT          eRP;

	XColorTable*        pColorTab;
	XHatchList*         pHatchingList;

	ChangeType*         pnHatchingListState;
	ChangeType*         pnColorTableState;
	USHORT*             pPageType;
	USHORT*             pDlgType;
	USHORT*             pPos;
	BOOL*               pbAreaTP;

	XOutdevItemPool*    pXPool;
	XOutputDevice       XOut;
	XFillStyleItem      aXFStyleItem;
	XFillHatchItem      aXHatchItem;
	XFillAttrSetItem    aXFillAttr;
	SfxItemSet&         rXFSet;

	SfxMapUnit			ePoolUnit;

#ifdef _SVX_TPHATCH_CXX
	DECL_LINK( ChangeHatchHdl_Impl, void * );
	DECL_LINK( ModifiedHdl_Impl, void * );
	DECL_LINK( ClickAddHdl_Impl, void * );
	DECL_LINK( ClickModifyHdl_Impl, void * );
	DECL_LINK( ClickDeleteHdl_Impl, void * );
	DECL_LINK( ClickLoadHdl_Impl, void * );
	DECL_LINK( ClickSaveHdl_Impl, void * );

	long CheckChanges_Impl();
#endif

public:
	SvxHatchTabPage( Window* pParent, const SfxItemSet& rInAttrs  );

	void    Construct();

	static  SfxTabPage* Create( Window*, const SfxItemSet& );
	virtual BOOL FillItemSet( SfxItemSet& );
	virtual void Reset( const SfxItemSet & );

	virtual void ActivatePage( const SfxItemSet& rSet );
	virtual int  DeactivatePage( SfxItemSet* pSet );

	virtual void PointChanged( Window* pWindow, RECT_POINT eRP );

	void    SetColorTable( XColorTable* pColTab ) { pColorTab = pColTab; }
	void    SetHatchingList( XHatchList* pHtchLst)
				{ pHatchingList = pHtchLst; }

	void    SetPageType( USHORT* pInType ) { pPageType = pInType; }
	void    SetDlgType( USHORT* pInType ) { pDlgType = pInType; }
	void    SetPos( USHORT* pInPos ) { pPos = pInPos; }
	void    SetAreaTP( BOOL* pIn ) { pbAreaTP = pIn; }

	void    SetHtchChgd( ChangeType* pIn ) { pnHatchingListState = pIn; }
	void    SetColorChgd( ChangeType* pIn ) { pnColorTableState = pIn; }

	virtual void		DataChanged( const DataChangedEvent& rDCEvt );
};

/*************************************************************************
|*
|* Bitmap-Tab-Page
|*
\************************************************************************/

class SvxBitmapTabPage : public SvxTabPage
{
private:
	SvxPixelCtl         aCtlPixel;
    FixedText           aFtPixelEdit;
	FixedText           aFtColor;
	ColorLB             aLbColor;
	FixedText           aFtBackgroundColor;
	ColorLB             aLbBackgroundColor;
	FixedText           aLbBitmapsHidden;
	BitmapLB            aLbBitmaps;
    FixedLine           aFlProp;
	SvxXRectPreview     aCtlPreview;
	PushButton          aBtnAdd;
	PushButton          aBtnModify;
	PushButton          aBtnImport;
	PushButton          aBtnDelete;
	ImageButton         aBtnLoad;
	ImageButton         aBtnSave;

	SvxBitmapCtl        aBitmapCtl;

	const SfxItemSet&   rOutAttrs;

	XColorTable*        pColorTab;
	XBitmapList*        pBitmapList;

	ChangeType*         pnBitmapListState;
	ChangeType*         pnColorTableState;
	USHORT*             pPageType;
	USHORT*             pDlgType;
	USHORT*             pPos;
	BOOL*               pbAreaTP;

	BOOL                bBmpChanged;

	XOutdevItemPool*    pXPool;
	XOutputDevice       XOut;
	XFillStyleItem      aXFStyleItem;
	XFillBitmapItem     aXBitmapItem;
	XFillAttrSetItem    aXFillAttr;
	SfxItemSet&         rXFSet;

#ifdef _SVX_TPBITMAP_CXX
	DECL_LINK( ClickAddHdl_Impl, void * );
	DECL_LINK( ClickImportHdl_Impl, void * );
	DECL_LINK( ClickModifyHdl_Impl, void * );
	DECL_LINK( ClickDeleteHdl_Impl, void * );
	DECL_LINK( ChangeBitmapHdl_Impl, void * );
	DECL_LINK( ChangePixelColorHdl_Impl, void * );
	DECL_LINK( ChangeBackgrndColorHdl_Impl, void * );
	DECL_LINK( ClickLoadHdl_Impl, void * );
	DECL_LINK( ClickSaveHdl_Impl, void * );

	long CheckChanges_Impl();
#endif

public:
	SvxBitmapTabPage( Window* pParent, const SfxItemSet& rInAttrs  );

	void    Construct();

	static  SfxTabPage* Create( Window*, const SfxItemSet& );
	virtual BOOL FillItemSet( SfxItemSet& );
	virtual void Reset( const SfxItemSet & );

	virtual void ActivatePage( const SfxItemSet& rSet );
	virtual int  DeactivatePage( SfxItemSet* pSet );

	virtual void PointChanged( Window* pWindow, RECT_POINT eRP );

	void    SetColorTable( XColorTable* pColTab ) { pColorTab = pColTab; }
	void    SetBitmapList( XBitmapList* pBmpLst) { pBitmapList = pBmpLst; }

	void    SetPageType( USHORT* pInType ) { pPageType = pInType; }
	void    SetDlgType( USHORT* pInType ) { pDlgType = pInType; }
	void    SetPos( USHORT* pInPos ) { pPos = pInPos; }
	void    SetAreaTP( BOOL* pIn ) { pbAreaTP = pIn; }

	void    SetBmpChgd( ChangeType* pIn ) { pnBitmapListState = pIn; }
	void    SetColorChgd( ChangeType* pIn ) { pnColorTableState = pIn; }

    /** Return a label that is associated with the given control.  This
        label is used to the determine the name for the control.
        @param pLabeled
            The control for which to return a label.
        @return
            Return a label control that provides a name for the specified
            control.
    */
    virtual Window*	GetParentLabeledBy( const Window* pLabeled ) const;
};

/*************************************************************************
|*
|* Farben-Tab-Page
|*
\************************************************************************/

class SvxColorTabPage : public SfxTabPage
{
private:
    FixedLine           aFlProp;
	FixedText           aFtName;
	Edit                aEdtName;
    FixedText           aFtColor;
	ColorLB             aLbColor;

    FixedText           aTableNameFT;
    ValueSet            aValSetColorTable;

    SvxXRectPreview     aCtlPreviewOld;
	SvxXRectPreview     aCtlPreviewNew;

    ListBox             aLbColorModel;
    FixedText           aFtColorModel1;
	MetricField         aMtrFldColorModel1;
    FixedText           aFtColorModel2;
	MetricField         aMtrFldColorModel2;
    FixedText           aFtColorModel3;
	MetricField         aMtrFldColorModel3;

    FixedText           aFtColorModel4;
	MetricField         aMtrFldColorModel4;

    PushButton          aBtnAdd;
	PushButton          aBtnModify;
	PushButton          aBtnWorkOn;
	PushButton          aBtnDelete;
	ImageButton         aBtnLoad;
	ImageButton         aBtnSave;

	const SfxItemSet&   rOutAttrs;

	XColorTable*        pColorTab;

	ChangeType*         pnColorTableState;
	USHORT*             pPageType;
	USHORT*             pDlgType;
	USHORT*             pPos;
	BOOL*               pbAreaTP;
	BOOL                bDeleteColorTable;

	XOutdevItemPool*    pXPool;
	XOutputDevice       XOutOld;
	XOutputDevice       XOutNew;
	XFillStyleItem      aXFStyleItem;
	XFillColorItem      aXFillColorItem;
	XFillAttrSetItem    aXFillAttr;
	SfxItemSet&         rXFSet;

	ColorModel          eCM;

	Color				aAktuellColor;

#ifdef _SVX_TPCOLOR_CXX
	void    ConvertColorValues (Color& rColor, ColorModel eModell);
	void    RgbToCmyk_Impl( Color& rColor, USHORT& rK );
	void    CmykToRgb_Impl( Color& rColor, const USHORT nKey );
	USHORT  ColorToPercent_Impl( USHORT nColor );
	USHORT  PercentToColor_Impl( USHORT nPercent );

	void    FillValueSet_Impl( ValueSet& rVs );
	//-----------------------------------------------------------------------------------------------------
	DECL_LINK( ClickAddHdl_Impl, void * );		// Button 'Hinzufuegen'
	DECL_LINK( ClickModifyHdl_Impl, void * );	// Button 'Aendern'
	DECL_LINK( ClickDeleteHdl_Impl, void * );	// Button 'loeschen'
	DECL_LINK( ClickWorkOnHdl_Impl, void * );	// Button 'Bearbeiten'

	DECL_LINK( SelectColorLBHdl_Impl, void * );	// Farbe aus Listbox auswhlen
	DECL_LINK( SelectValSetHdl_Impl, void * );	// Farbe aus Farbpalette (links) auswhlen
	DECL_LINK( SelectColorModelHdl_Impl, void * );	// Auswahl Listbox 'Farbmodell'
	long ChangeColorHdl_Impl( void* p );
	DECL_LINK( ModifiedHdl_Impl, void * );		// Inhalt der Farbwerte-Felder wurde verndert
	DECL_LINK( ClickLoadHdl_Impl, void * );		// Button 'Farbtabelle laden'
	DECL_LINK( ClickSaveHdl_Impl, void * );		// Button 'Farbtabelle sichern'

	long CheckChanges_Impl();
#endif

public:
	SvxColorTabPage( Window* pParent, const SfxItemSet& rInAttrs  );

	void    Construct();

	static  SfxTabPage* Create( Window*, const SfxItemSet& );
	virtual BOOL FillItemSet( SfxItemSet& );
	virtual void Reset( const SfxItemSet & );

	virtual void ActivatePage( const SfxItemSet& rSet );
	virtual int  DeactivatePage( SfxItemSet* pSet );

	void    SetColorTable( XColorTable* pColTab ) { pColorTab = pColTab; }

	void    SetPageType( USHORT* pInType ) { pPageType = pInType; }
	void    SetDlgType( USHORT* pInType ) { pDlgType = pInType; }
	void    SetPos( USHORT* pInPos ) { pPos = pInPos; }
	void    SetAreaTP( BOOL* pIn ) { pbAreaTP = pIn; }

	void    SetColorChgd( ChangeType* pIn ) { pnColorTableState = pIn; }

	void	SetDeleteColorTable( BOOL bIn ) { bDeleteColorTable = bIn; }

	virtual void FillUserData();
};


#endif // _SVX_TAB_AREA_HXX

