/*************************************************************************
 *
 *  $RCSfile: portxt.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: fme $ $Date: 2002/02/28 12:42:19 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _PORTXT_HXX
#define _PORTXT_HXX

#ifdef GCC
#include <sys/types.h>
#else
#include <new.h>	//fuer size_t, FIXEDMEM aus tools
#endif
#ifndef _SVMEMPOOL_HXX //autogen
#include <tools/mempool.hxx>
#endif

#include "porlin.hxx"

class SwTxtGuess;

/*************************************************************************
 *						class SwTxtPortion
 *************************************************************************/

class SwTxtPortion : public SwLinePortion
{
	void BreakCut( SwTxtFormatInfo &rInf, const SwTxtGuess &rGuess );
	void BreakUnderflow( SwTxtFormatInfo &rInf );
	sal_Bool _Format( SwTxtFormatInfo &rInf );

public:
	inline SwTxtPortion(){ SetWhichPor( POR_TXT ); }
	SwTxtPortion( const SwLinePortion &rPortion );
	virtual void Paint( const SwTxtPaintInfo &rInf ) const;
	virtual sal_Bool Format( SwTxtFormatInfo &rInf );
	virtual void FormatEOL( SwTxtFormatInfo &rInf );
	virtual xub_StrLen GetCrsrOfst( const KSHORT nOfst ) const;
	virtual SwPosSize GetTxtSize( const SwTxtSizeInfo &rInfo ) const;
	virtual sal_Bool GetExpTxt( const SwTxtSizeInfo &rInf, XubString &rTxt ) const;
	virtual long CalcSpacing( short nSpaceAdd, const SwTxtSizeInfo &rInf ) const;

	// zaehlt die Spaces fuer Blocksatz
	xub_StrLen GetSpaceCnt( const SwTxtSizeInfo &rInf, xub_StrLen& rCnt ) const;
	xub_StrLen GetCrsrOfst( const KSHORT nOfst, SwTxtSizeInfo &rSizeInf ) const;

	sal_Bool CreateHyphen( SwTxtFormatInfo &rInf, SwTxtGuess &rGuess );

    // Accessibility: pass information about this portion to the PortionHandler
    virtual void HandlePortion( SwPortionHandler& rPH ) const;

	OUTPUT_OPERATOR
	DECL_FIXEDMEMPOOL_NEWDEL(SwTxtPortion)
};

/*************************************************************************
 *						class SwHolePortion
 *************************************************************************/

class SwHolePortion : public SwLinePortion
{
	KSHORT nBlankWidth;
public:
			SwHolePortion( const SwTxtPortion &rPor );
	inline const KSHORT GetBlankWidth( ) const { return nBlankWidth; }
	inline void SetBlankWidth( const KSHORT nNew ) { nBlankWidth = nNew; }
	virtual SwLinePortion *Compress();
	virtual sal_Bool Format( SwTxtFormatInfo &rInf );
	virtual void Paint( const SwTxtPaintInfo &rInf ) const;

    // Accessibility: pass information about this portion to the PortionHandler
    virtual void HandlePortion( SwPortionHandler& rPH ) const;

	OUTPUT_OPERATOR
	DECL_FIXEDMEMPOOL_NEWDEL(SwHolePortion)
};

CLASSIO( SwTxtPortion )
CLASSIO( SwHolePortion )


#endif
