/*************************************************************************
 *
 *  $RCSfile: urp_reader.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: jbu $ $Date: 2001/05/14 09:57:58 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <osl/thread.hxx>

#include "urp_unmarshal.hxx"

struct remote_Connection;
typedef struct _uno_Environment uno_Environment;

namespace bridges_urp
{
	
class OWriterThread;
struct MessageFlags;

class OReaderThread :
	public ::osl::Thread
{
public:
	OReaderThread( remote_Connection *pConnection ,
				   uno_Environment *pEnvRemote,
				   OWriterThread *pWriterThread );
	~OReaderThread();
	
	virtual void SAL_CALL run();
	virtual void SAL_CALL onTerminated();

    // may only be called in the callstack of this thread !!!!!
    // run() -> disposeEnvironment() -> dispose() -> destroyYourself() 
	void destroyYourself();

	inline sal_Bool readBlock( sal_Int32 *pnMessageCount );
	inline sal_Bool readFlags( struct MessageFlags *pFlags );
private:
	void disposeEnvironment();

	inline sal_Bool getMemberTypeDescription(
		typelib_InterfaceAttributeTypeDescription **ppAttributeType,
		typelib_InterfaceMethodTypeDescription **ppMethodType,
		sal_Bool *pbIsSetter,
		sal_uInt16 nMethodId ,
		typelib_TypeDescriptionReference *pITypeRef);
	
	remote_Connection *m_pConnection;
	uno_Environment *m_pEnvRemote;
	OWriterThread *m_pWriterThread;
	sal_Bool m_bDestroyMyself;
	sal_Bool m_bContinue;
	urp_BridgeImpl *m_pBridgeImpl;
	Unmarshal m_unmarshal;
};

}
