/*************************************************************************
 *
 *  $RCSfile: datasourceselector.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/19 17:52:21 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc..
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef DBAUI_DATASOURCESELECTOR_HXX
#include "datasourceselector.hxx"
#endif
#ifndef _DBAUI_DBADMIN_HRC_
#include "dbadmin.hrc"
#endif
#ifndef _DBU_DLG_HRC_
#include "dbu_dlg.hrc"
#endif
#ifndef _DBAUI_MODULE_DBU_HXX_
#include "moduledbu.hxx"
#endif
#ifndef DBAUI_TOOLS_HXX
#include "UITools.hxx"
#endif
#ifndef _SV_MENU_HXX 
#include <vcl/menu.hxx>
#endif

//.........................................................................
namespace dbaui
{
//.........................................................................

	namespace
	{
		// -----------------------------------------------------------------------------
		/// get the resource id for imgages to be used for the given data source state
		sal_Int32 getImageId(DatasourceState _eState,sal_Bool _bHiContrast)
		{
			switch (_eState)
			{
				case CLEAN:		return _bHiContrast ? IMG_DATABASE_SCH			: IMG_DATABASE;
				case MODIFIED:	return _bHiContrast ? IMG_DATABASE_MODIFIED_SCH	: IMG_DATABASE_MODIFIED;
				case NEW:		return _bHiContrast ? IMG_DATABASE_NEW_SCH		: IMG_DATABASE_NEW;
				case DELETED:	return _bHiContrast ? IMG_DATABASE_DELETED_SCH	: IMG_DATABASE_DELETED;
			}
			OSL_ENSURE(sal_False, "ODatasourceSelector::getImage: invalid state");
			return 0;
		}
		// -----------------------------------------------------------------------------
		void adjustBitmaps(ListBox& _rListBox)
		{
			USHORT nCount = _rListBox.GetEntryCount();
			sal_Bool bHisContrast = isHiContrast(&_rListBox);
			for (USHORT i=0; i < nCount ; ++i)
			{
				ODatasourceSelector::EntryData* pData = static_cast<ODatasourceSelector::EntryData*>(_rListBox.GetEntryData(i));
				String sName = _rListBox.GetEntry(i);
				_rListBox.RemoveEntry(i);
				DatasourceState eState = CLEAN;
				if ( pData )
					eState = pData->eState;
				_rListBox.InsertEntry(sName,Image(ModuleRes((USHORT)getImageId(eState,bHisContrast))),i);
				_rListBox.SetEntryData(i, static_cast<void*>(pData));
				
			}
		}
		// -----------------------------------------------------------------------------
	}

	//=====================================================================
	//= ODatasourceSelector
	//=====================================================================
	//---------------------------------------------------------------------
	ODatasourceSelector::ODatasourceSelector(Window* _pParent, const ResId& _rResId)
		:Window(_pParent, _rResId)
		,m_aDatasourceList	(this, ResId(LB_DATASOURCES))
		,m_aNewDatasource	(this, ResId(PB_NEW_DATASOURCE))
	{
		FreeResource();

		m_aDatasourceList.EnableClipSiblings(sal_True);
		m_aNewDatasource.SetClickHdl(LINK(this, ODatasourceSelector, OnButtonPressed));

		SetStyle((GetStyle() | WB_TABSTOP | WB_DIALOGCONTROL) & ~WB_NODIALOGCONTROL);
		m_bHiContrast = isHiContrast(&m_aDatasourceList);
	}

	//---------------------------------------------------------------------
	ODatasourceSelector::~ODatasourceSelector()
	{
		for (sal_Int32 i=0; i<m_aDatasourceList.GetEntryCount(); ++i)
			delete reinterpret_cast<EntryData*>(m_aDatasourceList.GetEntryData((USHORT)i));
	}

	//---------------------------------------------------------------------
	DatasourceState ODatasourceSelector::getEntryState(sal_Int32 _nPos) const
	{
		EntryData* pData = static_cast<EntryData*>(m_aDatasourceList.GetEntryData((USHORT)_nPos));
		if (!pData)
			return CLEAN;
		return pData->eState;
	}

	//---------------------------------------------------------------------
	void ODatasourceSelector::setEntryState(sal_Int32 _nPos, DatasourceState _eState)
	{
		EntryData* pData = static_cast<EntryData*>(m_aDatasourceList.GetEntryData((USHORT)_nPos));
		if (pData ? _eState == pData->eState : CLEAN == _eState)
			// nothing changed
			return;

		// to restore the selection afterwards ...
		sal_Bool bWasSelected = m_aDatasourceList.GetSelectEntryPos() == _nPos;

		String sName = m_aDatasourceList.GetEntry((USHORT)_nPos);
		m_aDatasourceList.RemoveEntry((USHORT)_nPos);
		_nPos = m_aDatasourceList.InsertEntry(sName, Image(ModuleRes((USHORT)getImageId(_eState,m_bHiContrast))), (USHORT)_nPos);

		if (!pData)
			pData = new EntryData;
		pData->eState = _eState;
		m_aDatasourceList.SetEntryData((USHORT)_nPos, static_cast<void*>(pData));

		if (bWasSelected)
			m_aDatasourceList.SelectEntryPos((USHORT)_nPos, sal_True);
	}

	//---------------------------------------------------------------------
	sal_Int32 ODatasourceSelector::getAccessKey(sal_Int32 _nPos) const
	{
		EntryData* pData = static_cast<EntryData*>(m_aDatasourceList.GetEntryData((USHORT)_nPos));
		if (!pData)
			return 0;	// entry is in default state
		return pData->nAccessKey;
	}

	//---------------------------------------------------------------------
	void ODatasourceSelector::setAccessKey(sal_Int32 _nPos, sal_Int32 _nAccessKey)
	{
		EntryData* pData = static_cast<EntryData*>(m_aDatasourceList.GetEntryData((USHORT)_nPos));
		OSL_ENSURE(pData, "ODatasourceSelector::setAccessKey: to be called for entry in DELETED state only!");
		if (!pData)
		{
			pData = new EntryData(DELETED);
			m_aDatasourceList.SetEntryData((USHORT)_nPos, static_cast<void*>(pData));
		}
		pData->nAccessKey = _nAccessKey;
	}

	//---------------------------------------------------------------------
	void ODatasourceSelector::implDeleted(sal_Int32 _nPos)
	{
		// remove the entry
		m_aDatasourceList.RemoveEntry((USHORT)_nPos);

		// select the one below (or above, if it was the last one)
		if (_nPos >= m_aDatasourceList.GetEntryCount())
			_nPos = m_aDatasourceList.GetEntryCount() - 1;
		m_aDatasourceList.SelectEntryPos((USHORT)_nPos);
		// call the select handler to propagate the new selection
		m_aDatasourceList.GetSelectHdl().Call(&m_aDatasourceList);
	}

	//---------------------------------------------------------------------
	void ODatasourceSelector::deleted(sal_Int32 _nAccessKey)
	{
		sal_Int32 nPos = getDeletedEntryPos(_nAccessKey);
		if (-1 != nPos)
			implDeleted(nPos);
		else
			OSL_ENSURE(sal_False, "ODatasourceSelector::deleted: no deleted entry wiht that name!");
	}

	//---------------------------------------------------------------------
	void ODatasourceSelector::deleted(const String& _rName)
	{
		sal_Int32 nPos = getValidEntryPos(_rName);
		if (-1 != nPos)
			implDeleted(nPos);
		else
			OSL_ENSURE(sal_False, "ODatasourceSelector::deleted: no non-deleted entry wiht that name!");
	}

	//---------------------------------------------------------------------
	void ODatasourceSelector::restoreDeleted(sal_Int32 _nAccessKey, DatasourceState _eState)
	{
		OSL_ENSURE(DELETED != _eState, "ODatasourceSelector::restoreDeleted: invalid datasource state!");
		sal_Int32 nPos = getDeletedEntryPos(_nAccessKey);
		if (-1 == nPos)
		{
			OSL_ENSURE(sal_False, "ODatasourceSelector::restoreDeleted: invalid access key!");
			return;
		}
		OSL_ENSURE(-1 == getValidEntryPos(m_aDatasourceList.GetEntry((USHORT)nPos)),
			"ODatasourceSelector::restoreDeleted: already have a not-deleted entry with that name!");

		setEntryState(nPos, _eState);
		setAccessKey(nPos, 0);
	}

	//---------------------------------------------------------------------
	void ODatasourceSelector::markDeleted(const String& _rName, sal_Int32 _nAccessKey)
	{
		sal_Int32 nPos = getValidEntryPos(_rName);
		OSL_ENSURE(-1 != nPos, "ODatasourceSelector::markDeleted: no non-deleted entry wiht that name!");
		setEntryState(nPos, DELETED);
		OSL_ENSURE(_nAccessKey, "ODatasourceSelector::markDeleted: invalid access key!");
		OSL_ENSURE(-1 == getDeletedEntryPos(_nAccessKey), "ODatasourceSelector::modified: already have a deleted entry with this access key!");
		setAccessKey(nPos, _nAccessKey);
	}

	//---------------------------------------------------------------------
	void ODatasourceSelector::modified(const String& _sName)
	{
		sal_Int32 nPos = getValidEntryPos(_sName);
		OSL_ENSURE(-1 != nPos, "ODatasourceSelector::modified: invalid name!");
		setEntryState(nPos, MODIFIED);
	}

	//---------------------------------------------------------------------
	sal_Int32 ODatasourceSelector::getDeletedEntryPos(sal_Int32 _nAccessKey)
	{
		for (sal_Int32 i=0; i<m_aDatasourceList.GetEntryCount(); ++i)
			if ((DELETED == getEntryState(i)) && (_nAccessKey == getAccessKey(i)))
				return i;

		return -1;
	}

	//---------------------------------------------------------------------
	sal_Int32 ODatasourceSelector::getValidEntryPos(const String& _rName)
	{
		// first guess
		sal_Int32 nPos = m_aDatasourceList.GetEntryPos(_rName);
		while (DELETED == getEntryState(nPos))
		{
			// unfortunally we no such thing as "GetEntryPos(<name>, <startindex>) ... -> search manually
			while ((++nPos<m_aDatasourceList.GetEntryCount()))
				if (m_aDatasourceList.GetEntry((USHORT)nPos).Equals(_rName))
					// have a candidate
					break;
			if (nPos>=m_aDatasourceList.GetEntryCount())
				// did not find another candidate
				return -1;
		}
		return nPos;
	}

	//---------------------------------------------------------------------
	void ODatasourceSelector::renamed(const String& _rOldName, const String& _rNewName)
	{
		sal_Int32 nPos = getValidEntryPos(_rOldName);
		OSL_ENSURE(-1 != nPos, "ODatasourceSelector::renamed: invalid old name!");

		// save the info about the entry
		DatasourceState eState = getEntryState(nPos);
		EntryData* pData = static_cast<EntryData*>(m_aDatasourceList.GetEntryData((USHORT)nPos));

		m_aDatasourceList.RemoveEntry((USHORT)nPos);
		nPos = m_aDatasourceList.InsertEntry(_rNewName, Image(ModuleRes((USHORT)getImageId(eState,m_bHiContrast))), (USHORT)nPos);

		// restore the info about the entry
		m_aDatasourceList.SetEntryData((USHORT)nPos, static_cast<void*>(pData));
	}

	//---------------------------------------------------------------------
	sal_Int32 ODatasourceSelector::insert(const String& _rName)
	{
		sal_Int16 nPos = m_aDatasourceList.InsertEntry(_rName, Image(ModuleRes((USHORT)getImageId(CLEAN,m_bHiContrast))));
		m_aDatasourceList.SetEntryData(nPos, static_cast<void*>(NULL));
		return nPos;
	}

	//---------------------------------------------------------------------
	void ODatasourceSelector::flushed(const String& _rName)
	{
		sal_Int32 nPos = getValidEntryPos(_rName);
		OSL_ENSURE(-1 != nPos, "ODatasourceSelector::flushed: invalid data source name!");

		setEntryState(nPos, CLEAN);
	}

	//---------------------------------------------------------------------
	void ODatasourceSelector::insertNew(const String& _rName)
	{
		// insert the new entry with the appropriate image
		sal_Int16 nPos = m_aDatasourceList.InsertEntry(_rName, Image(ModuleRes((USHORT)getImageId(NEW,m_bHiContrast))));
		m_aDatasourceList.SetEntryData(nPos, static_cast<void*>(new EntryData(NEW)));
	}

	//---------------------------------------------------------------------
	void ODatasourceSelector::select(const String& _rName)
	{
		sal_Int32 nPos = getValidEntryPos(_rName);
		OSL_ENSURE(-1 != nPos, "ODatasourceSelector::select: invalid data source name (maybe deleted or not existent)!");

		m_aDatasourceList.SelectEntryPos((USHORT)nPos);
	}

	//---------------------------------------------------------------------
	void ODatasourceSelector::select(sal_Int32 _nAccessKey)
	{
		sal_Int32 nPos = getDeletedEntryPos(_nAccessKey);
		OSL_ENSURE(-1 != nPos, "ODatasourceSelector::select: invalid access key (have no such entry)!");

		m_aDatasourceList.SelectEntryPos((USHORT)nPos);
	}

	//---------------------------------------------------------------------
	long ODatasourceSelector::Notify(NotifyEvent& _rNEvt)
	{
		sal_Bool bHandled = sal_False;

		switch (_rNEvt.GetType())
		{
			case EVENT_COMMAND:
			{
				const CommandEvent* pCommand = _rNEvt.GetCommandEvent();
				if (COMMAND_CONTEXTMENU == pCommand->GetCommand())
				{
					// check if the context menu request occured in the listbox
					if	(m_aDatasourceList.IsChild(_rNEvt.GetWindow()))
					{
						// calc the pos where to open the menu
						Point aWhere;
						if (pCommand->IsMouseEvent())
						{
							aWhere = pCommand->GetMousePosPixel();
						}
						else
						{	// context menu via keyboard -> assume the center of the currently selected data source
							// TODO: use another class instead of the listbox (e.g. a SvTreeListBox). We have no change
							// to get an item rect or the item height or something like that from a listbox ...
							aWhere = Point(0, 0);
						}
						PopupMenu aMenu(ModuleRes(MENU_DATASOURCELIST_POPUP));
						aMenu.SetMenuFlags(aMenu.GetMenuFlags() | MENU_FLAG_HIDEDISABLEDENTRIES);

						// we don't really know if adding datasources is allowed currently. But an other instance does
						// (the dialog), and this instance en- or disables our "new datasource" button
						aMenu.EnableItem(MID_NEW_DATASOURCE, m_aNewDatasource.IsEnabled());

						USHORT nSelectionPos = m_aDatasourceList.GetSelectEntryPos();
						DatasourceState eState = getEntryState(nSelectionPos);
						aMenu.EnableItem(MID_DELETE_DATASOURCE, (DELETED != eState && nSelectionPos != LISTBOX_ENTRY_NOTFOUND));
						aMenu.EnableItem(MID_RESTORE_DATASOURCE, DELETED == eState);

						switch (aMenu.Execute(_rNEvt.GetWindow(), aWhere))
						{
							case MID_NEW_DATASOURCE:
								m_aNewHandler.Call(this);
								break;
							case MID_DELETE_DATASOURCE:
								m_aDeleteHandler.Call(this);
								break;
							case MID_RESTORE_DATASOURCE:
								m_aRestoreHandler.Call(this);
								break;
						}
						bHandled = sal_True;
					}
				}
			}
			break;
			case EVENT_KEYINPUT:
			{
				const KeyEvent* pKeyEvent = _rNEvt.GetKeyEvent();
				const KeyCode& rKeyCode = pKeyEvent->GetKeyCode();
				if ((0 == rKeyCode.GetAllModifier()) && ((sal_Int32)-1 != m_aDatasourceList.GetSelectEntryPos()))
					switch (rKeyCode.GetCode())
					{
						case KEY_DELETE:
							if ( LISTBOX_ENTRY_NOTFOUND != m_aDatasourceList.GetSelectEntryPos() )
								if (getAccessKey(m_aDatasourceList.GetSelectEntryPos()) <= 0)
									// for a non-deleted data source, call the delete handler
									m_aDeleteHandler.Call(this);
							bHandled = sal_True;
							break;
						case KEY_INSERT:
							m_aNewHandler.Call(this);
							bHandled = sal_True;
							break;
					}
			}
			break;
		}

		return bHandled ? 1 : Window::Notify(_rNEvt);
	}

	//---------------------------------------------------------------------
	void ODatasourceSelector::Resize()
	{
		Window::Resize();
		Size aSize = GetSizePixel();

		// adjust the width of the button
		sal_Int32 nButtonHeight = m_aNewDatasource.GetSizePixel().Height();
		m_aNewDatasource.SetSizePixel(Size(aSize.Width(), nButtonHeight));

		// adjust width/height of the listbox
		m_aDatasourceList.SetPosPixel(Point(0, nButtonHeight));
		m_aDatasourceList.SetSizePixel(Size(aSize.Width(), aSize.Height() - nButtonHeight));
	}

	//---------------------------------------------------------------------
	IMPL_LINK(ODatasourceSelector, OnButtonPressed, Button*, EMPTYARG)
	{
		return m_aNewHandler.Call(this);
	}
	// -----------------------------------------------------------------------------
	void ODatasourceSelector::StateChanged( StateChangedType nType )
	{
		Window::StateChanged( nType );

		if ( nType == STATE_CHANGE_CONTROLBACKGROUND )
		{
			// Check if we need to get new images for normal/high contrast mode
			PostUserEvent( LINK( this, ODatasourceSelector, OnAsyncHiContrastCheck) );
		}
	}
	// -----------------------------------------------------------------------------
	void ODatasourceSelector::DataChanged( const DataChangedEvent& rDCEvt )
	{
		Window::DataChanged( rDCEvt );

		if ((( rDCEvt.GetType() == DATACHANGED_SETTINGS	)	||
			( rDCEvt.GetType() == DATACHANGED_DISPLAY	))	&&
			( rDCEvt.GetFlags() & SETTINGS_STYLE		))
		{
			// Check if we need to get new images for normal/high contrast mode
			PostUserEvent( LINK( this, ODatasourceSelector, OnAsyncHiContrastCheck) );
		}
	}
	// -----------------------------------------------------------------------------
	IMPL_LINK( ODatasourceSelector, OnAsyncHiContrastCheck, void*, NOTINTERESTEDIN )
	{
		if ( m_bHiContrast != isHiContrast(&m_aDatasourceList) )
			adjustBitmaps(m_aDatasourceList);
		return 0L;
	}
//.........................................................................
}
// namespace dbaui
//.........................................................................

