/*************************************************************************
 *
 *  $RCSfile: registry.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:02:18 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <vos/mutex.hxx>
#include <tools/urlobj.hxx>
#include <usr/weak.hxx>
#include <usr/reflserv.hxx>
#include <usr/factoryhlp.hxx>
#include <usr/services.hxx>
#include <usr/smart2uno.hxx>
#include <toolkit/unoiface.hxx>
#ifndef _SMART_COM_SUN_STAR_DATA_DATABASERECORDSTATUS_HXX_
#include <smart/com/sun/star/data/DatabaseRecordStatus.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_DATABASECURSOROPTION_HXX_
#include <smart/com/sun/star/data/DatabaseCursorOption.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_XDATABASECURSORSUPPLIER_HXX_
#include <smart/com/sun/star/data/XDatabaseCursorSupplier.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_XPREPAREDDATABASESTATEMENT_HXX_
#include <smart/com/sun/star/data/XPreparedDatabaseStatement.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_XDATABASESTATEMENT_HXX_
#include <smart/com/sun/star/data/XDatabaseStatement.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_XDATABASEUPDATECURSOR_HXX_
#include <smart/com/sun/star/data/XDatabaseUpdateCursor.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_XDATABASECURSOR_HXX_
#include <smart/com/sun/star/data/XDatabaseCursor.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_XDATABASEBOOKMARKCURSOR_HXX_
#include <smart/com/sun/star/data/XDatabaseBookmarkCursor.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_XDATABASEDIRECTCURSOR_HXX_
#include <smart/com/sun/star/data/XDatabaseDirectCursor.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_DATABASECURSORTYPE_HXX_
#include <smart/com/sun/star/data/DatabaseCursorType.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_DATABASERECORDMODE_HXX_
#include <smart/com/sun/star/data/DatabaseRecordMode.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XGRID_HXX_
#include <smart/com/sun/star/form/XGrid.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XGRIDCOLUMNFACTORY_HXX_
#include <smart/com/sun/star/form/XGridColumnFactory.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XGRIDPEER_HXX_
#include <smart/com/sun/star/form/XGridPeer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XGRIDFIELDDATASUPPLIER_HXX_
#include <smart/com/sun/star/form/XGridFieldDataSupplier.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XCONTROLLER_HXX_
#include <smart/com/sun/star/frame/XController.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XFRAMEACTIONLISTENER_HXX_
#include <smart/com/sun/star/frame/XFrameActionListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XCOMPONENTLOADER_HXX_
#include <smart/com/sun/star/frame/XComponentLoader.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XFRAME_HXX_
#include <smart/com/sun/star/frame/XFrame.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_FRAMEACTIONEVENT_HXX_
#include <smart/com/sun/star/frame/FrameActionEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_FRAMEACTION_HXX_
#include <smart/com/sun/star/frame/FrameAction.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XFRAMELOADER_HXX_
#include <smart/com/sun/star/frame/XFrameLoader.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XLOADEVENTLISTENER_HXX_
#include <smart/com/sun/star/frame/XLoadEventListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XFILTERDETECT_HXX_
#include <smart/com/sun/star/frame/XFilterDetect.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_IO_XCONNECTABLE_HXX_
#include <smart/com/sun/star/io/XConnectable.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_IO_XOUTPUTSTREAM_HXX_
#include <smart/com/sun/star/io/XOutputStream.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_IO_XDATAOUTPUTSTREAM_HXX_
#include <smart/com/sun/star/io/XDataOutputStream.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_IO_XACTIVEDATACONTROL_HXX_
#include <smart/com/sun/star/io/XActiveDataControl.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_IO_XDATAINPUTSTREAM_HXX_
#include <smart/com/sun/star/io/XDataInputStream.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_IO_XMARKABLESTREAM_HXX_
#include <smart/com/sun/star/io/XMarkableStream.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_IO_XINPUTSTREAM_HXX_
#include <smart/com/sun/star/io/XInputStream.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_IO_XSTREAMLISTENER_HXX_
#include <smart/com/sun/star/io/XStreamListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_IO_XACTIVEDATASINK_HXX_
#include <smart/com/sun/star/io/XActiveDataSink.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_IO_XACTIVEDATASOURCE_HXX_
#include <smart/com/sun/star/io/XActiveDataSource.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_LANG_XSERVICENAME_HXX_
#include <smart/com/sun/star/lang/XServiceName.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_LANG_XSERVICEINFO_HXX_
#include <smart/com/sun/star/lang/XServiceInfo.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HXX_
#include <smart/com/sun/star/lang/XMultiServiceFactory.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_LANG_XSINGLESERVICEFACTORY_HXX_
#include <smart/com/sun/star/lang/XSingleServiceFactory.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_PROPERTYVALUES_HXX_
#include <smart/com/sun/star/beans/PropertyValues.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTYSET_HXX_
#include <smart/com/sun/star/beans/XPropertySet.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_PROPERTYVALUE_HXX_
#include <smart/com/sun/star/beans/PropertyValue.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_PROPERTYSTATE_HXX_
#include <smart/com/sun/star/beans/PropertyState.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTYSETINFO_HXX_
#include <smart/com/sun/star/beans/XPropertySetInfo.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XMULTIPROPERTYSET_HXX_
#include <smart/com/sun/star/beans/XMultiPropertySet.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XFASTPROPERTYSET_HXX_
#include <smart/com/sun/star/beans/XFastPropertySet.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XVETOABLECHANGELISTENER_HXX_
#include <smart/com/sun/star/beans/XVetoableChangeListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTYSTATE_HXX_
#include <smart/com/sun/star/beans/XPropertyState.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTYSTATECHANGELISTENER_HXX_
#include <smart/com/sun/star/beans/XPropertyStateChangeListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_PROPERTYATTRIBUTE_HXX_
#include <smart/com/sun/star/beans/PropertyAttribute.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTIESCHANGELISTENER_HXX_
#include <smart/com/sun/star/beans/XPropertiesChangeListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTYCHANGELISTENER_HXX_
#include <smart/com/sun/star/beans/XPropertyChangeListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTYACCESS_HXX_
#include <smart/com/sun/star/beans/XPropertyAccess.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_XPROPERTYCONTAINER_HXX_
#include <smart/com/sun/star/beans/XPropertyContainer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_PROPERTYSTATECHANGEEVENT_HXX_
#include <smart/com/sun/star/beans/PropertyStateChangeEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_BEANS_PROPERTYCHANGEEVENT_HXX_
#include <smart/com/sun/star/beans/PropertyChangeEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CONTAINER_XCONTAINER_HXX_
#include <smart/com/sun/star/container/XContainer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CONTAINER_XINDEXCONTAINER_HXX_
#include <smart/com/sun/star/container/XIndexContainer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CONTAINER_XNAMEREPLACE_HXX_
#include <smart/com/sun/star/container/XNameReplace.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CONTAINER_XCONTAINERLISTENER_HXX_
#include <smart/com/sun/star/container/XContainerListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CONTAINER_XSET_HXX_
#include <smart/com/sun/star/container/XSet.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CONTAINER_CONTAINEREVENT_HXX_
#include <smart/com/sun/star/container/ContainerEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CONTAINER_XINDEXREPLACE_HXX_
#include <smart/com/sun/star/container/XIndexReplace.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_CONTAINER_XNAMECONTAINER_HXX_
#include <smart/com/sun/star/container/XNameContainer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_REGISTRY_MERGECONFLICTEXCEPTION_HXX_
#include <smart/com/sun/star/registry/MergeConflictException.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_REGISTRY_XSIMPLEREGISTRY_HXX_
#include <smart/com/sun/star/registry/XSimpleRegistry.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_REGISTRY_INVALIDVALUEEXCEPTION_HXX_
#include <smart/com/sun/star/registry/InvalidValueException.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_REGISTRY_REGISTRYKEYTYPE_HXX_
#include <smart/com/sun/star/registry/RegistryKeyType.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_REGISTRY_XREGISTRYKEY_HXX_
#include <smart/com/sun/star/registry/XRegistryKey.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_REGISTRY_REGISTRYVALUETYPE_HXX_
#include <smart/com/sun/star/registry/RegistryValueType.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_REGISTRY_INVALIDREGISTRYEXCEPTION_HXX_
#include <smart/com/sun/star/registry/InvalidRegistryException.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_LOADER_XIMPLEMENTATIONLOADER_HXX_
#include <smart/com/sun/star/loader/XImplementationLoader.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_LOADER_CANNOTACTIVATEFACTORYEXCEPTION_HXX_
#include <smart/com/sun/star/loader/CannotActivateFactoryException.hxx>
#endif

#include <svtools/iniprop.hxx>
#include <svtools/iniman.hxx>

#ifndef _SV_LSTBOX_HXX //autogen wg. ListBox
#include <vcl/lstbox.hxx>
#endif

#ifndef _SV_EDIT_HXX //autogen wg. Edit
#include <vcl/edit.hxx>
#endif

#ifndef _TOOLS_DEBUG_HXX //autogen wg. DBG_ASSERT
#include <tools/debug.hxx>
#endif

#ifndef _FSYS_HXX //autogen wg. DirEntry
#include <tools/fsys.hxx>
#endif


#include "registry.hxx"
#include "adrmod.hxx"

#ifdef _USE_NAMESPACE
using namespace usr;
using namespace vos;
#endif


SMART_UNO_IMPLEMENTATION( AdrRegistryKey, UsrObject );


AdrRegistryKey::AdrRegistryKey(const XRegistryKeyRef& aRegKey)
{
	xRegistryKey=aRegKey;
}
//XInterface
BOOL AdrRegistryKey::queryInterface( UsrUik aUIK, XInterfaceRef& xRet)
{
	if( aUIK == XRegistryKey::getSmartUik() )
		xRet = (XRegistryKey*) this;
	else if( aUIK == XPropertySet::getSmartUik() )
		xRet = (XPropertySet*) this;
	else	
		return UsrObject::queryInterface( aUIK, xRet );
	
	return xRet.is();
}

XIdlClassRef AdrRegistryKey::giveClassRef(RegistryValueType eValueType)
{
	XIdlClassRef xIdlClassRef;

	switch(eValueType)
	{
		case	RegistryValueType_LONG:
					xIdlClassRef=INT32_getReflection()->getIdlClass();
					break;

		case	RegistryValueType_STRING:
					xIdlClassRef=OUString_getReflection()->getIdlClass();
					break;

		case	RegistryValueType_LONGLIST:
					xIdlClassRef=Sequence<INT32>::getReflection()->getIdlClass();
					break;

		case	RegistryValueType_STRINGLIST:
					xIdlClassRef=Sequence<UString>::getReflection()->getIdlClass();
					break;

		case	RegistryValueType_BINARY:
					xIdlClassRef=XPersistObject_getReflection()->getIdlClass();
					break;
		
		default:
				xIdlClassRef=Void_getReflection()->getIdlClass();
					break;
	}
	
	return xIdlClassRef;
}

RegistryValueType AdrRegistryKey::giveValueType(const UsrAny& rValue)
{
	XIdlClassRef xIdlClass = rValue.getReflection()->getIdlClass();
	TypeClass eType = xIdlClass->getTypeClass();
	
	RegistryValueType eValueType;

	switch(eType)
	{
		case	TypeClass_LONG:
					eValueType=RegistryValueType_LONG;
					break;

		case	TypeClass_STRING:
					eValueType=RegistryValueType_STRING;
					break;

		case	TypeClass_SEQUENCE:
					
					if( rValue.getReflection()->equals(*Sequence<UString>::getReflection()))
					{
						eValueType=RegistryValueType_STRINGLIST;
					}
					else if( rValue.getReflection()->equals(*Sequence<INT32>::getReflection()))
					{
						eValueType=RegistryValueType_LONGLIST;
					}

					break;

		case	TypeClass_INTERFACE:
					if( rValue.getReflection()->equals(*XPersistObject_getReflection()))
					{
						eValueType=RegistryValueType_BINARY;
					}
					else
					{
						eValueType=RegistryValueType_NOT_DEFINED;
					}
					break;

		default:
					eValueType=RegistryValueType_NOT_DEFINED;
					break;
	}
	
	return eValueType;
}

// XRegistryKey
UString AdrRegistryKey::getKeyName() const THROWS( (UsrSystemException) )
{
	return xRegistryKey->getKeyName();
}
BOOL AdrRegistryKey::isReadOnly() THROWS( (InvalidRegistryException, UsrSystemException) )
{
	return xRegistryKey->isReadOnly();
}
BOOL AdrRegistryKey::isValid() THROWS( (UsrSystemException) )
{
	return xRegistryKey->isValid();
}
RegistryKeyType	AdrRegistryKey::getKeyType(const UString& rKeyName) THROWS( (InvalidRegistryException, UsrSystemException) )
{
	return xRegistryKey->getKeyType(rKeyName);
}
RegistryValueType AdrRegistryKey::getValueType() THROWS( (InvalidRegistryException, UsrSystemException) )
{
	return xRegistryKey->getValueType();
}
INT32 AdrRegistryKey::getLongValue() THROWS( (InvalidRegistryException, InvalidValueException, UsrSystemException) )
{
	return xRegistryKey->getLongValue();
}
void AdrRegistryKey::setLongValue(INT32 value) THROWS( (InvalidRegistryException, UsrSystemException) )
{
	xRegistryKey->setLongValue(value);
}
Sequence< INT32 > AdrRegistryKey::getLongListValue() THROWS( (InvalidRegistryException, InvalidValueException, UsrSystemException) )
{
	return xRegistryKey->getLongListValue();
}
void AdrRegistryKey::setLongListValue(const Sequence< INT32 >& seqValue) THROWS( (InvalidRegistryException, UsrSystemException) )
{
	xRegistryKey->setLongListValue(seqValue);
}
UString AdrRegistryKey::getAsciiValue() THROWS( (InvalidRegistryException, InvalidValueException, UsrSystemException) )
{
	return xRegistryKey->getAsciiValue();
}
void AdrRegistryKey::setAsciiValue(const UString& value) THROWS( (InvalidRegistryException, UsrSystemException) )
{
	xRegistryKey->setAsciiValue(value);
}
Sequence< UString > AdrRegistryKey::getAsciiListValue() THROWS( (InvalidRegistryException, InvalidValueException, UsrSystemException) )
{
	return xRegistryKey->getAsciiListValue();
}
void AdrRegistryKey::setAsciiListValue(const Sequence< UString >& seqValue) THROWS( (InvalidRegistryException, UsrSystemException) )
{
	xRegistryKey->setAsciiListValue(seqValue);
}
UString	AdrRegistryKey::getStringValue() THROWS( (InvalidRegistryException, InvalidValueException, UsrSystemException) )
{
	return xRegistryKey->getStringValue();
}
void AdrRegistryKey::setStringValue(const UString& value) THROWS( (InvalidRegistryException, UsrSystemException) )
{
	xRegistryKey->setStringValue(value);
}
Sequence< UString > AdrRegistryKey::getStringListValue() THROWS( (InvalidRegistryException, InvalidValueException, UsrSystemException) )
{
	return xRegistryKey->getStringListValue();
}
void AdrRegistryKey::setStringListValue(const Sequence< UString >& seqValue) THROWS( (InvalidRegistryException, UsrSystemException) )
{
	xRegistryKey->setStringListValue(seqValue);
}
Sequence< BYTE >	AdrRegistryKey::getBinaryValue() THROWS( (InvalidRegistryException, InvalidValueException, UsrSystemException) )
{
	return xRegistryKey->getBinaryValue();
}
void AdrRegistryKey::setBinaryValue(const Sequence< BYTE >& value) THROWS( (InvalidRegistryException, UsrSystemException) )
{
	xRegistryKey->setBinaryValue(value);
}
XRegistryKeyRef	AdrRegistryKey::openKey(const UString& aKeyName) THROWS( (InvalidRegistryException, UsrSystemException) )
{
	XRegistryKeyRef	aRegKey=xRegistryKey->openKey(aKeyName);
	if(aRegKey.is())
		return new AdrRegistryKey(aRegKey);
	else
		return aRegKey;
}
XRegistryKeyRef	AdrRegistryKey::createKey(const UString& aKeyName) THROWS( (InvalidRegistryException, UsrSystemException) )
{
	return new AdrRegistryKey(xRegistryKey->createKey(aKeyName));
}
void AdrRegistryKey::closeKey() THROWS( (InvalidRegistryException, UsrSystemException) )
{
	xRegistryKey->closeKey();
}
void AdrRegistryKey::deleteKey(const UString& rKeyName) THROWS( (InvalidRegistryException, UsrSystemException) )
{
	xRegistryKey->deleteKey(rKeyName);
}

Sequence< XRegistryKeyRef > AdrRegistryKey::openKeys() THROWS( (InvalidRegistryException, UsrSystemException) )
{
	Sequence< XRegistryKeyRef > aSeqKeys=xRegistryKey->openKeys();
	const XRegistryKeyRef* pRegKey=aSeqKeys.getConstArray();
	INT32 nCount=aSeqKeys.getLen();
	
	Sequence< XRegistryKeyRef > aSeqRegKeys(nCount);
	XRegistryKeyRef * pAdrKey = aSeqRegKeys.getArray();
	

	for(INT32 i=0; i< nCount; i++)
	{
		*pAdrKey=new AdrRegistryKey( pRegKey[i]);
	}

	return aSeqRegKeys;
}

Sequence< UString > AdrRegistryKey::getKeyNames() THROWS( (InvalidRegistryException, UsrSystemException) )
{
	return xRegistryKey->getKeyNames();
}
BOOL AdrRegistryKey::createLink(const UString& aLinkName, const UString& aLinkTarget) THROWS( (InvalidRegistryException, UsrSystemException) )
{
	return xRegistryKey->createLink(aLinkName,aLinkTarget);
}
void AdrRegistryKey::deleteLink(const UString& rLinkName) THROWS( (InvalidRegistryException, UsrSystemException) )
{
	xRegistryKey->deleteLink(rLinkName);
}
UString	AdrRegistryKey::getLinkTarget(const UString& rLinkName) THROWS( (InvalidRegistryException, UsrSystemException) )
{
	return xRegistryKey->getLinkTarget(rLinkName);
}
UString	AdrRegistryKey::getResolvedName(const UString& aKeyName) THROWS( (InvalidRegistryException, UsrSystemException) )
{
	return xRegistryKey->getResolvedName(aKeyName);
}

XPropertySetInfoRef AdrRegistryKey::getPropertySetInfo() const THROWS( (UsrSystemException) )
{
	return new AdrRegistryKeyInfo((XRegistryKey*) this);
}

void AdrRegistryKey::setPropertyValue(const UString& aName, const UsrAny& aValue) THROWS( (UnknownPropertyException, PropertyVetoException, IllegalArgumentException, WrappedTargetException, UsrSystemException) )
{
	RegistryValueType eValueType=giveValueType(aValue);

	XRegistryKeyRef aRegKey=xRegistryKey->openKey(aName);

	if(!aRegKey.is())
		aRegKey=xRegistryKey->createKey(aName);

	XIdlClassRef xIdlClass = aValue.getReflection()->getIdlClass();
	TypeClass eType = xIdlClass->getTypeClass();

	switch(eType)
	{				
		case	TypeClass_LONG:
					aRegKey->setLongValue(aValue.getINT32());
					break;

		case	TypeClass_STRING:
					aRegKey->setStringValue(aValue.getString());
					break;

		case	TypeClass_SEQUENCE:
					
					if( aValue.getReflection()->equals(*Sequence<UString>::getReflection()))
					{
						Sequence<UString>	StringSeq = *(Sequence<UString>*)aValue.get();
						aRegKey->setStringListValue(StringSeq);
					}
					else if( aValue.getReflection()->equals(*Sequence<INT32>::getReflection()))
					{
						Sequence<INT32>  LongSeq = *(Sequence<INT32>*)aValue.get();
						aRegKey->setLongListValue(LongSeq);
					}

					break;

		case	TypeClass_INTERFACE:
					if( aValue.getReflection()->equals(*XPersistObject_getReflection()))
					{
						XPersistObjectRef xPersistObject= *(XPersistObjectRef*) aValue.get();
						object2Registry(aRegKey, xPersistObject);
					}
					break;
	}

}

UsrAny AdrRegistryKey::getPropertyValue(const UString& aName) const THROWS( (UnknownPropertyException, WrappedTargetException, UsrSystemException) )
{
	UsrAny aValue;

	XRegistryKeyRef aRegKey=xRegistryKey->openKey(aName);

	if(!aRegKey.is())
		aRegKey=xRegistryKey->createKey(aName);



	RegistryValueType eValueType=aRegKey->getValueType();

	switch(eValueType)
	{
		case	RegistryValueType_LONG:
					aValue.setINT32(aRegKey->getLongValue());
					break;

		case	RegistryValueType_STRING:
					aValue.setString(aRegKey->getStringValue());
					break;
 
		case	RegistryValueType_LONGLIST:
					{
						Sequence<INT32> aSeq=aRegKey->getLongListValue();
						aValue.set(&aSeq, Sequence<INT32>::getReflection());
					}
					break;

		case	RegistryValueType_STRINGLIST:
					{
						Sequence<UString> aSeq=aRegKey->getStringListValue();
						aValue.set(&aSeq, Sequence<UString>::getReflection());
					}
					break;
  
		case	RegistryValueType_BINARY:

					XPersistObjectRef xPersistObject= registry2Object(aRegKey);
					aValue.set(&xPersistObject,XPersistObject_getReflection());
					break;
	}
	return aValue;
}


void AdrRegistryKey::addPropertyChangeListener(const UString& aPropertyName, const XPropertyChangeListenerRef& xListener) THROWS( (UnknownPropertyException, WrappedTargetException, UsrSystemException) )
{
}
void AdrRegistryKey::removePropertyChangeListener(const UString& aPropertyName, const XPropertyChangeListenerRef& aListener) THROWS( (UnknownPropertyException, WrappedTargetException, UsrSystemException) )
{
}
void AdrRegistryKey::addVetoableChangeListener(const UString& PropertyName, const XVetoableChangeListenerRef& aListener) THROWS( (UnknownPropertyException, WrappedTargetException, UsrSystemException) )
{
}
void AdrRegistryKey::removeVetoableChangeListener(const UString& PropertyName, const XVetoableChangeListenerRef& aListener) THROWS( (UnknownPropertyException, WrappedTargetException, UsrSystemException) )
{
}


XPersistObjectRef AdrRegistryKey::registry2Object(const XRegistryKeyRef& rKey) const
{

	XPersistObjectRef aObject;
    
	TRY
	{
		XMultiServiceFactoryRef xMgr( NAMESPACE_USR( getProcessServiceManager )() );
		
		Sequence< BYTE > aSeqBytes= rKey->getBinaryValue();

		XOutputStreamRef xOutputStream(xMgr->createInstance(L"com.sun.star.io.Pipe"), USR_QUERY );
		
		xOutputStream->writeBytes(aSeqBytes);
		XInputStreamRef xInputStream(xOutputStream, USR_QUERY );

		XMarkableStreamRef xMarkableStream(xMgr->createInstance(
			L"com.sun.star.io.MarkableInputStream"), USR_QUERY );
		XActiveDataSinkRef xMarkableDataSink(xMarkableStream,USR_QUERY );
		xMarkableDataSink->setInputStream(xInputStream);
		XInputStreamRef xMarkableInputStream(xMarkableStream, USR_QUERY );
		
		XObjectInputStreamRef xObjInputStream(xMgr->createInstance(L"com.sun.star.io.ObjectInputStream"), USR_QUERY );
		XActiveDataSinkRef xObjInputDataSink(xObjInputStream, USR_QUERY );
		
		xObjInputDataSink->setInputStream(xMarkableInputStream);

		aObject=xObjInputStream->readObject();

		xOutputStream->closeOutput();
		xInputStream->closeInput();
	}
	CATCH_ALL()
	{
		DBG_ERROR("::Data2Registry: something went wrong !");
	}
	END_CATCH

	return aObject;
}

void AdrRegistryKey::object2Registry(	const XRegistryKeyRef& rKey,const XPersistObjectRef& rObject)const
{
	TRY
	{
		XMultiServiceFactoryRef xMgr( NAMESPACE_USR( getProcessServiceManager )() );
		XObjectOutputStreamRef xObjOutputStream(xMgr->createInstance(L"com.sun.star.io.ObjectOutputStream"), USR_QUERY );
		XActiveDataSourceRef xObjOutputDataSource(xObjOutputStream, USR_QUERY );
		
		XMarkableStreamRef xMarkableStream(xMgr->createInstance(
			L"com.sun.star.io.MarkableOutputStream"), USR_QUERY );
		XActiveDataSourceRef xMarkableDataSource(xMarkableStream,USR_QUERY );
		
		XOutputStreamRef xOutputStream(xMgr->createInstance(L"com.sun.star.io.Pipe"), USR_QUERY );
		
		xMarkableDataSource->setOutputStream(xOutputStream);

		XOutputStreamRef xMarkableOutputStream(xMarkableDataSource,USR_QUERY);
		xObjOutputDataSource->setOutputStream(xMarkableOutputStream);
		xObjOutputStream->writeObject(rObject);

		XInputStreamRef xInputStream(xOutputStream, USR_QUERY );

		INT32 nCount=xInputStream->available();

		Sequence< BYTE > aSeqBytes(nCount);
		INT32 nRead= xInputStream->readBytes(aSeqBytes,nCount);
		rKey->setBinaryValue(aSeqBytes);
		xOutputStream->closeOutput();
		xInputStream->closeInput();
	}
	CATCH_ALL()
	{
		DBG_ERROR("::Data2Registry: something went wrong !");
	}
	END_CATCH
}


SMART_UNO_IMPLEMENTATION( AdrRegistryKeyInfo, UsrObject );

AdrRegistryKeyInfo::AdrRegistryKeyInfo(const XRegistryKeyRef& rKey)
{
	xAdrRegistryKey=rKey;
}
		
// XPropertySetInfo
Sequence< Property > AdrRegistryKeyInfo::getProperties() const THROWS( (UsrSystemException) )
{

	Sequence< UString > aNameSeq=xAdrRegistryKey->getKeyNames();
	INT32 nCount=aNameSeq.getLen();
	
	Sequence< Property > aPropSeq(nCount);
	
	Property* pProp = aPropSeq.getArray();
	const UString* pName = aNameSeq.getConstArray();
	
	INT32 i=0;

	while(i<nCount)
	{
		i++;
		XRegistryKeyRef aRegKey=xAdrRegistryKey->openKey(*pName);
		XIdlClassRef aClassRef= AdrRegistryKey::giveClassRef(aRegKey->getValueType());

		pProp->Name=*pName;
		pProp->Type=aClassRef;
		pProp->Attributes=PropertyAttribute_MAYBEVOID;
		pProp++;
		pName++;
		aRegKey->closeKey();
	}

	return aPropSeq;
}
Property AdrRegistryKeyInfo::getPropertyByName(const UString& aName) const THROWS( (UnknownPropertyException, UsrSystemException) )
{
	Property aProp;

	XRegistryKeyRef aRegKey=xAdrRegistryKey->openKey(aName);
	XIdlClassRef aClassRef= AdrRegistryKey::giveClassRef(aRegKey->getValueType());

	aProp.Name=aName;
	aProp.Type=aClassRef;
	aProp.Attributes=PropertyAttribute_MAYBEVOID;
	aRegKey->closeKey();

	return aProp;
}

BOOL AdrRegistryKeyInfo::hasPropertyByName(const UString& aName) const THROWS( (UsrSystemException) )
{
	BOOL bRet=FALSE;
	Sequence< UString > aNameSeq=xAdrRegistryKey->getKeyNames();
	INT32 nCount=aNameSeq.getLen();
	
	INT32 i=0;
	
	const UString* pName = aNameSeq.getConstArray();
	
	while(i<nCount)
	{
		i++;
		if(*pName==aName)
		{
			bRet=TRUE;
			break;
		}
	}
	return bRet;
}
//XInterface
BOOL AdrRegistryKeyInfo::queryInterface( UsrUik aUIK, XInterfaceRef& xRet)
{
	if( aUIK == XRegistryKey::getSmartUik() )
		xRet = (XRegistryKey*) this;
	else if( aUIK == XPropertySet::getSmartUik() )
		xRet = (XPropertySet*) this;
	else	
		return UsrObject::queryInterface( aUIK, xRet );
	
	return xRet.is();
}


SMART_UNO_IMPLEMENTATION( AdrRegistry, UsrObject );

AdrRegistry::AdrRegistry()
{
	InitRegistry();
}

AdrRegistry::~AdrRegistry()
{
	if(xRegistry.is())
		xRegistry->close();
}

void AdrRegistry::InitRegistry()
{
	TRY
	{
		XMultiServiceFactoryRef xMgr( NAMESPACE_USR( getProcessServiceManager )() );
				
		XNameAccessRef xSettings( xMgr->createInstance(L"com.sun.star.frame.Settings" ), USR_QUERY );
		UsrAny aSettings=xSettings->getByName( L"PathSettings" );
		XPropertySetRef xProps=*(XPropertySetRef*) aSettings.get();
		
		UsrAny aAnyPath=xProps->getPropertyValue( L"Config" );
		UString aPath=aAnyPath.getString();
		xRegistry = XSimpleRegistryRef(xMgr->createInstance(L"com.sun.star.registry.SimpleRegistry" ), USR_QUERY );
		if( !xRegistry.is() ) return;

		DirEntry aEntry( U2S( aPath ));
		aEntry += DirEntry( "adruidat.rdb" );
		xRegistry->open(S2U( aEntry.GetFull() ), FALSE, TRUE );
		
	}
	CATCH_ALL()
	{
		DBG_ERROR("Exception in AdrRegistry::InitRegistry")
	}
	END_CATCH
}

UString	AdrRegistry::getURL() const THROWS( (UsrSystemException) )
{	
	UString aURL;

	if(xRegistry.is())
		aURL=xRegistry->getURL();

	return aURL;
}
void AdrRegistry::open(const UString& rURL, BOOL bReadOnly, BOOL bCreate) THROWS( (InvalidRegistryException, UsrSystemException) )
{
	if(xRegistry.is())
		xRegistry->open(rURL,bReadOnly,bCreate);
}

BOOL AdrRegistry::isValid() THROWS( (UsrSystemException) )
{
	if(xRegistry.is())
		return xRegistry->isValid();
	else
		return FALSE;
}
void AdrRegistry::close() THROWS( (InvalidRegistryException, UsrSystemException) )
{
	if(xRegistry.is())
		xRegistry->close();
}
void AdrRegistry::destroy() THROWS( (InvalidRegistryException, UsrSystemException) )
{
	if(xRegistry.is())
		xRegistry->destroy();
}

BOOL AdrRegistry::isReadOnly(void) THROWS( (InvalidRegistryException, UsrSystemException) )
{
	if(xRegistry.is())
		return xRegistry->isReadOnly();
	else
		return TRUE;
}
void AdrRegistry::mergeKey(const UString& aKeyName, const UString& aUrl) THROWS( (InvalidRegistryException, MergeConflictException, UsrSystemException) )
{
	if(xRegistry.is())
		xRegistry->mergeKey(aKeyName,aUrl);
}

//XInterface
BOOL AdrRegistry::queryInterface( UsrUik aUIK, XInterfaceRef& xRet)
{
	if( aUIK == XPropertySetInfo::getSmartUik() )
		xRet = (XPropertySetInfo*) this;
	else 
		return UsrObject::queryInterface( aUIK, xRet );
	
	return xRet.is();
}

XRegistryKeyRef	AdrRegistry::getRootKey()
{
	XRegistryKeyRef xRoot;
	
	if(xRegistry.is())
	{
		xRoot=new AdrRegistryKey(xRegistry->getRootKey());
	}
	return xRoot;
}		

XRegistryKeyRef	AdrRegistry::openSectionKey(const UString& rName)
{
	return openSectionSubKey(getRootKey(),rName);
}

XRegistryKeyRef AdrRegistry::openSectionSubKey(const XRegistryKeyRef& rKey,const UString& aName)
{
	XRegistryKeyRef	aKeyRef;

	TRY
	{
		aKeyRef = rKey->openKey( aName );
		if( !aKeyRef.is() ) aKeyRef = rKey->createKey( aName );
	}

	CATCH_ALL()
	{
		DBG_ERROR("::openSectionSubKey: something went wrong !");
	}
	END_CATCH

	return aKeyRef;
}




