/*************************************************************************
 *
 *  $RCSfile: diagnose.c,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:17:22 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

#include <stdarg.h>
#include <stdio.h>

#include <windows.h>

#define NO_DEBUG_CRT
#include <osl/diagnose.h>
#define NO_DEBUG_CRT

/*
 Trace output
*/

void SAL_CALL osl_breakDebug()
{
	DebugBreak();
}

void SAL_CALL osl_trace(const sal_Char* pszFormat, ...)
{
	int     nBuf;
	sal_Char    szBuffer[512];
	va_list args;

	va_start(args, pszFormat);

	nBuf = vsprintf(szBuffer, pszFormat, args);
	OSL_ASSERT(nBuf < sizeof(szBuffer));

	OutputDebugString(szBuffer);

	va_end(args);
}

sal_Bool SAL_CALL osl_assertFailedLine(const sal_Char* pszFileName, sal_Int32 nLine, const sal_Char* pszMessage)
{
#ifndef NO_DEBUG_CRT
	return (_CrtDbgReport(_CRT_ASSERT, pszFileName, nLine, NULL, pszMessage));
#else
	HWND hWndParent;
	int  nCode;

	/* get app name or NULL if unknown (don't call assert) */
	LPCSTR lpszAppName = "OSL";
	sal_Char   szMessage[512];
	
	/* format message into buffer */
	szMessage[sizeof(szMessage)-1] = '\0';	/* zero terminate always */
#ifdef __WATCOMC__
	_snprintf(szMessage, sizeof(szMessage)-1, "%s: File %hs, Line %d\n:%s\n",
	 	      lpszAppName, pszFileName, nLine,	pszMessage);
#else
	sprintf(szMessage, "%s: File %hs, Line %d\n:%s\n",
	 	      lpszAppName, pszFileName, nLine,	pszMessage);
#endif

	OutputDebugString(szMessage);

	/* active popup window for the current thread */
	hWndParent = GetActiveWindow();
	if (hWndParent != NULL)
		hWndParent = GetLastActivePopup(hWndParent);

	/* display the assert */
	nCode = MessageBox(hWndParent, szMessage, "Assertion Failed!",
		               MB_TASKMODAL|MB_ICONHAND|MB_ABORTRETRYIGNORE);
	if (nCode == IDABORT)
		PostQuitMessage(-1);

	if (nCode == IDIGNORE)
		return sal_False;   /* ignore */

	if (nCode == IDRETRY)
		return sal_True;    /* will cause oslDebugBreak */

	return sal_False;
#endif /* NO_DEBUG_CRT */
}

sal_Int32 SAL_CALL osl_reportError(sal_uInt32 nType, const sal_Char* pszMessage)
{
	int nDisposition;

	// active popup window for the current thread
	HWND hWndParent = GetActiveWindow();
	if (hWndParent != NULL)
		hWndParent = GetLastActivePopup(hWndParent);

	// display the assert
	nDisposition = MessageBox(hWndParent, pszMessage, "Exception !",
			                  MB_TASKMODAL|MB_ICONHAND|MB_ABORTRETRYIGNORE);

	return nDisposition;
}

#ifdef __cplusplus
}
#endif





