/*************************************************************************
 *
 *  $RCSfile: xmlaccelcfg.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/15 16:31:01 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "xmlaccelcfg.hxx"
#include "attriblist.hxx"

#include <vcl/keycodes.hxx>

#ifndef _RTL_USTRBUF_HXX_
#include <rtl/ustrbuf.hxx>
#endif

#ifndef _COM_SUN_STAR_XML_SAX_XEXTENDEDDOCUMENTHANDLER_HPP_
#include <com/sun/star/xml/sax/XExtendedDocumentHandler.hpp>
#endif

using namespace rtl;
using namespace com::sun::star::uno;
using namespace com::sun::star::xml::sax;

#define XMLNS_ACCEL					"http://openoffice.org/2001/accel"
#define XMLNS_XLINK					"http://www.w3.org/1999/xlink"
#define XMLNS_ACCEL_PREFIX			"accel:"
#define XMLNS_XLINK_PREFIX			"xlink:"

#define XMLNS_FILTER_SEPARATOR		"^"

#define	ELEMENT_ACCELERATORLIST		"acceleratorlist"
#define ELEMENT_ITEM				"item"

#define ATTRIBUTE_KEYCODE			"code"
#define ATTRIBUTE_URL				"href"
#define ATTRIBUTE_MOD_SHIFT			"shift"
#define ATTRIBUTE_MOD_MOD1			"mod1"
#define ATTRIBUTE_MOD_MOD2			"mod2"

#ifdef ATTRIBUTE_URL
#undef ATTRIBUTE_URL
#endif

#define ATTRIBUTE_URL				"href"

#define ELEMENT_NS_ACCELERATORLIST	"accel:acceleratorlist"
#define ELEMENT_NS_ITEM				"accel:item"

#define ATTRIBUTE_XMLNS_ACCEL		"xmlns:accel"
#define ATTRIBUTE_XMLNS_XLINK		"xmlns:xlink"

#define ATTRIBUTE_TYPE_CDATA		"CDATA"

#define ATTRIBUTE_BOOLEAN_TRUE		"true"
#define ATTRIBUTE_BOOLEAN_FALSE		"false"

#define ACCEL_DOCTYPE				"<!DOCTYPE accel:acceleratorlist PUBLIC \"-//OpenOffice.org//DTD OfficeDocument 1.0//EN\" \"accelerator.dtd\">"

// ------------------------------------------------------------------

struct AcceleratorEntryProperty
{
	OReadAcceleratorDocumentHandler::Accelerator_XML_Namespace	nNamespace;
	char														aEntryName[20];
};

struct KeyHashEntry
{
	sal_uInt16	nKeyCode;
	char		aKeyName[20];
};

struct USHORTHashCode
{
	size_t operator()( const sal_uInt16& nCode ) const
	{
		return (size_t)nCode;
	}
};


AcceleratorEntryProperty AcceleratorEntries[OReadAcceleratorDocumentHandler::AC_XML_ENTRY_COUNT] =
{
	{ OReadAcceleratorDocumentHandler::AC_NS_ACCEL,	ELEMENT_ACCELERATORLIST	},
	{ OReadAcceleratorDocumentHandler::AC_NS_ACCEL,	ELEMENT_ITEM			},
	{ OReadAcceleratorDocumentHandler::AC_NS_ACCEL,	ATTRIBUTE_KEYCODE		},
	{ OReadAcceleratorDocumentHandler::AC_NS_ACCEL,	ATTRIBUTE_MOD_SHIFT		},
	{ OReadAcceleratorDocumentHandler::AC_NS_ACCEL,	ATTRIBUTE_MOD_MOD1		},
	{ OReadAcceleratorDocumentHandler::AC_NS_ACCEL,	ATTRIBUTE_MOD_MOD2		},
	{ OReadAcceleratorDocumentHandler::AC_NS_XLINK,	ATTRIBUTE_URL			}
};

// ------------------------------------------------------------------

class KeyToNameHashMap : public ::std::hash_map< sal_uInt16											,
												 ::rtl::OUString									,
												 USHORTHashCode										,
												 ::std::equal_to< USHORT > >
{
};

class NameToKeyHashMap : public ::std::hash_map< ::rtl::OUString									,
												 sal_uInt16											,
												 OReadAcceleratorDocumentHandler::OUStringHashCode	,
												 ::std::equal_to< ::rtl::OUString > >
{
};


KeyHashEntry KeyHashEntries[] =
{
	{ KEY_0,	"KEY_0" },
	{ KEY_1,	"KEY_1" },
	{ KEY_2,	"KEY_2" },
	{ KEY_3,	"KEY_3" },
	{ KEY_4,	"KEY_4" },
	{ KEY_5,	"KEY_5" },
	{ KEY_6,	"KEY_6" },
	{ KEY_7,	"KEY_7" },
	{ KEY_8,	"KEY_8" },
	{ KEY_9,	"KEY_9" },

	{ KEY_A,	"KEY_A" },
	{ KEY_B,	"KEY_B" },
	{ KEY_C,	"KEY_C" },
	{ KEY_D,	"KEY_D" },
	{ KEY_E,	"KEY_E" },
	{ KEY_F,	"KEY_F" },
	{ KEY_G,	"KEY_G" },
	{ KEY_H,	"KEY_H" },
	{ KEY_I,	"KEY_I" },
	{ KEY_J,	"KEY_J" },
	{ KEY_K,	"KEY_K" },
	{ KEY_L,	"KEY_L" },
	{ KEY_M,	"KEY_M" },
	{ KEY_N,	"KEY_N" },
	{ KEY_O,	"KEY_O" },
	{ KEY_P,	"KEY_P" },
	{ KEY_Q,	"KEY_Q" },
	{ KEY_R,	"KEY_R" },
	{ KEY_S,	"KEY_S" },
	{ KEY_T,	"KEY_T" },
	{ KEY_U,	"KEY_U" },
	{ KEY_V,	"KEY_V" },
	{ KEY_W,	"KEY_W" },
	{ KEY_X,	"KEY_X" },
	{ KEY_Y,	"KEY_Y" },
	{ KEY_Z,	"KEY_Z" },

	{ KEY_F1,	"KEY_F1" },
	{ KEY_F2,	"KEY_F2" },
	{ KEY_F3,	"KEY_F3" },
	{ KEY_F4,	"KEY_F4" },
	{ KEY_F5,	"KEY_F5" },
	{ KEY_F6,	"KEY_F6" },
	{ KEY_F7,	"KEY_F7" },
	{ KEY_F8,	"KEY_F8" },
	{ KEY_F9,	"KEY_F9" },
	{ KEY_F10,	"KEY_F10" },
	{ KEY_F11,	"KEY_F11" },
	{ KEY_F12,	"KEY_F12" },
	{ KEY_F13,	"KEY_F13" },
	{ KEY_F14,	"KEY_F14" },
	{ KEY_F15,	"KEY_F15" },
	{ KEY_F16,	"KEY_F16" },
	{ KEY_F17,	"KEY_F17" },
	{ KEY_F18,	"KEY_F18" },
	{ KEY_F19,	"KEY_F19" },
	{ KEY_F20,	"KEY_F20" },
	{ KEY_F21,	"KEY_F21" },
	{ KEY_F22,	"KEY_F22" },
	{ KEY_F23,	"KEY_F23" },
	{ KEY_F24,	"KEY_F24" },
	{ KEY_F25,	"KEY_F25" },
	{ KEY_F26,	"KEY_F26" },

	{ KEY_DOWN,			"KEY_DOWN"		},
	{ KEY_UP,			"KEY_UP"		},
	{ KEY_LEFT,			"KEY_LEFT"		},
	{ KEY_RIGHT,		"KEY_RIGHT"		},
	{ KEY_HOME,			"KEY_HOME"		},
	{ KEY_END,			"KEY_END"		},
	{ KEY_PAGEUP,		"KEY_PAGEUP"	},
	{ KEY_PAGEDOWN,		"KEY_PAGEDOWN"	},

	{ KEY_RETURN,		"KEY_RETURN"	},
	{ KEY_ESCAPE,		"KEY_ESCAPE"	},
	{ KEY_TAB,			"KEY_TAB"		},
	{ KEY_BACKSPACE,	"KEY_BACKSPACE"	},
	{ KEY_SPACE,		"KEY_SPACE"		},
	{ KEY_INSERT,		"KEY_INSERT"	},
	{ KEY_DELETE,		"KEY_DELETE"	},

	{ KEY_ADD,			"KEY_ADD"		},
	{ KEY_SUBTRACT,		"KEY_SUBTRACT"	},
	{ KEY_MULTIPLY,		"KEY_MULTIPLY"	},
	{ KEY_DIVIDE,		"KEY_DIVIDE"	},
	{ KEY_POINT,		"KEY_POINT"		},
	{ KEY_COMMA,		"KEY_COMMA"		},
	{ KEY_LESS,			"KEY_LESS"		},
	{ KEY_GREATER,		"KEY_GREATER"	},
	{ KEY_EQUAL,		"KEY_EQUAL"		},

	{ KEY_OPEN,			"KEY_OPEN"			},
	{ KEY_CUT,			"KEY_CUT"			},
	{ KEY_COPY,			"KEY_COPY"			},
	{ KEY_PASTE,		"KEY_PASTE"			},
	{ KEY_UNDO,			"KEY_UNDO"			},
	{ KEY_REPEAT,		"KEY_REPEAT"		},
	{ KEY_FIND,			"KEY_FIND"			},
	{ KEY_PROPERTIES,	"KEY_PROPERTIES"	},
	{ KEY_FRONT,		"KEY_FRONT"			},
	{ KEY_CONTEXTMENU,	"KEY_CONTEXTMENU"	},
	{ KEY_MENU,			"KEY_MENU"			},
	{ KEY_HELP,			"KEY_HELP"			},
	{ 0,				""					}
};

KeyToNameHashMap*	GetKeyToNameHashMap()
{
	static KeyToNameHashMap* pKeyToNameHashMap = NULL;

	if ( !pKeyToNameHashMap )
	{
        ::osl::MutexGuard aGuard( ::osl::Mutex::getGlobalMutex() );
        if ( !pKeyToNameHashMap )
        {
			OUString aKeyName;

			pKeyToNameHashMap = new KeyToNameHashMap;

			int		i = 0;
			USHORT	nKeyCode;
			while ( KeyHashEntries[i].nKeyCode != 0 )
			{
				nKeyCode = KeyHashEntries[i].nKeyCode;
				aKeyName = OUString::createFromAscii( KeyHashEntries[i].aKeyName );
				pKeyToNameHashMap->insert( KeyToNameHashMap::value_type( nKeyCode, aKeyName ) );
				++i;
			}
		}
	}

	return pKeyToNameHashMap;
}

NameToKeyHashMap*	GetNameToKeyHashMap()
{
	static NameToKeyHashMap* pNameToKeyHashMap = NULL;

	if ( !pNameToKeyHashMap )
	{
        ::osl::MutexGuard aGuard( ::osl::Mutex::getGlobalMutex() );
        if ( !pNameToKeyHashMap )
        {
			OUString aKeyName;
		    pNameToKeyHashMap = new NameToKeyHashMap;

			int		i = 0;
			USHORT	nKeyCode;
			while ( KeyHashEntries[i].nKeyCode != 0 )
			{
				nKeyCode = KeyHashEntries[i].nKeyCode;
				aKeyName = OUString::createFromAscii( KeyHashEntries[i].aKeyName );
				pNameToKeyHashMap->insert( NameToKeyHashMap::value_type( aKeyName, nKeyCode ) );
				++i;
			}
		}
	}

	return pNameToKeyHashMap;
}


// ------------------------------------------------------------------
OReadAcceleratorDocumentHandler::OReadAcceleratorDocumentHandler(
	SfxAcceleratorItemList& aNewAcceleratorItemList ) :
	m_aReadAcceleratorList( aNewAcceleratorItemList ),
	m_xLocator( 0 ),
	m_bAcceleratorListStartFound( sal_False ),
	m_bAcceleratorListEndFound( sal_False ),
	m_bAcceleratorItemStartFound( sal_False )
{
	OUString aNamespaceAccelerator( RTL_CONSTASCII_USTRINGPARAM( XMLNS_ACCEL ));
	OUString aNamespaceXLink( RTL_CONSTASCII_USTRINGPARAM( XMLNS_XLINK ));

	// create hash map
	for ( int i = 0; i <= (int)AC_XML_ENTRY_COUNT; i++ )
	{
		if ( AcceleratorEntries[i].nNamespace == AC_NS_ACCEL )
		{
			OUStringBuffer temp( 60 );
			temp.append( aNamespaceAccelerator );
			temp.appendAscii(XMLNS_FILTER_SEPARATOR );
			temp.appendAscii( AcceleratorEntries[i].aEntryName );
			m_aAcceleratorHashMap.insert( AcceleratorHashMap::value_type( temp.makeStringAndClear(), (Accelerator_XML_Entry)i ) );
		}
		else
		{
			OUStringBuffer temp( 60 );
			temp.append( aNamespaceXLink );
			temp.appendAscii( XMLNS_FILTER_SEPARATOR );
			temp.appendAscii( AcceleratorEntries[i].aEntryName );
			m_aAcceleratorHashMap.insert( AcceleratorHashMap::value_type( temp.makeStringAndClear(), (Accelerator_XML_Entry)i ) );
		}
	}
}

Any SAL_CALL OReadAcceleratorDocumentHandler::queryInterface( const Type & rType ) throw( RuntimeException )
{
	Any a = ::cppu::queryInterface( rType ,SAL_STATIC_CAST( XDocumentHandler*, this ));
	if ( a.hasValue() )
		return a;
	else
		return OWeakObject::queryInterface( rType );
}

void SAL_CALL OReadAcceleratorDocumentHandler::ignorableWhitespace(
	const OUString& aWhitespaces )
throw( SAXException, RuntimeException )
{
}

void SAL_CALL OReadAcceleratorDocumentHandler::processingInstruction(
	const OUString& aTarget, const OUString& aData )
throw( SAXException, RuntimeException )
{
}

void SAL_CALL OReadAcceleratorDocumentHandler::setDocumentLocator(
	const Reference< XLocator > &xLocator)
throw(	SAXException, RuntimeException )
{
	m_xLocator = xLocator;
}

::rtl::OUString OReadAcceleratorDocumentHandler::getErrorLineString()
{
	char buffer[32];

	if ( m_xLocator.is() )
	{
		return OUString::createFromAscii( buffer );
	}
	else
		return OUString();
}

void SAL_CALL OReadAcceleratorDocumentHandler::startDocument(void)
	throw ( SAXException, RuntimeException )
{
}

void SAL_CALL OReadAcceleratorDocumentHandler::endDocument(void)
	throw( SAXException, RuntimeException )
{
	if (( m_bAcceleratorListStartFound && !m_bAcceleratorListEndFound ) ||
		( !m_bAcceleratorListStartFound && m_bAcceleratorListEndFound )		)
	{
		OUString aErrorMessage = getErrorLineString();
		aErrorMessage += OUString( RTL_CONSTASCII_USTRINGPARAM( "No matching start or end element 'acceleratorlist' found!" ));
		throw SAXException( aErrorMessage, Reference< XInterface >(), Any() );
	}
}


void SAL_CALL OReadAcceleratorDocumentHandler::startElement(
	const OUString& aName, const Reference< XAttributeList > &xAttrList )
throw( SAXException, RuntimeException )
{
	AcceleratorHashMap::const_iterator pAcceleratorEntry = m_aAcceleratorHashMap.find( aName ) ;

	if ( pAcceleratorEntry != m_aAcceleratorHashMap.end() )
	{
		switch ( pAcceleratorEntry->second )
		{
			case AC_ELEMENT_ACCELERATORLIST:
			{
				if ( m_bAcceleratorListStartFound )
				{
					OUString aErrorMessage = getErrorLineString();
					aErrorMessage += OUString( RTL_CONSTASCII_USTRINGPARAM( "Element 'accel:acceleratorlist' cannot be used recursive!" ));
					throw SAXException( aErrorMessage, Reference< XInterface >(), Any() );
				}

				m_bAcceleratorListStartFound = sal_True;
			}
			break;

			case AC_ELEMENT_ITEM:
			{
				if ( !m_bAcceleratorListStartFound || m_bAcceleratorListEndFound )
				{
					OUString aErrorMessage = getErrorLineString();
					aErrorMessage += OUString( RTL_CONSTASCII_USTRINGPARAM( "'accel:item' must be embeded into 'accel:acceleratorlist'!" ));
					throw SAXException( aErrorMessage, Reference< XInterface >(), Any() );
				}

				if ( m_bAcceleratorItemStartFound )
				{
					OUString aErrorMessage = getErrorLineString();
					aErrorMessage += OUString( RTL_CONSTASCII_USTRINGPARAM( "Element accel:item is not a container!" ));
					throw SAXException( aErrorMessage, Reference< XInterface >(), Any() );
				}

				m_bAcceleratorItemStartFound = sal_True;

				sal_Bool				 bURLSet = sal_False;
				SfxAcceleratorConfigItem aItem;

				// read attributes for accelerator
				for ( int n=0; n < xAttrList->getLength(); n++ )
				{
					pAcceleratorEntry = m_aAcceleratorHashMap.find( xAttrList->getNameByIndex( n ) );
					if ( pAcceleratorEntry != m_aAcceleratorHashMap.end() )
					{
						switch ( pAcceleratorEntry->second )
						{
							case AC_ATTRIBUTE_URL:
							{
								aItem.aCommand = xAttrList->getValueByIndex( n );
								bURLSet = sal_True;
							}
							break;

							case AC_ATTRIBUTE_KEYCODE:
							{
								aItem.nCode = (sal_uInt16)( xAttrList->getValueByIndex( n ).toInt32() );
								if ( aItem.nCode == 0 )
								{
									// This could be a key name use hash map determine key code
									NameToKeyHashMap::const_iterator pKeyEntry;

									NameToKeyHashMap* pNameToKeyHashMap = GetNameToKeyHashMap();
									pKeyEntry= pNameToKeyHashMap->find( xAttrList->getValueByIndex( n ) );
									if ( pKeyEntry != pNameToKeyHashMap->end() )
										aItem.nCode = pKeyEntry->second;
								}
							}
							break;

							case AC_ATTRIBUTE_MOD_SHIFT:
							case AC_ATTRIBUTE_MOD_MOD1:
							case AC_ATTRIBUTE_MOD_MOD2:
							{
								OUString aValue = xAttrList->getValueByIndex( n );
								if ( aValue.equalsAsciiL( RTL_CONSTASCII_STRINGPARAM( ATTRIBUTE_BOOLEAN_TRUE )))
								{
									if ( pAcceleratorEntry->second == AC_ATTRIBUTE_MOD_SHIFT )
										aItem.nModifier |= KEY_SHIFT;
									else if ( pAcceleratorEntry->second == AC_ATTRIBUTE_MOD_MOD1 )
										aItem.nModifier |= KEY_MOD1;
									else if ( pAcceleratorEntry->second == AC_ATTRIBUTE_MOD_MOD2 )
										aItem.nModifier |= KEY_MOD2;
								}
							}
							break;
						}
					}
				}

				if ( bURLSet && aItem.nCode != 0 )
					m_aReadAcceleratorList.push_back( aItem );
			}
			break;
		}
	}
}


void SAL_CALL OReadAcceleratorDocumentHandler::characters(const rtl::OUString& aChars)
throw(	SAXException, RuntimeException )
{
}


void SAL_CALL OReadAcceleratorDocumentHandler::endElement( const OUString& aName )
	throw( SAXException, RuntimeException )
{
	AcceleratorHashMap::const_iterator pAcceleratorEntry = m_aAcceleratorHashMap.find( aName ) ;
	if ( pAcceleratorEntry != m_aAcceleratorHashMap.end() )
	{
		switch ( pAcceleratorEntry->second )
		{
			case AC_ELEMENT_ACCELERATORLIST:
			{
				if ( !m_bAcceleratorListStartFound )
				{
					OUString aErrorMessage = getErrorLineString();
					aErrorMessage += OUString( RTL_CONSTASCII_USTRINGPARAM( "End element 'accel:acceleratorlist' found, but no start element." ));
					throw SAXException( aErrorMessage, Reference< XInterface >(), Any() );
				}

				m_bAcceleratorListStartFound = sal_False;
				m_bAcceleratorListEndFound = sal_True;
			}
			break;

			case AC_ELEMENT_ITEM:
			{
				if ( !m_bAcceleratorItemStartFound )
				{
					OUString aErrorMessage = getErrorLineString();
					aErrorMessage += OUString( RTL_CONSTASCII_USTRINGPARAM( "End element 'accel:item' found, but no start element." ));
					throw SAXException( aErrorMessage, Reference< XInterface >(), Any() );
				}

				m_bAcceleratorItemStartFound = sal_False;
			}
			break;
		}
	}
}

// ------------------------------------------------------------------

OWriteAcceleratorDocumentHandler::OWriteAcceleratorDocumentHandler(
    const SfxAcceleratorItemList& aWriteAcceleratorList, Reference< XDocumentHandler > xDocumentHandler ) :
	m_xWriteDocumentHandler( xDocumentHandler ),
	m_aWriteAcceleratorList( aWriteAcceleratorList )
{
	m_aAttributeType	= OUString( RTL_CONSTASCII_USTRINGPARAM( ATTRIBUTE_TYPE_CDATA ));
	m_aXMLXlinkNS		= OUString( RTL_CONSTASCII_USTRINGPARAM( XMLNS_XLINK_PREFIX ));
	m_aXMLAccelNS		= OUString( RTL_CONSTASCII_USTRINGPARAM( XMLNS_ACCEL_PREFIX ));
	m_xEmptyList		= Reference< XAttributeList >( (XAttributeList *)new AttributeListImpl, UNO_QUERY );
}

OWriteAcceleratorDocumentHandler::~OWriteAcceleratorDocumentHandler()
{
}

void OWriteAcceleratorDocumentHandler::WriteAcceleratorDocument()
	throw ( SAXException, RuntimeException )
{
	AttributeListImpl* pList = new AttributeListImpl;
	Reference< XAttributeList > rList( (XAttributeList *)pList , UNO_QUERY );

	m_xWriteDocumentHandler->startDocument();

	// write DOCTYPE line!
	Reference< XExtendedDocumentHandler > xExtendedDocHandler( m_xWriteDocumentHandler, UNO_QUERY );
	if ( xExtendedDocHandler.is() )
	{
		xExtendedDocHandler->unknown( OUString( RTL_CONSTASCII_USTRINGPARAM( ACCEL_DOCTYPE )) );
		m_xWriteDocumentHandler->ignorableWhitespace( OUString() );
	}

	pList->addAttribute( OUString( RTL_CONSTASCII_USTRINGPARAM( ATTRIBUTE_XMLNS_ACCEL )),
						 m_aAttributeType,
						 OUString( RTL_CONSTASCII_USTRINGPARAM( XMLNS_ACCEL )) );

	pList->addAttribute( OUString( RTL_CONSTASCII_USTRINGPARAM( ATTRIBUTE_XMLNS_XLINK )),
						 m_aAttributeType,
						 OUString( RTL_CONSTASCII_USTRINGPARAM( XMLNS_XLINK )) );

	m_xWriteDocumentHandler->startElement( OUString( RTL_CONSTASCII_USTRINGPARAM( ELEMENT_NS_ACCELERATORLIST )), pList );
	m_xWriteDocumentHandler->ignorableWhitespace( OUString() );

    std::vector< SfxAcceleratorConfigItem>::const_iterator p;
	for ( p = m_aWriteAcceleratorList.begin(); p != m_aWriteAcceleratorList.end(); p++ )
		WriteAcceleratorItem( *p );

	m_xWriteDocumentHandler->ignorableWhitespace( OUString() );
	m_xWriteDocumentHandler->endElement( OUString( RTL_CONSTASCII_USTRINGPARAM( ELEMENT_NS_ACCELERATORLIST )) );
	m_xWriteDocumentHandler->ignorableWhitespace( OUString() );
	m_xWriteDocumentHandler->endDocument();
}

void OWriteAcceleratorDocumentHandler::WriteAcceleratorItem(
    const SfxAcceleratorConfigItem& aAcceleratorItem )
	throw( SAXException, RuntimeException )
{
	AttributeListImpl* pAcceleratorAttributes = new AttributeListImpl;
	Reference< XAttributeList > xAcceleratorAttrList( (XAttributeList *)pAcceleratorAttributes , UNO_QUERY );

	if ( m_aAttributeURL.getLength() == 0 )
	{
		m_aAttributeURL = m_aXMLXlinkNS;
		m_aAttributeURL += OUString( RTL_CONSTASCII_USTRINGPARAM( ATTRIBUTE_URL ));
	}

	if ( m_aAttributeKeycode.getLength() == 0 )
	{
		m_aAttributeKeycode = m_aXMLAccelNS;
		m_aAttributeKeycode += OUString( RTL_CONSTASCII_USTRINGPARAM( ATTRIBUTE_KEYCODE ));
	}

	// set attributes
	// Key name

	KeyToNameHashMap::const_iterator pKeyNameEntry;

	KeyToNameHashMap* pKeyToNameHashMap = GetKeyToNameHashMap();
	pKeyNameEntry = pKeyToNameHashMap->find( aAcceleratorItem.nCode );
	if ( pKeyNameEntry != pKeyToNameHashMap->end() )
	{
		// Key code is inside our hash map => use key name
		pAcceleratorAttributes->addAttribute(
			m_aAttributeKeycode,
			m_aAttributeType,
			pKeyNameEntry->second );
	}
	else
	{
		// Key code is not inside our hash map => use key code
		pAcceleratorAttributes->addAttribute(
			m_aAttributeKeycode,
			m_aAttributeType,
			OUString::valueOf( (sal_Int32) aAcceleratorItem.nCode ));
	}

	if ( aAcceleratorItem.nModifier != 0 )
	{
		if ( m_aAttributeModShift.getLength() == 0 )
		{
			// Performance: Initialize element names only on demand but store them for further use
			m_aAttributeModShift	= m_aXMLAccelNS;
			m_aAttributeModShift	+= OUString( RTL_CONSTASCII_USTRINGPARAM( ATTRIBUTE_MOD_SHIFT ));
			m_aAttributeModMod1		= m_aXMLAccelNS;
			m_aAttributeModMod1		+= OUString( RTL_CONSTASCII_USTRINGPARAM( ATTRIBUTE_MOD_MOD1 ));
			m_aAttributeModMod2		= m_aXMLAccelNS;
			m_aAttributeModMod2		+= OUString( RTL_CONSTASCII_USTRINGPARAM( ATTRIBUTE_MOD_MOD2 ));
			m_aAttributeBooleanTRUE	= OUString( RTL_CONSTASCII_USTRINGPARAM( ATTRIBUTE_BOOLEAN_TRUE ));
		}

		if ( aAcceleratorItem.nModifier & KEY_SHIFT )
			pAcceleratorAttributes->addAttribute(
				m_aAttributeModShift,
				m_aAttributeType,
				m_aAttributeBooleanTRUE );

		if ( aAcceleratorItem.nModifier & KEY_MOD1 )
			pAcceleratorAttributes->addAttribute(
				m_aAttributeModMod1,
				m_aAttributeType,
				m_aAttributeBooleanTRUE );

		if ( aAcceleratorItem.nModifier & KEY_MOD2 )
			pAcceleratorAttributes->addAttribute(
				m_aAttributeModMod2,
				m_aAttributeType,
				m_aAttributeBooleanTRUE );
	}

	pAcceleratorAttributes->addAttribute(
		m_aAttributeURL,
		m_aAttributeType,
        aAcceleratorItem.aCommand );

	// write element
	m_xWriteDocumentHandler->ignorableWhitespace( OUString() );
	m_xWriteDocumentHandler->startElement( OUString( RTL_CONSTASCII_USTRINGPARAM( ELEMENT_NS_ITEM )), xAcceleratorAttrList );

	m_xWriteDocumentHandler->ignorableWhitespace( OUString() );
	m_xWriteDocumentHandler->endElement( OUString( RTL_CONSTASCII_USTRINGPARAM( ELEMENT_NS_ITEM )) );
	m_xWriteDocumentHandler->ignorableWhitespace( OUString() );
}
