/*************************************************************************
 *
 *  $RCSfile: readmap.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: armin $ $Date: 2001/03/08 09:47:32 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <stdio.h>

#include <string>
#include <hash_map>

#include "string.hxx"
#include "list.hxx"
#include "fsys.hxx"

#include "../listmacr.hxx"
#include "../prj.hxx"

#include "deco.hxx"

using namespace std;

DECLARE_LIST( LibNameList, ByteString *);

// ***--- class Symbol ---***
class Symbol
{
	ByteString	aName;
	ByteString	aLib;
	LibNameList* pLibLst;

	BOOL	bRef;
	BOOL	bEx;
public:
			Symbol( ByteString& rName, ByteString& rLibname );
			Symbol( ByteString& rName );

	ByteString	GetName(){ return aName; }
	ByteString	GetLibName(){ return aLib; }
	void	SetRef(){ bRef = TRUE; }
	BOOL	IsRef(){ return bRef; }
	void	AddLib( ByteString aLibname );
	LibNameList*	GetLibList(){ return pLibLst; }
};

Symbol::Symbol( ByteString& rName, ByteString& rLibname ) : bRef( FALSE )
{
	pLibLst = new LibNameList;
	aName = rName;
	aLib = rLibname;
}

Symbol::Symbol( ByteString& rName ) : bRef( FALSE )
{
	pLibLst = new LibNameList;
	aName = rName;
}

void Symbol::AddLib( ByteString aLibname )
{
	pLibLst->Insert( new ByteString( aLibname ), LIST_APPEND );
}

struct eqstr
{
	bool operator()( const char* s1, const char* s2 ) const
	{
		return strcmp( s1, s2 ) == 0;
	}
};

// ***--- SymbolList ---***
typedef hash_map<const char*, Symbol*, hash<const char*>, eqstr > SymbolList;


class Archive
{
	ByteString		aArchivename;
	ByteString		aMapPath;
	SymbolList	aSymList;
	SymbolList	aImportList;
	BOOL		bDll;
public:
				Archive( ByteString& rName);
	void		Execute();

	ByteString		GetName(){ return aArchivename; }
	BOOL		IsDll(){ return bDll; }
	ULONG		GetSymbolCount();
	SymbolList	GetSymbolList(){ return aSymList; }
	ULONG		GetImportCount();
	SymbolList	GetImportList(){ return aImportList; }
};

DECLARE_LIST( LibList, Archive* );


class Libraries
{
	LibList*	pLibs;
	ULONG		nTotalSymbolCount;

	SymbolList	aTotalSymLst;
	SymbolList	aDupSymLst;
public:
				Libraries( ByteString& rPath );
	void		ExecuteExports();
	void		ExecuteDups();
	Archive*	GetArchive( ByteString aArchiveName );

	void 		PrintStat();
	void 		PrintRef();
};

class ReadMap
{
	ByteString	aPath;
	ByteString	aName;
	USHORT	nState;
	BOOL	bReadSymbols;
	BOOL	bLib;
public:
		ReadMap( ByteString& rPath );

	void	Execute( SymbolList& rLst, SymbolList& rImpLst );
	BOOL	IsLib(){ return bLib;}
	ByteString	GetName(){ return aName; }
};

Archive::Archive( ByteString& rName )
{
	aMapPath = rName;
	//pSymList = new SymbolList;
	//pImportList = new SymbolList;
}

void Archive::Execute()
{
	ReadMap* pMap = new ReadMap( aMapPath );
	pMap->Execute( aSymList, aImportList );
	bDll = pMap->IsLib();
	aArchivename = pMap->GetName();
	delete pMap;
}

ULONG Archive::GetSymbolCount()
{
	return aSymList.size();
}

ULONG Archive::GetImportCount()
{
	return aImportList.size();
}

Libraries::Libraries( ByteString& rPath )
{
	pLibs = new LibList;
	ByteString aPath = rPath;
	aPath += ByteString( "*.map" );
	Dir aDir( String( aPath, gsl_getSystemTextEncoding()));

	ULONG nCount = aDir.Count();
	for ( ULONG i=0; i< nCount; i++ )
	{
		ByteString aFilename( aDir[i].GetFull(), gsl_getSystemTextEncoding());
		Archive *pArchive = new Archive( aFilename );
		pArchive->Execute();
		pLibs->Insert( pArchive, LIST_APPEND );
	}
}

Archive* Libraries::GetArchive( ByteString aName )
{
	Archive* pRet = NULL;
	ULONG nCount = pLibs->Count();
	for ( ULONG i=0; i< nCount; i++ )
	{
		Archive* pArchive = pLibs->GetObject( i );
		if ( pArchive->GetName() == aName )
		{
			pRet = pArchive;
			break;
		}
	}
	return pRet;
}

void Libraries::ExecuteExports()
{
	ULONG nLibCount = 0;
	nTotalSymbolCount = 0;
	ULONG nCount = pLibs->Count();
	// walk through all libraries
	for ( ULONG i=0; i< nCount; i++ )
	{
		Archive* pArchive = pLibs->GetObject( i );
		// walk over imported symbol table
		SymbolList::iterator pos;
		SymbolList aLst = pArchive->GetImportList();
		for ( pos = aLst.begin(); pos != aLst.end(); ++pos )
		{
			Symbol* pSym = pos->second;
			// get that library
			Archive* pArchive = GetArchive( pSym->GetLibName() );
			if ( pArchive )
			{
				// mark symbol as referenced
				SymbolList aSymLst = pArchive->GetSymbolList();
				const char* pKey = pSym->GetName().GetBuffer();
				SymbolList::iterator pos;
				pos = aSymLst.find(pKey);
				if ( pos != aSymLst.end() )
				{
					Symbol *pSSym = pos->second;
					//Symbol *pSSym = aSymLst.find(pKey)->second;
					if ( pSSym )
					{
						pSSym->SetRef();
					}
				}
				nTotalSymbolCount += pArchive->GetSymbolCount();
			}
		}
	}
}

void Libraries::ExecuteDups()
{
	ULONG nCount = pLibs->Count();
	// walk through all libraries
	for ( ULONG i=0; i< nCount; i++ )
	{
		Archive* pArchive = pLibs->GetObject( i );
		if ( pArchive->IsDll() )
		{
			// walk over imported symbol table
			SymbolList::iterator pos;
			SymbolList aLst = pArchive->GetSymbolList();
			for ( pos = aLst.begin(); pos != aLst.end(); ++pos )
			{
				Symbol* pSym = pos->second;
				pSym->AddLib( pArchive->GetName());
				SymbolList::iterator pos;
				const char* pKey = pSym->GetName().GetBuffer();
				pos = aTotalSymLst.find(pKey);
				if ( pos == aTotalSymLst.end() )
				{
					//  no such Symbol !!
					aTotalSymLst[pKey] = pSym;
				}
				else
				{
					Symbol* pDupSym = pos->second;
					pDupSym->AddLib( pArchive->GetName());
					aDupSymLst[pKey] = pDupSym;
				}
			}
		}

	}
	FILE* fp;
	fp = fopen("doppelte","w" );

	ULONG nRefSym = 0;
	SymbolList::iterator pos;
	fprintf( fp, "%d doppelte Symbole\n", aDupSymLst.size());
	for ( pos = aDupSymLst.begin(); pos != aDupSymLst.end(); ++pos )
	{
		Symbol* pSym = pos->second;
		if ( pSym->IsRef() )
		{
			fprintf( fp, "RefSym \t");
			nRefSym++;
		}
		fprintf( fp, "%s\t", pSym->GetName().GetBuffer());
		LibNameList *pLibLst = pSym->GetLibList();
		for ( ULONG n=0; n< pLibLst->Count(); n++ )
		{
			fprintf( fp, "\t%s", pLibLst->GetObject(n)->GetBuffer());
		}
		fprintf( fp, "\n" );
	}
	fprintf( fp, "%d kritische Symbole\n", nRefSym );
	fclose(fp);
}

void Libraries::PrintStat()
{
	ULONG nLibCount = 0;
	ULONG nCount = pLibs->Count();
	for ( ULONG i=0; i< nCount; i++ )
	{
		Archive* pArchive = pLibs->GetObject( i );
		if (  pArchive->IsDll() )
		{
			nLibCount++;
			fprintf( stderr, "Library %s : \n", pArchive->GetName().GetBuffer() );
			fprintf( stderr, "\t %d Symbols \n", pArchive->GetSymbolCount() );
			fprintf( stderr, "\t %d imported Symbols \n",
				pArchive->GetImportCount() );

			SymbolList::iterator pos;
			SymbolList aLst = pArchive->GetSymbolList();
			for ( pos = aLst.begin(); pos != aLst.end(); ++pos )
			{
				Symbol* pSym = pos->second;
				fprintf( stderr, "%s\n", pSym->GetName().GetBuffer());
				DecoName *pMName = new DecoName( pSym->GetName());
				pMName	->PrintName();
				delete pMName;
			}
		}
	}
	fprintf( stderr, "Read %d Mapfiles\n", nCount );
	fprintf( stderr, "Total %d Symbols\n", nTotalSymbolCount );
}

void Libraries::PrintRef()
{
	FILE* fp;
	ULONG nCount = pLibs->Count();
	for ( ULONG i=0; i< nCount; i++ )
	{
		Archive* pArchive = pLibs->GetObject( i );
		if (  pArchive->IsDll() )
		{
			ByteString aFilename =  pArchive->GetName();
			aFilename += ".ref";
			if (( fp = fopen( aFilename.GetBuffer(), "w" )) == NULL )
			{
				exit(1);
			}
			fprintf( fp, "Library %s : \n", pArchive->GetName().GetBuffer() );
			fprintf( fp, "\t %d Symbols \n", pArchive->GetSymbolCount() );
			fprintf( fp, "\t %d imported Symbols \n",
				pArchive->GetImportCount() );

			SymbolList::iterator pos;
			SymbolList aLst = pArchive->GetSymbolList();
			for ( pos = aLst.begin(); pos != aLst.end(); ++pos )
			{
				Symbol* pSym = pos->second;
				if ( pSym->IsRef() )
				{
					fprintf( fp, "bref : %s\n", pSym->GetName().GetBuffer());
				}
			}
			fclose( fp );
		}
	}
}

ReadMap::ReadMap( ByteString& rPath ) :
	bReadSymbols( FALSE ), nState( 0 ), bLib( TRUE )
{
	aPath = rPath;
}

void ReadMap::Execute( SymbolList& rLst, SymbolList& rImpLst )
{
	ByteString aToken, aSymbolname, aDllname;
	BOOL bSym = FALSE; BOOL bImp = FALSE;
	fprintf( stderr,  "Reading File : %s \n", aPath.GetBuffer() );
	SimpleConfig* pFile = new SimpleConfig( String( aPath, gsl_getSystemTextEncoding()));
	// first Token in Map File is the Name
	aName = pFile->GetNext();
	//fprintf( stderr,  "Reading Name : %s \n", aName.GetStr() );
	do
	{
		bSym = FALSE; bImp = FALSE;
		aToken = pFile->GetNext();

		if ( aToken == "Lib:Object" )
			bReadSymbols = TRUE;
		if ( aToken == "entry" )
			bReadSymbols = FALSE;

		if ( bReadSymbols && ( aToken.Len() == 13 ))
		{
			nState = 1;
			aToken = pFile->GetNext();
		}

		if ( nState == 1 )
		{
			//printf( "Symbol : %s\n", aToken.GetStr() );
			aSymbolname = aToken;
			if  ( (aSymbolname == "_main") || (aSymbolname == "_WinMain@16" ))
				bLib = FALSE;
			nState = 2;
			aToken = pFile->GetNext();
		}
		if ( nState == 2 )
		{
			if ( aToken.Len() == 8 )
			{
				nState = 3;
				aToken = pFile->GetNext();
			}
		}
		if ( nState == 3 )
		{
			if ( aToken.Len() == 1 )
			{
				nState = 4;
				aToken = pFile->GetNext();
			}
		}
		if ( nState == 4 )
		{
			if ( aToken.Len() == 1 )
			{
				nState = 4;
				aToken = pFile->GetNext();
			}
			USHORT nLen = aToken.Len();
			ByteString aExt = aToken.Copy( nLen -4, 4 );
			if ( aExt == ".obj" )
				bSym = TRUE;
			if ( aExt == ".dll" )
			{
				USHORT nPos = aToken.Search(':');
				//String aLibname = aToken.Copy( 0, nPos);
				aDllname = aToken.Copy( nPos+1, nLen -nPos -5 );
				//printf( "aDllname : %s\n", aDllname.GetStr());
				bImp = TRUE;
			}
			//printf( "Ext: %s\n", aExt.GetStr() );
			nState = 0;
			//aToken = pFile->GetNext();
		}

		if ( bSym )
		{
			ByteString aTst = aSymbolname.Copy( 0, 3 );
			//fprintf( stderr, "Tst : %s\n", aTst.GetStr());
			if ( aTst != "_$E" )
			{
				Symbol* pSym = new Symbol( aSymbolname );
				//pLst->Insert( pSym );
				rLst[aSymbolname.GetBuffer()] = pSym;
			}
		}
		if ( bImp )
		{
			Symbol* pSym = new Symbol( aSymbolname, aDllname );
			//fprintf( stderr, "Imp: %s aus %s\n",aSymbolname.GetStr(), aDllname.GetStr());
			//pImpLst->Insert( pSym );
			rImpLst[aSymbolname.GetBuffer()]
							= pSym;
		}
		//printf("Token : %s \n", aToken.GetStr());
	}
	while ( aToken != "" );

	delete pFile;

}

int __cdecl main( int argc, char **argv )
{
	ByteString aPath(".\\..\\..\\wntmsci3.pro\\misc\\");

	Libraries *pLibs = new Libraries( aPath );
	(void)pLibs->ExecuteExports();
	(void)pLibs->ExecuteDups();
	(void)pLibs->PrintRef();
	(void)pLibs->PrintStat();
	delete pLibs;

	return 0;
}

