/*************************************************************************
 *
 *  $RCSfile: rapofflineresultsetdatasupplier.cxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: sb $ $Date: 2001/06/07 12:58:11 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef INCLUDED_UCB_RAPOFFLINERESULTSETDATASUPPLIER_HXX
#include "rapofflineresultsetdatasupplier.hxx"
#endif

#ifndef INCLUDED_UCB_RAPOFFLINECONTENT_HXX
#include "rapofflinecontent.hxx"
#endif
#ifndef INCLUDED_UCB_RAPOFFLINEPROPERTYVALUESET_HXX
#include "rapofflinepropertyvalueset.hxx"
#endif
#ifndef INCLUDED_UCB_RAPOFFLINESTORAGE_HXX
#include "rapofflinestorage.hxx"
#endif
#ifndef INCLUDED_UCB_RAPOFFLINESTORAGENODE_HXX
#include "rapofflinestoragenode.hxx"
#endif

#ifndef _COM_SUN_STAR_BEANS_PROPERTY_HPP_
#include "com/sun/star/beans/Property.hpp"
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include "com/sun/star/lang/XMultiServiceFactory.hpp"
#endif
#ifndef _COM_SUN_STAR_UCB_OPENMODE_HPP_
#include "com/sun/star/ucb/OpenMode.hpp"
#endif
#ifndef _UCBHELPER_CONTENTIDENTIFIER_HXX
#include "ucbhelper/contentidentifier.hxx"
#endif

using namespace com::sun;
using ucprmt::offline::ContentContainer;
using ucprmt::offline::createPropertyValueSet;
using ucprmt::offline::ResultSetDataSupplier;
using ucprmt::offline::Storage;
using ucprmt::offline::StorageNode;

void ResultSetDataSupplier::read()
{
    if (m_bRead)
        return;

    bool bChanged = false;
    {
        osl::MutexGuard aGuard(m_aMutex);
        if (m_bRead)
            return;

        star::uno::Sequence< rtl::OUString > aAllIdentifiers;
        try
        {
            aAllIdentifiers = m_xStorageNode->getCurrentChildren();
        }
        catch (StorageError &)
        {
            throw star::ucb::ResultSetException(); //TODO! add information
        }

        if (m_eMode == star::ucb::OpenMode::ALL)
            m_aIdentifiers = aAllIdentifiers;
        else
        {
            m_aIdentifiers.realloc(aAllIdentifiers.getLength());
            sal_Int32 nCount = 0;
            for (sal_Int32 i = 0; i < aAllIdentifiers.getLength(); ++i)
            {
                rtl::Reference< StorageNode > xChildNode;
                try
                {
                    xChildNode
                        = m_xStorage->getNodes()->find(aAllIdentifiers[i]);
                }
                catch (StorageError &)
                {
                    OSL_ASSERT(false);
                }
                if (xChildNode.is()
                    && !xChildNode->isDeleted()
                    && (m_eMode == star::ucb::OpenMode::FOLDERS ?
                            xChildNode->getFolder() :
                            xChildNode->getDocument()))
                    m_aIdentifiers[nCount++] = aAllIdentifiers[i];
            }
            m_aIdentifiers.realloc(nCount);
        }

        bChanged = m_aIdentifiers.getLength() > 0;
        m_bRead = true;
    }
    if (bChanged)
        getResultSet()->
            rowCountChanged(0,
                            static_cast< sal_uInt32 >(m_aIdentifiers.
                                                          getLength()));
    getResultSet()->rowCountFinal();
}

ResultSetDataSupplier::ResultSetDataSupplier(
    star::uno::Reference< star::lang::XMultiServiceFactory > const &
        rServiceFactory,
    sal_Int32 eMode,
    star::uno::Sequence< star::beans::Property > const & rProperties,
    rtl::Reference< StorageNode > const & rStorageNode,
    rtl::Reference< Storage > const & rStorage,
    rtl::Reference< ContentContainer > const & rContainer):
    m_xServiceFactory(rServiceFactory),
    m_aProperties(rProperties),
    m_xStorageNode(rStorageNode),
    m_xStorage(rStorage),
    m_xContainer(rContainer),
    m_eMode(eMode),
    m_bRead(false)
{
    OSL_ASSERT(m_xStorageNode.is());
    OSL_ASSERT(m_xStorage.is());
    OSL_ASSERT(m_xContainer.is());
    OSL_ASSERT(m_eMode == star::ucb::OpenMode::ALL
               || m_eMode == star::ucb::OpenMode::FOLDERS
               || m_eMode == star::ucb::OpenMode::DOCUMENTS);
}

rtl::OUString
ResultSetDataSupplier::queryContentIdentifierString(sal_uInt32 nIndex)
{
    read();
    OSL_ASSERT(nIndex
                   < static_cast< sal_uInt32 >(m_aIdentifiers.getLength()));
    return m_aIdentifiers[static_cast< sal_Int32 >(nIndex)];
}

star::uno::Reference< star::ucb::XContentIdentifier >
ResultSetDataSupplier::queryContentIdentifier(sal_uInt32 nIndex)
{
    read();
    OSL_ASSERT(nIndex
                   < static_cast< sal_uInt32 >(m_aIdentifiers.getLength()));
    return new ucb::ContentIdentifier(m_aIdentifiers[static_cast< sal_Int32 >(
                                                         nIndex)]);
}

star::uno::Reference< star::ucb::XContent >
ResultSetDataSupplier::queryContent(sal_uInt32 nIndex)
{
    read();
    OSL_ASSERT(nIndex
                   < static_cast< sal_uInt32 >(m_aIdentifiers.getLength()));
    try
    {
        return m_xContainer->
                   queryContent(m_aIdentifiers[static_cast< sal_Int32 >(
                                                   nIndex)]);
    }
    catch (StorageError &)
    {
        OSL_ASSERT(false);
    }
    catch (star::uno::RuntimeException &)
    {
        //TODO! let it pass through?
        OSL_ASSERT(false);
    }
    return 0; //TODO! throw exception instead?
}

sal_Bool ResultSetDataSupplier::getResult(sal_uInt32 nIndex)
{
    read();
    return nIndex < static_cast< sal_uInt32 >(m_aIdentifiers.getLength());
}

sal_uInt32 ResultSetDataSupplier::totalCount()
{
    read();
    return static_cast< sal_uInt32 >(m_aIdentifiers.getLength());
}

sal_uInt32 ResultSetDataSupplier::currentCount()
{
    return m_bRead ? static_cast< sal_uInt32 >(m_aIdentifiers.getLength()) :
                     0;
}

sal_Bool ResultSetDataSupplier::isCountFinal()
{
    return m_bRead;
}

star::uno::Reference< star::sdbc::XRow >
ResultSetDataSupplier::queryPropertyValues(sal_uInt32 nIndex)
{
    read();
    OSL_ASSERT(nIndex
                   < static_cast< sal_uInt32 >(m_aIdentifiers.getLength()));
    rtl::Reference< StorageNode > xChildNode;
    if (m_aProperties.getLength() > 0)
        try
        {
            xChildNode
                = m_xStorage->
                      getNodes()->
                          find(m_aIdentifiers[static_cast< sal_Int32 >(
                                                  nIndex)]);
        }
        catch (StorageError &)
        {
            OSL_ASSERT(false);
        }
    return
        createPropertyValueSet(m_xServiceFactory, xChildNode, m_aProperties);
}

void ResultSetDataSupplier::releasePropertyValues(sal_uInt32)
{}

void ResultSetDataSupplier::close()
{}

void ResultSetDataSupplier::validate() throw (star::ucb::ResultSetException)
{}
