/*************************************************************************
 *
 *  $RCSfile: regtools.cxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: csaba $ $Date: 2000/10/12 13:10:10 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <regtools.hxx>

using namespace ::rtl;

sal_Bool getRegKey(HKEY rKey, const OString name, HKEY &result)
{
    return (RegOpenKeyEx(rKey, name.getStr(), 0, KEY_ALL_ACCESS, &result)
            == ERROR_SUCCESS);
}

sal_Bool getRegValue(HKEY rKey, const OString name, DWORD &type, void *buf,
                 DWORD &len)
{
    return (RegQueryValueEx(rKey, name.getStr(), 0, &type,
                            (unsigned char *) buf, &len) == ERROR_SUCCESS);
}

sal_Bool getRegDWORD(HKEY rKey, const OString name, DWORD &result)
{
    DWORD type = REG_DWORD, len = sizeof(DWORD);
    return getRegValue(rKey, name, type, &result, len);
}

sal_Bool getRegSTRING(HKEY rKey, const OString name, OString &result)
{
    DWORD type = REG_SZ;
    DWORD len = 1024;
    char *c = new char[len];
    if (!getRegValue(rKey, name, type, c, len)) return FALSE;
    result = c;
    return TRUE;
}

sal_Bool createRegKey(HKEY rKey, const char *rSubKey, const char* rName)
{
    int l = strlen(rSubKey);
    for (int i = l - 1; i >= 0; i--) if (rSubKey[i] == '\\') break;
    if (i >= 0)
    { // create/open parent key
        char *t = new char[l - i];
        strcpy(t, rSubKey + i + 1);
        t[l - i - 1] = 0;
        char *h = new char[i + 1];
        strncpy(h, rSubKey, i);
        h[i] = 0;
        if (!createRegKey(rKey, h, t)) return 0;
    }

    HKEY hKey;
    LONG lErr = RegCreateKeyEx(rKey, rSubKey, 0, "", REG_OPTION_NON_VOLATILE,
                               KEY_ALL_ACCESS, 0, &hKey, 0);
    if (lErr != ERROR_SUCCESS) return 0;
    HKEY newKey;

    lErr = RegCreateKeyEx(hKey, rName, 0, "", REG_OPTION_NON_VOLATILE,
                          KEY_ALL_ACCESS, 0, &newKey, 0);
    if (newKey)
    {
        RegFlushKey(newKey);
        RegCloseKey(newKey);
    }
    if (hKey) RegCloseKey(hKey);
    if (lErr != ERROR_SUCCESS) return 0;
    return 1;
}

sal_Bool delRegKey(HKEY rKey, const char *rSubKey, const char* rName)
{
    sal_Bool bResult = TRUE;
    HKEY hKey;
    int i;
    OString buf = rSubKey;
    buf += "\\";
    buf += rName;
    if (RegOpenKeyEx(rKey, buf.getStr(), 0, KEY_ALL_ACCESS, &hKey)
        == ERROR_SUCCESS)
    { // check for subKeys
        DWORD nSubKeyCount, nMaxSubKeyLen;
        if (RegQueryInfoKey(hKey, 0, 0, 0, &nSubKeyCount, &nMaxSubKeyLen,
                            0, 0, 0, 0, 0, 0) == ERROR_SUCCESS)
        { // nSubKeyLen: NT/2000->does'nt include terminating char
            if (nSubKeyCount > 0) // 95/98->includes terminating char
            {
                char **c = new char *[nSubKeyCount];

                for (i = 0; i < nSubKeyCount; i++) // get all keys
                {
                    c[i] = new char[nMaxSubKeyLen + 1];
                    DWORD l = nMaxSubKeyLen + 1;
                    bResult &= (RegEnumKeyEx(hKey, i, c[i], &l, 0, 0, 0, 0)
                                == ERROR_SUCCESS);
                }
                for (i = 0; i < nSubKeyCount; i++) // delete subkeys
                    bResult &= delRegKey(rKey, buf.getStr(), c[i]);
                for (i = nSubKeyCount -1; i >= 0; i--) delete c[i];
                delete [] c;
            }
        }
        RegCloseKey(hKey);
    }
    if (RegOpenKeyEx(rKey, rSubKey, 0, KEY_ALL_ACCESS, &hKey)==ERROR_SUCCESS)
    { // delete key
        bResult &= (RegDeleteKey(hKey, rName) == ERROR_SUCCESS);
        RegCloseKey(hKey);
    }
    else bResult = FALSE;
    return bResult;
}

char *getRegValue(HKEY rKey, const char *rSubKey, const char* rName)
{
    HKEY hKey;
    LONG lErr = RegOpenKeyEx(rKey, rSubKey, 0, KEY_QUERY_VALUE, &hKey);
    char *szBuffer = 0;
    if (lErr == ERROR_SUCCESS)
    {
        DWORD dwType  = 0;
        DWORD dwSize  = 256;
        szBuffer = new char[dwSize];
        lErr = RegQueryValueEx(hKey, rName, 0, &dwType, (LPBYTE) szBuffer,
                               &dwSize);
    }
    if (hKey) RegCloseKey(hKey);
    return szBuffer;
}

sal_Bool isRegKeyAvailable(HKEY rKey, const char *rSubKey, const char* rName)
{
    HKEY hKey;
    LONG lErr = RegOpenKeyEx(rKey, rSubKey, 0, KEY_ALL_ACCESS, &hKey);
    if (lErr != ERROR_SUCCESS) return 0;
    DWORD SubKeys, bMaxSubKeyLen;
    lErr = RegQueryInfoKey(hKey, 0, 0, 0, &SubKeys, &bMaxSubKeyLen, 0, 0,
                           0, 0, 0, 0);
    char *name  = new char[bMaxSubKeyLen];
//    FILETIME time;
    for (int i = SubKeys - 1; (i >= 0) && (lErr == ERROR_SUCCESS); i--)
    {
        DWORD len = bMaxSubKeyLen;
        lErr = RegEnumKeyEx(hKey, i, name, &len, 0, 0, 0, 0);
        if (strcmp(name, rName) == 0) break;
    }
    if (hKey) RegCloseKey(hKey);
    delete name;
    if (lErr != ERROR_SUCCESS) return 0;
    else return 1;
}

sal_Bool setRegValue(HKEY rKey, const char *rSubKey, const char *rName,
                 const char *rValue)
{
    HKEY hKey;
    LONG lErr = RegOpenKeyEx(rKey, rSubKey, 0, KEY_WRITE, &hKey);
    if (lErr != ERROR_SUCCESS) return 0;
    lErr = RegSetValueEx(hKey, rName, 0, REG_SZ, (LPBYTE) rValue,
                         strlen(rValue) + 1);
    if (hKey) RegCloseKey(hKey);
    if (lErr != ERROR_SUCCESS) return 0;
    else return 1;
}

sal_Bool setRegDWORD(HKEY rKey, const char *rSubKey, const char *rName,
                 const DWORD &rValue)
{
    HKEY hKey;
    LONG lErr = RegOpenKeyEx(rKey, rSubKey, 0, KEY_WRITE, &hKey);
    if (lErr != ERROR_SUCCESS) return 0;
    lErr = RegSetValueEx(hKey, rName, 0, REG_DWORD, (LPBYTE) &rValue,
                         sizeof(DWORD));
    if (hKey) RegCloseKey(hKey);
    if (lErr != ERROR_SUCCESS) return 0;
    else return 1;
}

sal_Bool setRegBINARY(HKEY rKey, const char *rSubKey, const char *rName,
                  const void *rValue, const int len)
{
    HKEY hKey;
    LONG lErr = RegOpenKeyEx(rKey, rSubKey, 0, KEY_WRITE, &hKey);
    if (lErr != ERROR_SUCCESS) return 0;
    lErr = RegSetValueEx(hKey, rName, 0, REG_BINARY, (LPBYTE) rValue, len);
    if (hKey) RegCloseKey(hKey);
    if (lErr != ERROR_SUCCESS) return 0;
    else return 1;
}

